/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0016\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\n\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b\u000b\u001a!\u0010\u0000\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\f\u001a\u001a\u0010\u0000\u001a\u00020\r*\u00020\r2\u0006\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r\u001a\u001a\u0010\u0000\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e\u001a\u001a\u0010\u0000\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u000f\u001a\u001a\u0010\u0000\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0010\u001a\u001a\u0010\u0000\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011\u001a\u001a\u0010\u0000\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0012\u001a\u0012\u0010\u0006\u001a\u00020\r*\u00020\r2\u0006\u0010\b\u001a\u00020\r\u001a\u0012\u0010\u0006\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e\u001a\u0012\u0010\u0006\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f\u001a\u0012\u0010\u0006\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\b\u001a\u00020\u0010\u001a\u0012\u0010\u0006\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011\u001a\u0012\u0010\u0006\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\b\u001a\u00020\u0012\u001a\u0019\u0010\u0013\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b\u0014\u001a\u0019\u0010\u0013\u001a\u00020\t*\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\u0015\u001a\u0019\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0016\u001a\u0019\u0010\u0013\u001a\u00020\n*\u00020\n2\u0006\u0010\b\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"clamp", "", "value", "min", "max", "", "mod", "a", "b", "", "", "doubleClamp", "intClamp", "Lorg/openrndr/math/IntVector2;", "Lorg/openrndr/math/IntVector3;", "Lorg/openrndr/math/IntVector4;", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "Lorg/openrndr/math/Vector4;", "mod_", "modDouble", "modFloat", "modInt", "modLong", "openrndr-math"})
public final class FunctionsKt {
    public static final double mod(double a2, double b) {
        return (a2 % b + b) % b;
    }

    public static final int mod(int a2, int b) {
        return (a2 % b + b) % b;
    }

    public static final float mod(float a2, float b) {
        return (a2 % b + b) % b;
    }

    public static final long mod(long a2, long b) {
        return (a2 % b + b) % b;
    }

    @JvmName(name="modDouble")
    public static final double modDouble(double $this$mod_, double b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @JvmName(name="modInt")
    public static final int modInt(int $this$mod_, int b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @JvmName(name="modFloat")
    public static final float modFloat(float $this$mod_, float b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @JvmName(name="modLong")
    public static final long modLong(long $this$mod_, long b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @NotNull
    public static final Vector2 mod(@NotNull Vector2 $this$mod, @NotNull Vector2 b) {
        Intrinsics.checkNotNullParameter($this$mod, "$this$mod");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector2(FunctionsKt.modDouble($this$mod.getX(), b.getX()), FunctionsKt.modDouble($this$mod.getY(), b.getY()));
    }

    @NotNull
    public static final Vector3 mod(@NotNull Vector3 $this$mod, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter($this$mod, "$this$mod");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector3(FunctionsKt.modDouble($this$mod.getX(), b.getX()), FunctionsKt.modDouble($this$mod.getY(), b.getY()), FunctionsKt.modDouble($this$mod.getZ(), b.getZ()));
    }

    @NotNull
    public static final Vector4 mod(@NotNull Vector4 $this$mod, @NotNull Vector4 b) {
        Intrinsics.checkNotNullParameter($this$mod, "$this$mod");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector4(FunctionsKt.modDouble($this$mod.getX(), b.getX()), FunctionsKt.modDouble($this$mod.getY(), b.getY()), FunctionsKt.modDouble($this$mod.getZ(), b.getZ()), FunctionsKt.modDouble($this$mod.getW(), b.getW()));
    }

    @NotNull
    public static final IntVector2 mod(@NotNull IntVector2 $this$mod, @NotNull IntVector2 b) {
        Intrinsics.checkNotNullParameter($this$mod, "$this$mod");
        Intrinsics.checkNotNullParameter(b, "b");
        return new IntVector2(FunctionsKt.modInt($this$mod.getX(), b.getX()), FunctionsKt.modInt($this$mod.getY(), b.getY()));
    }

    @NotNull
    public static final IntVector3 mod(@NotNull IntVector3 $this$mod, @NotNull IntVector3 b) {
        Intrinsics.checkNotNullParameter($this$mod, "$this$mod");
        Intrinsics.checkNotNullParameter(b, "b");
        return new IntVector3(FunctionsKt.modInt($this$mod.getX(), b.getX()), FunctionsKt.modInt($this$mod.getY(), b.getY()), FunctionsKt.modInt($this$mod.getZ(), b.getZ()));
    }

    @NotNull
    public static final IntVector4 mod(@NotNull IntVector4 $this$mod, @NotNull IntVector4 b) {
        Intrinsics.checkNotNullParameter($this$mod, "$this$mod");
        Intrinsics.checkNotNullParameter(b, "b");
        return new IntVector4(FunctionsKt.modInt($this$mod.getX(), b.getX()), FunctionsKt.modInt($this$mod.getY(), b.getY()), FunctionsKt.modInt($this$mod.getZ(), b.getZ()), FunctionsKt.modInt($this$mod.getW(), b.getW()));
    }

    public static final double clamp(double value, double min, double max) {
        boolean bl = false;
        double d = Math.min(max, value);
        boolean bl2 = false;
        return Math.max(min, d);
    }

    public static final int clamp(int value, int min, int max) {
        int n = 0;
        n = Math.min(max, value);
        boolean bl = false;
        return Math.max(min, n);
    }

    @JvmName(name="doubleClamp")
    public static final double doubleClamp(double $this$clamp, double min, double max) {
        return FunctionsKt.clamp($this$clamp, min, max);
    }

    @JvmName(name="intClamp")
    public static final int intClamp(int $this$clamp, int min, int max) {
        return FunctionsKt.clamp($this$clamp, min, max);
    }

    @NotNull
    public static final Vector2 clamp(@NotNull Vector2 $this$clamp, @NotNull Vector2 min, @NotNull Vector2 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "$this$clamp");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector2(FunctionsKt.doubleClamp($this$clamp.getX(), min.getX(), max.getX()), FunctionsKt.doubleClamp($this$clamp.getY(), min.getY(), max.getY()));
    }

    @NotNull
    public static final Vector3 clamp(@NotNull Vector3 $this$clamp, @NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "$this$clamp");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector3(FunctionsKt.doubleClamp($this$clamp.getX(), min.getX(), max.getX()), FunctionsKt.doubleClamp($this$clamp.getY(), min.getY(), max.getY()), FunctionsKt.doubleClamp($this$clamp.getZ(), min.getY(), max.getZ()));
    }

    @NotNull
    public static final Vector4 clamp(@NotNull Vector4 $this$clamp, @NotNull Vector4 min, @NotNull Vector4 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "$this$clamp");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector4(FunctionsKt.doubleClamp($this$clamp.getX(), min.getX(), max.getX()), FunctionsKt.doubleClamp($this$clamp.getY(), min.getY(), max.getY()), FunctionsKt.doubleClamp($this$clamp.getZ(), min.getZ(), max.getZ()), FunctionsKt.doubleClamp($this$clamp.getW(), min.getW(), max.getW()));
    }

    @NotNull
    public static final IntVector2 clamp(@NotNull IntVector2 $this$clamp, @NotNull IntVector2 min, @NotNull IntVector2 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "$this$clamp");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new IntVector2(FunctionsKt.intClamp($this$clamp.getX(), min.getX(), max.getX()), FunctionsKt.intClamp($this$clamp.getY(), min.getY(), max.getY()));
    }

    @NotNull
    public static final IntVector3 clamp(@NotNull IntVector3 $this$clamp, @NotNull IntVector3 min, @NotNull IntVector3 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "$this$clamp");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new IntVector3(FunctionsKt.intClamp($this$clamp.getX(), min.getX(), max.getX()), FunctionsKt.intClamp($this$clamp.getY(), min.getY(), max.getY()), FunctionsKt.intClamp($this$clamp.getZ(), min.getY(), max.getZ()));
    }

    @NotNull
    public static final IntVector4 clamp(@NotNull IntVector4 $this$clamp, @NotNull IntVector4 min, @NotNull IntVector4 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "$this$clamp");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new IntVector4(FunctionsKt.intClamp($this$clamp.getX(), min.getX(), max.getX()), FunctionsKt.intClamp($this$clamp.getY(), min.getY(), max.getY()), FunctionsKt.intClamp($this$clamp.getZ(), min.getZ(), max.getZ()), FunctionsKt.intClamp($this$clamp.getW(), min.getW(), max.getW()));
    }
}

