/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b'\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 Y2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001YB\u00a5\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\r\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0014J\t\u00103\u001a\u00020\u0004H\u00c6\u0003J\t\u00104\u001a\u00020\u0004H\u00c6\u0003J\t\u00105\u001a\u00020\u0004H\u00c6\u0003J\t\u00106\u001a\u00020\u0004H\u00c6\u0003J\t\u00107\u001a\u00020\u0004H\u00c6\u0003J\t\u00108\u001a\u00020\u0004H\u00c6\u0003J\t\u00109\u001a\u00020\u0004H\u00c6\u0003J\t\u0010:\u001a\u00020\u0004H\u00c6\u0003J\t\u0010;\u001a\u00020\u0004H\u00c6\u0003J\t\u0010<\u001a\u00020\u0004H\u00c6\u0003J\t\u0010=\u001a\u00020\u0004H\u00c6\u0003J\t\u0010>\u001a\u00020\u0004H\u00c6\u0003J\t\u0010?\u001a\u00020\u0004H\u00c6\u0003J\t\u0010@\u001a\u00020\u0004H\u00c6\u0003J\t\u0010A\u001a\u00020\u0004H\u00c6\u0003J\t\u0010B\u001a\u00020\u0004H\u00c6\u0003J\u00a9\u0001\u0010C\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0004H\u00c6\u0001J\u0011\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0004H\u0096\u0002J\u0013\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u00d6\u0003J\u0011\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0086\u0002J\t\u0010N\u001a\u00020MH\u00d6\u0001J\u0011\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010Q\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010R\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010R\u001a\u00020K2\u0006\u0010T\u001a\u00020KH\u0086\u0002J\u0006\u0010U\u001a\u00020VJ\b\u0010W\u001a\u00020XH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016R\u0011\u0010&\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0011\u0010(\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0016R\u0011\u00101\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b2\u0010*\u00a8\u0006Z"}, d2={"Lorg/openrndr/math/Matrix44;", "Ljava/io/Serializable;", "Lorg/openrndr/math/LinearType;", "c0r0", "", "c1r0", "c2r0", "c3r0", "c0r1", "c1r1", "c2r1", "c3r1", "c0r2", "c1r2", "c2r2", "c3r2", "c0r3", "c1r3", "c2r3", "c3r3", "(DDDDDDDDDDDDDDDD)V", "getC0r0", "()D", "getC0r1", "getC0r2", "getC0r3", "getC1r0", "getC1r1", "getC1r2", "getC1r3", "getC2r0", "getC2r1", "getC2r2", "getC2r3", "getC3r0", "getC3r1", "getC3r2", "getC3r3", "determinant", "getDeterminant", "inversed", "getInversed", "()Lorg/openrndr/math/Matrix44;", "matrix33", "Lorg/openrndr/math/Matrix33;", "getMatrix33", "()Lorg/openrndr/math/Matrix33;", "trace", "getTrace", "transposed", "getTransposed", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "div", "s", "equals", "", "other", "", "get", "Lorg/openrndr/math/Vector4;", "index", "", "hashCode", "minus", "o", "plus", "times", "mat", "v", "toDoubleArray", "", "toString", "", "Companion", "openrndr-math"})
public final class Matrix44
implements Serializable,
LinearType<Matrix44> {
    private final double c0r0;
    private final double c1r0;
    private final double c2r0;
    private final double c3r0;
    private final double c0r1;
    private final double c1r1;
    private final double c2r1;
    private final double c3r1;
    private final double c0r2;
    private final double c1r2;
    private final double c2r2;
    private final double c3r2;
    private final double c0r3;
    private final double c1r3;
    private final double c2r3;
    private final double c3r3;
    @NotNull
    private static final Matrix44 IDENTITY;
    @NotNull
    private static final Matrix44 ZERO;
    public static final Companion Companion;

    @NotNull
    public final double[] toDoubleArray() {
        return new double[]{this.c0r0, this.c1r0, this.c2r0, this.c3r0, this.c0r1, this.c1r1, this.c2r1, this.c3r1, this.c0r2, this.c1r2, this.c2r2, this.c3r2, this.c0r3, this.c1r3, this.c2r3, this.c3r3};
    }

    @NotNull
    public final Vector4 get(int index) {
        Vector4 vector4;
        switch (index) {
            case 0: {
                vector4 = new Vector4(this.c0r0, this.c0r1, this.c0r2, this.c0r3);
                break;
            }
            case 1: {
                vector4 = new Vector4(this.c1r0, this.c1r1, this.c1r2, this.c1r3);
                break;
            }
            case 2: {
                vector4 = new Vector4(this.c2r0, this.c2r1, this.c2r2, this.c2r3);
                break;
            }
            case 3: {
                vector4 = new Vector4(this.c3r0, this.c3r1, this.c3r2, this.c3r3);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("not implemented");
            }
        }
        return vector4;
    }

    @NotNull
    public final Matrix44 getInversed() {
        if (this == IDENTITY) {
            return this;
        }
        double n00 = this.c1r2 * this.c2r3 * this.c3r1 - this.c1r3 * this.c2r2 * this.c3r1 + this.c1r3 * this.c2r1 * this.c3r2 - this.c1r1 * this.c2r3 * this.c3r2 - this.c1r2 * this.c2r1 * this.c3r3 + this.c1r1 * this.c2r2 * this.c3r3;
        double n01 = this.c0r3 * this.c2r2 * this.c3r1 - this.c0r2 * this.c2r3 * this.c3r1 - this.c0r3 * this.c2r1 * this.c3r2 + this.c0r1 * this.c2r3 * this.c3r2 + this.c0r2 * this.c2r1 * this.c3r3 - this.c0r1 * this.c2r2 * this.c3r3;
        double n02 = this.c0r2 * this.c1r3 * this.c3r1 - this.c0r3 * this.c1r2 * this.c3r1 + this.c0r3 * this.c1r1 * this.c3r2 - this.c0r1 * this.c1r3 * this.c3r2 - this.c0r2 * this.c1r1 * this.c3r3 + this.c0r1 * this.c1r2 * this.c3r3;
        double n03 = this.c0r3 * this.c1r2 * this.c2r1 - this.c0r2 * this.c1r3 * this.c2r1 - this.c0r3 * this.c1r1 * this.c2r2 + this.c0r1 * this.c1r3 * this.c2r2 + this.c0r2 * this.c1r1 * this.c2r3 - this.c0r1 * this.c1r2 * this.c2r3;
        double n10 = this.c1r3 * this.c2r2 * this.c3r0 - this.c1r2 * this.c2r3 * this.c3r0 - this.c1r3 * this.c2r0 * this.c3r2 + this.c1r0 * this.c2r3 * this.c3r2 + this.c1r2 * this.c2r0 * this.c3r3 - this.c1r0 * this.c2r2 * this.c3r3;
        double n11 = this.c0r2 * this.c2r3 * this.c3r0 - this.c0r3 * this.c2r2 * this.c3r0 + this.c0r3 * this.c2r0 * this.c3r2 - this.c0r0 * this.c2r3 * this.c3r2 - this.c0r2 * this.c2r0 * this.c3r3 + this.c0r0 * this.c2r2 * this.c3r3;
        double n12 = this.c0r3 * this.c1r2 * this.c3r0 - this.c0r2 * this.c1r3 * this.c3r0 - this.c0r3 * this.c1r0 * this.c3r2 + this.c0r0 * this.c1r3 * this.c3r2 + this.c0r2 * this.c1r0 * this.c3r3 - this.c0r0 * this.c1r2 * this.c3r3;
        double n13 = this.c0r2 * this.c1r3 * this.c2r0 - this.c0r3 * this.c1r2 * this.c2r0 + this.c0r3 * this.c1r0 * this.c2r2 - this.c0r0 * this.c1r3 * this.c2r2 - this.c0r2 * this.c1r0 * this.c2r3 + this.c0r0 * this.c1r2 * this.c2r3;
        double n20 = this.c1r1 * this.c2r3 * this.c3r0 - this.c1r3 * this.c2r1 * this.c3r0 + this.c1r3 * this.c2r0 * this.c3r1 - this.c1r0 * this.c2r3 * this.c3r1 - this.c1r1 * this.c2r0 * this.c3r3 + this.c1r0 * this.c2r1 * this.c3r3;
        double n21 = this.c0r3 * this.c2r1 * this.c3r0 - this.c0r1 * this.c2r3 * this.c3r0 - this.c0r3 * this.c2r0 * this.c3r1 + this.c0r0 * this.c2r3 * this.c3r1 + this.c0r1 * this.c2r0 * this.c3r3 - this.c0r0 * this.c2r1 * this.c3r3;
        double n22 = this.c0r1 * this.c1r3 * this.c3r0 - this.c0r3 * this.c1r1 * this.c3r0 + this.c0r3 * this.c1r0 * this.c3r1 - this.c0r0 * this.c1r3 * this.c3r1 - this.c0r1 * this.c1r0 * this.c3r3 + this.c0r0 * this.c1r1 * this.c3r3;
        double n23 = this.c0r3 * this.c1r1 * this.c2r0 - this.c0r1 * this.c1r3 * this.c2r0 - this.c0r3 * this.c1r0 * this.c2r1 + this.c0r0 * this.c1r3 * this.c2r1 + this.c0r1 * this.c1r0 * this.c2r3 - this.c0r0 * this.c1r1 * this.c2r3;
        double n30 = this.c1r2 * this.c2r1 * this.c3r0 - this.c1r1 * this.c2r2 * this.c3r0 - this.c1r2 * this.c2r0 * this.c3r1 + this.c1r0 * this.c2r2 * this.c3r1 + this.c1r1 * this.c2r0 * this.c3r2 - this.c1r0 * this.c2r1 * this.c3r2;
        double n31 = this.c0r1 * this.c2r2 * this.c3r0 - this.c0r2 * this.c2r1 * this.c3r0 + this.c0r2 * this.c2r0 * this.c3r1 - this.c0r0 * this.c2r2 * this.c3r1 - this.c0r1 * this.c2r0 * this.c3r2 + this.c0r0 * this.c2r1 * this.c3r2;
        double n32 = this.c0r2 * this.c1r1 * this.c3r0 - this.c0r1 * this.c1r2 * this.c3r0 - this.c0r2 * this.c1r0 * this.c3r1 + this.c0r0 * this.c1r2 * this.c3r1 + this.c0r1 * this.c1r0 * this.c3r2 - this.c0r0 * this.c1r1 * this.c3r2;
        double n33 = this.c0r1 * this.c1r2 * this.c2r0 - this.c0r2 * this.c1r1 * this.c2r0 + this.c0r2 * this.c1r0 * this.c2r1 - this.c0r0 * this.c1r2 * this.c2r1 - this.c0r1 * this.c1r0 * this.c2r2 + this.c0r0 * this.c1r1 * this.c2r2;
        double d = this.getDeterminant();
        return new Matrix44(n00 / d, n10 / d, n20 / d, n30 / d, n01 / d, n11 / d, n21 / d, n31 / d, n02 / d, n12 / d, n22 / d, n32 / d, n03 / d, n13 / d, n23 / d, n33 / d);
    }

    public final double getTrace() {
        return this.c0r0 + this.c1r1 + this.c2r2 + this.c3r3;
    }

    public final double getDeterminant() {
        return this.c0r3 * this.c1r2 * this.c2r1 * this.c3r0 - this.c0r2 * this.c1r3 * this.c2r1 * this.c3r0 - this.c0r3 * this.c1r1 * this.c2r2 * this.c3r0 + this.c0r1 * this.c1r3 * this.c2r2 * this.c3r0 + this.c0r2 * this.c1r1 * this.c2r3 * this.c3r0 - this.c0r1 * this.c1r2 * this.c2r3 * this.c3r0 - this.c0r3 * this.c1r2 * this.c2r0 * this.c3r1 + this.c0r2 * this.c1r3 * this.c2r0 * this.c3r1 + this.c0r3 * this.c1r0 * this.c2r2 * this.c3r1 - this.c0r0 * this.c1r3 * this.c2r2 * this.c3r1 - this.c0r2 * this.c1r0 * this.c2r3 * this.c3r1 + this.c0r0 * this.c1r2 * this.c2r3 * this.c3r1 + this.c0r3 * this.c1r1 * this.c2r0 * this.c3r2 - this.c0r1 * this.c1r3 * this.c2r0 * this.c3r2 - this.c0r3 * this.c1r0 * this.c2r1 * this.c3r2 + this.c0r0 * this.c1r3 * this.c2r1 * this.c3r2 + this.c0r1 * this.c1r0 * this.c2r3 * this.c3r2 - this.c0r0 * this.c1r1 * this.c2r3 * this.c3r2 - this.c0r2 * this.c1r1 * this.c2r0 * this.c3r3 + this.c0r1 * this.c1r2 * this.c2r0 * this.c3r3 + this.c0r2 * this.c1r0 * this.c2r1 * this.c3r3 - this.c0r0 * this.c1r2 * this.c2r1 * this.c3r3 - this.c0r1 * this.c1r0 * this.c2r2 * this.c3r3 + this.c0r0 * this.c1r1 * this.c2r2 * this.c3r3;
    }

    @Override
    @NotNull
    public Matrix44 plus(@NotNull Matrix44 o) {
        Intrinsics.checkNotNullParameter(o, "o");
        return new Matrix44(this.c0r0 + o.c0r0, this.c1r0 + o.c1r0, this.c2r0 + o.c2r0, this.c3r0 + o.c3r0, this.c0r1 + o.c0r1, this.c1r1 + o.c1r1, this.c2r1 + o.c2r1, this.c3r1 + o.c3r1, this.c0r2 + o.c0r2, this.c1r2 + o.c1r2, this.c2r2 + o.c2r2, this.c3r2 + o.c3r2, this.c0r3 + o.c0r3, this.c1r3 + o.c1r3, this.c2r3 + o.c2r3, this.c3r3 + o.c3r3);
    }

    @Override
    @NotNull
    public Matrix44 minus(@NotNull Matrix44 o) {
        Intrinsics.checkNotNullParameter(o, "o");
        return new Matrix44(this.c0r0 - o.c0r0, this.c1r0 - o.c1r0, this.c2r0 - o.c2r0, this.c3r0 - o.c3r0, this.c0r1 - o.c0r1, this.c1r1 - o.c1r1, this.c2r1 - o.c2r1, this.c3r1 - o.c3r1, this.c0r2 - o.c0r2, this.c1r2 - o.c1r2, this.c2r2 - o.c2r2, this.c3r2 - o.c3r2, this.c0r3 - o.c0r3, this.c1r3 - o.c1r3, this.c2r3 - o.c2r3, this.c3r3 - o.c3r3);
    }

    @NotNull
    public final Matrix44 getTransposed() {
        return new Matrix44(this.c0r0, this.c0r1, this.c0r2, this.c0r3, this.c1r0, this.c1r1, this.c1r2, this.c1r3, this.c2r0, this.c2r1, this.c2r2, this.c2r3, this.c3r0, this.c3r1, this.c3r2, this.c3r3);
    }

    @NotNull
    public final Matrix33 getMatrix33() {
        return new Matrix33(this.c0r0, this.c1r0, this.c2r0, this.c0r1, this.c1r1, this.c2r1, this.c0r2, this.c1r2, this.c2r2);
    }

    @NotNull
    public final Vector4 times(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(v.getX() * this.c0r0 + v.getY() * this.c1r0 + v.getZ() * this.c2r0 + v.getW() * this.c3r0, v.getX() * this.c0r1 + v.getY() * this.c1r1 + v.getZ() * this.c2r1 + v.getW() * this.c3r1, v.getX() * this.c0r2 + v.getY() * this.c1r2 + v.getZ() * this.c2r2 + v.getW() * this.c3r2, v.getX() * this.c0r3 + v.getY() * this.c1r3 + v.getZ() * this.c2r3 + v.getW() * this.c3r3);
    }

    @Override
    @NotNull
    public Matrix44 times(double s2) {
        return new Matrix44(s2 * this.c0r0, s2 * this.c1r0, s2 * this.c2r0, s2 * this.c3r0, s2 * this.c0r1, s2 * this.c1r1, s2 * this.c2r1, s2 * this.c3r1, s2 * this.c0r2, s2 * this.c1r2, s2 * this.c2r2, s2 * this.c3r2, s2 * this.c0r3, s2 * this.c1r3, s2 * this.c2r3, s2 * this.c3r3);
    }

    @Override
    @NotNull
    public Matrix44 div(double s2) {
        return new Matrix44(s2 / this.c0r0, s2 / this.c1r0, s2 / this.c2r0, s2 / this.c3r0, s2 / this.c0r1, s2 / this.c1r1, s2 / this.c2r1, s2 / this.c3r1, s2 / this.c0r2, s2 / this.c1r2, s2 / this.c2r2, s2 / this.c3r2, s2 / this.c0r3, s2 / this.c1r3, s2 / this.c2r3, s2 / this.c3r3);
    }

    @NotNull
    public final Matrix44 times(@NotNull Matrix44 mat) {
        Intrinsics.checkNotNullParameter(mat, "mat");
        return this == IDENTITY ? mat : (mat == IDENTITY ? this : new Matrix44(this.c0r0 * mat.c0r0 + this.c1r0 * mat.c0r1 + this.c2r0 * mat.c0r2 + this.c3r0 * mat.c0r3, this.c0r0 * mat.c1r0 + this.c1r0 * mat.c1r1 + this.c2r0 * mat.c1r2 + this.c3r0 * mat.c1r3, this.c0r0 * mat.c2r0 + this.c1r0 * mat.c2r1 + this.c2r0 * mat.c2r2 + this.c3r0 * mat.c2r3, this.c0r0 * mat.c3r0 + this.c1r0 * mat.c3r1 + this.c2r0 * mat.c3r2 + this.c3r0 * mat.c3r3, this.c0r1 * mat.c0r0 + this.c1r1 * mat.c0r1 + this.c2r1 * mat.c0r2 + this.c3r1 * mat.c0r3, this.c0r1 * mat.c1r0 + this.c1r1 * mat.c1r1 + this.c2r1 * mat.c1r2 + this.c3r1 * mat.c1r3, this.c0r1 * mat.c2r0 + this.c1r1 * mat.c2r1 + this.c2r1 * mat.c2r2 + this.c3r1 * mat.c2r3, this.c0r1 * mat.c3r0 + this.c1r1 * mat.c3r1 + this.c2r1 * mat.c3r2 + this.c3r1 * mat.c3r3, this.c0r2 * mat.c0r0 + this.c1r2 * mat.c0r1 + this.c2r2 * mat.c0r2 + this.c3r2 * mat.c0r3, this.c0r2 * mat.c1r0 + this.c1r2 * mat.c1r1 + this.c2r2 * mat.c1r2 + this.c3r2 * mat.c1r3, this.c0r2 * mat.c2r0 + this.c1r2 * mat.c2r1 + this.c2r2 * mat.c2r2 + this.c3r2 * mat.c2r3, this.c0r2 * mat.c3r0 + this.c1r2 * mat.c3r1 + this.c2r2 * mat.c3r2 + this.c3r2 * mat.c3r3, this.c0r3 * mat.c0r0 + this.c1r3 * mat.c0r1 + this.c2r3 * mat.c0r2 + this.c3r3 * mat.c0r3, this.c0r3 * mat.c1r0 + this.c1r3 * mat.c1r1 + this.c2r3 * mat.c1r2 + this.c3r3 * mat.c1r3, this.c0r3 * mat.c2r0 + this.c1r3 * mat.c2r1 + this.c2r3 * mat.c2r2 + this.c3r3 * mat.c2r3, this.c0r3 * mat.c3r0 + this.c1r3 * mat.c3r1 + this.c2r3 * mat.c3r2 + this.c3r3 * mat.c3r3));
    }

    @NotNull
    public String toString() {
        return this.c0r0 + ", " + this.c1r0 + ", " + this.c2r0 + ", " + this.c3r0 + '\n' + this.c0r1 + ", " + this.c1r1 + ", " + this.c2r1 + ", " + this.c3r1 + '\n' + this.c0r2 + ", " + this.c1r2 + ", " + this.c2r2 + ", " + this.c3r2 + '\n' + this.c0r3 + ", " + this.c1r3 + ", " + this.c2r3 + ", " + this.c3r3;
    }

    public final double getC0r0() {
        return this.c0r0;
    }

    public final double getC1r0() {
        return this.c1r0;
    }

    public final double getC2r0() {
        return this.c2r0;
    }

    public final double getC3r0() {
        return this.c3r0;
    }

    public final double getC0r1() {
        return this.c0r1;
    }

    public final double getC1r1() {
        return this.c1r1;
    }

    public final double getC2r1() {
        return this.c2r1;
    }

    public final double getC3r1() {
        return this.c3r1;
    }

    public final double getC0r2() {
        return this.c0r2;
    }

    public final double getC1r2() {
        return this.c1r2;
    }

    public final double getC2r2() {
        return this.c2r2;
    }

    public final double getC3r2() {
        return this.c3r2;
    }

    public final double getC0r3() {
        return this.c0r3;
    }

    public final double getC1r3() {
        return this.c1r3;
    }

    public final double getC2r3() {
        return this.c2r3;
    }

    public final double getC3r3() {
        return this.c3r3;
    }

    public Matrix44(double c0r0, double c1r0, double c2r0, double c3r0, double c0r1, double c1r1, double c2r1, double c3r1, double c0r2, double c1r2, double c2r2, double c3r2, double c0r3, double c1r3, double c2r3, double c3r3) {
        this.c0r0 = c0r0;
        this.c1r0 = c1r0;
        this.c2r0 = c2r0;
        this.c3r0 = c3r0;
        this.c0r1 = c0r1;
        this.c1r1 = c1r1;
        this.c2r1 = c2r1;
        this.c3r1 = c3r1;
        this.c0r2 = c0r2;
        this.c1r2 = c1r2;
        this.c2r2 = c2r2;
        this.c3r2 = c3r2;
        this.c0r3 = c0r3;
        this.c1r3 = c1r3;
        this.c2r3 = c2r3;
        this.c3r3 = c3r3;
    }

    public /* synthetic */ Matrix44(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d7 = 0.0;
        }
        if ((n & 0x80) != 0) {
            d8 = 0.0;
        }
        if ((n & 0x100) != 0) {
            d9 = 0.0;
        }
        if ((n & 0x200) != 0) {
            d10 = 0.0;
        }
        if ((n & 0x400) != 0) {
            d11 = 0.0;
        }
        if ((n & 0x800) != 0) {
            d12 = 0.0;
        }
        if ((n & 0x1000) != 0) {
            d13 = 0.0;
        }
        if ((n & 0x2000) != 0) {
            d14 = 0.0;
        }
        if ((n & 0x4000) != 0) {
            d15 = 0.0;
        }
        if ((n & 0x8000) != 0) {
            d16 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
    }

    public Matrix44() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 65535, null);
    }

    static {
        Companion = new Companion(null);
        IDENTITY = new Matrix44(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 31710, null);
        ZERO = new Matrix44(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 65535, null);
    }

    public final double component1() {
        return this.c0r0;
    }

    public final double component2() {
        return this.c1r0;
    }

    public final double component3() {
        return this.c2r0;
    }

    public final double component4() {
        return this.c3r0;
    }

    public final double component5() {
        return this.c0r1;
    }

    public final double component6() {
        return this.c1r1;
    }

    public final double component7() {
        return this.c2r1;
    }

    public final double component8() {
        return this.c3r1;
    }

    public final double component9() {
        return this.c0r2;
    }

    public final double component10() {
        return this.c1r2;
    }

    public final double component11() {
        return this.c2r2;
    }

    public final double component12() {
        return this.c3r2;
    }

    public final double component13() {
        return this.c0r3;
    }

    public final double component14() {
        return this.c1r3;
    }

    public final double component15() {
        return this.c2r3;
    }

    public final double component16() {
        return this.c3r3;
    }

    @NotNull
    public final Matrix44 copy(double c0r0, double c1r0, double c2r0, double c3r0, double c0r1, double c1r1, double c2r1, double c3r1, double c0r2, double c1r2, double c2r2, double c3r2, double c0r3, double c1r3, double c2r3, double c3r3) {
        return new Matrix44(c0r0, c1r0, c2r0, c3r0, c0r1, c1r1, c2r1, c3r1, c0r2, c1r2, c2r2, c3r2, c0r3, c1r3, c2r3, c3r3);
    }

    public static /* synthetic */ Matrix44 copy$default(Matrix44 matrix44, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, int n, Object object) {
        if ((n & 1) != 0) {
            d = matrix44.c0r0;
        }
        if ((n & 2) != 0) {
            d2 = matrix44.c1r0;
        }
        if ((n & 4) != 0) {
            d3 = matrix44.c2r0;
        }
        if ((n & 8) != 0) {
            d4 = matrix44.c3r0;
        }
        if ((n & 0x10) != 0) {
            d5 = matrix44.c0r1;
        }
        if ((n & 0x20) != 0) {
            d6 = matrix44.c1r1;
        }
        if ((n & 0x40) != 0) {
            d7 = matrix44.c2r1;
        }
        if ((n & 0x80) != 0) {
            d8 = matrix44.c3r1;
        }
        if ((n & 0x100) != 0) {
            d9 = matrix44.c0r2;
        }
        if ((n & 0x200) != 0) {
            d10 = matrix44.c1r2;
        }
        if ((n & 0x400) != 0) {
            d11 = matrix44.c2r2;
        }
        if ((n & 0x800) != 0) {
            d12 = matrix44.c3r2;
        }
        if ((n & 0x1000) != 0) {
            d13 = matrix44.c0r3;
        }
        if ((n & 0x2000) != 0) {
            d14 = matrix44.c1r3;
        }
        if ((n & 0x4000) != 0) {
            d15 = matrix44.c2r3;
        }
        if ((n & 0x8000) != 0) {
            d16 = matrix44.c3r3;
        }
        return matrix44.copy(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.c0r0);
        long l2 = Double.doubleToLongBits(this.c1r0);
        long l3 = Double.doubleToLongBits(this.c2r0);
        long l4 = Double.doubleToLongBits(this.c3r0);
        long l5 = Double.doubleToLongBits(this.c0r1);
        long l6 = Double.doubleToLongBits(this.c1r1);
        long l7 = Double.doubleToLongBits(this.c2r1);
        long l8 = Double.doubleToLongBits(this.c3r1);
        long l9 = Double.doubleToLongBits(this.c0r2);
        long l10 = Double.doubleToLongBits(this.c1r2);
        long l11 = Double.doubleToLongBits(this.c2r2);
        long l12 = Double.doubleToLongBits(this.c3r2);
        long l13 = Double.doubleToLongBits(this.c0r3);
        long l14 = Double.doubleToLongBits(this.c1r3);
        long l15 = Double.doubleToLongBits(this.c2r3);
        long l16 = Double.doubleToLongBits(this.c3r3);
        return (((((((((((((((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + (int)(l5 ^ l5 >>> 32)) * 31 + (int)(l6 ^ l6 >>> 32)) * 31 + (int)(l7 ^ l7 >>> 32)) * 31 + (int)(l8 ^ l8 >>> 32)) * 31 + (int)(l9 ^ l9 >>> 32)) * 31 + (int)(l10 ^ l10 >>> 32)) * 31 + (int)(l11 ^ l11 >>> 32)) * 31 + (int)(l12 ^ l12 >>> 32)) * 31 + (int)(l13 ^ l13 >>> 32)) * 31 + (int)(l14 ^ l14 >>> 32)) * 31 + (int)(l15 ^ l15 >>> 32)) * 31 + (int)(l16 ^ l16 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Matrix44)) break block3;
                Matrix44 matrix44 = (Matrix44)object;
                if (Double.compare(this.c0r0, matrix44.c0r0) != 0 || Double.compare(this.c1r0, matrix44.c1r0) != 0 || Double.compare(this.c2r0, matrix44.c2r0) != 0 || Double.compare(this.c3r0, matrix44.c3r0) != 0 || Double.compare(this.c0r1, matrix44.c0r1) != 0 || Double.compare(this.c1r1, matrix44.c1r1) != 0 || Double.compare(this.c2r1, matrix44.c2r1) != 0 || Double.compare(this.c3r1, matrix44.c3r1) != 0 || Double.compare(this.c0r2, matrix44.c0r2) != 0 || Double.compare(this.c1r2, matrix44.c1r2) != 0 || Double.compare(this.c2r2, matrix44.c2r2) != 0 || Double.compare(this.c3r2, matrix44.c3r2) != 0 || Double.compare(this.c0r3, matrix44.c0r3) != 0 || Double.compare(this.c1r3, matrix44.c1r3) != 0 || Double.compare(this.c2r3, matrix44.c2r3) != 0 || Double.compare(this.c3r3, matrix44.c3r3) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/math/Matrix44$Companion;", "", "()V", "IDENTITY", "Lorg/openrndr/math/Matrix44;", "getIDENTITY", "()Lorg/openrndr/math/Matrix44;", "ZERO", "getZERO", "fromColumnVectors", "c0", "Lorg/openrndr/math/Vector4;", "c1", "c2", "c3", "fromDoubleArray", "a", "", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Matrix44 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix44 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Matrix44 fromColumnVectors(@NotNull Vector4 c0, @NotNull Vector4 c1, @NotNull Vector4 c2, @NotNull Vector4 c3) {
            Intrinsics.checkNotNullParameter(c0, "c0");
            Intrinsics.checkNotNullParameter(c1, "c1");
            Intrinsics.checkNotNullParameter(c2, "c2");
            Intrinsics.checkNotNullParameter(c3, "c3");
            return new Matrix44(c0.getX(), c1.getX(), c2.getX(), c3.getX(), c0.getY(), c1.getY(), c2.getY(), c3.getY(), c0.getZ(), c1.getZ(), c2.getZ(), c3.getZ(), c0.getW(), c1.getW(), c2.getW(), c3.getW());
        }

        @NotNull
        public final Matrix44 fromDoubleArray(@NotNull double[] a2) {
            Intrinsics.checkNotNullParameter(a2, "a");
            boolean bl = a2.length >= 16;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "input array is too short (" + a2.length + "}, should have at least a length of 16)";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Matrix44(a2[0], a2[1], a2[2], a2[3], a2[4], a2[5], a2[6], a2[7], a2[8], a2[9], a2[10], a2[11], a2[12], a2[13], a2[14], a2[15]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

