/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bJ\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\bJ\u0011\u0010(\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0003J\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0-2\u0006\u0010\u001a\u001a\u00020\bJ,\u0010,\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0-\u0018\u00010.2\u0006\u0010/\u001a\u00020\u00002\b\b\u0002\u00100\u001a\u00020\u0019J\u0011\u00101\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Lorg/openrndr/shape/Circle;", "", "x", "", "y", "radius", "(DDD)V", "center", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;D)V", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getRadius", "()D", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "component1", "component2", "contains", "", "point", "copy", "div", "scale", "equals", "other", "hashCode", "", "minus", "right", "moved", "offset", "movedTo", "position", "plus", "scaled", "scaledTo", "fitRadius", "tangents", "Lkotlin/Pair;", "", "c", "isInner", "times", "toString", "", "Companion", "openrndr-core"})
public final class Circle {
    @NotNull
    private final Vector2 center;
    private final double radius;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Circle moved(@NotNull Vector2 offset2) {
        Intrinsics.checkNotNullParameter(offset2, "offset");
        return new Circle(this.center.plus(offset2), this.radius);
    }

    @NotNull
    public final Circle movedTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new Circle(position, this.radius);
    }

    @NotNull
    public final Circle scaled(double scale2) {
        return new Circle(this.center, this.radius * scale2);
    }

    @NotNull
    public final Circle scaledTo(double fitRadius) {
        return new Circle(this.center, fitRadius);
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return point.minus(this.center).getSquaredLength() < this.radius * this.radius;
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        double x = this.center.getX() - this.radius;
        double y = this.center.getY() - this.radius;
        double width = this.radius * 2.0;
        double height = this.radius * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        return ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(x, ym, oy, xm, ox, y, xe, ye){
            final /* synthetic */ double $x;
            final /* synthetic */ double $ym;
            final /* synthetic */ double $oy;
            final /* synthetic */ double $xm;
            final /* synthetic */ double $ox;
            final /* synthetic */ double $y;
            final /* synthetic */ double $xe;
            final /* synthetic */ double $ye;

            public final void invoke(@NotNull ContourBuilder $this$contour) {
                Intrinsics.checkNotNullParameter($this$contour, "$receiver");
                $this$contour.moveTo(new Vector2(this.$x, this.$ym));
                $this$contour.curveTo(new Vector2(this.$x, this.$ym - this.$oy), new Vector2(this.$xm - this.$ox, this.$y), new Vector2(this.$xm, this.$y));
                $this$contour.curveTo(new Vector2(this.$xm + this.$ox, this.$y), new Vector2(this.$xe, this.$ym - this.$oy), new Vector2(this.$xe, this.$ym));
                $this$contour.curveTo(new Vector2(this.$xe, this.$ym + this.$oy), new Vector2(this.$xm + this.$ox, this.$ye), new Vector2(this.$xm, this.$ye));
                $this$contour.curveTo(new Vector2(this.$xm - this.$ox, this.$ye), new Vector2(this.$x, this.$ym + this.$oy), new Vector2(this.$x, this.$ym));
                $this$contour.close();
            }
            {
                this.$x = d;
                this.$ym = d2;
                this.$oy = d3;
                this.$xm = d4;
                this.$ox = d5;
                this.$y = d6;
                this.$xe = d7;
                this.$ye = d8;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Pair<Vector2, Vector2>> tangents(@NotNull Circle c, boolean isInner2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(c, "c");
        double r1 = this.radius;
        double r2 = isInner2 ? -c.radius : c.radius;
        Vector2 w = c.center.minus(this.center);
        double d = w.getLength();
        double dr = r1 - r2;
        boolean bl = false;
        double d2 = Math.sqrt(d);
        double d3 = d;
        double d4 = 2.0;
        boolean bl2 = false;
        double d5 = Math.pow(d3, d4);
        d3 = dr;
        d4 = 2.0;
        bl2 = false;
        d3 = d5 - Math.pow(d3, d4);
        boolean bl3 = false;
        double h = Math.sqrt(d3);
        if (d2 == 0.0) {
            return null;
        }
        Iterable $this$map$iv = CollectionsKt.listOf(-1.0, 1.0);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sign;
            double d6 = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            double d7 = d;
            double d8 = 2.0;
            boolean bl5 = false;
            Vector2 v = w.times(dr).plus(Vector2.perpendicular$default(w, null, 1, null).times(h).times((double)sign)).div(Math.pow(d7, d8));
            Pair<Vector2, Vector2> pair = new Pair<Vector2, Vector2>(this.center.plus(v.times(r1)), c.center.plus(v.times(r2)));
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List tangents$default(Circle circle, Circle circle2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return circle.tangents(circle2, bl);
    }

    @NotNull
    public final Pair<Vector2, Vector2> tangents(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        Polar v = Polar.Companion.fromVector(point.minus(this.center));
        double b = v.getRadius();
        double d = this.radius / b;
        boolean bl = false;
        double theta = Math.toDegrees(Math.acos(d));
        double d1 = v.getTheta() + theta;
        double d2 = v.getTheta() - theta;
        Vector2 tp = this.center.plus(new Polar(d1, this.radius).getCartesian());
        Vector2 tp2 = this.center.plus(new Polar(d2, this.radius).getCartesian());
        return new Pair<Vector2, Vector2>(tp, tp2);
    }

    @NotNull
    public final Circle times(double scale2) {
        return new Circle(this.center.times(scale2), this.radius * scale2);
    }

    @NotNull
    public final Circle div(double scale2) {
        return new Circle(this.center.div(scale2), this.radius / scale2);
    }

    @NotNull
    public final Circle plus(@NotNull Circle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Circle(this.center.plus(right.center), this.radius + right.radius);
    }

    @NotNull
    public final Circle minus(@NotNull Circle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Circle(this.center.minus(right.center), this.radius - right.radius);
    }

    @NotNull
    public final Vector2 getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    public Circle(@NotNull Vector2 center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.radius = radius;
    }

    public Circle(double x, double y, double radius) {
        this(new Vector2(x, y), radius);
    }

    @NotNull
    public final Vector2 component1() {
        return this.center;
    }

    public final double component2() {
        return this.radius;
    }

    @NotNull
    public final Circle copy(@NotNull Vector2 center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new Circle(center, radius);
    }

    public static /* synthetic */ Circle copy$default(Circle circle, Vector2 vector2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = circle.center;
        }
        if ((n & 2) != 0) {
            d = circle.radius;
        }
        return circle.copy(vector2, d);
    }

    @NotNull
    public String toString() {
        return "Circle(center=" + this.center + ", radius=" + this.radius + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.center;
        long l = Double.doubleToLongBits(this.radius);
        return (vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (int)(l ^ l >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Circle)) break block3;
                Circle circle = (Circle)object;
                if (!Intrinsics.areEqual(this.center, circle.center) || Double.compare(this.radius, circle.radius) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/openrndr/shape/Circle$Companion;", "", "()V", "fromPoints", "Lorg/openrndr/shape/Circle;", "a", "Lorg/openrndr/math/Vector2;", "b", "c", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final Circle fromPoints(@NotNull Vector2 a2, @NotNull Vector2 b) {
            Intrinsics.checkNotNullParameter(a2, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Vector2 center = a2.plus(b).times(0.5);
            return new Circle(center, b.minus(center).getLength());
        }

        @NotNull
        public final Circle fromPoints(@NotNull Vector2 a2, @NotNull Vector2 b, @NotNull Vector2 c) {
            Intrinsics.checkNotNullParameter(a2, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(c, "c");
            double epsilon = 1.0E-7;
            double dyba = b.getY() - a2.getY();
            double dxba = b.getX() - a2.getX();
            double dycb = c.getY() - b.getY();
            double dxcb = c.getX() - b.getX();
            boolean bl = false;
            if (Math.abs(dxba) <= epsilon) {
                bl = false;
                if (Math.abs(dycb) <= epsilon) {
                    Vector2 center = b.plus(c).times(0.5);
                    double radius = center.distanceTo(a2);
                    return new Circle(center, radius);
                }
            }
            double baSlope = dyba / dxba;
            double cbSlope = dycb / dxcb;
            double d = baSlope - cbSlope;
            boolean bl2 = false;
            if (Math.abs(d) <= epsilon) {
                return new Circle(a2.plus(b).plus(c).div(3.0), 0.0);
            }
            double cx = (baSlope * cbSlope * (a2.getY() - c.getY()) + cbSlope * (a2.getX() + b.getX()) - baSlope * (b.getX() + c.getX())) / ((double)2 * (cbSlope - baSlope));
            double cy = (double)-1 * (cx - (a2.getX() + b.getX()) / (double)2) / baSlope + (a2.getY() + b.getY()) / (double)2;
            Vector2 center = new Vector2(cx, cy);
            return new Circle(center, center.distanceTo(a2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

