/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u001d\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\tJ\u0011\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000H\u0096\u0002J\u000e\u00100\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tJ\u0011\u00101\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000H\u0096\u0002J\u000e\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u0003J\u0018\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\u0003J\u0019\u00106\u001a\b\u0012\u0004\u0012\u00020\u0000072\u0006\u00103\u001a\u00020\u0003\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0096\u0002J\t\u0010<\u001a\u00020=H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012\u00a8\u0006>"}, d2={"Lorg/openrndr/shape/LineSegment;", "Lorg/openrndr/math/LinearType;", "x0", "", "y0", "x1", "y1", "(DDDD)V", "start", "Lorg/openrndr/math/Vector2;", "end", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "direction", "getDirection", "()Lorg/openrndr/math/Vector2;", "getEnd", "normal", "getNormal", "segment", "Lorg/openrndr/shape/Segment;", "getSegment", "()Lorg/openrndr/shape/Segment;", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getStart", "component1", "component2", "copy", "distance", "query", "div", "scale", "equals", "", "other", "", "extend", "times", "hashCode", "", "minus", "right", "nearest", "plus", "position", "t", "rotate", "degrees", "split", "", "(D)[Lorg/openrndr/shape/LineSegment;", "sub", "t0", "t1", "toString", "", "openrndr-core"})
public final class LineSegment
implements LinearType<LineSegment> {
    @NotNull
    private final Vector2 start;
    @NotNull
    private final Vector2 end;

    @NotNull
    public final Vector2 getDirection() {
        return this.end.minus(this.start);
    }

    @NotNull
    public final Vector2 getNormal() {
        return this.end.minus(this.start).getNormalized().perpendicular(YPolarity.CW_NEGATIVE_Y);
    }

    @NotNull
    public final Vector2 nearest(@NotNull Vector2 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        double l2 = this.end.minus(this.start).getSquaredLength();
        if (l2 == 0.0) {
            return this.start;
        }
        double t2 = ((query.getX() - this.start.getX()) * (this.end.getX() - this.start.getX()) + (query.getY() - this.start.getY()) * (this.end.getY() - this.start.getY())) / l2;
        double d = 0.0;
        double d2 = 1.0;
        boolean bl = false;
        d2 = Math.min(d2, t2);
        bl = false;
        t2 = Math.max(d, d2);
        return new Vector2(this.start.getX() + t2 * (this.end.getX() - this.start.getX()), this.start.getY() + t2 * (this.end.getY() - this.start.getY()));
    }

    public final double distance(@NotNull Vector2 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        return this.nearest(query).distanceTo(query);
    }

    @NotNull
    public final LineSegment sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final LineSegment[] split(double t2) {
        double u = RangesKt.coerceIn(t2, 0.0, 1.0);
        Vector2 cut = this.start.plus(this.end.minus(this.start).times(u));
        return new LineSegment[]{new LineSegment(this.start, cut), new LineSegment(cut, this.end)};
    }

    @NotNull
    public final Vector2 position(double t2) {
        return this.start.plus(this.end.minus(this.start).times(t2));
    }

    @NotNull
    public final LineSegment rotate(double degrees, double t2) {
        Vector2 anchorPoint = this.end.mix(this.start, RangesKt.coerceIn(t2, 0.0, 1.0));
        return new LineSegment(this.start.rotate(degrees, anchorPoint), this.end.rotate(degrees, anchorPoint));
    }

    public static /* synthetic */ LineSegment rotate$default(LineSegment lineSegment, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.5;
        }
        return lineSegment.rotate(d, d2);
    }

    @NotNull
    public final LineSegment extend(double times) {
        return new LineSegment(this.start.minus(this.getDirection().times(times)), this.end.plus(this.getDirection().times(times)));
    }

    @NotNull
    public final Segment getSegment() {
        return new Segment(this.start, this.end, false, 4, null);
    }

    @NotNull
    public final ShapeContour getContour() {
        return ShapeContour.Companion.fromPoints(CollectionsKt.listOf(this.start, this.end), false, YPolarity.CW_NEGATIVE_Y);
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @Override
    @NotNull
    public LineSegment times(double scale2) {
        return new LineSegment(this.start.times(scale2), this.end.times(scale2));
    }

    @Override
    @NotNull
    public LineSegment div(double scale2) {
        return new LineSegment(this.start.div(scale2), this.end.div(scale2));
    }

    @Override
    @NotNull
    public LineSegment plus(@NotNull LineSegment right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new LineSegment(this.start.plus(right.start), this.end.plus(right.end));
    }

    @Override
    @NotNull
    public LineSegment minus(@NotNull LineSegment right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new LineSegment(this.start.minus(right.start), this.end.minus(right.end));
    }

    @NotNull
    public final Vector2 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector2 getEnd() {
        return this.end;
    }

    public LineSegment(@NotNull Vector2 start2, @NotNull Vector2 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.end = end2;
    }

    public LineSegment(double x0, double y0, double x1, double y1) {
        this(new Vector2(x0, y0), new Vector2(x1, y1));
    }

    @NotNull
    public final Vector2 component1() {
        return this.start;
    }

    @NotNull
    public final Vector2 component2() {
        return this.end;
    }

    @NotNull
    public final LineSegment copy(@NotNull Vector2 start2, @NotNull Vector2 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        return new LineSegment(start2, end2);
    }

    public static /* synthetic */ LineSegment copy$default(LineSegment lineSegment, Vector2 vector2, Vector2 vector22, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = lineSegment.start;
        }
        if ((n & 2) != 0) {
            vector22 = lineSegment.end;
        }
        return lineSegment.copy(vector2, vector22);
    }

    @NotNull
    public String toString() {
        return "LineSegment(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.start;
        Vector2 vector22 = this.end;
        return (vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (vector22 != null ? ((Object)vector22).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LineSegment)) break block3;
                LineSegment lineSegment = (LineSegment)object;
                if (!Intrinsics.areEqual(this.start, lineSegment.start) || !Intrinsics.areEqual(this.end, lineSegment.end)) break block3;
            }
            return true;
        }
        return false;
    }
}

