/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bB'\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\nJ\u0018\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00032\b\b\u0002\u0010*\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u00060"}, d2={"Lorg/openrndr/shape/OrientedEllipse;", "", "x", "", "y", "xRadius", "yRadius", "rotation", "(DDDDD)V", "center", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;DDD)V", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getRotation", "()D", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getXRadius", "getYRadius", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "moved", "offset", "movedTo", "position", "scaled", "xScale", "yScale", "scaledTo", "xFitRadius", "yFitRadius", "toString", "", "openrndr-core"})
public final class OrientedEllipse {
    @NotNull
    private final Vector2 center;
    private final double xRadius;
    private final double yRadius;
    private final double rotation;

    @NotNull
    public final OrientedEllipse moved(@NotNull Vector2 offset2) {
        Intrinsics.checkNotNullParameter(offset2, "offset");
        return new OrientedEllipse(this.center.plus(offset2), this.xRadius, this.yRadius, this.rotation);
    }

    @NotNull
    public final OrientedEllipse movedTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new OrientedEllipse(position, this.xRadius, this.yRadius, this.rotation);
    }

    @NotNull
    public final OrientedEllipse scaled(double xScale, double yScale) {
        return new OrientedEllipse(this.center, this.xRadius * xScale, this.yRadius * yScale, this.rotation);
    }

    public static /* synthetic */ OrientedEllipse scaled$default(OrientedEllipse orientedEllipse, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return orientedEllipse.scaled(d, d2);
    }

    @NotNull
    public final OrientedEllipse scaledTo(double xFitRadius, double yFitRadius) {
        return new OrientedEllipse(this.center, xFitRadius, yFitRadius, this.rotation);
    }

    public static /* synthetic */ OrientedEllipse scaledTo$default(OrientedEllipse orientedEllipse, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return orientedEllipse.scaledTo(d, d2);
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        double x = this.center.getX() - this.xRadius;
        double y = this.center.getY() - this.yRadius;
        double width = this.xRadius * 2.0;
        double height = this.yRadius * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        Matrix44 t2 = TransformBuilderKt.transform$default(null, new Function1<TransformBuilder, Unit>(this){
            final /* synthetic */ OrientedEllipse this$0;

            public final void invoke(@NotNull TransformBuilder $this$transform) {
                Intrinsics.checkNotNullParameter($this$transform, "$receiver");
                $this$transform.translate(this.this$0.getCenter());
                $this$transform.rotate(Vector3.Companion.getUNIT_Z(), this.this$0.getRotation());
                $this$transform.translate(this.this$0.getCenter().unaryMinus());
            }
            {
                this.this$0 = orientedEllipse;
                super(1);
            }
        }, 1, null);
        return ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(x, ym, oy, xm, ox, y, xe, ye){
            final /* synthetic */ double $x;
            final /* synthetic */ double $ym;
            final /* synthetic */ double $oy;
            final /* synthetic */ double $xm;
            final /* synthetic */ double $ox;
            final /* synthetic */ double $y;
            final /* synthetic */ double $xe;
            final /* synthetic */ double $ye;

            public final void invoke(@NotNull ContourBuilder $this$contour) {
                Intrinsics.checkNotNullParameter($this$contour, "$receiver");
                $this$contour.moveTo(new Vector2(this.$x, this.$ym));
                $this$contour.curveTo(new Vector2(this.$x, this.$ym - this.$oy), new Vector2(this.$xm - this.$ox, this.$y), new Vector2(this.$xm, this.$y));
                $this$contour.curveTo(new Vector2(this.$xm + this.$ox, this.$y), new Vector2(this.$xe, this.$ym - this.$oy), new Vector2(this.$xe, this.$ym));
                $this$contour.curveTo(new Vector2(this.$xe, this.$ym + this.$oy), new Vector2(this.$xm + this.$ox, this.$ye), new Vector2(this.$xm, this.$ye));
                $this$contour.curveTo(new Vector2(this.$xm - this.$ox, this.$ye), new Vector2(this.$x, this.$ym + this.$oy), new Vector2(this.$x, this.$ym));
                $this$contour.close();
            }
            {
                this.$x = d;
                this.$ym = d2;
                this.$oy = d3;
                this.$xm = d4;
                this.$ox = d5;
                this.$y = d6;
                this.$xe = d7;
                this.$ye = d8;
                super(1);
            }
        }).transform(t2);
    }

    @NotNull
    public final Vector2 getCenter() {
        return this.center;
    }

    public final double getXRadius() {
        return this.xRadius;
    }

    public final double getYRadius() {
        return this.yRadius;
    }

    public final double getRotation() {
        return this.rotation;
    }

    public OrientedEllipse(@NotNull Vector2 center, double xRadius, double yRadius, double rotation) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.xRadius = xRadius;
        this.yRadius = yRadius;
        this.rotation = rotation;
    }

    public /* synthetic */ OrientedEllipse(Vector2 vector2, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        this(vector2, d, d2, d3);
    }

    public OrientedEllipse(double x, double y, double xRadius, double yRadius, double rotation) {
        this(new Vector2(x, y), xRadius, yRadius, rotation);
    }

    @NotNull
    public final Vector2 component1() {
        return this.center;
    }

    public final double component2() {
        return this.xRadius;
    }

    public final double component3() {
        return this.yRadius;
    }

    public final double component4() {
        return this.rotation;
    }

    @NotNull
    public final OrientedEllipse copy(@NotNull Vector2 center, double xRadius, double yRadius, double rotation) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new OrientedEllipse(center, xRadius, yRadius, rotation);
    }

    public static /* synthetic */ OrientedEllipse copy$default(OrientedEllipse orientedEllipse, Vector2 vector2, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = orientedEllipse.center;
        }
        if ((n & 2) != 0) {
            d = orientedEllipse.xRadius;
        }
        if ((n & 4) != 0) {
            d2 = orientedEllipse.yRadius;
        }
        if ((n & 8) != 0) {
            d3 = orientedEllipse.rotation;
        }
        return orientedEllipse.copy(vector2, d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "OrientedEllipse(center=" + this.center + ", xRadius=" + this.xRadius + ", yRadius=" + this.yRadius + ", rotation=" + this.rotation + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.center;
        long l = Double.doubleToLongBits(this.xRadius);
        long l2 = Double.doubleToLongBits(this.yRadius);
        long l3 = Double.doubleToLongBits(this.rotation);
        return (((vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OrientedEllipse)) break block3;
                OrientedEllipse orientedEllipse = (OrientedEllipse)object;
                if (!Intrinsics.areEqual(this.center, orientedEllipse.center) || Double.compare(this.xRadius, orientedEllipse.xRadius) != 0 || Double.compare(this.yRadius, orientedEllipse.yRadius) != 0 || Double.compare(this.rotation, orientedEllipse.rotation) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

