/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.EquationsKt;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2Kt;
import org.openrndr.math.Vector4;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.ContourIntersection;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.LineSegmentKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Segment$WhenMappings;
import org.openrndr.shape.SegmentIntersection;
import org.openrndr.shape.SegmentPoint;
import org.openrndr.shape.SegmentType;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeKt;
import org.openrndr.shape.ShapeOperationsKt;
import org.openrndr.shape.ShapeToolsKt;
import org.openrndr.shape.internal.BezierCubicSampler2D;
import org.openrndr.shape.internal.BezierQuadraticSampler2D;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00030*2\b\b\u0002\u00107\u001a\u00020$J(\u00108\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030*092\b\b\u0002\u00107\u001a\u00020$J \u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0002J*\u0010>\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u0003092\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010A\u001a\u00020\u0003H\u0002J/\u0010B\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010CJ\u000e\u0010D\u001a\u00020\u00032\u0006\u0010E\u001a\u00020$J\u0006\u0010F\u001a\u00020\u0003J\u000e\u0010F\u001a\u00020\u00032\u0006\u0010E\u001a\u00020$J\u0011\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020$H\u0086\u0002J\u0014\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030*0*H\u0002J\u0013\u0010J\u001a\u00020\u00062\b\u0010K\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010M\u001a\u00020?J\f\u0010N\u001a\b\u0012\u0004\u0012\u00020$0*J\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00030*J\b\u0010P\u001a\u00020?H\u0016J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0*2\u0006\u0010K\u001a\u00020\u0000J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0*2\u0006\u0010K\u001a\u00020TJ\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0*2\u0006\u0010K\u001a\u00020\u0017J\u0010\u0010U\u001a\u00020\u00062\b\b\u0002\u0010V\u001a\u00020$J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*2\b\b\u0002\u0010W\u001a\u00020?J\u0011\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u0003J\u0018\u0010]\u001a\u00020\u00032\u0006\u0010^\u001a\u00020$2\b\b\u0002\u0010_\u001a\u00020`J(\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00000*2\u0006\u0010b\u001a\u00020$2\b\b\u0002\u0010c\u001a\u00020$2\b\b\u0002\u0010d\u001a\u00020`J\u001f\u0010e\u001a\u0004\u0018\u00010$2\u0006\u0010\\\u001a\u00020\u00032\b\b\u0002\u0010f\u001a\u00020$\u00a2\u0006\u0002\u0010gJ\u0011\u0010h\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u0000H\u0086\u0002J\u0018\u0010i\u001a\u00020j2\u0006\u0010E\u001a\u00020$2\b\b\u0002\u0010_\u001a\u00020`J\u000e\u0010k\u001a\u00020\u00032\u0006\u0010^\u001a\u00020$J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00000*2\b\b\u0002\u0010c\u001a\u00020$J\u0016\u0010H\u001a\u00020\u00002\u0006\u0010H\u001a\u00020$2\u0006\u0010_\u001a\u00020`J\"\u0010H\u001a\u00020\u00002\u0006\u0010_\u001a\u00020`2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0mJ\u0019\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010E\u001a\u00020$\u00a2\u0006\u0002\u0010oJ\u000e\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00000*H\u0002J\u0016\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00000*2\u0006\u0010r\u001a\u00020$H\u0002J\u0016\u0010s\u001a\u00020\u00002\u0006\u0010t\u001a\u00020$2\u0006\u0010u\u001a\u00020$J\u000e\u0010v\u001a\u00020$2\u0006\u0010#\u001a\u00020$J\u0011\u0010w\u001a\u00020\u00002\u0006\u0010H\u001a\u00020$H\u0086\u0002J\b\u0010x\u001a\u00020yH\u0016J\u000e\u0010z\u001a\u00020\u00002\u0006\u0010z\u001a\u00020jR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u001e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u0016\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b,\u0010 R\u0011\u0010-\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b.\u0010 R\u0011\u0010/\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\"R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006{"}, d2={"Lorg/openrndr/shape/Segment;", "", "start", "Lorg/openrndr/math/Vector2;", "end", "corner", "", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Z)V", "c0", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Z)V", "c1", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Z)V", "control", "", "(Lorg/openrndr/math/Vector2;[Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Z)V", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "clockwise", "getClockwise", "()Z", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getControl", "()[Lorg/openrndr/math/Vector2;", "[Lorg/openrndr/math/Vector2;", "getCorner", "cubic", "getCubic", "()Lorg/openrndr/shape/Segment;", "getEnd", "()Lorg/openrndr/math/Vector2;", "length", "", "getLength", "()D", "linear", "getLinear", "lut", "", "quadratic", "getQuadratic", "reverse", "getReverse", "simple", "getSimple", "getStart", "type", "Lorg/openrndr/shape/SegmentType;", "getType", "()Lorg/openrndr/shape/SegmentType;", "adaptivePositions", "distanceTolerance", "adaptivePositionsAndNormals", "Lkotlin/Pair;", "angle", "o", "v1", "v2", "closest", "", "points", "query", "copy", "(Lorg/openrndr/math/Vector2;[Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)Lorg/openrndr/shape/Segment;", "derivative", "t", "direction", "div", "scale", "dpoints", "equals", "other", "equidistantPositions", "pointCount", "extrema", "extremaPoints", "hashCode", "intersections", "Lorg/openrndr/shape/SegmentIntersection;", "Lorg/openrndr/shape/ContourIntersection;", "Lorg/openrndr/shape/Shape;", "isStraight", "epsilon", "size", "minus", "right", "nearest", "Lorg/openrndr/shape/SegmentPoint;", "point", "normal", "ut", "polarity", "Lorg/openrndr/math/YPolarity;", "offset", "distance", "stepSize", "yPolarity", "on", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "plus", "pose", "Lorg/openrndr/math/Matrix44;", "position", "reduced", "Lkotlin/Function1;", "split", "(D)[Lorg/openrndr/shape/Segment;", "splitOnExtrema", "splitToSimple", "step", "sub", "startT", "endT", "tForLength", "times", "toString", "", "transform", "openrndr-core"})
public final class Segment {
    @NotNull
    private final Vector2 start;
    @NotNull
    private final Vector2 end;
    @NotNull
    private final Vector2[] control;
    private final boolean corner;
    private List<Vector2> lut;

    @NotNull
    public final Vector2 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector2 getEnd() {
        return this.end;
    }

    @NotNull
    public final Vector2[] getControl() {
        return this.control;
    }

    public final boolean getLinear() {
        Vector2[] vector2Array = this.control;
        boolean bl = false;
        return vector2Array.length == 0;
    }

    public final boolean getCorner() {
        return this.corner;
    }

    @NotNull
    public final SegmentType getType() {
        return this.getLinear() ? SegmentType.LINEAR : (this.control.length == 1 ? SegmentType.QUADRATIC : SegmentType.CUBIC);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> lut(int size) {
        block4: {
            Collection<Vector2> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block3: {
                if (this.lut == null) break block3;
                List<Vector2> list = this.lut;
                Intrinsics.checkNotNull(list);
                if (list.size() == size) break block4;
            }
            int n = 0;
            Iterable iterable = new IntRange(n, size);
            Segment segment = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                Vector2 vector2 = this.position((double)it / (double)size);
                collection.add(vector2);
            }
            collection = (List)destination$iv$iv;
            segment.lut = collection;
        }
        List<Vector2> list = this.lut;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public static /* synthetic */ List lut$default(Segment segment, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        return segment.lut(n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        List lut = Segment.lut$default(this, 0, 1, null);
        int hits = 0;
        double t2 = 0.0;
        int n = 0;
        int n2 = lut.size();
        while (n < n2) {
            void i;
            if (((Vector2)lut.get((int)i)).minus(point).getSquaredLength() < error * error) {
                ++hits;
                t2 += (double)i / (double)lut.size();
            }
            ++i;
        }
        return hits > 0 ? Double.valueOf(t2 / (double)hits) : null;
    }

    public static /* synthetic */ Double on$default(Segment segment, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return segment.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    public final double tForLength(double length2) {
        if (this.getType() == SegmentType.LINEAR) {
            return RangesKt.coerceIn(length2 / this.getLength(), 0.0, 1.0);
        }
        double segmentLength = this.getLength();
        double clength = RangesKt.coerceIn(length2, 0.0, segmentLength);
        if (clength == 0.0) {
            return 0.0;
        }
        if (clength >= segmentLength) {
            return 1.0;
        }
        double summedLength = 0.0;
        this.lut(100);
        List<Vector2> list = this.lut;
        if (list == null) {
            String string = "no lut";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        List<Vector2> clut = list;
        int partitionCount = clut.size() - 1;
        double dt = 1.0 / (double)partitionCount;
        boolean bl = false;
        List<Vector2> list2 = this.lut;
        Intrinsics.checkNotNull(list2);
        for (Vector2 point : (Iterable)list2) {
            Vector2 p1;
            Vector2 p0;
            double partitionLength;
            void index;
            List<Vector2> list3 = this.lut;
            Intrinsics.checkNotNull(list3);
            if (index < list3.size() - 1 && (summedLength += (partitionLength = (p0 = clut.get((int)index)).distanceTo(p1 = clut.get((int)(index + true))))) >= length2) {
                double localT = (double)index / (double)partitionCount;
                double overshoot = summedLength - length2;
                return localT + overshoot / partitionLength * dt;
            }
            ++index;
        }
        return 1.0;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Vector2> closest(List<Vector2> points, Vector2 query) {
        int closestIndex = 0;
        Vector2 closestValue = points.get(0);
        double closestDistance = Double.POSITIVE_INFINITY;
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void i;
            double distance = points.get((int)i).minus(query).getSquaredLength();
            if (distance < closestDistance) {
                closestIndex = i;
                closestValue = points.get((int)i);
                closestDistance = distance;
            }
            ++i;
        }
        return new Pair<Integer, Vector2>(closestIndex, closestValue);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SegmentPoint nearest(@NotNull Vector2 point) {
        double d;
        Intrinsics.checkNotNullParameter(point, "point");
        switch (Segment$WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1: {
                Vector2 dir = this.end.minus(this.start);
                Vector2 relativePoint = point.minus(this.start);
                d = dir.dot(relativePoint) / dir.getSquaredLength();
                break;
            }
            case 2: {
                double[] ts;
                Vector2 qa = this.start.minus(point);
                Vector2 ab = this.control[0].minus(this.start);
                Vector2 bc = this.end.minus(this.control[0]);
                Vector2 qc = this.end.minus(point);
                Vector2 ac = this.end.minus(this.start);
                Vector2 br = this.start.plus(this.end).minus(this.control[0]).minus(this.control[0]);
                double d2 = ab.cross(qa);
                boolean bl = false;
                double minDistance = Math.signum(d2) * qa.getLength();
                double param = -qa.dot(ab) / ab.dot(ab);
                double d3 = bc.cross(qc);
                boolean bl2 = false;
                double distance = Math.signum(d3) * qc.getLength();
                boolean bl3 = false;
                bl3 = false;
                if (Math.abs(distance) < Math.abs(minDistance)) {
                    minDistance = distance;
                    double d4 = 1.0;
                    double d5 = point.minus(this.control[0]).dot(bc) / bc.dot(bc);
                    boolean bl4 = false;
                    param = Math.max(d4, d5);
                }
                double a2 = br.dot(br);
                double b2 = 3.0 * ab.dot(br);
                double c = 2.0 * ab.dot(ab) + qa.dot(br);
                double d6 = qa.dot(ab);
                for (double t2 : ts = EquationsKt.solveCubic(a2, b2, c, d6)) {
                    if (!(t2 > 0.0) || !(t2 < 1.0)) continue;
                    Vector2 endpoint = this.position(t2);
                    double d7 = ac.cross(endpoint.minus(point));
                    boolean bl5 = false;
                    double distance2 = Math.signum(d7) * endpoint.minus(point).getLength();
                    boolean bl6 = false;
                    bl6 = false;
                    if (!(Math.abs(distance2) < Math.abs(minDistance))) continue;
                    minDistance = distance2;
                    param = t2;
                }
                d = RangesKt.coerceIn(param, 0.0, 1.0);
                break;
            }
            case 3: {
                nearest.t.1 $fun$sign$1 = nearest.t.1.INSTANCE;
                Vector2 qa = this.start.minus(point);
                Vector2 ab = this.control[0].minus(this.start);
                Vector2 bc = this.control[1].minus(this.control[0]);
                Vector2 cd = this.end.minus(this.control[1]);
                Vector2 qd = this.end.minus(point);
                Vector2 br = bc.minus(ab);
                Vector2 ax = cd.minus(bc).minus(br);
                double minDistance = $fun$sign$1.invoke(ab.cross(qa)) * qa.getLength();
                double param = -qa.dot(ab) / ab.dot(ab);
                double distance = $fun$sign$1.invoke(cd.cross(qd)) * qd.getLength();
                boolean b2 = false;
                b2 = false;
                if (Math.abs(distance) < Math.abs(minDistance)) {
                    minDistance = distance;
                    double b2 = 1.0;
                    double c = point.minus(this.control[1]).dot(cd) / cd.dot(cd);
                    boolean d6 = false;
                    param = Math.max(b2, c);
                }
                int SEARCH_STARTS = 4;
                int SEARCH_STEPS = 8;
                int c = 0;
                int n = SEARCH_STARTS;
                while (c < n) {
                    void i;
                    double t3 = (double)i / (double)(SEARCH_STARTS - 1);
                    int step = 0;
                    while (true) {
                        Vector2 qpt = this.position(t3).minus(point);
                        distance = $fun$sign$1.invoke(this.direction(t3).cross(qpt)) * qpt.getLength();
                        boolean bl = false;
                        bl = false;
                        if (Math.abs(distance) < Math.abs(minDistance)) {
                            minDistance = distance;
                            param = t3;
                        }
                        if (step == SEARCH_STEPS) break;
                        Vector2 d1 = ax.times((double)3 * t3 * t3).plus(br.times((double)6 * t3)).plus(ab.times(3.0));
                        Vector2 d2 = ax.times((double)6 * t3).plus(br.times(6.0));
                        double dt = qpt.dot(d1) / (d1.dot(d1) + qpt.dot(d2));
                        boolean bl7 = false;
                        if (Math.abs(dt) < 1.0E-14 || (t3 -= dt) < 0.0 || t3 > 1.0) break;
                        ++step;
                    }
                    ++i;
                }
                d = RangesKt.coerceIn(param, 0.0, 1.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double t4 = d;
        Vector2 closest = this.position(t4);
        return new SegmentPoint(this, t4, closest);
    }

    @NotNull
    public final Segment transform(@NotNull Matrix44 transform2) {
        Segment segment;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (transform2 == Matrix44.Companion.getIDENTITY()) {
            segment = this;
        } else {
            Vector2[] vector2Array;
            Vector2 tstart = transform2.times(this.start.getXy01()).getDiv().getXy();
            Vector2 tend = transform2.times(this.end.getXy01()).getDiv().getXy();
            switch (this.control.length) {
                case 2: {
                    Vector2[] vector2Array2 = new Vector2[2];
                    vector2Array2[0] = transform2.times(this.control[0].getXy01()).getDiv().getXy();
                    vector2Array = vector2Array2;
                    vector2Array2[1] = transform2.times(this.control[1].getXy01()).getDiv().getXy();
                    break;
                }
                case 1: {
                    Vector2[] vector2Array3 = new Vector2[1];
                    vector2Array = vector2Array3;
                    vector2Array3[0] = transform2.times(this.control[0].getXy01()).getDiv().getXy();
                    break;
                }
                default: {
                    vector2Array = new Vector2[]{};
                }
            }
            Vector2[] tcontrol = vector2Array;
            segment = new Segment(tstart, tcontrol, tend, false, 8, null);
        }
        return segment;
    }

    @NotNull
    public final List<Vector2> adaptivePositions(double distanceTolerance) {
        List<Vector2> list;
        switch (this.control.length) {
            case 0: {
                list = CollectionsKt.listOf(this.start, this.end);
                break;
            }
            case 1: {
                BezierQuadraticSampler2D bezierQuadraticSampler2D = new BezierQuadraticSampler2D();
                boolean bl = false;
                boolean bl2 = false;
                BezierQuadraticSampler2D $this$apply = bezierQuadraticSampler2D;
                boolean bl3 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                list = bezierQuadraticSampler2D.sample(this.start, this.control[0], this.end).getFirst();
                break;
            }
            case 2: {
                BezierCubicSampler2D bezierCubicSampler2D = new BezierCubicSampler2D();
                boolean bl = false;
                boolean bl4 = false;
                BezierCubicSampler2D $this$apply = bezierCubicSampler2D;
                boolean bl5 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                list = bezierCubicSampler2D.sample(this.start, this.control[0], this.control[1], this.end).getFirst();
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return list;
    }

    public static /* synthetic */ List adaptivePositions$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment.adaptivePositions(d);
    }

    @NotNull
    public final Pair<List<Vector2>, List<Vector2>> adaptivePositionsAndNormals(double distanceTolerance) {
        Pair<List<Vector2>, List<Vector2>> pair;
        switch (this.control.length) {
            case 0: {
                pair = new Pair<List<Vector2>, List<Vector2>>(CollectionsKt.listOf(this.start, this.end), CollectionsKt.listOf(this.end.minus(this.start), this.end.minus(this.start)));
                break;
            }
            case 1: {
                BezierQuadraticSampler2D bezierQuadraticSampler2D = new BezierQuadraticSampler2D();
                boolean bl = false;
                boolean bl2 = false;
                BezierQuadraticSampler2D $this$apply = bezierQuadraticSampler2D;
                boolean bl3 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                pair = bezierQuadraticSampler2D.sample(this.start, this.control[0], this.end);
                break;
            }
            case 2: {
                BezierCubicSampler2D bezierCubicSampler2D = new BezierCubicSampler2D();
                boolean bl = false;
                boolean bl4 = false;
                BezierCubicSampler2D $this$apply = bezierCubicSampler2D;
                boolean bl5 = false;
                $this$apply.setDistanceTolerance(distanceTolerance);
                pair = bezierCubicSampler2D.sample(this.start, this.control[0], this.control[1], this.end);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return pair;
    }

    public static /* synthetic */ Pair adaptivePositionsAndNormals$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment.adaptivePositionsAndNormals(d);
    }

    @NotNull
    public final List<Vector2> equidistantPositions(int pointCount) {
        return ShapeToolsKt.sampleEquidistant(Segment.adaptivePositions$default(this, 0.0, 1, null), pointCount);
    }

    public final double getLength() {
        double d;
        switch (this.control.length) {
            case 0: {
                d = this.end.minus(this.start).getLength();
                break;
            }
            case 1: 
            case 2: {
                d = ShapeKt.access$sumDifferences(Segment.adaptivePositions$default(this, 0.0, 1, null));
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return d;
    }

    @NotNull
    public final Vector2 position(double ut) {
        Vector2 vector2;
        double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
        switch (this.control.length) {
            case 0: {
                vector2 = new Vector2(this.start.getX() * (1.0 - t2) + this.end.getX() * t2, this.start.getY() * (1.0 - t2) + this.end.getY() * t2);
                break;
            }
            case 1: {
                vector2 = BezierKt.bezier(this.start, this.control[0], this.end, t2);
                break;
            }
            case 2: {
                vector2 = BezierKt.bezier(this.start, this.control[0], this.control[1], this.end, t2);
                break;
            }
            default: {
                String string = "unsupported number of control points";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return vector2;
    }

    @NotNull
    public final Vector2 direction() {
        return this.end.minus(this.start).getNormalized();
    }

    @NotNull
    public final Vector2 direction(double t2) {
        return this.derivative(t2).getNormalized();
    }

    @NotNull
    public final Matrix44 pose(double t2, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        Vector4 dx = this.direction(t2).getXy0().getXyz0();
        Vector4 dy = this.direction(t2).perpendicular(polarity).getXy0().getXyz0();
        Vector4 dt = this.position(t2).getXy01();
        return Matrix44.Companion.fromColumnVectors(dx, dy, Vector4.Companion.getUNIT_Z(), dt);
    }

    public static /* synthetic */ Matrix44 pose$default(Segment segment, double d, YPolarity yPolarity, int n, Object object) {
        if ((n & 2) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return segment.pose(d, yPolarity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> extrema() {
        List list;
        List<List<Vector2>> dpoints = this.dpoints();
        if (this.getLinear()) {
            list = CollectionsKt.emptyList();
        } else if (this.control.length == 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Double d;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Vector2 vector2 = (Vector2)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                d = it.getX();
                collection.add(d);
            }
            List<Double> xRoots = BezierKt.roots((List)destination$iv$iv);
            Iterable $this$map$iv2 = dpoints.get(0);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Vector2 bl = (Vector2)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                d = it.getY();
                collection.add(d);
            }
            List<Double> yRoots = BezierKt.roots((List)destination$iv$iv2);
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                double d2 = it;
                if (!(d2 >= 0.0 && d2 <= 1.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else if (this.control.length == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Double d;
            Object object;
            Vector2 it;
            Collection collection;
            Iterable $this$mapTo$iv$iv3;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Vector2 element$iv$iv = (Vector2)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = it.getX();
                collection.add(object);
            }
            $this$map$iv = dpoints.get(1);
            collection = BezierKt.roots((List)destination$iv$iv);
            $i$f$map = false;
            $this$mapTo$iv$iv3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (Vector2)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                d = it.getX();
                object.add(d);
            }
            object = (List)destination$iv$iv;
            List xRoots = CollectionsKt.plus(collection, (Iterable)BezierKt.roots((List<Double>)object));
            Iterable $this$map$iv3 = dpoints.get(0);
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Vector2 bl = (Vector2)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                object = it2.getY();
                collection.add(object);
            }
            $this$map$iv3 = dpoints.get(1);
            collection = BezierKt.roots((List)destination$iv$iv3);
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Vector2 it2 = (Vector2)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                d = it2.getY();
                object.add(d);
            }
            object = (List)destination$iv$iv3;
            List yRoots = CollectionsKt.plus(collection, (Iterable)BezierKt.roots((List<Double>)object));
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Vector2 element$iv$iv : $this$filterTo$iv$iv) {
                double it3 = ((Number)((Object)element$iv$iv)).doubleValue();
                boolean bl = false;
                double d3 = it3;
                if (!(d3 >= 0.0 && d3 <= 1.0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            throw (Throwable)new RuntimeException("not supported");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> extremaPoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.extrema();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector2 vector2 = this.position((double)it);
            collection.add(vector2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Rectangle getBounds() {
        return RectangleKt.vector2Bounds(CollectionsKt.plus((Collection)CollectionsKt.listOf(this.start, this.end), (Iterable)this.extremaPoints()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Vector2>> dpoints() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add(this.start);
        spreadBuilder.addSpread(this.control);
        spreadBuilder.add(this.end);
        List points = CollectionsKt.listOf((Vector2[])spreadBuilder.toArray(new Vector2[spreadBuilder.size()]));
        int d = points.size();
        int c = d - 1;
        boolean bl = false;
        List dpoints = new ArrayList();
        List p = points;
        while (d > 1) {
            int n = 0;
            List list = new ArrayList();
            n = 0;
            int n2 = c;
            while (n < n2) {
                void j;
                list.add(new Vector2((double)c * (((Vector2)p.get((int)(j + true))).getX() - ((Vector2)p.get((int)j)).getX()), (double)c * (((Vector2)p.get((int)(j + true))).getY() - ((Vector2)p.get((int)j)).getY())));
                ++j;
            }
            dpoints.add(list);
            p = list;
            --d;
            --c;
        }
        return dpoints;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Segment> offset(double distance, double stepSize, @NotNull YPolarity yPolarity) {
        List<Segment> list;
        Intrinsics.checkNotNullParameter((Object)yPolarity, "yPolarity");
        if (this.getLinear()) {
            Vector2 n = this.normal(0.0, yPolarity);
            if (distance > 0.0) {
                list = CollectionsKt.listOf(new Segment(this.start.plus(Vector2Kt.times(distance, n)), this.end.plus(Vector2Kt.times(distance, n)), false, 4, null));
            } else {
                Vector2 d = this.direction();
                double s2 = RangesKt.coerceAtMost(distance, this.getLength() / 2.0);
                Segment candidate = new Segment(this.start.minus(Vector2Kt.times(s2, d)).plus(Vector2Kt.times(distance, n)), this.end.plus(Vector2Kt.times(s2, d)).plus(Vector2Kt.times(distance, n)), false, 4, null);
                list = candidate.getLength() > 0.0 ? CollectionsKt.listOf(candidate) : CollectionsKt.emptyList();
            }
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.reduced(stepSize);
            boolean $i$f$map = false;
            Iterable s2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment segment = (Segment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Segment segment2 = it.scale(distance, yPolarity);
                collection.add(segment2);
            }
            list = (List<Segment>)destination$iv$iv;
        }
        return list;
    }

    public static /* synthetic */ List offset$default(Segment segment, double d, double d2, YPolarity yPolarity, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.01;
        }
        if ((n & 4) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return segment.offset(d, d2, yPolarity);
    }

    private final double angle(Vector2 o, Vector2 v1, Vector2 v2) {
        double dx1 = v1.getX() - o.getX();
        double dy1 = v1.getY() - o.getY();
        double dx2 = v2.getX() - o.getX();
        double dy2 = v2.getY() - o.getY();
        double cross = dx1 * dy2 - dy1 * dx2;
        double dot = dx1 * dx2 + dy1 * dy2;
        boolean bl = false;
        return Math.atan2(cross, dot);
    }

    public final boolean isStraight(double epsilon) {
        boolean bl;
        switch (this.control.length) {
            case 2: {
                Vector2 dl = this.end.minus(this.start).getNormalized();
                Vector2 d0 = this.control[0].minus(this.start).getNormalized();
                Vector2 d1 = this.end.minus(this.control[0]).getNormalized();
                double dp0 = dl.dot(d0);
                double dp1 = dl.unaryMinus().dot(d1);
                if (dp0 * dp0 + dp1 * dp1 > 2.0 - (double)2 * epsilon) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                Vector2 dl = this.end.minus(this.start).getNormalized();
                Vector2 d0 = this.control[0].minus(this.start).getNormalized();
                double dp0 = dl.dot(d0);
                if (dp0 * dp0 > 1.0 - epsilon) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isStraight$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.01;
        }
        return segment.isStraight(d);
    }

    public final boolean getSimple() {
        Vector2 n2;
        Vector2 n1;
        double s2;
        if (this.getLinear()) {
            return true;
        }
        if (this.control.length == 2) {
            double a1 = this.angle(this.start, this.end, this.control[0]);
            double a2 = this.angle(this.start, this.end, this.control[1]);
            if (a1 > 0.0 && a2 < 0.0 || a1 < 0.0 && a2 > 0.0) {
                return false;
            }
        }
        return (s2 = (n1 = this.normal(0.0, YPolarity.CW_NEGATIVE_Y)).dot(n2 = this.normal(1.0, YPolarity.CW_NEGATIVE_Y))) >= 0.9;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Segment> splitOnExtrema() {
        void $this$mapTo$iv$iv;
        List extrema = CollectionsKt.toMutableList((Collection)this.extrema());
        if (this.isStraight(0.05)) {
            return CollectionsKt.listOf(this);
        }
        if (this.getSimple() && extrema.isEmpty()) {
            return CollectionsKt.listOf(this);
        }
        if (extrema.isEmpty()) {
            return CollectionsKt.listOf(this);
        }
        if (((Number)extrema.get(0)).doubleValue() <= 0.01) {
            extrema.set(0, 0.0);
        } else {
            extrema = CollectionsKt.toMutableList(CollectionsKt.plus((Collection)CollectionsKt.mutableListOf(0.0), (Iterable)extrema));
        }
        if (((Number)CollectionsKt.last(extrema)).doubleValue() < 0.99) {
            extrema = CollectionsKt.toMutableList(CollectionsKt.plus((Collection)extrema, (Iterable)CollectionsKt.listOf(1.0)));
        } else if (((Number)CollectionsKt.last(extrema)).doubleValue() >= 0.99) {
            extrema.set(CollectionsKt.getLastIndex(extrema), 1.0);
        }
        Iterable $this$map$iv = CollectionsKt.zipWithNext(extrema);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Segment segment = this.sub(((Number)it.getFirst()).doubleValue(), ((Number)it.getSecond()).doubleValue());
            collection.add(segment);
        }
        return (List)destination$iv$iv;
    }

    private final List<Segment> splitToSimple(double step) {
        double t1 = 0.0;
        double t2 = 0.0;
        boolean bl = false;
        List result2 = new ArrayList();
        block0: while (t2 <= 1.0) {
            for (t2 = t1 + step; t2 <= 1.0 + step; t2 += step) {
                Segment segment = this.sub(t1, t2);
                if (segment.getSimple()) continue;
                double d = t1 - (t2 -= step);
                boolean bl2 = false;
                if (Math.abs(d) < step) {
                    return CollectionsKt.listOf(this);
                }
                Segment segment2 = this.sub(t1, t2);
                result2.add(segment2);
                t1 = t2;
                continue block0;
            }
        }
        if (t1 < 1.0) {
            result2.add(this.sub(t1, 1.0));
        }
        if (result2.isEmpty()) {
            result2.add(this);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Segment> reduced(double stepSize) {
        void $this$flatMapTo$iv$iv;
        List<Segment> pass1 = this.splitOnExtrema();
        Iterable $this$flatMap$iv = pass1;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Segment it = (Segment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.splitToSimple(stepSize);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List reduced$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.01;
        }
        return segment.reduced(d);
    }

    @NotNull
    public final Segment scale(double scale2, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        return this.scale(polarity, (Function1<? super Double, Double>)new Function1<Double, Double>(scale2){
            final /* synthetic */ double $scale;

            public final double invoke(double it) {
                return this.$scale;
            }
            {
                this.$scale = d;
                super(1);
            }
        });
    }

    public final boolean getClockwise() {
        return this.angle(this.start, this.end, this.control[0]) > 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Segment scale(@NotNull YPolarity polarity, @NotNull Function1<? super Double, Double> scale2) {
        void $this$mapIndexedTo$iv$iv;
        LineSegment b;
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        Intrinsics.checkNotNullParameter(scale2, "scale");
        if (this.control.length == 1) {
            return this.getCubic().scale(polarity, scale2);
        }
        Vector2 newStart = this.start.plus(this.normal(0.0, polarity).times(((Number)scale2.invoke((Double)0.0)).doubleValue()));
        Vector2 newEnd = this.end.plus(this.normal(1.0, polarity).times(((Number)scale2.invoke((Double)1.0)).doubleValue()));
        LineSegment a2 = new LineSegment(this.start.plus(this.normal(0.0, polarity).times(((Number)scale2.invoke((Double)0.0)).doubleValue())), this.start);
        Vector2 o = LineSegmentKt.intersection(a2, b = new LineSegment(this.end.plus(this.normal(1.0, polarity).times(((Number)scale2.invoke((Double)1.0)).doubleValue())), this.end), 1.0E9);
        if (Intrinsics.areEqual(o, Vector2.Companion.getINFINITY()) ^ true) {
            void $this$mapIndexedTo$iv$iv2;
            Vector2[] $this$mapIndexed$iv = this.control;
            boolean $i$f$mapIndexed = false;
            Vector2[] vector2Array = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                void index;
                void it;
                int n = index$iv$iv++;
                void var19_28 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Vector2 d = it.minus(o);
                double rc = ((Number)scale2.invoke((Double)(((double)index + 1.0) / 3.0))).doubleValue();
                double d2 = this.normal(0.0, polarity).dot(d);
                boolean bl2 = false;
                double s2 = Math.signum(d2);
                Vector2 nd = d.getNormalized().times(s2);
                Vector2 vector2 = it.plus(Vector2Kt.times(rc, nd));
                collection.add(vector2);
            }
            List newControls = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = newControls;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Vector2[] vector2Array2 = thisCollection$iv.toArray(new Vector2[0]);
            if (vector2Array2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return new Segment(newStart, vector2Array2, newEnd, false, 8, null);
        }
        Vector2[] $this$mapIndexed$iv = this.control;
        boolean $i$f$mapIndexed = false;
        Object thisCollection$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            int n = index$iv$iv++;
            void it = item$iv$iv;
            int index = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double rc = ((Number)scale2.invoke((Double)(((double)index + 1.0) / 3.0))).doubleValue();
            Vector2 vector2 = it.plus(Vector2Kt.times(rc, this.normal((double)index + 1.0, polarity)));
            collection.add(vector2);
        }
        List newControls = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = newControls;
        boolean $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Vector2[] vector2Array = thisCollection$iv.toArray(new Vector2[0]);
        if (vector2Array == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new Segment(newStart, vector2Array, newEnd, false, 8, null);
    }

    @NotNull
    public final Segment getCubic() {
        Segment segment;
        if (this.control.length == 2) {
            segment = this;
        } else if (this.control.length == 1) {
            segment = new Segment(this.start, this.start.times(0.3333333333333333).plus(this.control[0].times(0.6666666666666666)), this.control[0].times(0.6666666666666666).plus(this.end.times(0.3333333333333333)), this.end, false, 16, null);
        } else if (this.getLinear()) {
            Vector2 delta = this.end.minus(this.start);
            segment = new Segment(this.start, this.start.plus(delta.times(0.3333333333333333)), this.start.plus(delta.times(0.6666666666666666)), this.end, false, 16, null);
        } else {
            String string = "cannot convert to cubic segment";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return segment;
    }

    @NotNull
    public final Segment getQuadratic() {
        Segment segment;
        if (this.control.length == 1) {
            segment = this;
        } else if (this.getLinear()) {
            Vector2 delta = this.end.minus(this.start);
            segment = new Segment(this.start, this.start.plus(delta.times(0.5)), this.end, false, 8, null);
        } else {
            String string = "cannot convert to quadratic segment";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return segment;
    }

    @NotNull
    public final Vector2 derivative(double t2) {
        Vector2 vector2;
        if (this.getLinear()) {
            vector2 = this.end.minus(this.start);
        } else if (this.control.length == 1) {
            vector2 = BezierKt.safeDerivative(this.start, this.control[0], this.end, t2);
        } else if (this.control.length == 2) {
            vector2 = BezierKt.safeDerivative(this.start, this.control[0], this.control[1], this.end, t2);
        } else {
            throw (Throwable)new RuntimeException("not implemented");
        }
        return vector2;
    }

    @NotNull
    public final Vector2 normal(double ut, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        return this.direction(ut).perpendicular(polarity);
    }

    public static /* synthetic */ Vector2 normal$default(Segment segment, double d, YPolarity yPolarity, int n, Object object) {
        if ((n & 2) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return segment.normal(d, yPolarity);
    }

    @NotNull
    public final Segment getReverse() {
        Segment segment;
        switch (this.control.length) {
            case 0: {
                segment = new Segment(this.end, this.start, false, 4, null);
                break;
            }
            case 1: {
                segment = new Segment(this.end, this.control[0], this.start, false, 8, null);
                break;
            }
            case 2: {
                segment = new Segment(this.end, this.control[1], this.control[0], this.start, false, 16, null);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return segment;
    }

    @NotNull
    public final Segment sub(double startT, double endT) {
        double z0 = startT;
        double z1 = endT;
        if (startT > endT) {
            z1 = startT;
            z0 = endT;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? ArraysKt.last(this.split(z0)) : ArraysKt.last(this.split(z0)).split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final Segment[] split(double t2) {
        double splitSigma;
        double u = FunctionsKt.doubleClamp(t2, 0.0, 1.0);
        if (u < (splitSigma = 1.0E-5)) {
            return new Segment[]{new Segment(this.start, this.start, false, 4, null), this};
        }
        if (u >= 1.0 - splitSigma) {
            return new Segment[]{this, new Segment(this.end, this.end, false, 4, null)};
        }
        if (this.getLinear()) {
            Vector2 cut = this.start.plus(this.end.minus(this.start).times(u));
            return new Segment[]{new Segment(this.start, cut, false, 4, null), new Segment(cut, this.end, false, 4, null)};
        }
        switch (this.control.length) {
            case 2: {
                double z = u;
                double z2 = z * z;
                double z3 = z * z * z;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double iz3 = iz * iz * iz;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
                Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.control[1].getX(), this.end.getX());
                Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.control[1].getY(), this.end.getY());
                Vector4 plx = lsm.times(px);
                Vector4 ply = lsm.times(py);
                Vector2 pl0 = new Vector2(plx.getX(), ply.getX());
                Vector2 pl1 = new Vector2(plx.getY(), ply.getY());
                Vector2 pl2 = new Vector2(plx.getZ(), ply.getZ());
                Vector2 pl3 = new Vector2(plx.getW(), ply.getW());
                Segment left = new Segment(pl0, pl1, pl2, pl3, false, 16, null);
                Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
                Vector4 prx = rsm.times(px);
                Vector4 pry = rsm.times(py);
                Vector2 pr0 = new Vector2(prx.getX(), pry.getX());
                Vector2 pr1 = new Vector2(prx.getY(), pry.getY());
                Vector2 pr2 = new Vector2(prx.getZ(), pry.getZ());
                Vector2 pr3 = new Vector2(prx.getW(), pry.getW());
                Segment right = new Segment(pr0, pr1, pr2, pr3, false, 16, null);
                return new Segment[]{left, right};
            }
            case 1: {
                double z = u;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double z2 = z * z;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.end.getX(), 0.0);
                Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.end.getY(), 0.0);
                Vector4 plx = lsm.times(px);
                Vector4 ply = lsm.times(py);
                Segment left = new Segment(new Vector2(plx.getX(), ply.getX()), new Vector2(plx.getY(), ply.getY()), new Vector2(plx.getZ(), ply.getZ()), false, 8, null);
                Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 prx = rsm.times(px);
                Vector4 pry = rsm.times(py);
                double rdx0 = prx.getY() - prx.getX();
                double rdy0 = pry.getY() - pry.getX();
                double rdx1 = prx.getZ() - prx.getY();
                double rdy1 = pry.getZ() - pry.getY();
                boolean pr0 = rdx0 * rdx0 + rdy0 * rdy0 > 0.0;
                boolean bl = false;
                boolean bl2 = false;
                if (!pr0) {
                    boolean bl3 = false;
                    String string = "Q start/c0 overlap after split on " + t2 + ' ' + this;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                pr0 = rdx1 * rdx1 + rdy1 * rdy1 > 0.0;
                bl = false;
                bl2 = false;
                if (!pr0) {
                    boolean bl4 = false;
                    String string = "Q end/c0 overlap after split on " + t2 + ' ' + this;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Segment right = new Segment(new Vector2(prx.getX(), pry.getX()), new Vector2(prx.getY(), pry.getY()), new Vector2(prx.getZ(), pry.getZ()), false, 8, null);
                return new Segment[]{left, right};
            }
        }
        String string = "unsupported number of control points";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Segment(start=").append(this.start).append(", end=").append(this.end).append(", control=");
        Object[] objectArray = this.control;
        boolean bl = false;
        String string = Arrays.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "java.util.Arrays.toString(this)");
        return stringBuilder.append(string).append(')').toString();
    }

    @NotNull
    public final Segment copy(@NotNull Vector2 start2, @NotNull Vector2[] control, @NotNull Vector2 end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end2, "end");
        return new Segment(start2, control, end2, false, 8, null);
    }

    public static /* synthetic */ Segment copy$default(Segment segment, Vector2 vector2, Vector2[] vector2Array, Vector2 vector22, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = segment.start;
        }
        if ((n & 2) != 0) {
            vector2Array = segment.control;
        }
        if ((n & 4) != 0) {
            vector22 = segment.end;
        }
        return segment.copy(vector2, vector2Array, vector22);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrndr.shape.Segment");
        }
        Segment cfr_ignored_0 = (Segment)object2;
        if (Intrinsics.areEqual(this.start, ((Segment)other).start) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.end, ((Segment)other).end) ^ true) {
            return false;
        }
        Object[] objectArray = this.control;
        Object[] objectArray2 = ((Segment)other).control;
        boolean bl = false;
        return Arrays.equals(objectArray, objectArray2);
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = 31 * result2 + this.end.hashCode();
        Object[] objectArray = this.control;
        boolean bl = false;
        result2 = 31 * result2 + Arrays.hashCode(objectArray);
        return result2;
    }

    @NotNull
    public final Segment times(double scale2) {
        Segment segment;
        switch (Segment$WhenMappings.$EnumSwitchMapping$1[this.getType().ordinal()]) {
            case 1: {
                segment = new Segment(this.start.times(scale2), this.end.times(scale2), false, 4, null);
                break;
            }
            case 2: {
                segment = new Segment(this.start.times(scale2), this.control[0].times(scale2), this.end.times(scale2), false, 8, null);
                break;
            }
            case 3: {
                segment = new Segment(this.start.times(scale2), this.control[0].times(scale2), this.control[1].times(scale2), this.end.times(scale2), false, 16, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return segment;
    }

    @NotNull
    public final Segment div(double scale2) {
        Segment segment;
        switch (Segment$WhenMappings.$EnumSwitchMapping$2[this.getType().ordinal()]) {
            case 1: {
                segment = new Segment(this.start.div(scale2), this.end.div(scale2), false, 4, null);
                break;
            }
            case 2: {
                segment = new Segment(this.start.div(scale2), this.control[0].div(scale2), this.end.div(scale2), false, 8, null);
                break;
            }
            case 3: {
                segment = new Segment(this.start.div(scale2), this.control[0].div(scale2), this.control[1].div(scale2), this.end.div(scale2), false, 16, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return segment;
    }

    @NotNull
    public final Segment minus(@NotNull Segment right) {
        Segment segment;
        block16: {
            block17: {
                block15: {
                    Intrinsics.checkNotNullParameter(right, "right");
                    if (this.getType() != right.getType()) break block15;
                    switch (Segment$WhenMappings.$EnumSwitchMapping$3[this.getType().ordinal()]) {
                        case 1: {
                            segment = new Segment(this.start.minus(right.start), this.end.minus(right.end), false, 4, null);
                            break block16;
                        }
                        case 2: {
                            segment = new Segment(this.start.minus(right.start), this.control[0].minus(right.control[0]), this.end.minus(right.end), false, 8, null);
                            break block16;
                        }
                        case 3: {
                            segment = new Segment(this.start.minus(right.start), this.control[0].minus(right.control[0]), this.control[1].minus(right.control[1]), this.end.minus(right.end), false, 16, null);
                            break block16;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (this.getType().ordinal() <= right.getType().ordinal()) break block17;
                switch (Segment$WhenMappings.$EnumSwitchMapping$4[this.getType().ordinal()]) {
                    case 1: {
                        String string = "impossible?";
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    case 2: {
                        segment = this.minus(right.getQuadratic());
                        break block16;
                    }
                    case 3: {
                        segment = this.minus(right.getCubic());
                        break block16;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (Segment$WhenMappings.$EnumSwitchMapping$5[right.getType().ordinal()]) {
                case 1: {
                    String string = "impossible?";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 2: {
                    segment = this.getQuadratic().minus(right);
                    break;
                }
                case 3: {
                    segment = this.getCubic().minus(right);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return segment;
    }

    @NotNull
    public final Segment plus(@NotNull Segment right) {
        Segment segment;
        block16: {
            block17: {
                block15: {
                    Intrinsics.checkNotNullParameter(right, "right");
                    if (this.getType() != right.getType()) break block15;
                    switch (Segment$WhenMappings.$EnumSwitchMapping$6[this.getType().ordinal()]) {
                        case 1: {
                            segment = new Segment(this.start.plus(right.start), this.end.plus(right.end), false, 4, null);
                            break block16;
                        }
                        case 2: {
                            segment = new Segment(this.start.plus(right.start), this.control[0].plus(right.control[0]), this.end.plus(right.end), false, 8, null);
                            break block16;
                        }
                        case 3: {
                            segment = new Segment(this.start.plus(right.start), this.control[0].plus(right.control[0]), this.control[1].plus(right.control[1]), this.end.plus(right.end), false, 16, null);
                            break block16;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (this.getType().ordinal() <= right.getType().ordinal()) break block17;
                switch (Segment$WhenMappings.$EnumSwitchMapping$7[this.getType().ordinal()]) {
                    case 1: {
                        String string = "impossible?";
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    case 2: {
                        segment = this.plus(right.getQuadratic());
                        break block16;
                    }
                    case 3: {
                        segment = this.plus(right.getCubic());
                        break block16;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (Segment$WhenMappings.$EnumSwitchMapping$8[right.getType().ordinal()]) {
                case 1: {
                    String string = "impossible?";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 2: {
                    segment = this.getQuadratic().plus(right);
                    break;
                }
                case 3: {
                    segment = this.getCubic().plus(right);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return segment;
    }

    @NotNull
    public final ShapeContour getContour() {
        return new ShapeContour(CollectionsKt.listOf(this), false, null, 4, null);
    }

    @NotNull
    public final List<SegmentIntersection> intersections(@NotNull Segment other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this, other);
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull ShapeContour other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this.getContour(), other);
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this.getContour().getShape(), other);
    }

    public Segment(@NotNull Vector2 start2, @NotNull Vector2 end2, boolean corner) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.end = end2;
        this.control = new Vector2[0];
        this.corner = corner;
    }

    public /* synthetic */ Segment(Vector2 vector2, Vector2 vector22, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(vector2, vector22, bl);
    }

    public Segment(@NotNull Vector2 start2, @NotNull Vector2 c0, @NotNull Vector2 end2, boolean corner) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.control = new Vector2[]{c0};
        this.end = end2;
        this.corner = corner;
    }

    public /* synthetic */ Segment(Vector2 vector2, Vector2 vector22, Vector2 vector23, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(vector2, vector22, vector23, bl);
    }

    public Segment(@NotNull Vector2 start2, @NotNull Vector2 c0, @NotNull Vector2 c1, @NotNull Vector2 end2, boolean corner) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.control = new Vector2[]{c0, c1};
        this.end = end2;
        this.corner = corner;
    }

    public /* synthetic */ Segment(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(vector2, vector22, vector23, vector24, bl);
    }

    public Segment(@NotNull Vector2 start2, @NotNull Vector2[] control, @NotNull Vector2 end2, boolean corner) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end2, "end");
        this.start = start2;
        this.control = control;
        this.end = end2;
        this.corner = corner;
    }

    public /* synthetic */ Segment(Vector2 vector2, Vector2[] vector2Array, Vector2 vector22, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(vector2, vector2Array, vector22, bl);
    }
}

