/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import io.lacuna.artifex.Vec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourIntersection;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape$WhenMappings;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeOperationsKt;
import org.openrndr.shape.ShapeTopology;
import org.openrndr.shape.Triangle;
import org.openrndr.shape.TriangulatorKt;
import org.openrndr.shape.Winding;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 I2\u00020\u0001:\u0001IB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0086\u0002J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000J\u0013\u0010/\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u000201J\u000e\u00104\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000J\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00032\u0006\u0010.\u001a\u000207J\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00032\u0006\u0010.\u001a\u00020\u0000J\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00032\u0006\u0010.\u001a\u00020\u0004J\u001a\u00108\u001a\u00020\u00002\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040:J\u0010\u0010;\u001a\u00020\u00002\b\b\u0002\u0010<\u001a\u00020\u0007J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020,0\u00032\u0006\u0010>\u001a\u0002012\b\b\u0002\u0010?\u001a\u00020@J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\b\b\u0002\u0010B\u001a\u00020CJ\b\u0010D\u001a\u00020EH\u0016J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0019\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R!\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000b\u001a\u0004\b(\u0010\u0013\u00a8\u0006J"}, d2={"Lorg/openrndr/shape/Shape;", "", "contours", "", "Lorg/openrndr/shape/ShapeContour;", "(Ljava/util/List;)V", "area", "", "getArea", "()D", "area$delegate", "Lkotlin/Lazy;", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "bounds$delegate", "closedContours", "getClosedContours", "()Ljava/util/List;", "compound", "", "getCompound", "()Z", "getContours", "empty", "getEmpty", "linear", "getLinear", "openContours", "getOpenContours", "outline", "getOutline", "()Lorg/openrndr/shape/ShapeContour;", "topology", "Lorg/openrndr/shape/ShapeTopology;", "getTopology", "()Lorg/openrndr/shape/ShapeTopology;", "triangulation", "Lorg/openrndr/shape/Triangle;", "getTriangulation", "triangulation$delegate", "contains", "v", "Lorg/openrndr/math/Vector2;", "difference", "other", "equals", "hashCode", "", "hole", "index", "intersection", "intersections", "Lorg/openrndr/shape/ContourIntersection;", "Lorg/openrndr/shape/Segment;", "map", "mapper", "Lkotlin/Function1;", "polygon", "distanceTolerance", "randomPoints", "pointCount", "random", "Lkotlin/random/Random;", "splitCompounds", "winding", "Lorg/openrndr/shape/Winding;", "toString", "", "transform", "Lorg/openrndr/math/Matrix44;", "union", "Companion", "openrndr-core"})
public final class Shape {
    @NotNull
    private final Lazy bounds$delegate;
    @NotNull
    private final ShapeTopology topology;
    @NotNull
    private final List<ShapeContour> openContours;
    @NotNull
    private final List<ShapeContour> closedContours;
    @NotNull
    private final Lazy triangulation$delegate;
    @NotNull
    private final Lazy area$delegate;
    @NotNull
    private final List<ShapeContour> contours;
    @NotNull
    private static final Shape EMPTY;
    public static final Companion Companion;

    @NotNull
    public final Rectangle getBounds() {
        Lazy lazy = this.bounds$delegate;
        Shape shape2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Rectangle)lazy.getValue();
    }

    @NotNull
    public final ShapeTopology getTopology() {
        return this.topology;
    }

    @NotNull
    public final List<ShapeContour> getOpenContours() {
        return this.openContours;
    }

    @NotNull
    public final List<ShapeContour> getClosedContours() {
        return this.closedContours;
    }

    public final boolean getEmpty() {
        return this == EMPTY || this.contours.isEmpty();
    }

    public final boolean getLinear() {
        boolean bl;
        block7: {
            Iterable $this$all$iv = this.contours;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        ShapeContour it = (ShapeContour)element$iv;
                        boolean bl3 = false;
                        Iterable $this$all$iv2 = it.getSegments();
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                Segment it2 = (Segment)element$iv2;
                                boolean bl4 = false;
                                if (it2.getLinear()) continue;
                                bl2 = false;
                                break block6;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape polygon(double distanceTolerance) {
        Shape shape2;
        if (this.getEmpty()) {
            shape2 = EMPTY;
        } else {
            Collection<ShapeContour> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.contours;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ShapeContour shapeContour2 = it.sampleLinear(distanceTolerance);
                collection.add(shapeContour2);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            shape2 = new Shape(list);
        }
        return shape2;
    }

    public static /* synthetic */ Shape polygon$default(Shape shape2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shape2.polygon(d);
    }

    @NotNull
    public final List<Triangle> getTriangulation() {
        Lazy lazy = this.triangulation$delegate;
        Shape shape2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final double getArea() {
        Lazy lazy = this.area$delegate;
        Shape shape2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final List<Vector2> randomPoints(int pointCount, @NotNull Random random) {
        Intrinsics.checkNotNullParameter(random, "random");
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Double> arrayList = new ArrayList<Double>(pointCount);
        boolean bl3 = false;
        int n = 0;
        n = 0;
        int n2 = pointCount;
        while (n < n2) {
            int n3 = n++;
            boolean bl4 = false;
            int n4 = n3;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl5 = false;
            Double d = random.nextDouble() * this.getArea();
            arrayList2.add(d);
        }
        List randomValues = CollectionsKt.toMutableList(CollectionsKt.sortedDescending((Iterable)arrayList));
        double sum = 0.0;
        bl3 = false;
        List result2 = new ArrayList();
        block1: for (Triangle triangle : this.getTriangulation()) {
            sum += triangle.getArea();
            if (randomValues.isEmpty()) break;
            while (sum > ((Number)CollectionsKt.last(randomValues)).doubleValue()) {
                result2.add(Triangle.randomPoint$default(triangle, null, 1, null));
                CollectionsKt.removeLastOrNull(randomValues);
                if (!randomValues.isEmpty()) continue;
                continue block1;
            }
        }
        return result2;
    }

    public static /* synthetic */ List randomPoints$default(Shape shape2, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            random = Random.Default;
        }
        return shape2.randomPoints(n, random);
    }

    public final boolean contains(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.getEmpty()) {
            return false;
        }
        return ShapeOperationsKt.toRegion2(this).contains(new Vec2(v.getX(), v.getY()));
    }

    @NotNull
    public final ShapeContour getOutline() {
        return this.contours.get(0);
    }

    @NotNull
    public final ShapeContour hole(int index) {
        return this.contours.get(index + 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape transform(@NotNull Matrix44 transform2) {
        Shape shape2;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (this.getEmpty()) {
            shape2 = EMPTY;
        } else if (transform2 == Matrix44.Companion.getIDENTITY()) {
            shape2 = this;
        } else {
            Collection<ShapeContour> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.contours;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ShapeContour shapeContour2 = it.transform(transform2);
                collection.add(shapeContour2);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            shape2 = new Shape(list);
        }
        return shape2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape map(@NotNull Function1<? super ShapeContour, ShapeContour> mapper) {
        Collection<ShapeContour> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        Iterable $this$map$iv = this.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ShapeContour shapeContour2 = mapper.invoke((ShapeContour)it);
            collection.add(shapeContour2);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        return new Shape(list);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getCompound() {
        boolean bl;
        if (this.contours.isEmpty()) {
            bl = false;
        } else {
            boolean bl2;
            Iterable $this$count$iv = this.contours;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                bl2 = false;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ShapeContour it = (ShapeContour)element$iv;
                    boolean bl3 = false;
                    if (!(it.getWinding() == Winding.CLOCKWISE)) continue;
                    int n = ++count$iv;
                    boolean bl4 = false;
                    if (n >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                bl2 = var3_3;
            }
            bl = bl2 > true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Shape> splitCompounds(@NotNull Winding winding) {
        List list;
        Intrinsics.checkNotNullParameter((Object)winding, "winding");
        if (this.contours.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            void cw;
            Iterable $this$partition$iv = this.closedContours;
            boolean $i$f$partition = false;
            Iterable<Object> first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                ShapeContour it = (ShapeContour)element$iv;
                boolean bl = false;
                if (it.getWinding() == winding) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list2 = pair.component1();
            List ccw = pair.component2();
            Iterable $this$map$iv = (Iterable)cw;
            boolean $i$f$map = false;
            first$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void outer;
                void $this$filterTo$iv$iv;
                ShapeContour bl = (ShapeContour)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Iterable $this$filter$iv = ccw;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ShapeContour it = (ShapeContour)element$iv$iv;
                    boolean bl3 = false;
                    if (!RectangleKt.intersects(it.getBounds(), outer.getBounds())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List cs = (List)destination$iv$iv2;
                object = CollectionsKt.plus((Collection)CollectionsKt.listOf(outer), (Iterable)cs);
                collection.add(object);
            }
            List candidates = (List)destination$iv$iv;
            $this$map$iv = this.openContours;
            collection = candidates;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ShapeContour outer = (ShapeContour)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                List<void> list3 = CollectionsKt.listOf(it);
                object.add(list3);
            }
            object = (List)destination$iv$iv;
            $this$map$iv = CollectionsKt.plus(collection, (Iterable)object);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List it = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = new Shape(it);
                collection.add(object);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public static /* synthetic */ List splitCompounds$default(Shape shape2, Winding winding, int n, Object object) {
        if ((n & 1) != 0) {
            winding = Winding.CLOCKWISE;
        }
        return shape2.splitCompounds(winding);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrndr.shape.Shape");
        }
        Shape cfr_ignored_0 = (Shape)object2;
        return !(Intrinsics.areEqual(this.contours, ((Shape)other).contours) ^ true);
    }

    public int hashCode() {
        return ((Object)this.contours).hashCode();
    }

    @NotNull
    public final Shape union(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.union(this, other);
    }

    @NotNull
    public final Shape difference(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.difference(this, other);
    }

    @NotNull
    public final Shape intersection(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersection(this, other);
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this, other);
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull ShapeContour other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this, other.getShape());
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull Segment other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this, other.getContour().getShape());
    }

    @NotNull
    public String toString() {
        return "Shape(contours=" + this.contours + ", topology=" + (Object)((Object)this.topology) + ')';
    }

    @NotNull
    public final List<ShapeContour> getContours() {
        return this.contours;
    }

    public Shape(@NotNull List<ShapeContour> contours) {
        List list;
        ShapeContour it;
        Iterable $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        List list2;
        Iterable $this$all$iv;
        Shape shape2;
        ShapeTopology shapeTopology;
        Intrinsics.checkNotNullParameter(contours, "contours");
        this.contours = contours;
        this.bounds$delegate = LazyKt.lazy((Function0)new Function0<Rectangle>(this){
            final /* synthetic */ Shape this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Rectangle invoke() {
                Rectangle rectangle;
                if (this.this$0.getEmpty()) {
                    rectangle = new Rectangle(0.0, 0.0, 0.0, 0.0);
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = this.this$0.getContours();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Rectangle rectangle2;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        ShapeContour it = (ShapeContour)element$iv$iv;
                        boolean bl2 = false;
                        if ((it.getEmpty() ? null : it.getBounds()) == null) continue;
                        rectangle2 = rectangle2;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Rectangle it$iv$iv = rectangle2;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    rectangle = RectangleKt.rectangleBounds((List)destination$iv$iv);
                }
                return rectangle;
            }
            {
                this.this$0 = shape2;
                super(0);
            }
        });
        Shape shape3 = this;
        if (this.contours.isEmpty()) {
            shapeTopology = ShapeTopology.OPEN;
        } else {
            ShapeContour it2;
            boolean bl;
            boolean $i$f$all;
            block22: {
                Iterable iterable = this.contours;
                shape2 = shape3;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it2 = (ShapeContour)element$iv;
                        boolean bl2 = false;
                        if (it2.getClosed()) continue;
                        bl = false;
                        break block22;
                    }
                    bl = true;
                }
            }
            boolean bl3 = bl;
            shape3 = shape2;
            if (bl3) {
                shapeTopology = ShapeTopology.CLOSED;
            } else {
                boolean bl4;
                block23: {
                    $this$all$iv = this.contours;
                    shape2 = shape3;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it2 = (ShapeContour)element$iv;
                            boolean bl5 = false;
                            if (!it2.getClosed()) continue;
                            bl4 = false;
                            break block23;
                        }
                        bl4 = true;
                    }
                }
                bl3 = bl4;
                shape3 = shape2;
                shapeTopology = bl3 ? ShapeTopology.OPEN : ShapeTopology.MIXED;
            }
        }
        shape3.topology = shapeTopology;
        Shape shape4 = this;
        switch (Shape$WhenMappings.$EnumSwitchMapping$0[this.topology.ordinal()]) {
            case 1: {
                list2 = this.contours;
                break;
            }
            case 2: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            case 3: {
                $this$all$iv = this.contours;
                shape2 = shape4;
                $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShapeContour)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.getClosed())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                shape4 = shape2;
                list2 = list3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        shape4.openContours = list2;
        Shape shape5 = this;
        switch (Shape$WhenMappings.$EnumSwitchMapping$1[this.topology.ordinal()]) {
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = this.contours;
                break;
            }
            case 3: {
                $this$filter$iv = this.contours;
                shape2 = shape5;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShapeContour)element$iv$iv;
                    boolean bl = false;
                    if (!it.getClosed()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list4 = (List)destination$iv$iv;
                shape5 = shape2;
                list = list4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        shape5.closedContours = list;
        this.triangulation$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Triangle>>(this){
            final /* synthetic */ Shape this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Triangle> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.windowed$default(TriangulatorKt.triangulate$default(this.this$0, 0.0, null, 6, null), 3, 3, false, 4, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Triangle triangle = new Triangle((Vector2)it.get(0), (Vector2)it.get(1), (Vector2)it.get(2));
                    collection.add(triangle);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = shape2;
                super(0);
            }
        });
        this.area$delegate = LazyKt.lazy((Function0)new Function0<Double>(this){
            final /* synthetic */ Shape this$0;

            /*
             * WARNING - void declaration
             */
            public final double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getTriangulation();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    Triangle triangle = (Triangle)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getArea();
                    sum$iv = d + d2;
                }
                return (double)var3_3;
            }
            {
                this.this$0 = shape2;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        EMPTY = new Shape(CollectionsKt.<ShapeContour>emptyList());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/openrndr/shape/Shape$Companion;", "", "()V", "EMPTY", "Lorg/openrndr/shape/Shape;", "getEMPTY", "()Lorg/openrndr/shape/Shape;", "compound", "shapes", "", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final Shape getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Shape compound(@NotNull List<Shape> shapes) {
            List list;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(shapes, "shapes");
            Iterable $this$flatMap$iv = shapes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Shape it = (Shape)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getContours();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List list2 = list = (List)destination$iv$iv;
            return new Shape(list2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

