/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import io.lacuna.artifex.Vec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector4;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.ContourIntersection;
import org.openrndr.shape.ContourPoint;
import org.openrndr.shape.LineSegmentKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment;
import org.openrndr.shape.SegmentJoin;
import org.openrndr.shape.SegmentPoint;
import org.openrndr.shape.SegmentType;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour$WhenMappings;
import org.openrndr.shape.ShapeOperationsKt;
import org.openrndr.shape.ShapeToolsKt;
import org.openrndr.shape.Triangle;
import org.openrndr.shape.TriangulatorKt;
import org.openrndr.shape.Winding;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 g2\u00020\u0001:\u0001gB%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00032\b\b\u0002\u00106\u001a\u00020\u001dJ(\u00107\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0003082\b\b\u0002\u00106\u001a\u00020\u001dJ(\u00109\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u0003082\b\b\u0002\u00106\u001a\u00020\u001dJ\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0006H\u00c6\u0003J\t\u0010<\u001a\u00020\bH\u00c6\u0003J\u0011\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u000205H\u0086\u0002J-\u0010?\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u000e\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020)J\u0013\u0010B\u001a\u00020\u00062\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u0002050\u00032\u0006\u0010D\u001a\u00020EJ\t\u0010F\u001a\u00020EH\u00d6\u0001J\u000e\u0010G\u001a\u00020)2\u0006\u0010A\u001a\u00020)J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00032\u0006\u0010A\u001a\u00020\u0004J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00032\u0006\u0010A\u001a\u00020)J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00032\u0006\u0010A\u001a\u00020\u0000J&\u0010J\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040LH\u0007J\u000e\u0010M\u001a\u00020N2\u0006\u0010>\u001a\u000205J\u000e\u0010O\u001a\u0002052\u0006\u0010P\u001a\u00020\u001dJ\u0018\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u001d2\b\b\u0002\u0010S\u001a\u00020TJ\u001f\u0010U\u001a\u0004\u0018\u00010\u001d2\u0006\u0010>\u001a\u0002052\b\b\u0002\u0010V\u001a\u00020\u001d\u00a2\u0006\u0002\u0010WJ\u0011\u0010X\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\u001dJ\u000e\u0010\\\u001a\u0002052\u0006\u0010P\u001a\u00020\u001dJ\u000e\u0010]\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EJ\u0010\u0010^\u001a\u00020\u00002\b\b\u0002\u00106\u001a\u00020\u001dJ\u0016\u0010_\u001a\u00020\u00002\u0006\u0010`\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020\u001dJ\u000e\u0010b\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010c\u001a\u00020dH\u00d6\u0001J\u000e\u0010e\u001a\u00020\u00002\u0006\u0010e\u001a\u00020ZJ\u000e\u0010f\u001a\u00020)2\u0006\u0010A\u001a\u00020)R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000f\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001bR\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R!\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u000f\u001a\u0004\b.\u0010\u001bR\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006h"}, d2={"Lorg/openrndr/shape/ShapeContour;", "", "segments", "", "Lorg/openrndr/shape/Segment;", "closed", "", "polarity", "Lorg/openrndr/math/YPolarity;", "(Ljava/util/List;ZLorg/openrndr/math/YPolarity;)V", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "bounds$delegate", "Lkotlin/Lazy;", "clockwise", "getClockwise", "()Lorg/openrndr/shape/ShapeContour;", "getClosed", "()Z", "counterClockwise", "getCounterClockwise", "empty", "getEmpty", "exploded", "getExploded", "()Ljava/util/List;", "length", "", "getLength", "()D", "length$delegate", "opened", "getOpened", "getPolarity", "()Lorg/openrndr/math/YPolarity;", "reversed", "getReversed", "getSegments", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "triangulation", "Lorg/openrndr/shape/Triangle;", "getTriangulation", "triangulation$delegate", "winding", "Lorg/openrndr/shape/Winding;", "getWinding", "()Lorg/openrndr/shape/Winding;", "adaptivePositions", "Lorg/openrndr/math/Vector2;", "distanceTolerance", "adaptivePositionsAndCorners", "Lkotlin/Pair;", "adaptivePositionsAndDirection", "component1", "component2", "component3", "contains", "point", "copy", "difference", "other", "equals", "equidistantPositions", "pointCount", "", "hashCode", "intersection", "intersections", "Lorg/openrndr/shape/ContourIntersection;", "map", "mapper", "Lkotlin/Function1;", "nearest", "Lorg/openrndr/shape/ContourPoint;", "normal", "ut", "offset", "distance", "joinType", "Lorg/openrndr/shape/SegmentJoin;", "on", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "plus", "pose", "Lorg/openrndr/math/Matrix44;", "t", "position", "sampleEquidistant", "sampleLinear", "sub", "startT", "endT", "tForLength", "toString", "", "transform", "union", "Companion", "openrndr-core"})
public final class ShapeContour {
    @NotNull
    private final Lazy triangulation$delegate;
    @NotNull
    private final Lazy length$delegate;
    @NotNull
    private final Lazy bounds$delegate;
    @NotNull
    private final List<Segment> segments;
    private final boolean closed;
    @NotNull
    private final YPolarity polarity;
    @NotNull
    private static final ShapeContour EMPTY;
    public static final Companion Companion;

    @NotNull
    public final List<Triangle> getTriangulation() {
        Lazy lazy = this.triangulation$delegate;
        ShapeContour shapeContour = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this));
    }

    public final double getLength() {
        Lazy lazy = this.length$delegate;
        ShapeContour shapeContour = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final Rectangle getBounds() {
        Lazy lazy = this.bounds$delegate;
        ShapeContour shapeContour = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Rectangle)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Winding getWinding() {
        Winding winding;
        double sum = 0.0;
        Iterable $this$forEachIndexed$iv = this.segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void v;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment segment = (Segment)item$iv;
            int i = n;
            boolean bl2 = false;
            Vector2 after = this.segments.get(FunctionsKt.mod(i + 1, this.segments.size())).getStart();
            sum += (after.getX() - v.getStart().getX()) * (after.getY() + v.getStart().getY());
        }
        switch (ShapeContour$WhenMappings.$EnumSwitchMapping$0[this.polarity.ordinal()]) {
            case 1: {
                if (sum < 0.0) {
                    winding = Winding.COUNTER_CLOCKWISE;
                    break;
                }
                winding = Winding.CLOCKWISE;
                break;
            }
            case 2: {
                if (sum < 0.0) {
                    winding = Winding.CLOCKWISE;
                    break;
                }
                winding = Winding.COUNTER_CLOCKWISE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return winding;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShapeContour> getExploded() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ShapeContour shapeContour = new ShapeContour(CollectionsKt.listOf(it), false, this.polarity);
            collection.add(shapeContour);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ShapeContour getClockwise() {
        return this.getWinding() == Winding.CLOCKWISE ? this : this.getReversed();
    }

    @NotNull
    public final ShapeContour getCounterClockwise() {
        return this.getWinding() == Winding.COUNTER_CLOCKWISE ? this : this.getReversed();
    }

    @NotNull
    public final ShapeContour plus(@NotNull ShapeContour other) {
        Intrinsics.checkNotNullParameter(other, "other");
        boolean bl = this.polarity == other.polarity;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "shapes have mixed polarities";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.segments.isEmpty() && other.segments.isEmpty()) {
            return EMPTY;
        }
        if (this.segments.isEmpty()) {
            return other;
        }
        if (other.segments.isEmpty()) {
            return this;
        }
        double epsilon = 0.001;
        boolean bl5 = false;
        List segments = new ArrayList();
        segments.addAll((Collection)this.segments);
        if (this.segments.get(this.segments.size() - 1).getEnd().minus(other.segments.get(0).getStart()).getLength() > epsilon) {
            segments.add(new Segment(this.segments.get(this.segments.size() - 1).getEnd(), other.segments.get(0).getStart(), false, 4, null));
        }
        segments.addAll((Collection)other.segments);
        return new ShapeContour(segments, false, this.polarity);
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.closed && ShapeOperationsKt.toRing2((ShapeContour)this).test((Vec2)new Vec2((double)point.getX(), (double)point.getY())).inside;
    }

    /*
     * WARNING - void declaration
     */
    public final double tForLength(double length2) {
        double remaining = length2;
        if (length2 <= 0.0) {
            return 0.0;
        }
        if (this.segments.size() == 1) {
            return CollectionsKt.first(this.segments).tForLength(length2);
        }
        boolean bl = false;
        for (Segment segment : (Iterable)this.segments) {
            void index;
            double segmentLength = segment.getLength();
            if (segmentLength > remaining) {
                return (segment.tForLength(remaining) + (double)index) / (double)this.segments.size();
            }
            remaining -= segmentLength;
            ++index;
        }
        return 1.0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour offset(double distance, @NotNull SegmentJoin joinType) {
        void $this$filterTo$iv$iv;
        List it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)joinType, "joinType");
        if (this.segments.size() == 1) {
            return new ShapeContour(Segment.offset$default(this.segments.get(0), distance, 0.0, this.polarity, 2, null), false, this.polarity);
        }
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Segment segment = (Segment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = Segment.offset$default((Segment)((Object)it), distance, 0.0, this.polarity, 2, null);
            collection.add(list);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            Collection collection = it;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List offsets = (List)destination$iv$iv;
        if (offsets.isEmpty()) {
            return new ShapeContour(CollectionsKt.emptyList(), false, null, 4, null);
        }
        Vector2 startPoint = this.closed ? ((Segment)CollectionsKt.last((List)CollectionsKt.last(offsets))).getEnd() : ((Segment)CollectionsKt.first((List)CollectionsKt.first(offsets))).getStart();
        return ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(this, startPoint, offsets, joinType){
            final /* synthetic */ ShapeContour this$0;
            final /* synthetic */ Vector2 $startPoint;
            final /* synthetic */ List $offsets;
            final /* synthetic */ SegmentJoin $joinType;

            public final void invoke(@NotNull ContourBuilder $this$contour) {
                Intrinsics.checkNotNullParameter($this$contour, "$receiver");
                $this$contour.moveTo(this.$startPoint);
                for (List offset2 : this.$offsets) {
                    boolean bl;
                    Object object;
                    List<Segment> mOffset = CollectionsKt.toMutableList(offset2);
                    Segment segment = $this$contour.getLastSegment();
                    if (segment != null) {
                        Vector2 i;
                        object = segment;
                        bl = false;
                        boolean bl2 = false;
                        Object ls2 = object;
                        boolean bl3 = false;
                        Segment fs = (Segment)CollectionsKt.first(offset2);
                        if (((Segment)ls2).getType() == SegmentType.LINEAR && fs.getType() == SegmentType.LINEAR && Intrinsics.areEqual(i = LineSegmentKt.intersection$default(((Segment)ls2).getStart(), ((Segment)ls2).getEnd(), ((Segment)CollectionsKt.first(offset2)).getStart(), ((Segment)CollectionsKt.first(offset2)).getEnd(), 0.0, 16, null), Vector2.Companion.getINFINITY()) ^ true && i.minus(((Segment)ls2).getEnd()).getSquaredLength() > 1.0E-5) {
                            $this$contour.undo();
                            $this$contour.lineTo(i);
                            $this$contour.lineTo(fs.getEnd());
                            mOffset.remove(0);
                        }
                    }
                    object = mOffset;
                    bl = false;
                    if (!(!object.isEmpty())) continue;
                    Vector2 delta = CollectionsKt.first(mOffset).getStart().minus($this$contour.getCursor());
                    double joinDistance = delta.getLength();
                    if (joinDistance > 1.0E-5) {
                        switch (ShapeContour$WhenMappings.$EnumSwitchMapping$1[this.$joinType.ordinal()]) {
                            case 1: {
                                $this$contour.lineTo(CollectionsKt.first(mOffset).getStart());
                                break;
                            }
                            case 2: {
                                double ls2 = 2.0;
                                boolean fs = false;
                                double d = joinDistance * 0.5 * Math.sqrt(ls2);
                                ls2 = 2.0;
                                fs = false;
                                $this$contour.arcTo(d, joinDistance * 0.5 * Math.sqrt(ls2), 90.0, false, true, CollectionsKt.first(mOffset).getStart());
                                break;
                            }
                            case 3: {
                                Segment segment2 = $this$contour.getLastSegment();
                                if (segment2 == null) {
                                    segment2 = (Segment)CollectionsKt.last((List)CollectionsKt.last(this.$offsets));
                                }
                                Segment ls = segment2;
                                Segment fs = CollectionsKt.first(mOffset);
                                Vector2 i = LineSegmentKt.intersection(ls.getEnd(), ls.getEnd().plus(ls.direction(1.0)), fs.getStart(), fs.getStart().minus(fs.direction(0.0)), 1.0E9);
                                if (i != Vector2.Companion.getINFINITY()) {
                                    $this$contour.lineTo(i);
                                    $this$contour.lineTo(fs.getStart());
                                    break;
                                }
                                $this$contour.lineTo(fs.getStart());
                                break;
                            }
                        }
                    }
                    for (Segment segment3 : mOffset) {
                        double d = segment3.getStart().minus($this$contour.getCursor()).getLength();
                        if (d > 1.0) {
                            $this$contour.lineTo(segment3.getStart());
                        }
                        $this$contour.segment(segment3);
                    }
                }
                if (this.this$0.getClosed()) {
                    $this$contour.close();
                }
            }
            {
                this.this$0 = shapeContour;
                this.$startPoint = vector2;
                this.$offsets = list;
                this.$joinType = segmentJoin;
                super(1);
            }
        });
    }

    public static /* synthetic */ ShapeContour offset$default(ShapeContour shapeContour, double d, SegmentJoin segmentJoin, int n, Object object) {
        if ((n & 2) != 0) {
            segmentJoin = SegmentJoin.ROUND;
        }
        return shapeContour.offset(d, segmentJoin);
    }

    public final boolean getEmpty() {
        return this == EMPTY || this.segments.isEmpty();
    }

    @NotNull
    public final Vector2 position(double ut) {
        Vector2 vector2;
        if (this.getEmpty()) {
            return Vector2.Companion.getINFINITY();
        }
        double t2 = FunctionsKt.doubleClamp(ut, 0.0, 1.0);
        double d = t2;
        if (d == 0.0) {
            vector2 = this.segments.get(0).getStart();
        } else if (d == 1.0) {
            vector2 = CollectionsKt.last(this.segments).getEnd();
        } else {
            int segment = (int)(t2 * (double)this.segments.size());
            double segmentOffset = t2 * (double)this.segments.size() - (double)segment;
            int n = this.segments.size() - 1;
            boolean bl = false;
            vector2 = this.segments.get(Math.min(n, segment)).position(segmentOffset);
        }
        return vector2;
    }

    @NotNull
    public final Vector2 normal(double ut) {
        Vector2 vector2;
        if (this.getEmpty()) {
            return Vector2.Companion.getZERO();
        }
        double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
        double d = t2;
        if (d == 0.0) {
            vector2 = this.segments.get(0).normal(0.0, this.polarity);
        } else if (d == 1.0) {
            vector2 = CollectionsKt.last(this.segments).normal(1.0, this.polarity);
        } else {
            int segment = (int)(t2 * (double)this.segments.size());
            double segmentOffset = t2 * (double)this.segments.size() - (double)segment;
            int n = this.segments.size() - 1;
            boolean bl = false;
            vector2 = this.segments.get(Math.min(n, segment)).normal(segmentOffset, this.polarity);
        }
        return vector2;
    }

    @NotNull
    public final Matrix44 pose(double t2) {
        Vector2 n = this.normal(t2);
        Vector4 dx = n.perpendicular(this.polarity).getXy0().getXyz0();
        Vector4 dy = n.getXy0().getXyz0();
        Vector4 dt = this.position(t2).getXy01();
        return Matrix44.Companion.fromColumnVectors(dx, dy, Vector4.Companion.getUNIT_Z(), dt);
    }

    @NotNull
    public final List<Vector2> adaptivePositions(double distanceTolerance) {
        return this.adaptivePositionsAndCorners(distanceTolerance).getFirst();
    }

    public static /* synthetic */ List adaptivePositions$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositions(d);
    }

    @NotNull
    public final Pair<List<Vector2>, List<Boolean>> adaptivePositionsAndCorners(double distanceTolerance) {
        int n;
        if (this.getEmpty()) {
            return new Pair<List<Vector2>, List<Boolean>>(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        boolean bl = false;
        List adaptivePoints = new ArrayList();
        boolean bl2 = false;
        List corners = new ArrayList();
        for (Segment segment : this.segments) {
            List<Vector2> samples = segment.adaptivePositions(distanceTolerance);
            Iterable $this$forEachIndexed$iv = samples;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                n = index$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Vector2 vector2 = (Vector2)item$iv;
                int index = n;
                boolean bl4 = false;
                if (index == 0) {
                    corners.add(segment.getCorner());
                    continue;
                }
                corners.add(false);
            }
            Iterable $this$forEach$iv = samples;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vector2 it = (Vector2)element$iv;
                boolean bl5 = false;
                Vector2 last2 = (Vector2)CollectionsKt.lastOrNull(adaptivePoints);
                if (last2 != null && !(last2.squaredDistanceTo(it) > 0.0)) continue;
                adaptivePoints.add(it);
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext(adaptivePoints);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl6 = false;
            boolean bl7 = ((Vector2)it.getFirst()).squaredDistanceTo((Vector2)it.getSecond()) > 0.0;
            boolean bl8 = false;
            n = 0;
            n = 0;
            boolean bl9 = false;
            if (bl7) continue;
            boolean bl10 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new Pair<List<Vector2>, List<Boolean>>(adaptivePoints, corners);
    }

    public static /* synthetic */ Pair adaptivePositionsAndCorners$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositionsAndCorners(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<Vector2>, List<Vector2>> adaptivePositionsAndDirection(double distanceTolerance) {
        if (this.getEmpty()) {
            return new Pair<List<Vector2>, List<Vector2>>(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        boolean bl = false;
        List adaptivePoints = new ArrayList();
        boolean bl2 = false;
        List adaptiveNormals = new ArrayList();
        Vector2 last2 = null;
        for (Segment segment : this.segments) {
            Pair<List<Vector2>, List<Vector2>> samples = segment.adaptivePositionsAndNormals(distanceTolerance);
            Collection collection = samples.getFirst();
            int n = 0;
            if (!(!collection.isEmpty())) continue;
            Vector2 r = samples.getFirst().get(0);
            if (last2 == null || last2.minus(r).getLength() > 0.01) {
                adaptivePoints.add(r);
                adaptiveNormals.add(samples.getSecond().get(0).getNormalized());
            }
            n = 1;
            int n2 = samples.getFirst().size();
            while (n < n2) {
                void i;
                adaptivePoints.add(samples.getFirst().get((int)i));
                adaptiveNormals.add(samples.getSecond().get((int)i).getNormalized());
                last2 = samples.getFirst().get((int)i);
                ++i;
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext(adaptivePoints);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl3 = false;
            boolean bl4 = ((Vector2)it.getFirst()).squaredDistanceTo((Vector2)it.getSecond()) > 0.0;
            boolean bl5 = false;
            boolean bl6 = false;
            bl6 = false;
            boolean bl7 = false;
            if (bl4) continue;
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new Pair<List<Vector2>, List<Vector2>>(adaptivePoints, adaptiveNormals);
    }

    public static /* synthetic */ Pair adaptivePositionsAndDirection$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositionsAndDirection(d);
    }

    @NotNull
    public final List<Vector2> equidistantPositions(int pointCount) {
        return this.getEmpty() ? CollectionsKt.emptyList() : ShapeToolsKt.sampleEquidistant(ShapeContour.adaptivePositions$default(this, 0.0, 1, null), pointCount + (this.closed ? 1 : 0));
    }

    @NotNull
    public final ShapeContour sampleLinear(double distanceTolerance) {
        return this.getEmpty() ? EMPTY : Companion.fromPoints(this.adaptivePositions(distanceTolerance), this.closed, this.polarity);
    }

    public static /* synthetic */ ShapeContour sampleLinear$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.sampleLinear(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour sampleEquidistant(int pointCount) {
        void $this$mapTo$iv$iv;
        if (this.getEmpty()) {
            return EMPTY;
        }
        List<Vector2> points = this.equidistantPositions(RangesKt.coerceAtLeast(pointCount, 2));
        Iterable $this$map$iv = RangesKt.until(0, points.size() - 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Segment segment = new Segment(points.get((int)it), points.get((int)(it + true)), false, 4, null);
            collection.add(segment);
        }
        List segments = (List)destination$iv$iv;
        return new ShapeContour(segments, this.closed, this.polarity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour transform(@NotNull Matrix44 transform2) {
        ShapeContour shapeContour;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (this.getEmpty()) {
            shapeContour = EMPTY;
        } else if (transform2 == Matrix44.Companion.getIDENTITY()) {
            shapeContour = this;
        } else {
            Collection<Segment> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.segments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment segment = (Segment)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Segment segment2 = it.transform(transform2);
                collection.add(segment2);
            }
            collection = (List)destination$iv$iv;
            YPolarity yPolarity = this.polarity;
            boolean bl = this.closed;
            List list = collection;
            shapeContour = new ShapeContour(list, bl, yPolarity);
        }
        return shapeContour;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour sub(double startT, double endT) {
        double length2;
        int segment0;
        if (this.getEmpty()) {
            return EMPTY;
        }
        boolean bl = startT == startT;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "u0 is NaN";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = endT == endT;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "u1 is NaN";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d = startT - endT;
        bl3 = false;
        if (Math.abs(d) < 1.0E-5) {
            return EMPTY;
        }
        double t0 = startT;
        double t1 = endT;
        if (this.closed && (t1 < t0 || t1 > 1.0 || t0 > 1.0 || t0 < 0.0 || t1 < 0.0)) {
            double diff = t1 - t0;
            t0 = FunctionsKt.mod(t0, 1.0);
            boolean bl6 = false;
            if (Math.abs(diff) < 0.99999) {
                return diff > 0.0 ? ((t1 = t0 + diff) > 1.0 ? this.sub(t0, 1.0).plus(this.sub(0.0, t1 - 1.0)) : this.sub(t0, t1)) : ((t1 = t0 + diff) < 0.0 ? this.sub(t1 + 1.0, 1.0).plus(this.sub(0.0, t0)) : this.sub(t1, t0));
            }
            double d2 = t1 = diff < 0.0 ? t0 - 1.0 : t0 + 1.0;
            if (t1 > 1.0) {
                return this.sub(t0, 1.0).plus(this.sub(0.0, t1 - 1.0));
            }
            if (t1 < 1.0) {
                return this.sub(t0, 1.0).plus(this.sub(0.0, t1 + 1.0));
            }
        }
        t0 = RangesKt.coerceIn(t0, 0.0, 1.0);
        t1 = RangesKt.coerceIn(t1, 0.0, 1.0);
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z0 = t1;
            z1 = t0;
        }
        double segmentOffset0 = (segment0 = (int)(z0 * (length2 = (double)this.segments.size()))) < this.segments.size() ? z0 * length2 % 1.0 : 1.0;
        int segment1 = (int)(z1 * length2);
        double segmentOffset1 = segment1 < this.segments.size() ? z1 * length2 % 1.0 : 1.0;
        int n = this.segments.size() - 1;
        boolean bl7 = false;
        segment1 = Math.min(n, segment1);
        n = this.segments.size() - 1;
        bl7 = false;
        segment0 = Math.min(n, segment0);
        bl7 = false;
        List newSegments = new ArrayList();
        double epsilon = 1.0E-6;
        int n2 = segment0;
        int n3 = segment1;
        if (n2 <= n3) {
            while (true) {
                void s2;
                if (s2 == segment0 && s2 == segment1) {
                    newSegments.add(this.segments.get((int)s2).sub(segmentOffset0, segmentOffset1));
                } else if (s2 == segment0) {
                    if (segmentOffset0 < 1.0 - epsilon) {
                        newSegments.add(this.segments.get((int)s2).sub(segmentOffset0, 1.0));
                    }
                } else if (s2 == segment1) {
                    if (segmentOffset1 > epsilon) {
                        newSegments.add(this.segments.get((int)s2).sub(0.0, segmentOffset1));
                    }
                } else {
                    newSegments.add(this.segments.get((int)s2));
                }
                if (s2 == n3) break;
                ++s2;
            }
        }
        return new ShapeContour(newSegments, false, this.polarity);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        int n = 0;
        int n2 = ((Collection)this.segments).size();
        while (n < n2) {
            void i;
            Double st = this.segments.get((int)i).on(point, error);
            if (st != null) {
                return ((double)i + st) / (double)this.segments.size();
            }
            ++i;
        }
        return null;
    }

    public static /* synthetic */ Double on$default(ShapeContour shapeContour, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return shapeContour.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContourPoint nearest(@NotNull Vector2 point) {
        Object v0;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(point, "point");
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SegmentPoint segmentPoint = it.nearest(point);
            collection.add(segmentPoint);
        }
        Object $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                SegmentPoint it = (SegmentPoint)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getPosition().distanceTo(point);
                do {
                    Object e$iv = iterator$iv.next();
                    SegmentPoint it2 = (SegmentPoint)e$iv;
                    $i$a$-minByOrNull-ShapeContour$nearest$n$2 = false;
                    double v$iv = it2.getPosition().distanceTo(point);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        SegmentPoint segmentPoint = v0;
        if (segmentPoint == null) {
            $this$minByOrNull$iv = "no segments";
            $i$f$minByOrNull = false;
            throw (Throwable)new IllegalStateException($this$minByOrNull$iv.toString());
        }
        SegmentPoint n = segmentPoint;
        int segmentIndex = this.segments.indexOf(n.getSegment());
        double t2 = ((double)segmentIndex + n.getSegmentT()) / (double)this.segments.size();
        return new ContourPoint(this, t2, n.getSegment(), n.getSegmentT(), n.getPosition());
    }

    @NotNull
    public final ShapeContour getOpened() {
        return new ShapeContour(this.segments, false, this.polarity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour getReversed() {
        Collection<Segment> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Segment segment2 = it.getReverse();
            collection.add(segment2);
        }
        collection = (List)destination$iv$iv;
        YPolarity yPolarity = this.polarity;
        boolean bl = this.closed;
        List<Segment> list = CollectionsKt.reversed((Iterable)collection);
        return new ShapeContour(list, bl, yPolarity);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="complicated semantics")
    @NotNull
    public final ShapeContour map(boolean closed, @NotNull Function1<? super Segment, Segment> mapper) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        Iterable $this$map$iv = this.segments;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(mapper.invoke((Segment)item$iv$iv));
        }
        List segments = (List)destination$iv$iv;
        $i$f$map = 0;
        List fixedSegments = new ArrayList();
        if (segments.size() > 1) {
            $i$f$map = 0;
            int $this$mapTo$iv$iv2 = segments.size() - 1;
            while ($i$f$map < $this$mapTo$iv$iv2) {
                void i;
                Segment left = (Segment)segments.get((int)i);
                Segment right = (Segment)segments.get((int)(i + true));
                Segment fixLeft = new Segment(left.getStart(), left.getControl(), right.getStart(), false, 8, null);
                fixedSegments.add(fixLeft);
                ++i;
            }
            if (closed) {
                Segment left = (Segment)CollectionsKt.last(segments);
                Segment right = (Segment)CollectionsKt.first(segments);
                fixedSegments.add(new Segment(left.getStart(), left.getControl(), right.getStart(), false, 8, null));
            } else {
                fixedSegments.add(CollectionsKt.last(segments));
            }
        }
        return new ShapeContour(segments.size() > 1 ? fixedSegments : segments, closed, this.polarity);
    }

    public static /* synthetic */ ShapeContour map$default(ShapeContour shapeContour, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = shapeContour.closed;
        }
        return shapeContour.map(bl, function1);
    }

    @NotNull
    public final Shape union(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.union(this.getShape(), other);
    }

    @NotNull
    public final Shape difference(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.difference(this, other);
    }

    @NotNull
    public final Shape intersection(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersection(this, other);
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull Segment other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this, other.getContour());
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull ShapeContour other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this, other);
    }

    @NotNull
    public final List<ContourIntersection> intersections(@NotNull Shape other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ShapeOperationsKt.intersections(this.getShape(), other);
    }

    @NotNull
    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    @NotNull
    public final YPolarity getPolarity() {
        return this.polarity;
    }

    public ShapeContour(@NotNull List<Segment> segments, boolean closed, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        this.segments = segments;
        this.closed = closed;
        this.polarity = polarity;
        this.triangulation$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Triangle>>(this){
            final /* synthetic */ ShapeContour this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Triangle> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.windowed$default(TriangulatorKt.triangulate$default(new Shape(CollectionsKt.listOf(this.this$0)), 0.0, null, 6, null), 3, 3, false, 4, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Triangle triangle = new Triangle((Vector2)it.get(0), (Vector2)it.get(1), (Vector2)it.get(2));
                    collection.add(triangle);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = shapeContour;
                super(0);
            }
        });
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)this.segments);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            double d = ((Segment)it.getFirst()).getEnd().minus(((Segment)it.getSecond()).getStart()).getLength();
            boolean bl2 = d < 1.0E-5;
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl2) continue;
            boolean bl5 = false;
            String string = "points are too far away from each other " + ((Segment)it.getFirst()).getEnd() + ' ' + ((Segment)it.getSecond()).getStart() + ' ' + d;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.length$delegate = LazyKt.lazy((Function0)new Function0<Double>(this){
            final /* synthetic */ ShapeContour this$0;

            /*
             * WARNING - void declaration
             */
            public final double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getSegments();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    Segment segment = (Segment)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getLength();
                    sum$iv = d + d2;
                }
                return (double)var3_3;
            }
            {
                this.this$0 = shapeContour;
                super(0);
            }
        });
        this.bounds$delegate = LazyKt.lazy((Function0)new Function0<Rectangle>(this){
            final /* synthetic */ ShapeContour this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Rectangle invoke() {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = ShapeContour.sampleLinear$default(this.this$0, 0.0, 1, null).getSegments();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Segment it = (Segment)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = CollectionsKt.listOf(it.getStart(), it.getEnd());
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                return RectangleKt.vector2Bounds((List)destination$iv$iv);
            }
            {
                this.this$0 = shapeContour;
                super(0);
            }
        });
    }

    public /* synthetic */ ShapeContour(List list, boolean bl, YPolarity yPolarity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        this(list, bl, yPolarity);
    }

    static {
        Companion = new Companion(null);
        EMPTY = new ShapeContour(CollectionsKt.emptyList(), false, null, 4, null);
    }

    @NotNull
    public final List<Segment> component1() {
        return this.segments;
    }

    public final boolean component2() {
        return this.closed;
    }

    @NotNull
    public final YPolarity component3() {
        return this.polarity;
    }

    @NotNull
    public final ShapeContour copy(@NotNull List<Segment> segments, boolean closed, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        return new ShapeContour(segments, closed, polarity);
    }

    public static /* synthetic */ ShapeContour copy$default(ShapeContour shapeContour, List list, boolean bl, YPolarity yPolarity, int n, Object object) {
        if ((n & 1) != 0) {
            list = shapeContour.segments;
        }
        if ((n & 2) != 0) {
            bl = shapeContour.closed;
        }
        if ((n & 4) != 0) {
            yPolarity = shapeContour.polarity;
        }
        return shapeContour.copy(list, bl, yPolarity);
    }

    @NotNull
    public String toString() {
        return "ShapeContour(segments=" + this.segments + ", closed=" + this.closed + ", polarity=" + (Object)((Object)this.polarity) + ")";
    }

    public int hashCode() {
        List<Segment> list = this.segments;
        int n = (list != null ? ((Object)list).hashCode() : 0) * 31;
        int n2 = this.closed ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        YPolarity yPolarity = this.polarity;
        return (n + n2) * 31 + (yPolarity != null ? ((Object)((Object)yPolarity)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ShapeContour)) break block3;
                ShapeContour shapeContour = (ShapeContour)object;
                if (!Intrinsics.areEqual(this.segments, shapeContour.segments) || this.closed != shapeContour.closed || !Intrinsics.areEqual((Object)this.polarity, (Object)shapeContour.polarity)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/shape/ShapeContour$Companion;", "", "()V", "EMPTY", "Lorg/openrndr/shape/ShapeContour;", "getEMPTY", "()Lorg/openrndr/shape/ShapeContour;", "fromPoints", "points", "", "Lorg/openrndr/math/Vector2;", "closed", "", "polarity", "Lorg/openrndr/math/YPolarity;", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final ShapeContour getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShapeContour fromPoints(@NotNull List<Vector2> points, boolean closed, @NotNull YPolarity polarity) {
            ShapeContour shapeContour;
            Intrinsics.checkNotNullParameter(points, "points");
            Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
            if (!closed) {
                Collection<Segment> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RangesKt.until(0, points.size() - 1);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Segment segment = new Segment(points.get((int)it), points.get((int)(it + true)), false, 4, null);
                    collection.add(segment);
                }
                collection = (List)destination$iv$iv;
                YPolarity yPolarity = polarity;
                boolean bl = closed;
                List list = collection;
                shapeContour = new ShapeContour(list, bl, yPolarity);
            } else {
                Collection<Segment> collection;
                void $this$mapTo$iv$iv;
                double d = CollectionsKt.last(points).minus(CollectionsKt.first(points)).getSquaredLength();
                List<Vector2> usePoints = d > 1.0E-5 ? points : CollectionsKt.dropLast(points, 1);
                Iterable $this$map$iv = CollectionsKt.getIndices((Collection)usePoints);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Segment segment = new Segment(usePoints.get((int)it), usePoints.get((int)((it + true) % usePoints.size())), false, 4, null);
                    collection.add(segment);
                }
                collection = (List)destination$iv$iv;
                YPolarity yPolarity = polarity;
                boolean bl = true;
                List list = collection;
                shapeContour = new ShapeContour(list, bl, yPolarity);
            }
            return shapeContour;
        }

        public static /* synthetic */ ShapeContour fromPoints$default(Companion companion, List list, boolean bl, YPolarity yPolarity, int n, Object object) {
            if ((n & 4) != 0) {
                yPolarity = YPolarity.CW_NEGATIVE_Y;
            }
            return companion.fromPoints(list, bl, yPolarity);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

