/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Color;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionKt;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Shape;
import org.openrndr.shape.StrokeWeight;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u0000JF\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0002\u001a\u00020\u0003J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000b\"\u0004\b\r\u0010\u0004\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/shape/ShapeNode;", "Lorg/openrndr/shape/CompositionNode;", "shape", "Lorg/openrndr/shape/Shape;", "(Lorg/openrndr/shape/Shape;)V", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "effectiveShape", "getEffectiveShape", "()Lorg/openrndr/shape/Shape;", "getShape", "setShape", "conflate", "copy", "id", "", "parent", "transform", "Lorg/openrndr/math/Matrix44;", "fill", "Lorg/openrndr/shape/CompositionColor;", "stroke", "equals", "", "other", "", "flatten", "hashCode", "", "openrndr-core"})
public final class ShapeNode
extends CompositionNode {
    @NotNull
    private Shape shape;

    @Override
    @NotNull
    public Rectangle getBounds() {
        Matrix44 t2 = this.getEffectiveTransform();
        return t2 == Matrix44.Companion.getIDENTITY() ? this.shape.getBounds() : this.shape.getBounds().getContour().transform(t2).getBounds();
    }

    @NotNull
    public final ShapeNode conflate() {
        ShapeNode shapeNode = new ShapeNode(this.shape);
        boolean bl = false;
        boolean bl2 = false;
        ShapeNode it = shapeNode;
        boolean bl3 = false;
        it.setFill(this.getFill());
        it.setStroke(this.getStroke());
        it.setStrokeWeight(this.getStrokeWeight());
        it.setTransform(CompositionKt.access$transform(this));
        it.setId(this.getId());
        return shapeNode;
    }

    @NotNull
    public final ShapeNode flatten() {
        ShapeNode shapeNode = new ShapeNode(this.shape.transform(CompositionKt.access$transform(this)));
        boolean bl = false;
        boolean bl2 = false;
        ShapeNode it = shapeNode;
        boolean bl3 = false;
        it.setFill(new Color(this.getEffectiveFill()));
        it.setStroke(new Color(this.getEffectiveStroke()));
        Double d = this.getEffectiveStrokeWeight();
        it.setStrokeWeight(new StrokeWeight(d != null ? d : 0.0));
        it.setTransform(Matrix44.Companion.getIDENTITY());
        it.setId(this.getId());
        return shapeNode;
    }

    @NotNull
    public final ShapeNode copy(@Nullable String id, @Nullable CompositionNode parent, @NotNull Matrix44 transform2, @NotNull CompositionColor fill2, @NotNull CompositionColor stroke, @NotNull Shape shape2) {
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Intrinsics.checkNotNullParameter(fill2, "fill");
        Intrinsics.checkNotNullParameter(stroke, "stroke");
        Intrinsics.checkNotNullParameter(shape2, "shape");
        ShapeNode shapeNode = new ShapeNode(shape2);
        boolean bl = false;
        boolean bl2 = false;
        ShapeNode it = shapeNode;
        boolean bl3 = false;
        it.setId(id);
        it.setParent(parent);
        it.setTransform(transform2);
        it.setFill(fill2);
        it.setStroke(stroke);
        it.setStrokeWeight(this.getStrokeWeight());
        it.shape = shape2;
        return shapeNode;
    }

    public static /* synthetic */ ShapeNode copy$default(ShapeNode shapeNode, String string, CompositionNode compositionNode, Matrix44 matrix44, CompositionColor compositionColor, CompositionColor compositionColor2, Shape shape2, int n, Object object) {
        if ((n & 1) != 0) {
            string = shapeNode.getId();
        }
        if ((n & 2) != 0) {
            compositionNode = null;
        }
        if ((n & 4) != 0) {
            matrix44 = shapeNode.getTransform();
        }
        if ((n & 8) != 0) {
            compositionColor = shapeNode.getFill();
        }
        if ((n & 0x10) != 0) {
            compositionColor2 = shapeNode.getStroke();
        }
        if ((n & 0x20) != 0) {
            shape2 = shapeNode.shape;
        }
        return shapeNode.copy(string, compositionNode, matrix44, compositionColor, compositionColor2, shape2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShapeNode)) {
            return false;
        }
        return !(Intrinsics.areEqual(this.shape, ((ShapeNode)other).shape) ^ true);
    }

    public int hashCode() {
        return this.shape.hashCode();
    }

    @NotNull
    public final Shape getEffectiveShape() {
        return this.shape.transform(this.getEffectiveTransform());
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    public final void setShape(@NotNull Shape shape2) {
        Intrinsics.checkNotNullParameter(shape2, "<set-?>");
        this.shape = shape2;
    }

    public ShapeNode(@NotNull Shape shape2) {
        Intrinsics.checkNotNullParameter(shape2, "shape");
        super(null);
        this.shape = shape2;
    }
}

