/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\bH\u0086\u0002J\u0013\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020'J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\bH\u0086\u0002J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006+"}, d2={"Lorg/openrndr/shape/Triangle;", "", "x1", "Lorg/openrndr/math/Vector2;", "x2", "x3", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "area", "", "getArea", "()D", "area$delegate", "Lkotlin/Lazy;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getX1", "()Lorg/openrndr/math/Vector2;", "getX2", "getX3", "component1", "component2", "component3", "contains", "", "v", "copy", "div", "scale", "equals", "other", "hashCode", "", "minus", "right", "plus", "randomPoint", "random", "Lkotlin/random/Random;", "times", "toString", "", "openrndr-core"})
public final class Triangle {
    @NotNull
    private final Lazy area$delegate;
    @NotNull
    private final Vector2 x1;
    @NotNull
    private final Vector2 x2;
    @NotNull
    private final Vector2 x3;

    public final boolean contains(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        Vector2 x23 = this.x2.minus(this.x3);
        Vector2 x32 = this.x3.minus(this.x2);
        Vector2 x31 = this.x3.minus(this.x1);
        Vector2 x13 = this.x1.minus(this.x3);
        double det = x23.getY() * x13.getX() - x32.getX() * x31.getY();
        double d = 0.0;
        boolean bl = false;
        double minD = Math.min(det, d) - 1.0E-5;
        double d2 = 0.0;
        boolean bl2 = false;
        double maxD = Math.max(det, d2) + 1.0E-5;
        Vector2 d3 = v.minus(this.x3);
        double a2 = x23.getY() * d3.getX() + x32.getX() * d3.getY();
        if (a2 < minD || a2 > maxD) {
            return false;
        }
        double b = x31.getY() * d3.getX() + x13.getX() * d3.getY();
        if (b < minD || b > maxD) {
            return false;
        }
        double c = det - a2 - b;
        return !(c < minD) && !(c > maxD);
    }

    @NotNull
    public final ShapeContour getContour() {
        return ShapeContour.Companion.fromPoints$default(ShapeContour.Companion, CollectionsKt.listOf(this.x1, this.x2, this.x3), true, null, 4, null);
    }

    @NotNull
    public final Vector2 randomPoint(@NotNull Random random) {
        Intrinsics.checkNotNullParameter(random, "random");
        double u = random.nextDouble();
        double v = random.nextDouble();
        boolean bl = false;
        double su0 = Math.sqrt(u);
        double b0 = 1.0 - su0;
        double b1 = v * su0;
        Vector3 b = new Vector3(b0, b1, 1.0 - b0 - b1);
        return this.x1.times(b.getX()).plus(this.x2.times(b.getY())).plus(this.x3.times(b.getZ()));
    }

    public static /* synthetic */ Vector2 randomPoint$default(Triangle triangle, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return triangle.randomPoint(random);
    }

    public final double getArea() {
        Lazy lazy = this.area$delegate;
        Triangle triangle = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final Triangle times(double scale2) {
        return new Triangle(this.x1.times(scale2), this.x2.times(scale2), this.x3.times(scale2));
    }

    @NotNull
    public final Triangle div(double scale2) {
        return new Triangle(this.x1.div(scale2), this.x2.div(scale2), this.x3.div(scale2));
    }

    @NotNull
    public final Triangle plus(@NotNull Triangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Triangle(this.x1.plus(right.x1), this.x2.plus(right.x2), this.x3.plus(right.x3));
    }

    @NotNull
    public final Triangle minus(@NotNull Triangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Triangle(this.x1.minus(right.x1), this.x2.minus(right.x2), this.x3.minus(right.x3));
    }

    @NotNull
    public final Vector2 getX1() {
        return this.x1;
    }

    @NotNull
    public final Vector2 getX2() {
        return this.x2;
    }

    @NotNull
    public final Vector2 getX3() {
        return this.x3;
    }

    public Triangle(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.area$delegate = LazyKt.lazy((Function0)new Function0<Double>(this){
            final /* synthetic */ Triangle this$0;

            public final double invoke() {
                Vector2 u = this.this$0.getX2().minus(this.this$0.getX1());
                Vector2 v = this.this$0.getX3().minus(this.this$0.getX1());
                double d = u.cross(v);
                boolean bl = false;
                return Math.abs(d) / 2.0;
            }
            {
                this.this$0 = triangle;
                super(0);
            }
        });
    }

    @NotNull
    public final Vector2 component1() {
        return this.x1;
    }

    @NotNull
    public final Vector2 component2() {
        return this.x2;
    }

    @NotNull
    public final Vector2 component3() {
        return this.x3;
    }

    @NotNull
    public final Triangle copy(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        return new Triangle(x1, x2, x3);
    }

    public static /* synthetic */ Triangle copy$default(Triangle triangle, Vector2 vector2, Vector2 vector22, Vector2 vector23, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = triangle.x1;
        }
        if ((n & 2) != 0) {
            vector22 = triangle.x2;
        }
        if ((n & 4) != 0) {
            vector23 = triangle.x3;
        }
        return triangle.copy(vector2, vector22, vector23);
    }

    @NotNull
    public String toString() {
        return "Triangle(x1=" + this.x1 + ", x2=" + this.x2 + ", x3=" + this.x3 + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.x1;
        Vector2 vector22 = this.x2;
        Vector2 vector23 = this.x3;
        return ((vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (vector22 != null ? ((Object)vector22).hashCode() : 0)) * 31 + (vector23 != null ? ((Object)vector23).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Triangle)) break block3;
                Triangle triangle = (Triangle)object;
                if (!Intrinsics.areEqual(this.x1, triangle.x1) || !Intrinsics.areEqual(this.x2, triangle.x2) || !Intrinsics.areEqual(this.x3, triangle.x3)) break block3;
            }
            return true;
        }
        return false;
    }
}

