/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.FillRule;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeTopology;
import org.openrndr.shape.TriangulatorKt$WhenMappings;
import org.openrndr.shape.tessellation.GLConstants;
import org.openrndr.shape.tessellation.Primitive;
import org.openrndr.shape.tessellation.Tessellator;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001*\b\u0012\u0004\u0012\u00020\n0\u0001\u00a8\u0006\u000b"}, d2={"triangulate", "", "Lorg/openrndr/math/Vector2;", "shape", "Lorg/openrndr/shape/Shape;", "distanceTolerance", "", "fillRule", "Lorg/openrndr/shape/FillRule;", "cumsum", "", "openrndr-core"})
public final class TriangulatorKt {
    @NotNull
    public static final List<Integer> cumsum(@NotNull List<Integer> $this$cumsum) {
        Intrinsics.checkNotNullParameter($this$cumsum, "$this$cumsum");
        boolean bl = false;
        List result2 = new ArrayList();
        int sum = 0;
        Iterator<Integer> iterator2 = $this$cumsum.iterator();
        while (iterator2.hasNext()) {
            int i = ((Number)iterator2.next()).intValue();
            Collection collection = result2;
            Integer n = sum += i;
            boolean bl2 = false;
            collection.add(n);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> triangulate(@NotNull Shape shape2, double distanceTolerance, @NotNull FillRule fillRule) {
        int i;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(shape2, "shape");
        Intrinsics.checkNotNullParameter((Object)fillRule, "fillRule");
        if (shape2.getContours().isEmpty() || shape2.getTopology() == ShapeTopology.OPEN) {
            return CollectionsKt.emptyList();
        }
        Tessellator tessellator = new Tessellator();
        if (shape2.getTopology() == ShapeTopology.CLOSED) {
            switch (TriangulatorKt$WhenMappings.$EnumSwitchMapping$0[fillRule.ordinal()]) {
                case 1: {
                    tessellator.gluTessProperty(100140, 100130);
                    break;
                }
                case 2: {
                    tessellator.gluTessProperty(100140, 100131);
                    break;
                }
            }
        }
        tessellator.gluTessBeginPolygon(null);
        for (ShapeContour contour2 : shape2.getClosedContours()) {
            Collection collection = contour2.getSegments();
            boolean bl = false;
            if (!(!collection.isEmpty())) continue;
            tessellator.gluTessBeginContour();
            List<Vector2> positions = CollectionsKt.dropLast(contour2.adaptivePositions(distanceTolerance), 1);
            int n3 = positions.size() * 3;
            double[] dArray = new double[n3];
            n2 = 0;
            while (n2 < n3) {
                double d;
                int n4 = n2;
                int n5 = n2++;
                double[] dArray2 = dArray;
                boolean bl2 = false;
                dArray2[n5] = d = 0.0;
            }
            double[] positionData = dArray;
            int offset2 = 0;
            n = 0;
            n2 = ((Collection)positions).size();
            while (n < n2) {
                positionData[offset2] = positions.get(i).getX();
                positionData[++offset2] = positions.get(i).getY();
                positionData[++offset2] = 0.0;
                ++offset2;
                ++i;
            }
            n2 = ((Collection)positions).size();
            for (i = 0; i < n2; ++i) {
                tessellator.gluTessVertex(positionData, i * 3, new double[]{positions.get(i).getX(), positions.get(i).getY(), 0.0});
            }
            tessellator.gluTessEndContour();
        }
        tessellator.gluTessEndPolygon();
        boolean bl = false;
        List result2 = new ArrayList();
        for (Primitive pd : tessellator.primitives) {
            ArrayList<Vector2> arrayList = pd.positions;
            Intrinsics.checkNotNullExpressionValue(arrayList, "pd.positions");
            Collection collection = arrayList;
            boolean offset2 = false;
            if (!(!collection.isEmpty())) continue;
            int n6 = pd.type;
            if (n6 == GLConstants.GL_TRIANGLES) {
                ArrayList<Vector2> arrayList2 = pd.positions;
                Intrinsics.checkNotNullExpressionValue(arrayList2, "pd.positions");
                result2.addAll((Collection)arrayList2);
                continue;
            }
            if (n6 == GLConstants.GL_TRIANGLE_FAN) {
                Vector2 fixed = pd.positions.get(0);
                n2 = pd.positions.size() - 1;
                for (i = 1; i < n2; ++i) {
                    Vector2 vector2 = fixed;
                    Intrinsics.checkNotNullExpressionValue(vector2, "fixed");
                    result2.add(vector2);
                    Vector2 vector22 = pd.positions.get(i);
                    Intrinsics.checkNotNullExpressionValue(vector22, "pd.positions[i]");
                    result2.add(vector22);
                    Vector2 vector23 = pd.positions.get(i + 1);
                    Intrinsics.checkNotNullExpressionValue(vector23, "pd.positions[i + 1]");
                    result2.add(vector23);
                }
                continue;
            }
            if (n6 == GLConstants.GL_TRIANGLE_STRIP) {
                int fixed = 0;
                n = pd.positions.size() - 2;
                while (fixed < n) {
                    void i2;
                    Vector2 vector2 = pd.positions.get((int)i2);
                    Intrinsics.checkNotNullExpressionValue(vector2, "pd.positions[i]");
                    result2.add(vector2);
                    Vector2 vector24 = pd.positions.get((int)(i2 + true));
                    Intrinsics.checkNotNullExpressionValue(vector24, "pd.positions[i + 1]");
                    result2.add(vector24);
                    Vector2 vector25 = pd.positions.get((int)(i2 + 2));
                    Intrinsics.checkNotNullExpressionValue(vector25, "pd.positions[i + 2]");
                    result2.add(vector25);
                    ++i2;
                }
                continue;
            }
            String string = "type not supported: " + pd.type;
            n = 0;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        tessellator.gluDeleteTess();
        return result2;
    }

    public static /* synthetic */ List triangulate$default(Shape shape2, double d, FillRule fillRule, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        if ((n & 4) != 0) {
            fillRule = FillRule.NONZERO_WINDING;
        }
        return TriangulatorKt.triangulate(shape2, d, fillRule);
    }
}

