/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.shape.Composition;
import org.openrndr.svg.SVGDocument;
import org.openrndr.svg.SVGLoader;
import org.openrndr.svg.SVGLoaderKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b0\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0001\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u00a8\u0006\u0015"}, d2={"expandToTwoDigitsPerComponent", "", "hexValue", "loadSVG", "Lorg/openrndr/shape/Composition;", "file", "Ljava/io/File;", "fileOrUrlOrSvg", "normalizeColorHex", "colorHex", "parseArcCommand", "", "p", "parseColor", "Lorg/openrndr/color/ColorRGBa;", "scolor", "parseSVG", "svgString", "toBoolean", "", "", "openrndr-svg"})
public final class SVGLoaderKt {
    @NotNull
    public static final Composition loadSVG(@NotNull String fileOrUrlOrSvg) {
        Composition composition3;
        Intrinsics.checkNotNullParameter(fileOrUrlOrSvg, "fileOrUrlOrSvg");
        if (StringsKt.endsWith$default(fileOrUrlOrSvg, ".svg", false, 2, null)) {
            Composition composition4;
            try {
                URL url;
                URL uRL = url = new URL(fileOrUrlOrSvg);
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes(uRL);
                boolean bl2 = false;
                boolean bl3 = false;
                composition4 = SVGLoaderKt.parseSVG(new String(byArray, charset));
            }
            catch (MalformedURLException e) {
                composition4 = SVGLoaderKt.parseSVG(FilesKt.readText$default(new File(fileOrUrlOrSvg), null, 1, null));
            }
            composition3 = composition4;
        } else {
            composition3 = SVGLoaderKt.parseSVG(fileOrUrlOrSvg);
        }
        return composition3;
    }

    @NotNull
    public static final Composition loadSVG(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return SVGLoaderKt.parseSVG(FilesKt.readText$default(file, null, 1, null));
    }

    @NotNull
    public static final Composition parseSVG(@NotNull String svgString) {
        Intrinsics.checkNotNullParameter(svgString, "svgString");
        SVGDocument document = new SVGLoader().loadSVG(svgString);
        return document.composition();
    }

    @Nullable
    public static final ColorRGBa parseColor(@NotNull String scolor) {
        ColorRGBa colorRGBa;
        Intrinsics.checkNotNullParameter(scolor, "scolor");
        CharSequence charSequence = scolor;
        boolean bl = false;
        if (charSequence.length() == 0 || Intrinsics.areEqual(scolor, "none")) {
            colorRGBa = null;
        } else if (StringsKt.startsWith$default(scolor, "#", false, 2, null)) {
            String normalizedColor;
            String string = normalizedColor = StringsKt.replace$default(SVGLoaderKt.normalizeColorHex(scolor), "#", "", false, 4, null);
            int n = 16;
            boolean bl2 = false;
            long v = Long.parseLong(string, CharsKt.checkRadix(n));
            int vi = (int)v;
            int r = vi >> 16 & 0xFF;
            int g = vi >> 8 & 0xFF;
            int b = vi & 0xFF;
            colorRGBa = new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0, null, 16, null);
        } else if (Intrinsics.areEqual(scolor, "white")) {
            colorRGBa = ColorRGBa.Companion.getWHITE();
        } else if (Intrinsics.areEqual(scolor, "silver")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xC0C0C0);
        } else if (Intrinsics.areEqual(scolor, "gray")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x808080);
        } else if (Intrinsics.areEqual(scolor, "black")) {
            colorRGBa = ColorRGBa.Companion.getBLACK();
        } else if (Intrinsics.areEqual(scolor, "red")) {
            colorRGBa = ColorRGBa.Companion.getRED();
        } else if (Intrinsics.areEqual(scolor, "maroon")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x800000);
        } else if (Intrinsics.areEqual(scolor, "yellow")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xFFFF00);
        } else if (Intrinsics.areEqual(scolor, "olive")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x808000);
        } else if (Intrinsics.areEqual(scolor, "lime")) {
            colorRGBa = ColorRGBa.Companion.fromHex(65280);
        } else if (Intrinsics.areEqual(scolor, "green")) {
            colorRGBa = ColorRGBa.Companion.fromHex(32768);
        } else if (Intrinsics.areEqual(scolor, "aqua")) {
            colorRGBa = ColorRGBa.Companion.fromHex(65535);
        } else if (Intrinsics.areEqual(scolor, "teal")) {
            colorRGBa = ColorRGBa.Companion.fromHex(32896);
        } else if (Intrinsics.areEqual(scolor, "blue")) {
            colorRGBa = ColorRGBa.Companion.fromHex(255);
        } else if (Intrinsics.areEqual(scolor, "navy")) {
            colorRGBa = ColorRGBa.Companion.fromHex(128);
        } else if (Intrinsics.areEqual(scolor, "fuchsia")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xFF00FF);
        } else if (Intrinsics.areEqual(scolor, "purple")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x800080);
        } else if (Intrinsics.areEqual(scolor, "orange")) {
            colorRGBa = ColorRGBa.Companion.fromHex(16753920);
        } else {
            charSequence = "could not parse color: " + scolor;
            bl = false;
            throw (Throwable)new IllegalStateException(((Object)charSequence).toString());
        }
        return colorRGBa;
    }

    @NotNull
    public static final String normalizeColorHex(@NotNull String colorHex) {
        String string;
        Intrinsics.checkNotNullParameter(colorHex, "colorHex");
        String string2 = "#?([0-9a-f]{3,6})";
        Object object = RegexOption.IGNORE_CASE;
        boolean bl = false;
        Regex colorHexRegex = new Regex(string2, (RegexOption)object);
        MatchResult matchResult = colorHexRegex.matchEntire(colorHex);
        if (matchResult == null) {
            object = "The provided colorHex '" + colorHex + "' is not a valid color hex for the SVG spec";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        String string3 = matchGroup.getValue();
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
        String hexValue = string5;
        switch (hexValue.length()) {
            case 3: {
                string = SVGLoaderKt.expandToTwoDigitsPerComponent('f' + hexValue);
                break;
            }
            case 6: {
                string = hexValue;
                break;
            }
            default: {
                String string6 = "The provided colorHex '" + colorHex + "' is not in a supported format";
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string6.toString());
            }
        }
        String normalizedArgb = string;
        return '#' + normalizedArgb;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String expandToTwoDigitsPerComponent(@NotNull String hexValue) {
        Intrinsics.checkNotNullParameter(hexValue, "hexValue");
        Sequence $this$reduce$iv = SequencesKt.map(StringsKt.asSequence(hexValue), expandToTwoDigitsPerComponent.1.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void component;
            String string = (String)iterator$iv.next();
            String accumulatedHex = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = accumulatedHex + (String)component;
        }
        return (String)accumulator$iv;
    }

    public static final boolean toBoolean(double $this$toBoolean) {
        return (int)$this$toBoolean == 1;
    }

    @NotNull
    public static final List<List<String>> parseArcCommand(@NotNull String p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Pattern sepReg = Pattern.compile(",|\\s");
        Pattern boolReg = Pattern.compile("[01]");
        String group = "";
        boolean bl = false;
        List groups2 = new ArrayList();
        boolean bl2 = false;
        List commands = new ArrayList();
        for (int cursor = 0; cursor <= StringsKt.getLastIndex(p); ++cursor) {
            block7: {
                boolean bl3;
                block8: {
                    int n;
                    String token;
                    block6: {
                        token = String.valueOf(p.charAt(cursor));
                        if (!sepReg.matcher(token).find()) break block6;
                        CharSequence charSequence = group;
                        bl3 = false;
                        if (charSequence.length() > 0) {
                            groups2.add(group);
                        }
                        group = "";
                        break block7;
                    }
                    group = group + token;
                    if (boolReg.matcher(token).find() && 3 <= (n = groups2.size()) && 5 >= n) break block8;
                    if (cursor != StringsKt.getLastIndex(p)) break block7;
                }
                CharSequence charSequence = group;
                bl3 = false;
                if (charSequence.length() > 0) {
                    groups2.add(group);
                }
                group = "";
            }
            if (groups2.size() != 7) continue;
            commands.add(CollectionsKt.toList(groups2));
            groups2.clear();
            group = "";
        }
        return commands;
    }
}

