INCLUDE gba_common.ld

SECTIONS {
    /* VMA LAYOUT:
     *
     * ROM:
     * * boot code
     * * slow code
     * * rodata
     * IWRAM:
     * * fast code
     * * fast rodata
     * * fast data
     * * fast bss
     * * STACK
     * EWRAM:
     * * code
     * * ewram rodata
     * * data
     * * bss
     * * HEAP
     */

    /* ROM stuff */

    . = ORIGIN(romws0);
    __text_start = .;
    .text.crt0 :
    {
        . = ALIGN(4);
        KEEP (*(.text.crt0 .text.startup))
    } >romws0 =0xff

    .text.slow :
    {
        . = ALIGN(4);
        *(.text.rom .text.slow .text.unlikely)
    } >romws0 =0xff

    .rodata :
    {
        . = ALIGN(4);
        *(.rodata.rom .rodata)
    } >romws0 =0xff

    /* IWRAM stuff */

    __iwram_lma = .;
    .iwram ORIGIN(iwram) : AT (__iwram_lma)
    {
        __iwram_startv = ABSOLUTE(.);
        . = ALIGN(2);
        *(.text.isr .text.iwram .text.hot .text.arm)
        *(.iwram*)
        . = ALIGN(4);
        *(.rodata.iwram)
    } >iwram = 0xff

    __iwdata_lma = __iwram_lma + SIZEOF(.iwram);
    .data.iwram ALIGN(4) : AT (__iwdata_lma)
    {
        *(.data.iwram)
    } >iwram =0xff

    __iwram_endl = __iwdata_lma + SIZEOF(.data.iwram);
    __iwram_endv = ABSOLUTE(.); /*ORIGIN(iwram) + SIZEOF(.iwram) + SIZEOF(.data.iwram);*/

    .bss.iwram ALIGN(4) (NOLOAD) :
    {
        PROVIDE(__iwbss_start = ABSOLUTE(.));
        . = ALIGN(4);
        *(.bss.iwram* .sbss*)
    } AT>iwram

    .stack ALIGN(4) (NOLOAD) :
    {
        __sp_max = ABSOLUTE(.);
        ASSERT(__sp_max < __sp_sys - __min_stack_size, "No space left for stack!");
    } AT>iwram

    /* EWRAM stuff */

    __ewram_lma = __iwdata_lma + SIZEOF(.data.iwram);
    .ewram ORIGIN(ewram) : AT (__ewram_lma)
    {
        __ewram_startv = ABSOLUTE(.);
        . = ALIGN(2);
        *(.text.ewram .text .text.thumb)
        *(.ewram)
        *(.rodata.ewram)
    } >ewram =0xff

    __ewdata_lma = __ewram_lma + SIZEOF(.ewram);
    .data ALIGN(2) : AT(__ewdata_lma)
    {
        *(.data .data.ewram)
    } >ewram =0xff

    __ewram_endl = __ewdata_lma + SIZEOF(.data);
    __ewram_endv = ABSOLUTE(.); /*ORIGIN(ewram) + SIZEOF(.ewram) + SIZEOF(.data);*/

    .bss ALIGN(2) (NOLOAD) :
    {
        PROVIDE(__ewbss_start = ABSOLUTE(.));
        *(.bss .bss.ewram)
    } AT>ewram

    .heap ALIGN(4) (NOLOAD) :
    {
        __heap_start = ABSOLUTE(.);
        PROVIDE(__heap_start = __heap_start);
        /*. = __heap_end;*/
        ASSERT(__heap_start < __heap_end - __min_heap_size, "No space left for heap!");
    }

    __rom_end = __ewdata_lma + SIZEOF(.data);
}

