/*
 * Decompiled with CFR 0.152.
 */
package com.demoframe;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.demoframe.BaseGame;
import com.demoframe.Demo;
import com.demoframe.DummyScene;
import com.demoframe.NetworkLights;
import com.demoframe.StartParams;
import com.demoframe.TextFile;
import com.demoframe.TextLoader;
import com.mygdx.game.MusicSync;
import com.other.StaticInitialization;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import ktx.assets.Asset;
import ktx.assets.DelayedAsset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0007J\u0006\u0010D\u001a\u00020\tJ \u0010E\u001a\u00020B2\u000e\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0007012\b\b\u0002\u0010G\u001a\u00020.J\b\u0010H\u001a\u00020BH\u0016J\b\u0010I\u001a\u00020BH\u0016J\u0010\u0010J\u001a\u00020.2\u0006\u0010K\u001a\u00020<H\u0016J\u0010\u0010L\u001a\u00020.2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020.2\u0006\u0010K\u001a\u00020<H\u0016J\u0018\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020<H\u0016J\u0006\u0010S\u001a\u00020BJ\b\u0010T\u001a\u00020BH\u0016J\b\u0010U\u001a\u00020BH\u0016J\u0018\u0010V\u001a\u00020B2\u0006\u0010W\u001a\u00020<2\u0006\u0010X\u001a\u00020<H\u0016J\b\u0010Y\u001a\u00020BH\u0016J\u0010\u0010Z\u001a\u00020.2\u0006\u0010[\u001a\u00020<H\u0016J\u0006\u0010\\\u001a\u00020\tJ(\u0010]\u001a\u00020.2\u0006\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020<2\u0006\u0010^\u001a\u00020<2\u0006\u0010_\u001a\u00020<H\u0016J \u0010`\u001a\u00020.2\u0006\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020<2\u0006\u0010^\u001a\u00020<H\u0016J(\u0010a\u001a\u00020.2\u0006\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020<2\u0006\u0010^\u001a\u00020<2\u0006\u0010_\u001a\u00020<H\u0016J\u0006\u0010b\u001a\u00020<J\u0006\u0010c\u001a\u00020<R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000b\"\u0004\b,\u0010\rR\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010/\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000701\u0012\u0004\u0012\u00020\u000700j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000701\u0012\u0004\u0012\u00020\u0007`2X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010>\u00a8\u0006d"}, d2={"Lcom/demoframe/GameEngine;", "Lcom/badlogic/gdx/ApplicationListener;", "Lcom/badlogic/gdx/InputProcessor;", "startParams", "Lcom/demoframe/StartParams;", "(Lcom/demoframe/StartParams;)V", "activeScene", "Lcom/demoframe/BaseGame;", "bulletTimeIgnoredDelta", "", "getBulletTimeIgnoredDelta", "()F", "setBulletTimeIgnoredDelta", "(F)V", "bulletTimeMultiplier", "getBulletTimeMultiplier", "setBulletTimeMultiplier", "cameraDepth", "dummyScene", "Lcom/demoframe/DummyScene;", "inputMultiplexer", "Lcom/badlogic/gdx/InputMultiplexer;", "getInputMultiplexer", "()Lcom/badlogic/gdx/InputMultiplexer;", "music", "Lcom/mygdx/game/MusicSync;", "getMusic", "()Lcom/mygdx/game/MusicSync;", "setMusic", "(Lcom/mygdx/game/MusicSync;)V", "networkLights", "Lcom/demoframe/NetworkLights;", "getNetworkLights", "()Lcom/demoframe/NetworkLights;", "setNetworkLights", "(Lcom/demoframe/NetworkLights;)V", "orthographicProjection", "Lorg/joml/Matrix4f;", "getOrthographicProjection", "()Lorg/joml/Matrix4f;", "setOrthographicProjection", "(Lorg/joml/Matrix4f;)V", "runningTime", "getRunningTime", "setRunningTime", "sceneChanged", "", "scenes", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lkotlin/collections/HashMap;", "getStartParams", "()Lcom/demoframe/StartParams;", "viewport", "Lcom/badlogic/gdx/utils/viewport/Viewport;", "getViewport", "()Lcom/badlogic/gdx/utils/viewport/Viewport;", "setViewport", "(Lcom/badlogic/gdx/utils/viewport/Viewport;)V", "virtualScreenHeight", "", "getVirtualScreenHeight", "()I", "virtualScreenWidth", "getVirtualScreenWidth", "addScene", "", "scene", "aspectRatio", "changeScene", "to", "resetNextScene", "create", "dispose", "keyDown", "keycode", "keyTyped", "character", "", "keyUp", "mouseMoved", "screenX", "screenY", "nextScene", "pause", "render", "resize", "width", "height", "resume", "scrolled", "amount", "songPosition", "touchDown", "pointer", "button", "touchDragged", "touchUp", "virtualHeight", "virtualWidth", "core"})
public final class GameEngine
implements ApplicationListener,
InputProcessor {
    private boolean sceneChanged;
    private float bulletTimeIgnoredDelta;
    private final float cameraDepth = 10.0f;
    @NotNull
    public Matrix4f orthographicProjection;
    @NotNull
    public MusicSync music;
    @Nullable
    private NetworkLights networkLights;
    private final HashMap<KClass<? extends BaseGame>, BaseGame> scenes;
    private final DummyScene dummyScene;
    private BaseGame activeScene;
    @NotNull
    public Viewport viewport;
    private float runningTime;
    private float bulletTimeMultiplier;
    @NotNull
    private final InputMultiplexer inputMultiplexer;
    private final int virtualScreenWidth;
    private final int virtualScreenHeight;
    @NotNull
    private final StartParams startParams;

    public final float getBulletTimeIgnoredDelta() {
        return this.bulletTimeIgnoredDelta;
    }

    public final void setBulletTimeIgnoredDelta(float f) {
        this.bulletTimeIgnoredDelta = f;
    }

    @NotNull
    public final Matrix4f getOrthographicProjection() {
        Matrix4f matrix4f = this.orthographicProjection;
        if (matrix4f == null) {
            Intrinsics.throwUninitializedPropertyAccessException("orthographicProjection");
        }
        return matrix4f;
    }

    public final void setOrthographicProjection(@NotNull Matrix4f matrix4f) {
        Intrinsics.checkParameterIsNotNull(matrix4f, "<set-?>");
        this.orthographicProjection = matrix4f;
    }

    @NotNull
    public final MusicSync getMusic() {
        MusicSync musicSync = this.music;
        if (musicSync == null) {
            Intrinsics.throwUninitializedPropertyAccessException("music");
        }
        return musicSync;
    }

    public final void setMusic(@NotNull MusicSync musicSync) {
        Intrinsics.checkParameterIsNotNull(musicSync, "<set-?>");
        this.music = musicSync;
    }

    @Nullable
    public final NetworkLights getNetworkLights() {
        return this.networkLights;
    }

    public final void setNetworkLights(@Nullable NetworkLights networkLights) {
        this.networkLights = networkLights;
    }

    @NotNull
    public final Viewport getViewport() {
        Viewport viewport = this.viewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        return viewport;
    }

    public final void setViewport(@NotNull Viewport viewport) {
        Intrinsics.checkParameterIsNotNull(viewport, "<set-?>");
        this.viewport = viewport;
    }

    public final float getRunningTime() {
        return this.runningTime;
    }

    public final void setRunningTime(float f) {
        this.runningTime = f;
    }

    public final float getBulletTimeMultiplier() {
        return this.bulletTimeMultiplier;
    }

    public final void setBulletTimeMultiplier(float f) {
        this.bulletTimeMultiplier = f;
    }

    @NotNull
    public final InputMultiplexer getInputMultiplexer() {
        return this.inputMultiplexer;
    }

    public final int getVirtualScreenWidth() {
        return this.virtualScreenWidth;
    }

    public final int getVirtualScreenHeight() {
        return this.virtualScreenHeight;
    }

    public final float songPosition() {
        MusicSync musicSync = this.music;
        if (musicSync == null) {
            Intrinsics.throwUninitializedPropertyAccessException("music");
        }
        return musicSync.position();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void create() {
        BaseGame[] sceneArray;
        void $receiver$iv;
        void $receiver$iv2;
        if (this.startParams.getFullscreen()) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        }
        this.inputMultiplexer.addProcessor(this);
        Input input = Gdx.input;
        Intrinsics.checkExpressionValueIsNotNull(input, "Gdx.input");
        input.setInputProcessor(this.inputMultiplexer);
        AssetManager assetManager = Demo.INSTANCE.getAssetManager();
        Object assetLoader$iv = new TextLoader(new InternalFileHandleResolver());
        String suffix$iv = null;
        boolean $i$f$setLoader = false;
        $receiver$iv2.setLoader(TextFile.class, suffix$iv, assetLoader$iv);
        assetLoader$iv = Demo.INSTANCE.getAssetManager();
        String path$iv = StaticInitialization.INSTANCE.getMusicSyncFileName();
        AssetLoaderParameters parameters$iv = null;
        boolean $i$f$loadOnDemand = false;
        Asset s = new DelayedAsset<TextFile>((AssetManager)$receiver$iv, new AssetDescriptor<TextFile>(path$iv, TextFile.class, parameters$iv));
        String musicfile = StaticInitialization.INSTANCE.getMusicFileName();
        AssetManager $receiver$iv3 = Demo.INSTANCE.getAssetManager();
        parameters$iv = null;
        $i$f$loadOnDemand = false;
        Asset cfr_ignored_0 = new DelayedAsset<Music>($receiver$iv3, new AssetDescriptor<Music>(musicfile, Music.class, parameters$iv));
        String string = ((TextFile)s.getAsset()).getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MusicSync musicSync = this.music = new MusicSync(string, Demo.INSTANCE.getAssetManager(), musicfile);
        if (musicSync == null) {
            Intrinsics.throwUninitializedPropertyAccessException("music");
        }
        musicSync.volume(0.8f);
        StaticInitialization.INSTANCE.loadAssets();
        Demo.INSTANCE.getAssetManager().finishLoading();
        if (this.startParams.getNetworkAddress().length() > 0) {
            NetworkLights networkLights = this.networkLights = new NetworkLights(this.startParams.getNetworkPort(), this.startParams.getNetworkAddress());
            if (networkLights != null) {
                networkLights.setDropAmount(45);
            }
        }
        this.viewport = new FitViewport(StaticInitialization.INSTANCE.getVirtualScreenWidth(), StaticInitialization.INSTANCE.getVirtualScreenHeight());
        BaseGame[] $this$forEach$iv = sceneArray = StaticInitialization.INSTANCE.getSceneList().invoke(this);
        boolean $i$f$forEach = false;
        BaseGame[] baseGameArray = $this$forEach$iv;
        int n = baseGameArray.length;
        for (int i = 0; i < n; ++i) {
            BaseGame element$iv;
            BaseGame it = element$iv = baseGameArray[i];
            boolean bl = false;
            it.create();
            this.addScene(it);
        }
        $this$forEach$iv = sceneArray;
        GameEngine gameEngine = this;
        boolean bl = false;
        boolean bl2 = $this$forEach$iv.length == 0;
        gameEngine.activeScene = bl2 ? (BaseGame)this.dummyScene : ArraysKt.first(sceneArray);
        BaseGame baseGame = this.activeScene;
        if (baseGame == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        baseGame.reset();
        BaseGame baseGame2 = this.activeScene;
        if (baseGame2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        baseGame2.onEnter(new DummyScene(this));
        Cursor customCursor = Gdx.graphics.newCursor(new Pixmap(Gdx.files.internal("cursor.png")), 0, 0);
        Gdx.graphics.setCursor(customCursor);
        Matrix4f matrix4f = new Matrix4f();
        Viewport viewport = this.viewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        float f = viewport.getWorldWidth();
        Viewport viewport2 = this.viewport;
        if (viewport2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        Matrix4f matrix4f2 = matrix4f.ortho(0.0f, f, 0.0f, viewport2.getWorldHeight(), -1.0f, 1.0f);
        Intrinsics.checkExpressionValueIsNotNull(matrix4f2, "Matrix4f().ortho(0f, vie\u2026rt.worldHeight, -1f,  1f)");
        this.orthographicProjection = matrix4f2;
    }

    public final float aspectRatio() {
        Viewport viewport = this.viewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        float f = viewport.getWorldWidth();
        Viewport viewport2 = this.viewport;
        if (viewport2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        return f / viewport2.getWorldHeight();
    }

    public final void addScene(@NotNull BaseGame scene) {
        Intrinsics.checkParameterIsNotNull(scene, "scene");
        ((Map)this.scenes).put(Reflection.getOrCreateKotlinClass(scene.getClass()), scene);
    }

    public final void changeScene(@NotNull KClass<? extends BaseGame> to, boolean resetNextScene) {
        Intrinsics.checkParameterIsNotNull(to, "to");
        BaseGame baseGame = this.scenes.get(to);
        if (baseGame == null) {
            throw (Throwable)new Exception("Cannot change to " + to.toString() + " scene. Did you load it?");
        }
        Intrinsics.checkExpressionValueIsNotNull(baseGame, "scenes[to] ?: throw Exce\u2026scene. Did you load it?\")");
        BaseGame nextScene = baseGame;
        BaseGame baseGame2 = this.activeScene;
        if (baseGame2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        baseGame2.onExit(nextScene);
        BaseGame baseGame3 = this.activeScene;
        if (baseGame3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        BaseGame lastScene = baseGame3;
        this.activeScene = nextScene;
        if (resetNextScene) {
            BaseGame baseGame4 = this.activeScene;
            if (baseGame4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeScene");
            }
            baseGame4.reset();
        }
        BaseGame baseGame5 = this.activeScene;
        if (baseGame5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        baseGame5.onEnter(lastScene);
        this.sceneChanged = true;
    }

    public static /* synthetic */ void changeScene$default(GameEngine gameEngine, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        gameEngine.changeScene(kClass, bl);
    }

    public final void nextScene() {
        BaseGame baseGame;
        Map map = this.scenes;
        boolean bl = false;
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext() && this.scenes.size() > 1) {
            Map.Entry next = itr.next();
            BaseGame baseGame2 = (BaseGame)next.getValue();
            BaseGame baseGame3 = this.activeScene;
            if (baseGame3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeScene");
            }
            if (!Intrinsics.areEqual(baseGame2, this.scenes.get(Reflection.getOrCreateKotlinClass(baseGame3.getClass())))) continue;
            break;
        }
        if (itr.hasNext()) {
            baseGame = (BaseGame)itr.next().getValue();
        } else {
            Map map2 = this.scenes;
            boolean bl2 = false;
            baseGame = (BaseGame)map2.entrySet().iterator().next().getValue();
        }
        BaseGame nextScene = baseGame;
        this.changeScene(Reflection.getOrCreateKotlinClass(nextScene.getClass()), true);
    }

    @Override
    public void render() {
        Graphics graphics = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics, "Gdx.graphics");
        float delta = graphics.getDeltaTime() * this.bulletTimeMultiplier;
        Graphics graphics2 = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics2, "Gdx.graphics");
        this.bulletTimeIgnoredDelta = graphics2.getDeltaTime();
        this.runningTime += delta;
        NetworkLights networkLights = this.networkLights;
        if (networkLights != null) {
            networkLights.update(delta);
        }
        MusicSync musicSync = this.music;
        if (musicSync == null) {
            Intrinsics.throwUninitializedPropertyAccessException("music");
        }
        musicSync.update();
        BaseGame baseGame = this.activeScene;
        if (baseGame == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        baseGame.update(delta);
        if (!this.sceneChanged) {
            BaseGame baseGame2 = this.activeScene;
            if (baseGame2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeScene");
            }
            baseGame2.render();
        } else {
            this.sceneChanged = false;
        }
        Viewport viewport = this.viewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        viewport.apply();
        if (Gdx.input.isKeyPressed(131)) {
            Gdx.app.exit();
        }
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 248: {
                this.nextScene();
                break;
            }
            case 244: {
                BaseGame baseGame = this.activeScene;
                if (baseGame == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activeScene");
                }
                baseGame.reset();
            }
        }
        return true;
    }

    public final int virtualWidth() {
        return StaticInitialization.INSTANCE.getVirtualScreenWidth();
    }

    public final int virtualHeight() {
        return StaticInitialization.INSTANCE.getVirtualScreenHeight();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void resize(int width, int height) {
        Viewport viewport = this.viewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewport");
        }
        viewport.update(width, height);
        BaseGame baseGame = this.activeScene;
        if (baseGame == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeScene");
        }
        baseGame.resize(width, height);
    }

    @Override
    public void dispose() {
        Demo.INSTANCE.dispose();
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button2) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button2) {
        return false;
    }

    @NotNull
    public final StartParams getStartParams() {
        return this.startParams;
    }

    public GameEngine(@NotNull StartParams startParams) {
        Intrinsics.checkParameterIsNotNull(startParams, "startParams");
        this.startParams = startParams;
        this.cameraDepth = 10.0f;
        this.scenes = new HashMap();
        this.dummyScene = new DummyScene(this);
        this.bulletTimeMultiplier = 1.0f;
        this.inputMultiplexer = new InputMultiplexer();
        this.virtualScreenHeight = StaticInitialization.INSTANCE.getVirtualScreenHeight();
        this.virtualScreenWidth = StaticInitialization.INSTANCE.getVirtualScreenWidth();
    }
}

