/*
 * Decompiled with CFR 0.152.
 */
package com.demoframe;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.demoframe.Demo;
import com.demoframe.Entity;
import com.demoframe.Shader;
import com.demoframe.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.support.jdk7.AutoCloseableKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u000bJ\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bJ\u001e\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bJ\u0006\u0010\"\u001a\u00020\u0018J\u0016\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000bJ\u001e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0003J\u001a\u0010*\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020\u0007H\u0002J\u0006\u0010,\u001a\u00020\u0018J!\u0010-\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010.\u001a\u000203J\u0016\u00104\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00105\u001a\u000206J\u0016\u00104\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u000bJ\u0016\u00104\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00105\u001a\u000207J\u0016\u00104\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00105\u001a\u000208J\u0016\u00104\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00105\u001a\u000209J!\u0010:\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090/\u00a2\u0006\u0002\u0010;J\u0006\u0010<\u001a\u00020\u0018R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR-\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0010j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/demoframe/ShaderProgram;", "", "vertexShader", "", "fragmentShader", "shaderFolder", "internalResource", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "bound", "fragmentShaderId", "", "programId", "getProgramId", "()I", "uniforms", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getUniforms", "()Ljava/util/HashMap;", "vertexShaderId", "attributeLocation", "name", "bind", "", "bindCheck", "bindGLTexture", "uniformName", "texture", "Lcom/badlogic/gdx/graphics/Texture;", "textureUnitSlot", "textureHandle", "bindGLTextureRect", "glTextureHandle", "cleanup", "createShader", "resource", "type", "version", "createUniform", "disableVertexAttribute", "enableVertexAttribute", "handleUniformLocation", "storeLookup", "link", "setEntityAsMat4ArrayUniform", "values", "", "Lcom/demoframe/Entity;", "(Ljava/lang/String;[Lcom/demoframe/Entity;)V", "setFloatArrayUniform", "", "setUniform", "value", "", "Lorg/joml/Matrix4f;", "Lorg/joml/Vector3f;", "Lorg/joml/Vector4f;", "setVec4fArrayUniform", "(Ljava/lang/String;[Lorg/joml/Vector4f;)V", "unbind", "core"})
public final class ShaderProgram {
    private boolean bound;
    private final int programId;
    private int vertexShaderId;
    private int fragmentShaderId;
    @NotNull
    private final HashMap<String, Integer> uniforms;

    public final int getProgramId() {
        return this.programId;
    }

    @NotNull
    public final HashMap<String, Integer> getUniforms() {
        return this.uniforms;
    }

    public final int attributeLocation(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return GL20C.glGetAttribLocation(this.programId, name);
    }

    public final void enableVertexAttribute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        GL20.glEnableVertexAttribArray(this.attributeLocation(name));
    }

    public final void disableVertexAttribute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        GL20.glDisableVertexAttribArray(this.attributeLocation(name));
    }

    public final void link() throws Exception {
        GL20.glLinkProgram(this.programId);
        if (GL20.glGetProgrami(this.programId, 35714) == 0) {
            throw (Throwable)new Exception("Error linking Shader code: " + GL20.glGetProgramInfoLog(this.programId, 1024));
        }
        if (this.vertexShaderId != 0) {
            GL20.glDetachShader(this.programId, this.vertexShaderId);
        }
        if (this.fragmentShaderId != 0) {
            GL20.glDetachShader(this.programId, this.fragmentShaderId);
        }
        GL20.glValidateProgram(this.programId);
        if (GL20.glGetProgrami(this.programId, 35715) == 0) {
            System.err.println("Warning validating Shader code: " + GL20.glGetProgramInfoLog(this.programId, 1024));
        }
    }

    public final void bind() {
        GL20.glUseProgram(this.programId);
        this.bound = true;
    }

    public final void unbind() {
        GL20.glUseProgram(0);
        this.bound = false;
    }

    public final void cleanup() {
        this.unbind();
        if (this.programId != 0) {
            GL20.glDeleteProgram(this.programId);
        }
    }

    public final void createUniform(@NotNull String uniformName) throws Exception {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        int uniformLocation = GL20.glGetUniformLocation(this.programId, uniformName);
        if (uniformLocation < 0) {
            throw (Throwable)new Exception("Could not find uniform: " + uniformName);
        }
        this.uniforms.put(uniformName, uniformLocation);
    }

    public final void bindGLTextureRect(@NotNull String uniformName, int textureUnitSlot, int glTextureHandle) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        int uni = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
        GL20.glActiveTexture(33984 + textureUnitSlot);
        GL20.glBindTexture(34037, glTextureHandle);
        GL20.glUniform1i(uni, textureUnitSlot);
    }

    public final void bindGLTexture(@NotNull String uniformName, @NotNull Texture texture, int textureUnitSlot) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        int uni = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
        GL20.glActiveTexture(33984 + textureUnitSlot);
        texture.bind(textureUnitSlot);
        GL20.glUniform1i(uni, textureUnitSlot);
    }

    public static /* synthetic */ void bindGLTexture$default(ShaderProgram shaderProgram, String string, Texture texture, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        shaderProgram.bindGLTexture(string, texture, n);
    }

    public final void bindGLTexture(@NotNull String uniformName, int textureUnitSlot, int textureHandle) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        int uni = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
        GL20.glActiveTexture(33984 + textureUnitSlot);
        GL20.glBindTexture(3553, textureHandle);
        GL20.glUniform1i(uni, textureUnitSlot);
    }

    private final int handleUniformLocation(String uniformName, boolean storeLookup) {
        Integer uni = this.uniforms.get(uniformName);
        if (uni == null) {
            int uniformLocation = GL20.glGetUniformLocation(this.programId, uniformName);
            if (uniformLocation < 0 && Demo.INSTANCE.getStrictUniforms()) {
                throw (Throwable)new Exception("This uniform (" + uniformName + ") is not defined in the shader.");
            }
            if (storeLookup) {
                this.uniforms.put(uniformName, uniformLocation);
            }
            return uniformLocation;
        }
        return uni;
    }

    static /* synthetic */ int handleUniformLocation$default(ShaderProgram shaderProgram, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return shaderProgram.handleUniformLocation(string, bl);
    }

    private final void bindCheck() {
        if (!this.bound) {
            throw (Throwable)new Exception("Cannot set uniform for unbound shader! Bind the shader first.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setUniform(@NotNull String uniformName, @NotNull Vector4f value) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.bindCheck();
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(4);
            fb.put(value.x);
            fb.put(value.y);
            fb.put(value.z);
            fb.put(value.w);
            fb.flip();
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniform4fv(uniform, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setUniform(@NotNull String uniformName, @NotNull Vector3f value) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.bindCheck();
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(3);
            value.get(fb);
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniform3fv(uniform, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setUniform(@NotNull String uniformName, float value) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        this.bindCheck();
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(1);
            fb.put(value).flip();
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniform1fv(uniform, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setUniform(@NotNull String uniformName, int value) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        this.bindCheck();
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            IntBuffer fb = stack.mallocInt(1);
            fb.put(value).flip();
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniform1iv(uniform, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setUniform(@NotNull String uniformName, @NotNull Matrix4f value) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.bindCheck();
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(16);
            value.get(fb);
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniformMatrix4fv(uniform, false, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    public final int createShader(@NotNull String resource, int type) throws IOException {
        Intrinsics.checkParameterIsNotNull(resource, "resource");
        return this.createShader(resource, type, "");
    }

    public final int createShader(@NotNull String resource, int type, @NotNull String version) throws IOException {
        String shaderLog;
        Intrinsics.checkParameterIsNotNull(resource, "resource");
        Intrinsics.checkParameterIsNotNull(version, "version");
        int shader = GL20.glCreateShader(type);
        ByteBuffer source = Utils.INSTANCE.ioResourceToByteBuffer(resource, 8192);
        PointerBuffer strings = BufferUtils.createPointerBuffer(2);
        IntBuffer lengths = BufferUtils.createIntBuffer(2);
        ByteBuffer preamble = MemoryUtil.memUTF8("#version " + version + '\n', false);
        strings.put(0, preamble);
        lengths.put(0, preamble.remaining());
        strings.put(1, source);
        lengths.put(1, source.remaining());
        GL20.glShaderSource(shader, strings, lengths);
        GL20.glCompileShader(shader);
        int compiled = GL20.glGetShaderi(shader, 35713);
        String string = shaderLog = GL20.glGetShaderInfoLog(shader);
        Intrinsics.checkExpressionValueIsNotNull(string, "shaderLog");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().length() > 0) {
            System.err.println(shaderLog);
        }
        if (compiled == 0) {
            throw (Throwable)((Object)new AssertionError((Object)"Could not compile shader"));
        }
        return shader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setFloatArrayUniform(@NotNull String uniformName, @NotNull float[] values2) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(values2.length);
            for (float i : values2) {
                fb.put(i);
            }
            fb.flip();
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniform1fv(uniform, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setVec4fArrayUniform(@NotNull String uniformName, @NotNull Vector4f[] values2) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(values2.length * 4);
            for (Vector4f i : values2) {
                fb.put(i.x);
                fb.put(i.y);
                fb.put(i.z);
                fb.put(i.w);
            }
            fb.flip();
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniform4fv(uniform, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setEntityAsMat4ArrayUniform(@NotNull String uniformName, @NotNull Entity[] values2) {
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        AutoCloseable $receiver$iv = MemoryStack.stackPush();
        boolean closed$iv = false;
        try {
            MemoryStack stack = (MemoryStack)$receiver$iv;
            boolean bl = false;
            FloatBuffer fb = stack.mallocFloat(values2.length * 4 * 4);
            FloatBuffer tmp = stack.mallocFloat(16);
            for (Entity i : values2) {
                Matrix4f mat4 = i.model();
                mat4.get(tmp);
                int n = 0;
                int n2 = tmp.capacity();
                while (n < n2) {
                    void j;
                    fb.put(tmp.get((int)j));
                    ++j;
                }
            }
            fb.flip();
            int uniform = ShaderProgram.handleUniformLocation$default(this, uniformName, false, 2, null);
            GL20.glUniformMatrix4fv(uniform, false, fb);
            Unit unit = Unit.INSTANCE;
            if ($receiver$iv == null) return;
        }
        catch (Throwable e$iv) {
            try {
                closed$iv = true;
                AutoCloseable autoCloseable = $receiver$iv;
                if (autoCloseable == null) throw e$iv;
                AutoCloseableKt.closeSuppressed(autoCloseable, e$iv);
                throw e$iv;
            }
            catch (Throwable throwable) {
                if ($receiver$iv == null || closed$iv) throw throwable;
                $receiver$iv.close();
                throw throwable;
            }
        }
        $receiver$iv.close();
        return;
    }

    public ShaderProgram(@NotNull String vertexShader, @NotNull String fragmentShader, @NotNull String shaderFolder, boolean internalResource) {
        Intrinsics.checkParameterIsNotNull(vertexShader, "vertexShader");
        Intrinsics.checkParameterIsNotNull(fragmentShader, "fragmentShader");
        Intrinsics.checkParameterIsNotNull(shaderFolder, "shaderFolder");
        this.uniforms = new HashMap();
        this.programId = GL20.glCreateProgram();
        if (this.programId == 0) {
            throw (Throwable)new Exception("Could not create Shader");
        }
        if (internalResource) {
            this.vertexShaderId = this.createShader(vertexShader, 35633);
            this.fragmentShaderId = this.createShader(fragmentShader, 35632);
        } else {
            String vsSource = Gdx.files.internal(vertexShader).readString();
            String fsSource = Gdx.files.internal(fragmentShader).readString();
            String string = vsSource;
            Intrinsics.checkExpressionValueIsNotNull(string, "vsSource");
            this.vertexShaderId = Shader.Companion.createShader(string, vertexShader, 35633).getId();
            String string2 = fsSource;
            Intrinsics.checkExpressionValueIsNotNull(string2, "fsSource");
            this.fragmentShaderId = Shader.Companion.createShader(string2, fragmentShader, 35632).getId();
        }
        GL20.glAttachShader(this.programId, this.vertexShaderId);
        GL20.glAttachShader(this.programId, this.fragmentShaderId);
        this.link();
    }

    public /* synthetic */ ShaderProgram(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl);
    }
}

