/*
 * Decompiled with CFR 0.152.
 */
package com.demoframe;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.demoframe.Demo;
import com.demoframe.Material;
import com.demoframe.Mesh;
import com.demoframe.StaticMeshesLoader$WhenMappings;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.support.jdk7.AutoCloseableKt;
import ktx.assets.Asset;
import ktx.assets.ManagedAsset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIMaterial;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.assimp.Assimp;
import org.lwjgl.system.MemoryStack;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002J&\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0017H\u0002J\u001e\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0017H\u0002J\u001e\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020!0\u0017H\u0002R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Lcom/demoframe/StaticMeshesLoader;", "", "()V", "meshMap", "Ljava/util/HashMap;", "", "", "Lcom/demoframe/Mesh;", "getMeshMap", "()Ljava/util/HashMap;", "load", "resourcePath", "texturesDir", "flags", "", "vboMode", "Lcom/demoframe/StaticMeshesLoader$VBOMode;", "(Ljava/lang/String;Ljava/lang/String;ILcom/demoframe/StaticMeshesLoader$VBOMode;)[Lcom/demoframe/Mesh;", "processIndices", "", "aiMesh", "Lorg/lwjgl/assimp/AIMesh;", "indices", "", "processMaterial", "aiMaterial", "Lorg/lwjgl/assimp/AIMaterial;", "materials", "Lcom/demoframe/Material;", "processMesh", "", "processNormals", "normals", "", "processTextCoords", "textures", "processVertices", "vertices", "VBOMode", "core"})
public final class StaticMeshesLoader {
    @NotNull
    private static final HashMap<String, Mesh[]> meshMap;
    public static final StaticMeshesLoader INSTANCE;

    @NotNull
    public final HashMap<String, Mesh[]> getMeshMap() {
        return meshMap;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Mesh[] load(@NotNull String resourcePath, @Nullable String texturesDir, int flags, @NotNull VBOMode vboMode) throws Exception {
        Intrinsics.checkParameterIsNotNull(resourcePath, "resourcePath");
        Intrinsics.checkParameterIsNotNull((Object)vboMode, "vboMode");
        Mesh[] storedMesh = meshMap.get(resourcePath);
        if (storedMesh != null) {
            return storedMesh;
        }
        AIScene aIScene = Assimp.aiImportFile(resourcePath, flags);
        if (aIScene == null) {
            throw (Throwable)new Exception("Error loading model");
        }
        Intrinsics.checkExpressionValueIsNotNull(aIScene, "Assimp.aiImportFile(reso\u2026on(\"Error loading model\")");
        AIScene aiScene = aIScene;
        if (aiScene == null) {
            String error = Assimp.aiGetErrorString();
            throw (Throwable)new Exception(String.valueOf(error));
        }
        int numMaterials = aiScene.mNumMaterials();
        PointerBuffer aiMaterials = aiScene.mMaterials();
        List materials = new ArrayList();
        int n = 0;
        int n2 = numMaterials;
        while (n < n2) {
            void i;
            AIMaterial aiMaterial;
            PointerBuffer pointerBuffer = aiMaterials;
            if (pointerBuffer == null) {
                Intrinsics.throwNpe();
            }
            AIMaterial aIMaterial = aiMaterial = AIMaterial.create(pointerBuffer.get((int)i));
            Intrinsics.checkExpressionValueIsNotNull(aIMaterial, "aiMaterial");
            this.processMaterial(aIMaterial, materials, texturesDir);
            ++i;
        }
        int numMeshes = aiScene.mNumMeshes();
        if (numMeshes < 1) {
            throw (Throwable)new Exception("Failed to load mesh: " + resourcePath);
        }
        PointerBuffer aiMeshes = aiScene.mMeshes();
        Mesh[] meshes = new Mesh[numMeshes];
        int n3 = 0;
        int n4 = numMeshes;
        while (n3 < n4) {
            Mesh mesh;
            void i;
            AIMesh aiMesh;
            PointerBuffer pointerBuffer = aiMeshes;
            if (pointerBuffer == null) {
                Intrinsics.throwNpe();
            }
            AIMesh aIMesh = aiMesh = AIMesh.create(pointerBuffer.get((int)i));
            Intrinsics.checkExpressionValueIsNotNull(aIMesh, "aiMesh");
            meshes[i] = mesh = this.processMesh(aIMesh, materials, vboMode);
            ++i;
        }
        meshMap.put(resourcePath, meshes);
        return meshes;
    }

    public static /* synthetic */ Mesh[] load$default(StaticMeshesLoader staticMeshesLoader, String string, String string2, int n, VBOMode vBOMode, int n2, Object object) throws Exception {
        if ((n2 & 4) != 0) {
            n = 8202;
        }
        if ((n2 & 8) != 0) {
            vBOMode = VBOMode.Packed;
        }
        return staticMeshesLoader.load(string, string2, n, vBOMode);
    }

    @JvmOverloads
    @NotNull
    public final Mesh[] load(@NotNull String resourcePath, @Nullable String texturesDir, int flags) throws Exception {
        return StaticMeshesLoader.load$default(this, resourcePath, texturesDir, flags, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Mesh[] load(@NotNull String resourcePath, @Nullable String texturesDir) throws Exception {
        return StaticMeshesLoader.load$default(this, resourcePath, texturesDir, 0, null, 12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processMaterial(AIMaterial aiMaterial, List<Material> materials, String texturesDir) throws Exception {
        String textPath;
        AIColor4D colour;
        block10: {
            colour = AIColor4D.create();
            textPath = null;
            AutoCloseable $receiver$iv = MemoryStack.stackPush();
            boolean closed$iv = false;
            try {
                MemoryStack it = (MemoryStack)$receiver$iv;
                boolean bl = false;
                AIString path = AIString.calloc();
                Assimp.aiGetMaterialTexture(aiMaterial, 1, 0, path, (IntBuffer)null, null, null, null, null, null);
                textPath = path.dataString();
                Unit unit = Unit.INSTANCE;
                if ($receiver$iv == null) break block10;
            }
            catch (Throwable e$iv2) {
                try {
                    closed$iv = true;
                    AutoCloseable autoCloseable = $receiver$iv;
                    if (autoCloseable == null) throw e$iv2;
                    AutoCloseableKt.closeSuppressed(autoCloseable, e$iv2);
                    throw e$iv2;
                }
                catch (Throwable e$iv2) {
                    if ($receiver$iv == null) throw e$iv2;
                    if (closed$iv) throw e$iv2;
                    $receiver$iv.close();
                    throw e$iv2;
                }
            }
            $receiver$iv.close();
        }
        Texture texture = null;
        if (textPath != null) {
            String string = textPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (string.length() > 0) {
                String fullpath = texturesDir + '/' + textPath;
                AssetManager $receiver$iv = Demo.INSTANCE.getAssetManager();
                AssetLoaderParameters parameters$iv = null;
                boolean $i$f$load = false;
                AssetDescriptor<Texture> assetDescriptor$iv = new AssetDescriptor<Texture>(fullpath, Texture.class, parameters$iv);
                $receiver$iv.load(assetDescriptor$iv);
                ((Asset)new ManagedAsset<Texture>($receiver$iv, assetDescriptor$iv)).finishLoading();
                texture = (Texture)Demo.INSTANCE.getAssetManager().get(fullpath);
            }
        }
        Vector4f ambient = Material.Companion.getDEFAULT_COLOUR();
        int result = Assimp.aiGetMaterialColor(aiMaterial, "$clr.ambient", 0, 0, colour);
        if (result == 0) {
            ambient = new Vector4f(colour.r(), colour.g(), colour.b(), colour.a());
        }
        Vector4f diffuse = Material.Companion.getDEFAULT_COLOUR();
        result = Assimp.aiGetMaterialColor(aiMaterial, "$clr.diffuse", 0, 0, colour);
        if (result == 0) {
            diffuse = new Vector4f(colour.r(), colour.g(), colour.b(), colour.a());
        }
        Vector4f specular = Material.Companion.getDEFAULT_COLOUR();
        result = Assimp.aiGetMaterialColor(aiMaterial, "$clr.specular", 0, 0, colour);
        if (result == 0) {
            specular = new Vector4f(colour.r(), colour.g(), colour.b(), colour.a());
        }
        Material material = new Material(ambient, diffuse, specular, 1.0f);
        material.setTexture(texture);
        materials.add(material);
    }

    private final Mesh processMesh(AIMesh aiMesh, List<Material> materials, VBOMode vboMode) {
        Mesh mesh;
        List indices = new ArrayList();
        this.processIndices(aiMesh, indices);
        switch (StaticMeshesLoader$WhenMappings.$EnumSwitchMapping$0[vboMode.ordinal()]) {
            case 1: {
                Mesh mesh2;
                List vertices = new ArrayList();
                List textures = new ArrayList();
                List normals = new ArrayList();
                this.processVertices(aiMesh, vertices);
                this.processNormals(aiMesh, normals);
                this.processTextCoords(aiMesh, textures);
                String string = "sizes: " + vertices.size() + ' ' + textures.size() + ' ' + normals.size();
                boolean bl = false;
                System.out.println((Object)string);
                mesh = mesh2 = new Mesh(CollectionsKt.toFloatArray(vertices), CollectionsKt.toFloatArray(textures), CollectionsKt.toFloatArray(normals), CollectionsKt.toIntArray(indices));
                break;
            }
            case 2: {
                List all = new ArrayList();
                AIVector3D.Buffer aiVertices = aiMesh.mVertices();
                AIVector3D.Buffer aiTextureCoords = aiMesh.mTextureCoords(0);
                AIVector3D.Buffer aiNormals = aiMesh.mNormals();
                while (aiVertices.remaining() > 0) {
                    AIVector3D aiVertex = (AIVector3D)aiVertices.get();
                    all.add(Float.valueOf(aiVertex.x()));
                    all.add(Float.valueOf(aiVertex.y()));
                    all.add(Float.valueOf(aiVertex.z()));
                    AIVector3D.Buffer buffer = aiTextureCoords;
                    if (buffer == null) {
                        Intrinsics.throwNpe();
                    }
                    AIVector3D aiTexCoord = (AIVector3D)buffer.get();
                    all.add(Float.valueOf(aiTexCoord.x()));
                    all.add(Float.valueOf(1.0f - aiTexCoord.y()));
                    AIVector3D.Buffer buffer2 = aiNormals;
                    if (buffer2 == null) {
                        Intrinsics.throwNpe();
                    }
                    AIVector3D aiNormal = (AIVector3D)buffer2.get();
                    all.add(Float.valueOf(aiNormal.x()));
                    all.add(Float.valueOf(aiNormal.y()));
                    all.add(Float.valueOf(aiNormal.z()));
                }
                mesh = new Mesh(CollectionsKt.toFloatArray(all), 8, CollectionsKt.toIntArray(indices));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Mesh mesh3 = mesh;
        Material material = null;
        int materialIdx = aiMesh.mMaterialIndex();
        material = materialIdx >= 0 && materialIdx < materials.size() ? materials.get(materialIdx) : new Material();
        mesh3.setMaterial(material);
        return mesh3;
    }

    private final void processVertices(AIMesh aiMesh, List<Float> vertices) {
        AIVector3D.Buffer aiVertices = aiMesh.mVertices();
        while (aiVertices.remaining() > 0) {
            AIVector3D aiVertex = (AIVector3D)aiVertices.get();
            vertices.add(Float.valueOf(aiVertex.x()));
            vertices.add(Float.valueOf(aiVertex.y()));
            vertices.add(Float.valueOf(aiVertex.z()));
        }
    }

    private final void processNormals(AIMesh aiMesh, List<Float> normals) {
        AIVector3D.Buffer aiNormals = aiMesh.mNormals();
        while (aiNormals != null && aiNormals.remaining() > 0) {
            AIVector3D aiNormal = (AIVector3D)aiNormals.get();
            normals.add(Float.valueOf(aiNormal.x()));
            normals.add(Float.valueOf(aiNormal.y()));
            normals.add(Float.valueOf(aiNormal.z()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processTextCoords(AIMesh aiMesh, List<Float> textures) {
        AIVector3D.Buffer textCoords;
        AIVector3D.Buffer buffer = textCoords = aiMesh.mTextureCoords(0);
        int numTextCoords = buffer != null ? buffer.remaining() : 0;
        int n = 0;
        int n2 = numTextCoords;
        while (n < n2) {
            void i;
            AIVector3D.Buffer buffer2 = textCoords;
            if (buffer2 == null) {
                Intrinsics.throwNpe();
            }
            AIVector3D textCoord = (AIVector3D)buffer2.get();
            textures.add(Float.valueOf(textCoord.x()));
            textures.add(Float.valueOf(1.0f - textCoord.y()));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processIndices(AIMesh aiMesh, List<Integer> indices) {
        int numFaces = aiMesh.mNumFaces();
        AIFace.Buffer aiFaces = aiMesh.mFaces();
        int n = 0;
        int n2 = numFaces;
        while (n < n2) {
            void i;
            AIFace aiFace = (AIFace)aiFaces.get((int)i);
            IntBuffer buffer = aiFace.mIndices();
            while (buffer.remaining() > 0) {
                indices.add(buffer.get());
            }
            ++i;
        }
    }

    private StaticMeshesLoader() {
    }

    static {
        StaticMeshesLoader staticMeshesLoader;
        INSTANCE = staticMeshesLoader = new StaticMeshesLoader();
        meshMap = new HashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/demoframe/StaticMeshesLoader$VBOMode;", "", "(Ljava/lang/String;I)V", "Interleaved", "Packed", "core"})
    public static final class VBOMode
    extends Enum<VBOMode> {
        public static final /* enum */ VBOMode Interleaved;
        public static final /* enum */ VBOMode Packed;
        private static final /* synthetic */ VBOMode[] $VALUES;

        static {
            VBOMode[] vBOModeArray = new VBOMode[2];
            VBOMode[] vBOModeArray2 = vBOModeArray;
            vBOModeArray[0] = Interleaved = new VBOMode();
            vBOModeArray[1] = Packed = new VBOMode();
            $VALUES = vBOModeArray;
        }

        public static VBOMode[] values() {
            return (VBOMode[])$VALUES.clone();
        }

        public static VBOMode valueOf(String string) {
            return Enum.valueOf(VBOMode.class, string);
        }
    }
}

