/*
 * Decompiled with CFR 0.152.
 */
package com.examplescenes;

import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.math.MathUtils;
import com.demoframe.BaseGame;
import com.demoframe.Demo;
import com.demoframe.GameEngine;
import com.demoframe.Material;
import com.demoframe.Mesh;
import com.demoframe.MeshObject;
import com.demoframe.ShaderProgram;
import com.demoframe.StaticMeshesLoader;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/examplescenes/Example2;", "Lcom/demoframe/BaseGame;", "engine", "Lcom/demoframe/GameEngine;", "(Lcom/demoframe/GameEngine;)V", "camPos", "Lorg/joml/Vector3f;", "getEngine", "()Lcom/demoframe/GameEngine;", "meshObject", "Lcom/demoframe/MeshObject;", "getMeshObject", "()Lcom/demoframe/MeshObject;", "setMeshObject", "(Lcom/demoframe/MeshObject;)V", "projectionMatrix", "Lorg/joml/Matrix4f;", "shader", "Lcom/demoframe/ShaderProgram;", "worldMatrix", "dispose", "", "keyUp", "", "keycode", "", "render", "reset", "update", "delta", "", "core"})
public final class Example2
extends BaseGame {
    private ShaderProgram shader;
    private final Vector3f camPos;
    private Matrix4f worldMatrix;
    private Matrix4f projectionMatrix;
    @NotNull
    private MeshObject meshObject;
    @NotNull
    private final GameEngine engine;

    @NotNull
    public final MeshObject getMeshObject() {
        return this.meshObject;
    }

    public final void setMeshObject(@NotNull MeshObject meshObject) {
        Intrinsics.checkParameterIsNotNull(meshObject, "<set-?>");
        this.meshObject = meshObject;
    }

    @Override
    public void reset() {
    }

    @Override
    public void update(float delta) {
        int d = 2;
        float stopFront = 1.5f;
        float speed = 3.2f;
        this.meshObject.getPosition().z = MathUtils.sin(this.getEngine().getRunningTime() * speed) * (float)d + (float)d + stopFront;
        float angle = this.getEngine().getRunningTime();
        this.meshObject.setRotation(new Quaternionf(new AxisAngle4f(angle, 1.0f, 0.0f, 1.0f)));
    }

    @Override
    public void render() {
        Matrix4f MVP;
        GL11.glEnable(2929);
        GL11.glClear(16640);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        ShaderProgram $this$use$iv = this.shader;
        boolean $i$f$use = false;
        $this$use$iv.bind();
        ShaderProgram it = $this$use$iv;
        boolean bl = false;
        Object object = this.meshObject.getMesh().getMaterial();
        if (object != null && (object = ((Material)object).getTexture()) != null) {
            ((GLTexture)object).bind(0);
        }
        this.shader.setUniform("projectionMatrix", this.projectionMatrix);
        this.shader.setUniform("worldMatrix", this.worldMatrix);
        this.shader.setUniform("modelMatrix", this.meshObject.model());
        Matrix4f matrix4f = MVP = new Matrix4f().identity().mul(this.projectionMatrix).mul(this.worldMatrix).mul(this.meshObject.model());
        Intrinsics.checkExpressionValueIsNotNull(matrix4f, "MVP");
        this.shader.setUniform("MVP", matrix4f);
        BaseGame.VAO $this$use$iv2 = this.meshObject.getMesh().getVao();
        boolean $i$f$use2 = false;
        $this$use$iv2.bind();
        BaseGame.VAO it2 = $this$use$iv2;
        boolean bl2 = false;
        GL11.glDrawElements(4, this.meshObject.getMesh().getVertexCount(), 5125, 0L);
        $this$use$iv2.unbind();
        GL30.glBindVertexArray(0);
        $this$use$iv.unbind();
    }

    @Override
    public boolean keyUp(int keycode) {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.meshObject.dispose();
    }

    @Override
    @NotNull
    public GameEngine getEngine() {
        return this.engine;
    }

    public Example2(@NotNull GameEngine engine) {
        Intrinsics.checkParameterIsNotNull(engine, "engine");
        this.engine = engine;
        this.camPos = new Vector3f(0.0f, 0.0f, -1.0f);
        Demo.INSTANCE.addShader("model", "examples/model.vs", "examples/model.fs");
        this.shader = Demo.INSTANCE.getShader("model");
        float aspectRatio = this.getEngine().getViewport().getWorldWidth() / this.getEngine().getViewport().getWorldHeight();
        float fov = (float)Math.toRadians(75.0);
        Matrix4f matrix4f = new Matrix4f().perspective(fov, aspectRatio, 0.01f, 100.0f);
        Intrinsics.checkExpressionValueIsNotNull(matrix4f, "Matrix4f().perspective(f\u2026aspectRatio, 0.01f, 100f)");
        this.projectionMatrix = matrix4f;
        Matrix4f matrix4f2 = new Matrix4f().lookAt(this.camPos, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        Intrinsics.checkExpressionValueIsNotNull(matrix4f2, "Matrix4f().lookAt(camPos\u2026f), Vector3f(0f, 1f, 0f))");
        this.worldMatrix = matrix4f2;
        Mesh mesh = ArraysKt.first(StaticMeshesLoader.load$default(StaticMeshesLoader.INSTANCE, "examples/models/diamond/diamond.obj", "examples/models/diamond", 0, StaticMeshesLoader.VBOMode.Interleaved, 4, null));
        if (mesh == null) {
            Intrinsics.throwNpe();
        }
        Mesh mesh2 = mesh;
        this.meshObject = new MeshObject(mesh2);
    }
}

