/*
 * Decompiled with CFR 0.152.
 */
package com.other;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Interpolation;
import com.demoframe.BaseGame;
import com.demoframe.Demo;
import com.demoframe.Entity;
import com.demoframe.GameEngine;
import com.demoframe.LerpService;
import com.demoframe.Mesh;
import com.demoframe.ShaderProgram;
import com.demoframe.StaticMeshesLoader;
import com.demoframe.Utils;
import com.mygdx.game.Timestamp;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u000e\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00060"}, d2={"Lcom/other/Pillar;", "", "engine", "Lcom/demoframe/GameEngine;", "(Lcom/demoframe/GameEngine;)V", "getEngine", "()Lcom/demoframe/GameEngine;", "entity", "Lcom/demoframe/Entity;", "getEntity", "()Lcom/demoframe/Entity;", "externalColor", "Lorg/joml/Vector4f;", "getExternalColor", "()Lorg/joml/Vector4f;", "setExternalColor", "(Lorg/joml/Vector4f;)V", "height", "", "getHeight", "()F", "mesh", "Lcom/demoframe/Mesh;", "scaleLerp", "Lcom/demoframe/LerpService;", "getScaleLerp", "()Lcom/demoframe/LerpService;", "shader", "Lcom/demoframe/ShaderProgram;", "textureImage", "Lcom/badlogic/gdx/graphics/Texture;", "vao", "Lcom/demoframe/BaseGame$VAO;", "vertexData", "", "getVertexData", "()[F", "vertexSize", "", "getVertexSize", "()I", "render", "", "projection", "Lorg/joml/Matrix4f;", "world", "update", "delta", "core"})
public final class Pillar {
    private Mesh mesh;
    private Texture textureImage;
    private ShaderProgram shader;
    private BaseGame.VAO vao;
    @NotNull
    private final Entity entity;
    private final float height = 5.0f;
    private final int vertexSize = 8;
    @NotNull
    private final float[] vertexData;
    @NotNull
    private Vector4f externalColor;
    @NotNull
    private final LerpService scaleLerp;
    @NotNull
    private final GameEngine engine;

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    public final float getHeight() {
        return this.height;
    }

    public final int getVertexSize() {
        return this.vertexSize;
    }

    @NotNull
    public final float[] getVertexData() {
        return this.vertexData;
    }

    @NotNull
    public final Vector4f getExternalColor() {
        return this.externalColor;
    }

    public final void setExternalColor(@NotNull Vector4f vector4f) {
        Intrinsics.checkParameterIsNotNull(vector4f, "<set-?>");
        this.externalColor = vector4f;
    }

    @NotNull
    public final LerpService getScaleLerp() {
        return this.scaleLerp;
    }

    public final void update(float delta) {
        this.entity.getPosition().x = 0.0f;
        this.entity.setRotation(this.entity.getRotation().rotate(delta, -delta * 1.9f, 0.0f));
        Timestamp timestamp = new Timestamp(0, 0, 24.0f);
        if (this.engine.getMusic().position() > timestamp.getSeconds()) {
            this.scaleLerp.setEnabled(true);
        }
        this.scaleLerp.update(delta);
        this.entity.setScale(new Vector3f(this.scaleLerp.apply()));
    }

    public final void render(@NotNull Matrix4f projection, @NotNull Matrix4f world) {
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        Intrinsics.checkParameterIsNotNull(world, "world");
        ShaderProgram $this$use$iv = this.shader;
        boolean $i$f$use = false;
        $this$use$iv.bind();
        ShaderProgram it = $this$use$iv;
        boolean bl = false;
        this.shader.bindGLTexture("texture0", this.textureImage, 0);
        this.shader.setUniform("viewPos", new Vector3f(0.0f, 0.0f, -3.0f));
        this.shader.setUniform("lightPos", new Vector3f(1.0f, 3.0f, -3.0f));
        this.shader.setUniform("externalColor", this.externalColor);
        this.shader.setUniform("lines", 0);
        this.shader.setUniform("projectionMatrix", projection);
        this.shader.setUniform("worldMatrix", world);
        this.shader.setUniform("modelMatrix", this.entity.model());
        BaseGame.VAO $this$use$iv2 = this.vao;
        boolean $i$f$use2 = false;
        $this$use$iv2.bind();
        BaseGame.VAO it2 = $this$use$iv2;
        boolean bl2 = false;
        int numVertices = this.vertexData.length / this.vertexSize;
        GL11.glDrawArrays(4, 0, numVertices);
        $this$use$iv2.unbind();
        $this$use$iv.unbind();
    }

    @NotNull
    public final GameEngine getEngine() {
        return this.engine;
    }

    public Pillar(@NotNull GameEngine engine) {
        Intrinsics.checkParameterIsNotNull(engine, "engine");
        this.engine = engine;
        this.entity = new Entity();
        this.height = 5.0f;
        this.vertexSize = 8;
        this.vertexData = Utils.Primitives.INSTANCE.getCubePTN();
        this.externalColor = new Vector4f(0.1f);
        Interpolation interpolation = Interpolation.linear;
        Intrinsics.checkExpressionValueIsNotNull(interpolation, "Interpolation.linear");
        this.scaleLerp = new LerpService(interpolation, 4.0f, false);
        this.shader = Demo.INSTANCE.getShader("pillar");
        Object t = Demo.INSTANCE.getAssetManager().get("examples/exampledemo/wines.png");
        Intrinsics.checkExpressionValueIsNotNull(t, "Demo.assetManager.get<Te\u2026s/exampledemo/wines.png\")");
        this.textureImage = (Texture)t;
        this.textureImage.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        BaseGame.VAO $this$use$iv = this.vao = new BaseGame.VAO(0, 1, null);
        boolean $i$f$use = false;
        $this$use$iv.bind();
        BaseGame.VAO it = $this$use$iv;
        boolean bl = false;
        Utils.INSTANCE.createInterleaved(this.vertexSize, this.vao, this.vertexData, null, new Utils.VertexAttribute(0, 0, 3, 0L), new Utils.VertexAttribute(1, 1, 2, 3L), new Utils.VertexAttribute(2, 2, 3, 5L));
        $this$use$iv.unbind();
        Mesh mesh = ArraysKt.first(StaticMeshesLoader.load$default(StaticMeshesLoader.INSTANCE, "examples/models/diamond/diamond.obj", "examples/models/diamond", 0, StaticMeshesLoader.VBOMode.Interleaved, 4, null));
        if (mesh == null) {
            Intrinsics.throwNpe();
        }
        this.mesh = mesh;
    }
}

