/*
 * Decompiled with CFR 0.152.
 */
package ktx.math;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import ktx.math.ImmutableVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 N2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001NB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0000H\u0087\bJ\u0016\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0000J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u0016\u001a\u00020\u0000H\u0007J\u0016\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u0011\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0004J\u0016\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u0011\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0004J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0013\u0010#\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010(\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0003H\u0016J\u001a\u0010+\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\u0003J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200H\u0007J\u001a\u00101\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\u0003J\u0011\u00101\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0011\u00102\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003H\u0087\bJ\b\u00103\u001a\u00020\u0000H\u0007J\u0011\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206H\u0086\u0002J\u0011\u00104\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0003H\u0096\u0002J\u0016\u00104\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J\u0011\u00104\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\b\u0010:\u001a\u00020;H\u0016J\t\u0010<\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003J\u0018\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0003H\u0016J\u0018\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0003H\u0016J\u0010\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0003H\u0016J\u0010\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020JH\u0016J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020&J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006O"}, d2={"Lktx/math/ImmutableVector2;", "Lktx/math/ImmutableVector;", "x", "", "y", "(FF)V", "len2", "getLen2", "()F", "nor", "getNor", "()Lktx/math/ImmutableVector2;", "getX", "getY", "angle", "reference", "angleRad", "referenceX", "referenceY", "component1", "component2", "copy", "cpy", "crs", "otherX", "otherY", "dec", "dot", "vector", "dst", "dst2", "epsilonEquals", "", "epsilon", "other", "equals", "", "hashCode", "", "inc", "isOnLine", "isZero", "margin", "minus", "deltaX", "deltaY", "mul", "matrix", "Lcom/badlogic/gdx/math/Matrix3;", "plus", "rotate", "setZero", "times", "transformation", "Lcom/badlogic/gdx/math/Affine2;", "scalar", "factorX", "factorY", "toString", "", "unaryMinus", "withAngleRad", "withClamp2", "min2", "max2", "withLength2", "length2", "withLerp", "target", "alpha", "withLimit2", "limit2", "withRandomDirection", "rng", "Ljava/util/Random;", "withRotation90", "direction", "withRotationRad", "Companion", "ktx-math"})
public final class ImmutableVector2
implements ImmutableVector<ImmutableVector2> {
    private final float len2;
    private final float x;
    private final float y;
    @NotNull
    private static final ImmutableVector2 ZERO;
    @NotNull
    private static final ImmutableVector2 X;
    @NotNull
    private static final ImmutableVector2 Y;
    public static final Companion Companion;

    @Override
    public float getLen2() {
        return this.len2;
    }

    @Override
    @NotNull
    public ImmutableVector2 getNor() {
        return this.withLength2(1.0f);
    }

    @Override
    public boolean isZero(float margin) {
        return this.x == 0.0f && this.y == 0.0f || this.getLen2() < margin;
    }

    @Override
    @NotNull
    public ImmutableVector2 unaryMinus() {
        return new ImmutableVector2(-this.x, -this.y);
    }

    @Override
    @NotNull
    public ImmutableVector2 minus(@NotNull ImmutableVector2 other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.minus(other.x, other.y);
    }

    @NotNull
    public final ImmutableVector2 minus(float deltaX, float deltaY) {
        return new ImmutableVector2(this.x - deltaX, this.y - deltaY);
    }

    @NotNull
    public static /* synthetic */ ImmutableVector2 minus$default(ImmutableVector2 immutableVector2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        return immutableVector2.minus(f, f2);
    }

    @Override
    @NotNull
    public ImmutableVector2 plus(@NotNull ImmutableVector2 other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.plus(other.x, other.y);
    }

    @NotNull
    public final ImmutableVector2 plus(float deltaX, float deltaY) {
        return new ImmutableVector2(this.x + deltaX, this.y + deltaY);
    }

    @NotNull
    public static /* synthetic */ ImmutableVector2 plus$default(ImmutableVector2 immutableVector2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        return immutableVector2.plus(f, f2);
    }

    @Override
    @NotNull
    public ImmutableVector2 inc() {
        return new ImmutableVector2(this.x + 1.0f, this.y + 1.0f);
    }

    @Override
    @NotNull
    public ImmutableVector2 dec() {
        return new ImmutableVector2(this.x - 1.0f, this.y - 1.0f);
    }

    @Override
    @NotNull
    public ImmutableVector2 times(float scalar) {
        return this.times(scalar, scalar);
    }

    @Override
    @NotNull
    public ImmutableVector2 times(@NotNull ImmutableVector2 vector) {
        Intrinsics.checkParameterIsNotNull(vector, "vector");
        return this.times(vector.x, vector.y);
    }

    @NotNull
    public final ImmutableVector2 times(float factorX, float factorY) {
        return new ImmutableVector2(this.x * factorX, this.y * factorY);
    }

    @Override
    @NotNull
    public ImmutableVector2 withLimit2(float limit2) {
        return this.getLen2() <= limit2 ? this : this.withLength2(limit2);
    }

    @Override
    @NotNull
    public ImmutableVector2 withClamp2(float min2, float max2) {
        float l2 = this.getLen2();
        return l2 < min2 ? this.withLength2(min2) : (l2 > max2 ? this.withLength2(max2) : this);
    }

    @Override
    @NotNull
    public ImmutableVector2 withLength2(float length2) {
        ImmutableVector2 immutableVector2;
        float oldLen2 = this.getLen2();
        if (oldLen2 == 0.0f || oldLen2 == length2) {
            immutableVector2 = this;
        } else {
            float f = length2 / oldLen2;
            ImmutableVector2 immutableVector22 = this;
            float f2 = (float)Math.sqrt(f);
            immutableVector2 = immutableVector22.times(f2);
        }
        return immutableVector2;
    }

    @Override
    public float dot(@NotNull ImmutableVector2 vector) {
        Intrinsics.checkParameterIsNotNull(vector, "vector");
        return this.dot(vector.x, vector.y);
    }

    public final float dot(float otherX, float otherY) {
        return Vector2.dot(this.x, this.y, otherX, otherY);
    }

    @Override
    public float dst2(@NotNull ImmutableVector2 vector) {
        Intrinsics.checkParameterIsNotNull(vector, "vector");
        return this.dst2(vector.x, vector.y);
    }

    public final float dst2(float otherX, float otherY) {
        return Vector2.dst2(this.x, this.y, otherX, otherY);
    }

    public final float dst(float otherX, float otherY) {
        return Vector2.dst(this.x, this.y, otherX, otherY);
    }

    @Override
    @NotNull
    public final ImmutableVector2 times(@NotNull Affine2 transformation) {
        Intrinsics.checkParameterIsNotNull(transformation, "transformation");
        return new ImmutableVector2(this.x * transformation.m00 + this.y * transformation.m01 + transformation.m02, this.x * transformation.m10 + this.y * transformation.m11 + transformation.m12);
    }

    public final float crs(float otherX, float otherY) {
        return this.x * otherY - this.y * otherX;
    }

    public final float angleRad(@NotNull ImmutableVector2 reference) {
        Intrinsics.checkParameterIsNotNull(reference, "reference");
        return this.angleRad(reference.x, reference.y);
    }

    public static /* synthetic */ float angleRad$default(ImmutableVector2 immutableVector2, ImmutableVector2 immutableVector22, int n, Object object) {
        if ((n & 1) != 0) {
            immutableVector22 = X;
        }
        return immutableVector2.angleRad(immutableVector22);
    }

    public final float angleRad(float referenceX, float referenceY) {
        float f;
        if (this.x == 0.0f && this.y == 0.0f || referenceX == 0.0f && referenceY == 0.0f) {
            return FloatCompanionObject.INSTANCE.getNaN();
        }
        float f2 = this.y;
        float f3 = this.x;
        float f4 = (float)Math.atan2(f2, f3);
        float result = f4 - (f = (float)Math.atan2(referenceY, referenceX));
        return result > (float)Math.PI ? result - (float)Math.PI * 2 : (result < (float)(-Math.PI) ? result + (float)Math.PI * 2 : result);
    }

    @NotNull
    public final ImmutableVector2 withAngleRad(float angle) {
        return new ImmutableVector2(this.getLen(), 0.0f).withRotationRad(angle);
    }

    @NotNull
    public final ImmutableVector2 withRotation90(int direction) {
        return direction >= 0 ? new ImmutableVector2(-this.y, this.x) : new ImmutableVector2(this.y, -this.x);
    }

    @NotNull
    public final ImmutableVector2 withRotationRad(float angle) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        return new ImmutableVector2(this.x * cos - this.y * sin, this.x * sin + this.y * cos);
    }

    @Override
    @NotNull
    public ImmutableVector2 withLerp(@NotNull ImmutableVector2 target, float alpha) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        float invAlpha = 1.0f - alpha;
        return new ImmutableVector2(this.x * invAlpha + target.x * alpha, this.y * invAlpha + target.y * alpha);
    }

    @Override
    @NotNull
    public ImmutableVector2 withRandomDirection(@NotNull Random rng) {
        Intrinsics.checkParameterIsNotNull(rng, "rng");
        return this.withAngleRad(rng.nextFloat() * ((float)Math.PI * 2));
    }

    @Override
    public boolean epsilonEquals(@NotNull ImmutableVector2 other, float epsilon) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.epsilonEquals(other.x, other.y, epsilon);
    }

    public final boolean epsilonEquals(float otherX, float otherY, float epsilon) {
        float f = otherX - this.x;
        return Math.abs(f) <= epsilon && Math.abs(f = otherY - this.y) <= epsilon;
    }

    @Override
    public boolean isOnLine(@NotNull ImmutableVector2 other, float epsilon) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return MathUtils.isZero(this.x * other.y - this.y * other.x, epsilon) && !this.isZero(0.0f) && !other.isZero(0.0f);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ',' + this.y + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="This function doesn't behave like its equivalent in LibGDX and return an angle between -180 and 180 (some LibGDX functions return between -180 and 180 and some other between 0 and 360)", replaceWith=@ReplaceWith(imports={}, expression="angleDeg(reference)"))
    public final float angle(@NotNull ImmutableVector2 reference) {
        void referenceX$iv$iv;
        void $receiver$iv$iv;
        int $i$f$angle = 0;
        Intrinsics.checkParameterIsNotNull(reference, "reference");
        ImmutableVector2 $receiver$iv = this;
        boolean $i$f$angleDeg = false;
        ImmutableVector2 immutableVector2 = $receiver$iv;
        float f = reference.getX();
        float referenceY$iv$iv = reference.getY();
        boolean $i$f$angleDeg2 = false;
        return $receiver$iv$iv.angleRad((float)referenceX$iv$iv, referenceY$iv$iv) * 57.295776f;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="This function doesn't behave like its equivalent in LibGDX and return an angle between -180 and 180 (some LibGDX functions return between -180 and 180 and some other between 0 and 360)", replaceWith=@ReplaceWith(imports={}, expression="angleDeg(reference)"))
    public static /* synthetic */ float angle$default(ImmutableVector2 this_, ImmutableVector2 reference, int n, Object object) {
        void referenceX$iv$iv;
        void $receiver$iv$iv;
        if ((n & 1) != 0) {
            reference = Companion.getX();
        }
        boolean $i$f$angle = false;
        Intrinsics.checkParameterIsNotNull(reference, "reference");
        ImmutableVector2 $receiver$iv = this_;
        boolean $i$f$angleDeg = false;
        ImmutableVector2 immutableVector2 = $receiver$iv;
        float f = reference.getX();
        float referenceY$iv$iv = reference.getY();
        boolean $i$f$angleDeg2 = false;
        return $receiver$iv$iv.angleRad((float)referenceX$iv$iv, referenceY$iv$iv) * 57.295776f;
    }

    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withRotationDeg(angle)"), level=DeprecationLevel.ERROR)
    @NotNull
    public final ImmutableVector2 rotate(float angle) {
        int $i$f$rotate = 0;
        ImmutableVector2 $receiver$iv = this;
        boolean $i$f$withRotationDeg = false;
        return $receiver$iv.withRotationRad(angle * ((float)Math.PI / 180));
    }

    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="ImmutableVector2.ZERO"), level=DeprecationLevel.ERROR)
    @NotNull
    public final ImmutableVector2 setZero() {
        return ZERO;
    }

    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={"com.badlogic.gdx.math.Affine2"}, expression="this * Affine2().set(matrix)"), level=DeprecationLevel.ERROR)
    @NotNull
    public final ImmutableVector2 mul(@NotNull Matrix3 matrix) {
        Intrinsics.checkParameterIsNotNull(matrix, "matrix");
        Affine2 affine2 = new Affine2().set(matrix);
        Intrinsics.checkExpressionValueIsNotNull(affine2, "Affine2().set(matrix)");
        return this.times(affine2);
    }

    @Deprecated(message="Immutable instances don't need to be copied", replaceWith=@ReplaceWith(imports={}, expression="this"))
    @NotNull
    public final ImmutableVector2 cpy() {
        return this;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public ImmutableVector2(float x, float y) {
        this.x = x;
        this.y = y;
        this.len2 = Vector2.len2(this.x, this.y);
    }

    static {
        Companion = new Companion(null);
        ZERO = new ImmutableVector2(0.0f, 0.0f);
        X = new ImmutableVector2(1.0f, 0.0f);
        Y = new ImmutableVector2(0.0f, 1.0f);
    }

    @Override
    public float getLen() {
        return ImmutableVector.DefaultImpls.getLen(this);
    }

    @Override
    public boolean isUnit(float margin) {
        return ImmutableVector.DefaultImpls.isUnit(this, margin);
    }

    @Override
    @NotNull
    public ImmutableVector2 withLength(float length) {
        return ImmutableVector.DefaultImpls.withLength(this, length);
    }

    @Override
    @NotNull
    public ImmutableVector2 withLimit(float limit) {
        return ImmutableVector.DefaultImpls.withLimit(this, limit);
    }

    @Override
    @NotNull
    public ImmutableVector2 withClamp(float min, float max) {
        return ImmutableVector.DefaultImpls.withClamp(this, min, max);
    }

    @Override
    @NotNull
    public ImmutableVector2 withInterpolation(@NotNull ImmutableVector2 target, float alpha, @NotNull Interpolation interpolation) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(interpolation, "interpolation");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.withInterpolation(this, (ImmutableVector)target, alpha, interpolation);
    }

    @Override
    public int compareTo(@NotNull ImmutableVector2 other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return ImmutableVector.DefaultImpls.compareTo(this, (ImmutableVector)other);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withLerp(target, alpha)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 lerp(@NotNull ImmutableVector2 target, float alpha) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.lerp(this, (ImmutableVector)target, alpha);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withLength2(len2)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 setLength2(float len2) {
        return ImmutableVector.DefaultImpls.setLength2(this, len2);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="this * scalar"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 scl(float scalar) {
        return (ImmutableVector2)ImmutableVector.DefaultImpls.scl(this, scalar);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="this * v"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 scl(@NotNull ImmutableVector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.scl(this, (ImmutableVector)v);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="this + v"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 add(@NotNull ImmutableVector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.add(this, (ImmutableVector)v);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withRandomDirection()"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 setToRandomDirection() {
        return ImmutableVector.DefaultImpls.setToRandomDirection(this);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="this + (v * scalar)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 mulAdd(@NotNull ImmutableVector2 v, float scalar) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.mulAdd(this, (ImmutableVector)v, scalar);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="this + (v * mulVec)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 mulAdd(@NotNull ImmutableVector2 v, @NotNull ImmutableVector2 mulVec) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(mulVec, "mulVec");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.mulAdd(this, (ImmutableVector)v, (ImmutableVector)mulVec);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withLimit(limit)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 limit(float limit) {
        return ImmutableVector.DefaultImpls.limit(this, limit);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withClamp(min, max)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 clamp(float min, float max) {
        return ImmutableVector.DefaultImpls.clamp(this, min, max);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="v"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 set(@NotNull ImmutableVector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.set(this, (ImmutableVector)v);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withInterpolation(target, alpha, interpolator)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 interpolate(@NotNull ImmutableVector2 target, float alpha, @NotNull Interpolation interpolator) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(interpolator, "interpolator");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.interpolate(this, (ImmutableVector)target, alpha, interpolator);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withLength(len)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 setLength(float len) {
        return ImmutableVector.DefaultImpls.setLength(this, len);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="withLimit2(limit2)"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 limit2(float limit2) {
        return ImmutableVector.DefaultImpls.limit2(this, limit2);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="this - v"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 sub(@NotNull ImmutableVector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return (ImmutableVector2)ImmutableVector.DefaultImpls.sub(this, (ImmutableVector)v);
    }

    @Override
    @Deprecated(message="Unlike its equivalent in LibGDX, this function does not change the internal state of the vector and returns a new instance instead. This might break existing code designed with mutable vectors in mind.", replaceWith=@ReplaceWith(imports={}, expression="nor"), level=DeprecationLevel.ERROR)
    @NotNull
    public ImmutableVector2 nor() {
        return ImmutableVector.DefaultImpls.nor(this);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    @NotNull
    public final ImmutableVector2 copy(float x, float y) {
        return new ImmutableVector2(x, y);
    }

    @NotNull
    public static /* synthetic */ ImmutableVector2 copy$default(ImmutableVector2 immutableVector2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = immutableVector2.x;
        }
        if ((n & 2) != 0) {
            f2 = immutableVector2.y;
        }
        return immutableVector2.copy(f, f2);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) * 31 + Float.floatToIntBits(this.y);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ImmutableVector2)) break block3;
                ImmutableVector2 immutableVector2 = (ImmutableVector2)object;
                if (Float.compare(this.x, immutableVector2.x) != 0 || Float.compare(this.y, immutableVector2.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lktx/math/ImmutableVector2$Companion;", "", "()V", "X", "Lktx/math/ImmutableVector2;", "getX", "()Lktx/math/ImmutableVector2;", "Y", "getY", "ZERO", "getZERO", "fromString", "string", "", "ktx-math"})
    public static final class Companion {
        @NotNull
        public final ImmutableVector2 getZERO() {
            return ZERO;
        }

        @NotNull
        public final ImmutableVector2 getX() {
            return X;
        }

        @NotNull
        public final ImmutableVector2 getY() {
            return Y;
        }

        @NotNull
        public final ImmutableVector2 fromString(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "string");
            Vector2 vector2 = new Vector2().fromString(string);
            Intrinsics.checkExpressionValueIsNotNull(vector2, "Vector2().fromString(string)");
            Vector2 $receiver$iv = vector2;
            boolean $i$f$toImmutable = false;
            return new ImmutableVector2($receiver$iv.x, $receiver$iv.y);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

