/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMeshKey")
public class AIMeshKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    public AIMeshKey(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMeshKey.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIMeshKey.nmTime(this.address());
    }

    @NativeType(value="unsigned int")
    public int mValue() {
        return AIMeshKey.nmValue(this.address());
    }

    public AIMeshKey mTime(double value) {
        AIMeshKey.nmTime(this.address(), value);
        return this;
    }

    public AIMeshKey mValue(@NativeType(value="unsigned int") int value) {
        AIMeshKey.nmValue(this.address(), value);
        return this;
    }

    public AIMeshKey set(double mTime, int mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIMeshKey set(AIMeshKey src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMeshKey malloc() {
        return AIMeshKey.wrap(AIMeshKey.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIMeshKey calloc() {
        return AIMeshKey.wrap(AIMeshKey.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIMeshKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIMeshKey.wrap(AIMeshKey.class, MemoryUtil.memAddress(container), container);
    }

    public static AIMeshKey create(long address) {
        return AIMeshKey.wrap(AIMeshKey.class, address);
    }

    @Nullable
    public static AIMeshKey createSafe(long address) {
        return address == 0L ? null : AIMeshKey.wrap(AIMeshKey.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIMeshKey.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIMeshKey.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMeshKey.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMeshKey.__create(capacity, SIZEOF);
        return AIMeshKey.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIMeshKey.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMeshKey.wrap(Buffer.class, address, capacity);
    }

    public static AIMeshKey mallocStack() {
        return AIMeshKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIMeshKey callocStack() {
        return AIMeshKey.callocStack(MemoryStack.stackGet());
    }

    public static AIMeshKey mallocStack(MemoryStack stack) {
        return AIMeshKey.wrap(AIMeshKey.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshKey callocStack(MemoryStack stack) {
        return AIMeshKey.wrap(AIMeshKey.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMeshKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMeshKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMeshKey.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMeshKey.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTIME);
    }

    public static int nmValue(long struct) {
        return UNSAFE.getInt(null, struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MVALUE, value);
    }

    static {
        Struct.Layout layout = AIMeshKey.__struct(AIMeshKey.__member(8), AIMeshKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIMeshKey, Buffer>
    implements NativeResource {
        private static final AIMeshKey ELEMENT_FACTORY = AIMeshKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMeshKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIMeshKey.nmTime(this.address());
        }

        @NativeType(value="unsigned int")
        public int mValue() {
            return AIMeshKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIMeshKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(@NativeType(value="unsigned int") int value) {
            AIMeshKey.nmValue(this.address(), value);
            return this;
        }
    }
}

