/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMetaDataEntry;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMetadata")
public class AIMetaData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNUMPROPERTIES;
    public static final int MKEYS;
    public static final int MVALUES;

    public AIMetaData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMetaData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mNumProperties() {
        return AIMetaData.nmNumProperties(this.address());
    }

    @NativeType(value="struct aiString *")
    public AIString.Buffer mKeys() {
        return AIMetaData.nmKeys(this.address());
    }

    @NativeType(value="struct aiMetadataEntry *")
    public AIMetaDataEntry.Buffer mValues() {
        return AIMetaData.nmValues(this.address());
    }

    public AIMetaData mNumProperties(@NativeType(value="unsigned int") int value) {
        AIMetaData.nmNumProperties(this.address(), value);
        return this;
    }

    public AIMetaData mKeys(@NativeType(value="struct aiString *") AIString.Buffer value) {
        AIMetaData.nmKeys(this.address(), value);
        return this;
    }

    public AIMetaData mValues(@NativeType(value="struct aiMetadataEntry *") AIMetaDataEntry.Buffer value) {
        AIMetaData.nmValues(this.address(), value);
        return this;
    }

    public AIMetaData set(int mNumProperties, AIString.Buffer mKeys, AIMetaDataEntry.Buffer mValues) {
        this.mNumProperties(mNumProperties);
        this.mKeys(mKeys);
        this.mValues(mValues);
        return this;
    }

    public AIMetaData set(AIMetaData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMetaData malloc() {
        return AIMetaData.wrap(AIMetaData.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIMetaData calloc() {
        return AIMetaData.wrap(AIMetaData.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIMetaData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIMetaData.wrap(AIMetaData.class, MemoryUtil.memAddress(container), container);
    }

    public static AIMetaData create(long address) {
        return AIMetaData.wrap(AIMetaData.class, address);
    }

    @Nullable
    public static AIMetaData createSafe(long address) {
        return address == 0L ? null : AIMetaData.wrap(AIMetaData.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIMetaData.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIMetaData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMetaData.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMetaData.__create(capacity, SIZEOF);
        return AIMetaData.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIMetaData.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMetaData.wrap(Buffer.class, address, capacity);
    }

    public static AIMetaData mallocStack() {
        return AIMetaData.mallocStack(MemoryStack.stackGet());
    }

    public static AIMetaData callocStack() {
        return AIMetaData.callocStack(MemoryStack.stackGet());
    }

    public static AIMetaData mallocStack(MemoryStack stack) {
        return AIMetaData.wrap(AIMetaData.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMetaData callocStack(MemoryStack stack) {
        return AIMetaData.wrap(AIMetaData.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMetaData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMetaData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMetaData.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMetaData.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmNumProperties(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMPROPERTIES);
    }

    public static AIString.Buffer nmKeys(long struct) {
        return AIString.create(MemoryUtil.memGetAddress(struct + (long)MKEYS), AIMetaData.nmNumProperties(struct));
    }

    public static AIMetaDataEntry.Buffer nmValues(long struct) {
        return AIMetaDataEntry.create(MemoryUtil.memGetAddress(struct + (long)MVALUES), AIMetaData.nmNumProperties(struct));
    }

    public static void nmNumProperties(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMPROPERTIES, value);
    }

    public static void nmKeys(long struct, AIString.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MKEYS, value.address());
    }

    public static void nmValues(long struct, AIMetaDataEntry.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MVALUES, value.address());
    }

    public static void validate(long struct) {
        int mNumProperties = AIMetaData.nmNumProperties(struct);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MKEYS));
        long mValues = MemoryUtil.memGetAddress(struct + (long)MVALUES);
        Checks.check(mValues);
        AIMetaDataEntry.validate(mValues, mNumProperties);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMetaData.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIMetaData.__struct(AIMetaData.__member(4), AIMetaData.__member(POINTER_SIZE), AIMetaData.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNUMPROPERTIES = layout.offsetof(0);
        MKEYS = layout.offsetof(1);
        MVALUES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMetaData, Buffer>
    implements NativeResource {
        private static final AIMetaData ELEMENT_FACTORY = AIMetaData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMetaData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mNumProperties() {
            return AIMetaData.nmNumProperties(this.address());
        }

        @NativeType(value="struct aiString *")
        public AIString.Buffer mKeys() {
            return AIMetaData.nmKeys(this.address());
        }

        @NativeType(value="struct aiMetadataEntry *")
        public AIMetaDataEntry.Buffer mValues() {
            return AIMetaData.nmValues(this.address());
        }

        public Buffer mNumProperties(@NativeType(value="unsigned int") int value) {
            AIMetaData.nmNumProperties(this.address(), value);
            return this;
        }

        public Buffer mKeys(@NativeType(value="struct aiString *") AIString.Buffer value) {
            AIMetaData.nmKeys(this.address(), value);
            return this;
        }

        public Buffer mValues(@NativeType(value="struct aiMetadataEntry *") AIMetaDataEntry.Buffer value) {
            AIMetaData.nmValues(this.address(), value);
            return this;
        }
    }
}

