/* -*- mode: javascript; tab-width: 4; indent-tabs-mode: nil; -*- */

/**
 * Example thingy
 *
 * Now using the dirty small library.
 *
 * How-to:
 *
 * 1. Create a JavaScript file containing "(function(){BULK})();"
 *    where BULK is a catenation of the library, the soft-synth, this
 *    file, and *last of all* the main "on-load code".
 *
 * 2. <!-- To run in "debug mode", create an HTML file containing
 *    "<html><head /><body><script>JS</script></body></html>" where JS
 *    is the JavaScript produced in step 1. Open in a browser that
 *    happens to accept the beast. -->
 *
 * 3. To produce a minified "intro competition" version, use the
 *    provided GNU Makefile or other means (automatic, to keep sane)
 *    to do the following: Remove debugging code and other redundant
 *    functionality (lines that end with "DEBUG". Feed into a
 *    JavaScript minifier like Closure. Then pack with PNGinator or
 *    JSExe or similar.
 *
 *    TODO: Write some "batch file" for Windows users who don't want
 *    to install MinGW or similar GNU toolset.
 *
 **/

/*
The visuals of this production are synced to the following song
created using the great SoundBox minisynth:
https://sb.bitsnbites.eu/?data=U0JveAwC7dvPatRQFAfgc-dPwCLVVcVNCbr2BcSVIK58C5duBsaFdNEI0nGYIZSEYUKRFunCh3Ch4Mqn6SPUTKcVhSLiamq-j5yc5N67SC7Z_cjznYityG-nr0WkL-NbEdnOg4h41k_p3qfIX2T3s1660t-ro16cRHPSxOK4iQ_Lj3G6PI7Tur6ovbgBFs3R9X1SbPyzFwezWLb9KJrfOgAAAAAAAP_ofJzairQ9yB6tR3rv70Qe8TSLnzFZTKcRVTt3Ta-m02rj37IoilExGl3evb449sf77w7a4dWc7wAAAAAAAKBr5ut6Mtha_U32eRjpbBL5q-HdQVzlZBFl_LkAAAAAAADgJum9LKL_vWivhtnj9vwtS71JRF5nbzK7AwAAAAAAwH9KTAYAAAAAAEAHickAAAAAAADoIDEZAAAAAAAAHSQmAwAAAAAAoIPEZAAAAAAAAHSQmAwAAAAAAIAOEpMBAAAAAADQRefj1FakGGQP1yO97Yj81yW7dgkAAAAAYJOVf7No_nY-W5kfVmVZV4flfGbngC77AQ

http://sb.bitsnbites.eu/?data=U0JveAwC7dm9SsNQGMbx56RpBoeqizgGexWCuzeiWIoSxBIIRcwSQmiQlCKIeCdOjl6Nl6AnX5Dix5zo_5e-73vaLCfhTH1OD6SJfNc5izV6i2Ud7tp27BnnVc5040V2NXI9W3Z6jqNAS6Wdnm31lfouCL7f_6qat7rv-f6vFCnp9HSrZ71__7PZQrEWzYyrab9pHobzKEmivu__Qje66_RrndtT0_ZwwOd_qVyPX85_0cy1rY0AAAAAAAAAAPibulHZvtqoTH4ZlUmmuhrPT3oY8qPW-y__-C-qWKBYK1cZ8WVEAQAAAAAAAAAAAP_Sx8LYkpHrTetfnInkt7dNqV6m9vNb8S4BAAAAAAAAAAAwLHldJ-7OkV29jGXeU_mX4z23vGuarKxqZRr2Q6UkZQAAAAAAAAAAABiWTw

http://sb.bitsnbites.eu/?data=U0JveAwC7dk9SgNBGAbgd2MS0MKfSsvFnELwOJZCGhsRJN0SEiQhCCLexMrS03gE3c0aiKLWRp9n-L4ZdqaY2fa9Pky2U3Y7Z6NsPY9SO9qr20m_6DylM1j0L-tVO5JhrlKt9fGHPslvNxx-ff9J3ae5y82n87P3eV7XIgAAAAAAAPw16ynZQVYpWcomJUuK5Uge7nO7ya9s799kXrNlIjabZ5om3RtLwQAAAAAAAP6l14uirhTp9gftl85uUq62i0aqpPqp_EYAAAAAAAA2y7St0-7Ocb167KV4qVKe9_a7zW7RxmTLIOybqoRkAAAAAAAAbJY3

http://sb.bitsnbites.eu/?data=U0JveAwC7dsxSgNBGAXgN0lcBUGbCJYL3kO8iY1HsLFLt4ghiEsgbJPz2NrbeY842WCZ3sD3wT_vzTA3GGZyk0zTTvO0SD7rPJ7NL5L8XJZJl7R989KUaplV3vORt7ymq22V5diHbNLXdbvNaBgOuV4fsu8DAAAAAAAA_8_uudRJyay5O5xMrpJ2X_bvY13NI9N1YwMAAAAAAIAT8r0o-Vqk7GbNfd0-nJfp7jrtPLfj_7H9lb9XsGMJAAAAAAAAp-IX

http://sb.bitsnbites.eu/?data=U0JveAwC7dwxSgQxFADQn9kxLgjarGAjDHgDDyAewt5mb6AgdtMNi-X2u9ewt7K1t_MI9uNkZ1EbtXXhveT__B9yg5BUxxHTaOqYtxHPQ1zvzaYR8XaQqi6iWeb7nAZRPGznt3VR5mLbr9fl1JiXY70aUolYbXoAAAAAAAD4R_rbNESkqPPZuFMdRjSl-Lwk636OrttUAAAAAAAAsENe2xQvbaS-zhdDe7mfJv1RNLM4-XpJVnR_rAAAAAAAALArqnkbk_LdYkQ-HdJTnSbnj3fvy3yVx7dkg5v4fQAAAAAAAMAu-QA

*/

// --------------------------------------------------------------------------------
// Variables used in this production, specifically:
var songBeatsPerMinute = 116;

// You can change/add whatever you want here:
var objTile, objBackground, objBall;

// FIXME: Find a proper place for these:
clearColor=[0,0,0,0];
defaultLightDirection=[1,1,1,0];

// --------------------------------------------------------------------------------

/**
 * Initialize the constant and pre-computed "assets" used in your own
 * production; this function is called once before entering the main
 * loop.
 *
 * Things like graphics primitives / building blocks can be generated
 * here.
 */
function initAssets(){
    // Create primitive building blocks by different profile sweeps:

    // Now I have a box in the library.
    objTile = new Box(1);

    // Ball can be built from circle curves:
    objBall = new GenCyl(new funCircle(1,10,.5), 32,
                         new funCircle(0,32));

    // Can make the radius negative to make an interior of a ball:
    objBackground = new GenCyl(new funCircle(-10,10,.5), 32,
                               new funCircle(0,32));

}




function palikat(t){
    var stuff = {
        f: [],
        o: [],
        c: []
    };
    var koko = .2;
    var s= 1;
    koko = Math.abs(Math.sin(t*0.1));
    for( var i = -5; i < 6; i++){
        s = s*-1;

        stuff.c.push(
            {
  
                f: [translate_wi(i*2*koko + Math.cos(t),Math.sin(t+i)*koko*2,0),scaleXYZ_wi(koko, koko, koko)],
                o: [objBall],
                c: []
            }
        )
    }

return stuff;
}


function naama(t){
    var stuff = {
        f: [],
        o: [],
        c: []
    };

    stuff.c.push(
        {

            f: [translate_wi(0,2,Math.tan(t/4)+ 25),scaleXYZ_wi(1, 1, 1)],
            o: [objBall],
            c: []
        }
    );

return stuff;
}

function silma(t){
    var stuff = {
        f: [],
        o: [],
        c: []
    };
    var puoli = 1;
    for(var i = 0; i < 2; i++) {
        stuff.c.push(
            {

                f: [translate_wi(.35* puoli,2.6,Math.tan(t/4)+2+ 24),scaleXYZ_wi(.1, .1, .1)],
                o: [objBall],
                c: []
            }
        );
        puoli = -1;
    }

return stuff;
}

function suu(t){
    var stuff = {
        f: [],
        o: [],
        c: []
    };
    var korkeus = 0;
    var j = Math.round(t/(4*Math.PI));
    if((j+2)%4==0) { //viiva
        for(var i = -4; i < 5; i++) {
            stuff.c.push(
                {

                    f: [translate_wi(i*0.1,2,-Math.tan(t/4)+2+ 26),scaleXYZ_wi(.05, .05, .05)],
                    o: [objTile],
                    c: []
                }
            );
        }
    }


    if((j+3)%4==0){//hymy 
        for(var i = -4; i < 5; i++) {
            stuff.c.push(
                {

                    f: [translate_wi(i*0.1,2+Math.abs(i*i*0.01),-Math.tan(t/4)+2+ 26),scaleXYZ_wi(.05, .05, .05)],
                    o: [objTile],
                    c: []
                }
            );
        }
    }
    var muutos = 0.05; 
    if((j+1)%4==0){ //mutru
        for(var i = -4; i < 5; i++) {
            stuff.c.push(
                {

                    f: [translate_wi(i*0.1,2+muutos,-Math.tan(t/4)+2+ 26),scaleXYZ_wi(.05, .05, .05)],
                    o: [objTile],
                    c: []
                }
            );
            muutos = muutos*-1;
        }
    
    }

    if((j)%4==0 && j != 0){ //suru
        for(var i = -5; i < 6; i++) {

            stuff.c.push(
                {

                    f: [translate_wi(i*0.06,2+(-1*Math.abs(i*i*0.01)),-Math.tan(t/4)+2+ 26),scaleXYZ_wi(.05, .05, .05)],
                    o: [objTile],
                    c: []
                }
            );
        }
    }
return stuff;
}

/**
 * Your own creative input goes here - this function will be called on every screen update.
 *
 * Return a scene graph for a specific time. Time given as 'beats' according to song tempo.
 *
 * This is an important function to re-write creatively to make your own entry.
 *
 */
function buildSceneAtTime(t){
    if (t > 66){
        return {
            f:[],
                o:[],
                c:[],
                r:[new Camera()]
        }
    }
    // Initialize empty scenegraph. Root node with nothing inside:
    var sceneroot={f:[],o:[],c:[]};

    // Animation parameters
    //var stufftrans=[translate_wi(0,0,0),rotY_wi(-t*.8),rotX_wi(t*.02)];
    var stufftrans=[translate_wi(0,-3.3,0)];


        var cpalikat=
            [.1,1,.1,1, //minini kirkkaus
             .0,1,.4,1, //matta heijastus
             0, 0, 0,1,  //kiilto heijastus
             4,1, 0,4];  //kiiltävyys

        var ctausta=
            [.0,.0,1,1,
             .3,.3,.8,1,
              .1, .1, .1,2,
             4,2,0.0,0];

        var cpallo=
            [1.0,.0,.0,2,
            .6,0.3,.1,3,
            .1, .1, .1,2,
            4,2,0.0,0];

        var csilma=
            [0,.0,.0,2,
            .3,.4,.6,3,
             .1, .1, .1,2,
            4,2,0.0,0];

        var tausta = {
            f:[rotZ_wi(t*.16)],
            o:[new Material(ctausta),objBackground],
            c:[]
        };

        sceneroot.c.push({f:[],
                          o:[],
                          c:[
                              
                            {f:[rotZ_wi(t), rotY_wi(t), rotX_wi(t/4)],
                                o:[new Material(cpalikat)],
                                c:[palikat(t)]},
                                                     
                                  {f:[],
                                o:[new Material(cpallo)],
                                c:[naama(t)]},       

                            {f:[],
                                o:[new Material(csilma)],
                                c:[silma(t)]},

                            {f:[],
                                o:[new Material(csilma)],
                                c:[suu(t)]},
                            

                            {f:[translate_wi(0,5,50), scaleXYZ_wi(4,6,3)],
                               o:[],
                               c:[tausta]
                              },

                              {f:[translate_wi(0,5,25), rotY_wi(Math.cos(t/2)/2) ,translate_wi(0,0,20), rotX_wi(.2)],
                               o:[],
                               c:[],
                               r:[new Camera()]
                              }
                          ]
                         }
                        );

    return sceneroot;
}




// --------------------------------------------------------------------------------

/**
 * (Optionally) initialize additional HTML and CSS parts of the
 * document. This can be used, for example, for scrolling or flashing
 * text shown as usual HTML or hypertext. Not often used in actual
 * demoscene productions.
 */
function initDocument(){
}

/**
 * (Optionally) update the HTML and CSS parts of the document. This
 * can be used for scrolling or flashing text shown as usual HTML. Not
 * often used in actual demoscene productions.
 */
function updateDocument(t){
}
