var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

function lpad(digit, len) {
    if (len === void null) {
        len = 2;
    }
    return digit.toString().padStart(len, 0);
}

var initialTime = Date.now();
function getHudTime() {
    var slowDate = new Date(initialTime + (Date.now() - initialTime) * 0.15);
    var time = lpad(slowDate.getHours()) + ":" + lpad(slowDate.getMinutes()) + ":" + lpad(slowDate.getSeconds()) + "." + lpad(slowDate.getMilliseconds(), 3);
    return time;
}

Demo.prototype.init = function()
{
    var start = 0;
    var duration = 90;
    var layer = 1;


    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png","fft0"]
        ,"shader":{"name":"fft.fs"}
    });

    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer, "image": {"name":"bad_apple.ogv", "video":{"speed":0.1} }
        ,"scale":[{"uniform2d":1.5}]
        ,"position":[{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}]
        ,"shader":{"name":"kaleidoscope.fs"}
//        ,"shader":{"name":"itsfullofstars.fs"}
                //,"color":[{"a":100}]
    });


    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"{return getHudTime();}"
        }
        ,"scale": [{"uniform2d":7.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":50}]
    });


    this.loader.addAnimation({
         "start": duration-2, "duration":2
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"noise.fs"}
        ,"color":[{"a":0},{"duration":2,"a":255}]
    });



    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });
}
