#version 330 core

in vec2 texCoord;
out vec4 fragColor;
uniform vec4 color = vec4(1,1,1,1);
uniform float time = 1.0;
uniform float sizeX = 0.1;
uniform float sizeY = 0.1;
uniform vec2 resolution = vec2(1920,1080);
uniform sampler2D texture0;

vec2 pixelate(vec2 coord)
{
    vec2 d = vec2(1.0,1.0)/vec2(resolution.x*sizeX, resolution.y*sizeY);
    coord.s = floor(coord.s/d.s)*d.s;
    coord.t = floor(coord.t/d.t)*d.t;
    return coord;    
}

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main()
{
    vec2 coord=pixelate(texCoord.st);
    fragColor = texture(texture0, texCoord.st) * vec4(vec3(rand(coord)),1) * color;
}
