# -*- coding: utf-8 -*-
"""
Created on Sun Jan 1 4:27:00 2020

@author: Ct
"""

import pygame, CollatzCollapseTimedViz, GoldbachsTimedViz, PolyaPixelsTimedViz

BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
WINWIDTH = 1920
WINHEIGHT = 1080
BOXWIDTH = 5
BOXHEIGHT = 5
MAX_X = WINWIDTH-BOXWIDTH
MAX_Y = WINHEIGHT-BOXHEIGHT
WINCENTX = round(WINWIDTH/2 - BOXWIDTH/2)
WINCENTY = round(WINHEIGHT/2 - BOXHEIGHT/2)

very_done = False

pygame.init()
#screen = pygame.display.set_mode((WINWIDTH,WINHEIGHT))
screen = pygame.display.set_mode((WINWIDTH,WINHEIGHT), pygame.FULLSCREEN)
clock = pygame.time.Clock()

#-------------------------------------------------------------------------------------------
#-----------------Title Card Logic----------------------------------------------------------------
#------------------------------------------------------------------------------------------

#How to print title card info for each conjecture
def PGPrint(fontsize, textlist, viztag):
    pygame.font.init()
    myfont = pygame.font.SysFont('cambria', fontsize)
    topMargin = fontsize
    leftMargin = fontsize
    lineSpacing = round(float(fontsize) / 3.0)
    cursor = [leftMargin,topMargin]
    # gold starting point
    pygame.Surface.fill(screen, BLACK)
    pygame.display.flip()
    #print main card text
    for i in range(len(textlist)):
        textsurface = myfont.render(textlist[i], False, WHITE)
        screen.blit(textsurface, tuple(cursor))
        cursor[1] += fontsize + lineSpacing
    #print viz exp
    myfontI = pygame.font.SysFont('cambria',round(0.9*fontsize),0,1)
    textsurface = myfontI.render(viztag, False, WHITE)
    cursor[1] += 1*(fontsize + lineSpacing)
    screen.blit(textsurface, tuple(cursor))
    #print 'PRESS ANY KEY TO START'
    cursor[1] += 2*(fontsize + lineSpacing)
    myfontS = pygame.font.SysFont('cambria', round(0.7 * fontsize))
    textsurface = myfontS.render('PRESS ANY KEY', False, WHITE)
    screen.blit(textsurface, tuple(cursor))
    pygame.display.flip()
    #Press button to play
    ready = False
    while not ready:
        clock.tick(50)
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                ready = True
    ready = False

#Title screen:
PGPrint(25, ['Numbers at an Exhibition.  Vol 1.',
             'January 4th, 2020',
             ' ',
             ' ',
             '  ',
              ' ',
             '  ',
             'Title:         Two Open Problems and One Closed',
             ' ',
             'Author:   Conjectress',
             ' ',
             ' ',
             ' ',
             ' ',
             ' ',
             ' ',
             ' ',
             ' ',
             ' ',
             ' '],
            '')


#-----------------------------------------------------------------------------------------------------
#------------COLLATZ----------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------------


PGPrint(35, ['Conjecture I',
         '',
         'The COLLATZ CONJECTURE is a conjecture in mathematics that concerns a sequence defined as follows:',
         '  Start with any positive integer n. Then each term is obtained from the previous term by this rule',
         '       If the previous term is even, the next term is one half the previous term.',
         '       If the previous term is odd, the next term is 3 times the previous term plus 1.',
         ' ',
         'The conjecture is that no matter what the value of n, the sequence will always reach 1.',
         ' ',
         'The conjecture is named after Lothar Collatz, who introduced the idea in 1937, ',
         'two years after receiving his doctorate. [1] ',
         ' ',
         'It is as yet unknown whether the Collatz Conjecture holds.',
         'Paul Erdős said about the Collatz conjecture: "Mathematics may not be ready for such problems".'],
         'VIZ: Randomly selected points iterate through simple arithmetic and inexplicably converge to (1,1) in the upper left corner')

boxCount = 200 #number of points
slowfreq = 2 #scales the number of ticks for each burst, different rates for different bursts
for i in range(3):
    very_done = CollatzCollapseTimedViz.main(boxCount,slowfreq,clock,MAX_X, MAX_Y,screen)
    if very_done: break
    pygame.Surface.fill(screen, BLACK)
    pygame.display.flip()

#---------------------------------------------------------------------------
#------------[The even numbers sum of two primes one]-----------------------
#---------------------------------------------------------------------------
if not very_done:
    PGPrint(35, ['Conjecture II',
             '',
             'On 7 June 1742, the German Mathematician Christian Goldbach wrote a letter to Leonhard Euler',
             '(letter XLIII), and in the margin of this letter he proposed a conjecture.',
             'GOLDBACH\'S CONJECTURE is one of the oldest and best-known unsolved problems in number theory',
             'and all of mathmatics.  It states: ',
             ' ',
             '        Every even integer greater than 2 can be expressed as the sum of two primes.',
             ' ',
             'The conjecture has been shown to hold for all integers less than 4 x 10^18, but remains unproven [2]',
             '...despite considerable effort.'],
            'VIZ: A prime sieve creates a golden grid of prime pairs. Blue rains down along a sequence of consecutive even prime pair sums.')

    for i in range(3):
        [SievedVerticalPrimes, very_done] = GoldbachsTimedViz.main(clock, MAX_X, MAX_Y, screen)
        if very_done: break
        pygame.Surface.fill(screen, BLACK)
        pygame.display.flip()

#---------------------------------------------------------------------------
#------------[The odd number of prime factors one]--------------------------
#---------------------------------------------------------------------------
if not very_done:
    PGPrint(35, ['Conjecture III',
         '',
         'In number theory, the POLYA CONJECTURE stated that: ',
         ' '    
         '       \"Most\" (i.e. 50% or more) of the natural numbers less than any given number',
         '        have an odd number of prime factors.',
         ' ',
         'The conjecture was posited by the Hungarian mathematician George Polya in 1919 ',
         '...and proved false in 1958 by C. Brian Haselgrove.',
         ' ',
         'The size of the smallest counterexample is 906,150,257 (1980 R. S. Lehman), which shows',
         'how a conjecture can be true for many cases, and still be false. [3]',
         'Luckily, our screen resolution is smaller than this'],
         'VIZ: Factorization cascades turn red (odd) or green (even) when completed.  When the majority are odd, the frame is red.')


    PolyaPixelsTimedViz.main(SievedVerticalPrimes, clock, WINWIDTH, WINHEIGHT, WINCENTX, WINCENTY, screen)


#------------[Done]----------------------------------------------------------
#Title screen:
if not very_done:
    PGPrint(25, ['REFERENCES',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 '        [1] Wikipedia Contributors. \"Collatz conjecture\".  ',
                 '               Wikipedia, The Free Encyclopedia. Web. 1 January 2020.',
                 ' ',
                 ' ',
                 '        [2] Wikipedia Contributors.  \"Goldbach\'s Conjecture\".  ',
                 '               Wikipedia, The Free Encyclopedia. Web. 2 January 2020. ',
                 ' ',
                 ' ',
                 '        [3] Wikipedia Contributors.  \"Polya conjecture\" ',
                 '               Wikipedia, The Free Encyclopedia. Web. 3 January 2020. ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' ',
                 ' '],
                 ' ')

pygame.quit()
