import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "insta"
  effectName: "Insta"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  property var syncIn: undefined
  property var syncFFTIn: undefined
  property var depthTestIn: undefined
  property var depthWriteIn: undefined
  property bool setShader: true
  property var fixedTimeStepIn: undefined


  property InstaImpl impl
  Component {
    id: ec
    InstaImpl {}
  }
  property bool drawOnly: false


  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("Insta removed:"+effect.name)
      impl = undefined;
    }
  }

  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        var effectSettings = {
          name: effect.name,
          effectName: effect.effectName,
          reDrawGroups: effect.reDrawGroups,
          setShader: effect.setShader,
          drawOnly: effect.drawOnly
          // meshParams: effect.meshParams
        };
        if (syncIn !== undefined) {
          effectSettings.syncIn = effect.syncIn;
        }
        if (syncFFTIn !== undefined) {
          effectSettings.syncFFTIn = effect.syncFFTIn;
        }
        if (depthTestIn !== undefined) {
          effectSettings.depthTestIn = effect.depthTestIn;
        }
        if (depthWriteIn !== undefined) {
          effectSettings.depthWriteIn = effect.depthWriteIn;
        }
        if (fixedTimeStepIn !== undefined) {
          effectSettings.fixedTimeStepIn = effect.fixedTimeStepIn
        }
        //    log("created Insta:"+effect.name)
        effect.impl = ec.createObject(effect, effectSettings);

      }
    }
  }
}
