#version 430

in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

// from pouet raymarching thread by las of mercury
float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.14159265)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z)-0.0;
}

float turb(vec3 p) {
    float r = 0.0;
    float a = 1.0;
    for (int i=0; i<3; i++) {
        a*=0.65;
        r += a*perlin(p);
        p*=2.0;
    }
    return r;
}

vec2 rotateXY2(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}


uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texImg;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float pixelSize;

uniform vec4 moveAmp;
uniform vec4 moveFreq;
uniform vec4 movePhase;
uniform float moveRand;

uniform float g_windowWidth;
uniform float g_windowHeight;

uniform float segments;

uniform float angle = 0.0;
uniform float angleDelta = 1.0;

uniform float radius = 1.0;
uniform float imageScale = 2.0;
uniform float bright = 1.0;

vec4 circ(vec4 screen, vec2 fc, float ang) {

    float aspect = g_windowWidth/g_windowHeight;

    fc = 2.0*fc-vec2(1.0);
    fc.x *= aspect;
    float circ = sqrt(dot(fc,fc))/radius;

    float am = clamp(1.0-clamp((circ-1.0), 0.0, 1.0)*g_windowWidth*0.5, 0.0, 1.0);

    //float persu = perlin(vec3(fc*10.0, g_time*0.30))*3.0*circ;
    float seg0 = floor(circ*segments*0.7+g_time);
    float persu = 0.50*perlin(vec3(floor(atan(fc.y/fc.x)*8.0+seg0), 0.5, g_time*0.20));

     //circ += perlin(vec3(fc*10.0, g_time*0.30))*1.10*circ;
    //circ += floor(persu*32.0);
    //circ += turb(vec3(fc*3.0, g_time*1.10))*0.20;
    circ *= segments;

   // circ = pow(circ, -0.50);


    float seg = floor(circ+persu*0.0);
   // seg = circ+persu;

    //float seg = circ+persu*0.50;

    //circ = fract(circ);

    vec2 fci = gl_FragCoord.xy/vec2(g_windowWidth, g_windowHeight);
    fci.y = 1.0-fci.y;
    fci = fci-vec2(0.5);
    fci *= imageScale/radius;
    fci.x *= aspect;

    float segAmp = 1.0;

    vec2 fcb = fc;
    fcb *= 2.0*(1.0+circ*0.01);

    fci = rotateXY2(fci, (perlin(vec3(seg+ang, 0.5, 0.5)*1.0)*ang*0.5*3.141592));
    //fci = rotateXY2(fci, (perlin(vec3(seg+ang, fcb.x, fcb.y)*1.0+1.0)*ang*0.5*3.141592));
    //fci = rotateXY2(fci, (perlin(vec3(seg+ang+g_time, fcb.x, fcb.y)*1.0)*ang*0.5*3.141592));
    fci.x /= aspect;
    fci = fci+vec2(0.5);
    fci = clamp(fci, 0.0, 1.0);
    vec4 img = texture2D(texImg, fci);

    img = vec4(1.0)-img;

    am *= dot(img, img);
    am *= bright;

    screen.rgb = screen.rgb*(1.0-am)+img.rgb*am;
    return screen;
}

void main() {

    vec2 uvS = uv;
    uvS.y = 1.0-uvS.y;


    vec2 vc = gl_FragCoord.xy;
    vec2 vco = vc;

    vec2 ts = textureSize(tex, 0);

    vc -= ts*0.5;

    vc /= pixelSize;
    vc = vec2(ivec2(vc)*pixelSize);

    vc += ts*0.5;


    vec2 fc = gl_FragCoord.xy/vec2(g_windowWidth, g_windowHeight);

    vec4 screen = texture2D(tex, fc);


    vec4 screenMix = vec4(0.0);

    int motions = 32;

    float r2 = 8.0/float(motions);
    float r1 = 1.0-r2;
    for (int i=0; i<motions; i++) {
        screenMix += circ(screen, fc, angle+angleDelta*(r1+r2*rand(fc))/16.67f*float(i)/float(motions));
        //screenMix += circ(screen, fc, angle+angleDelta*(r1+r2*rand(fc))*0.1f*float(i)/float(motions));
    }
    screenMix /= float(motions);

    screen.rgb = screenMix.rgb;


    screen.a = 1.0;
    frag = screen;
}

