#version 430



layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


uniform float g_time;
uniform float g_timeStep;

uniform float windowWidth;
uniform float windowHeight;


in vec2 posV[1];
in vec4 colV[1];
in float fadeV[1];

out vec4 col;
out float mask;

uniform float effectWidth;
uniform float effectHeight;

uniform float bright = 1.0;
uniform float maskBright = 1.0;

uniform float drawSize = 1.0;

vec4 vpa[4] = {
    vec4(0.0, 0.0, 0.0, 1.0),
    vec4(1.0, 0.0, 0.0, 1.0),
    vec4(0.0, 1.0, 0.0, 1.0),
    vec4(1.0, 1.0, 0.0, 1.0)
    };

void main(void) {

        vec4 vp;

        if (colV[0].w < 0.5) {
            return;
        }

        float kb = 1.0-fadeV[0];
        //kb *= kb;

        float kok = drawSize*2.0;
        //kok *= (kb*4.0+1.0);


        for (int i=0; i<4; i++) {
            vp = vpa[i];
            vp.xy -= vec2(0.50, 0.50);
            vp.x *= kok/effectWidth;
            vp.y *= kok/effectHeight;
            vp.xy += posV[0];
            gl_Position = vp;
            col.xyz = colV[0].xyz*bright;
            mask = maskBright;
            col.w = 1.0;
            EmitVertex();
        }

        EndPrimitive();
}
