#version 430

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float randCen(vec2 co) {
    return rand(co)-float(0.5);
}

// from pouet raymarching thread by las of mercury
float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.14159265)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z);
}

float turb(vec3 c) {
        float r=0.0;
        float s=0.5;
        c*=1.0;
        for (int i=0;i<6;i++) {
                //if (i<2) continue;
                r+=s*(perlin(c)*1.0+0.0);
                c*=3.0;
                s*=0.75;
        }
        return r;
}


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;
//layout(binding=2) uniform sampler2D texPartPos;
// layout(binding=3) uniform sampler2D texPartPosPrev;


uniform float g_windowWidth;
uniform float g_windowHeight;
uniform float g_time;
uniform float g_timeStep;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float approachOrigSize = -14.0;
uniform float approachRandSize = 0.0;
uniform float approachNoiseFreq = 128.0;
uniform float approachNoiseDist = 0.50;
uniform float approachNoiseDistOfs = 1.0;
uniform float approachNoiseAmp = 0.10;
uniform float approachNoiseSpeed = 0.20;
uniform float approachSpeed = 8.0;

uniform float vaporizeOrigShape = 2.0;
uniform float vaporizeNoiseFreq = 32.0;
uniform float vaporizeNoiseDist = 0.02;
uniform float vaporizeNoiseDistOfs = 2.0;
uniform float vaporizeNoiseAmp = 2.0;
uniform float vaporizeNoiseSpeed = 2.0;
uniform float vaporizeSpeed = 0.20;

uniform float emitsNum = 32.0;

uniform float emitsSpreadAmp = 0.1;
uniform float emitsSpread = 1.0;
uniform float emitsSpreadFade = 0.2;
uniform float emitsSpreadUV = 0.5;


uniform float ptw = 2048.0;
uniform float pth = 2048.0;

layout(binding=0, offset=0) uniform atomic_uint ac_next_free;
layout(binding=0, rgba32f) uniform image2D partorPos;
layout(binding=1, rgba32f) uniform image2D partorUVS;

void main() {

    vec2 uvs = gl_FragCoord.xy/vec2(effectWidth, effectHeight);

    ivec2 tcp = ivec2(gl_FragCoord.xy);
    ivec2 tc = ivec2(uvs*vec2(g_windowWidth, g_windowHeight));

    vec2 tcs = uvs;
    vec4 cur = texture2D(tex, tcs);
    vec4 prev = texture2D(texPrev, tcs);


    vec2 s = uvs*2.0-vec2(1.0);

    //vec4 pi = texelFetch(texPartPos, tcp, 0);
    //vec2 pp = pi.xy;

    vec4 pi = vec4(0.0);
    vec2 pp = vec2(0.0);
    vec4 pe = vec4(1.0);

    // if ((pi.z<0.01 || pi.z>2.50) && cur.r > 0.01) {


    if (cur.r > 0.5 && prev.r < 0.1) {
        // emit new

        float samplos = emitsNum;

        for (int i=0; i<int(samplos); i++) {
            pp = s;
            pp.xy *= approachOrigSize;
            float rr = approachRandSize;
            pp.x += rr*randCen(uvs*10.0+vec2(g_time, g_time*1.23));
            pp.y += rr*randCen(uvs*10.0+vec2(g_time+0.5, g_time*1.23+7.77));

            float fi = float(i);

            vec2 randu;
            randu.x = randCen(uvs*3.0+vec2(g_time, g_time*1.23)+vec2(0.70, 1.57)*fi*emitsSpread);
            randu.y = randCen(uvs*3.0+vec2(g_time+0.5, g_time*1.23+7.77)+vec2(0.630, 1.157)*fi*emitsSpread);

            //pp.xy *= 0.0;


            float ri = emitsSpreadAmp;
            // ri = (fi/samplos+0.1)*ri;
            pp.x += randu.x*ri;
            pp.y += randu.y*ri;

            pi.z = 0.011+emitsSpreadFade*rand(uvs*40.0+vec2(1.83, 2.34)*(fi+g_time));

            int emitNumber = int(atomicCounterIncrement(ac_next_free));

            emitNumber = emitNumber&(int(ptw)*int(pth)-1);

            int ey = emitNumber/int(ptw);
            int ex = emitNumber&(int(ptw)-1);

            pe.xy = pp.xy;
            pe.z = pi.z;

            imageStore(partorPos, ivec2(ex,ey), pe);

            uvs.xy += emitsSpreadUV*randu.xy*vec2(0.50/effectWidth, 0.50/effectHeight);

            imageStore(partorUVS, ivec2(ex,ey), vec4(uvs, 0.0, 0.0));
        }
    }
/*
    pe.xyz = vec3(0.0);
    for (int i=0; i<1000; i++) {
    int ex = 0+i;
    int ey = 100;

    imageStore(partorPos, ivec2(ex,ey), pe);
    }
*/
    frag = vec4(1.0);
    //return;
}

