#version 430

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float randCen(vec2 co) {
    return rand(co)-float(0.5);
}

// from pouet raymarching thread by las of mercury
float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.14159265)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z);
}

float turb(vec3 c) {
        float r=0.0;
        float s=0.5;
        c*=1.0;
        for (int i=0;i<6;i++) {
                //if (i<2) continue;
                r+=s*(perlin(c)*1.0+0.0);
                c*=3.0;
                s*=0.75;
        }
        return r;
}


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;


layout(binding=0, rgba32f) uniform image2D partorPos;
layout(binding=1, rgba32f) uniform image2D partorSUV;


uniform float g_windowWidth;
uniform float g_windowHeight;
uniform float g_time;
uniform float g_timeStep;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float approachOrigSize = -14.0;
uniform float approachRandSize = 0.0;
uniform float approachNoiseFreq = 128.0;
uniform float approachNoiseDist = 0.50;
uniform float approachNoiseDistOfs = 1.0;
uniform float approachNoiseAmp = 0.10;
uniform float approachNoiseSpeed = 0.20;
uniform float approachSpeed = 8.0;

uniform float vaporizeOrigShape = 2.0;
uniform float vaporizeNoiseFreq = 32.0;
uniform float vaporizeNoiseDist = 0.02;
uniform float vaporizeNoiseDistOfs = 2.0;
uniform float vaporizeNoiseAmp = 2.0;
uniform float vaporizeNoiseSpeed = 2.0;
uniform float vaporizeSpeed = 0.20;


void main() {

    ivec2 tcp = ivec2(gl_FragCoord.xy);
    vec4 suv = imageLoad(partorSUV, tcp);
    vec2 tcs = suv.xy;
    vec2 uvs = tcs;
    vec4 cur = texture2D(tex, tcs);
    vec4 prev = texture2D(texPrev, tcs);


    vec2 s = uvs*2.0-vec2(1.0);

    vec4 pi = imageLoad(partorPos, tcp);
    vec2 pp = pi.xy;


    //if (cur.r < 0.01 && prev.r > 0.5) {
    if (cur.r < 0.2 && pi.z <= 1.0 && pi.z >= 0.01) {
        pi.z = 2.0;
    }

    if (pi.z >= 2.0) {
        pi.z += g_timeStep*1.0;
        //if (pi.z > 3.0) pi.z = 0.011;
        if (pi.z > 3.0) pi.z = 0.0;
    } else if (pi.z >= 0.01) {
        pi.z += g_timeStep*1.0;
        if (pi.z >= cur.r) pi.z = cur.r;
    }
    // pi.z = 0.0;


    vec2 so = s;
    vec2 pd = s-pp;
    float d = 1.0;

    vec2 sd = vec2(1.5, 1.23);

    float fr = 1.0;

    float v = 1.0;

    if (pi.z < 2.0) {
        // approaching
        fr = approachNoiseFreq;

        float kallu = 1.0;

        kallu = max(pi.z, 0.0);
        //kallu = min(1.0, max(1.0-dot(pd,pd)*20.0, 0));

        d = approachNoiseAmp*max(1.0-kallu/approachNoiseDist+approachNoiseDistOfs, 0.0); // 1.0*min(max(dot(pd,pd)*2.0-0.10, 0.0), 10.0);
        s += d*vec2(turb(vec3(so*fr, g_time*approachNoiseSpeed)), turb(vec3(so*fr+sd, g_time*approachNoiseSpeed)));
        v = approachSpeed;
    } else if (pi.z >= 2.0) {
        // going away
        s += so*vaporizeOrigShape;
        fr = vaporizeNoiseFreq;
        d = vaporizeNoiseAmp*min(max(0.0-dot(pd,pd)/vaporizeNoiseDist+vaporizeNoiseDistOfs, 0.0), 10.0);
        s += d*vec2(turb(vec3(so*fr, g_time*vaporizeNoiseSpeed)), turb(vec3(so*fr+sd, g_time*vaporizeNoiseSpeed)));
        v = vaporizeSpeed;
    }

    pd = s-pp;


    pp += min(0.5, max(0.0, g_timeStep*v))*pd;

    vec4 result = vec4(1.0);

    result.xy = pp;

    result.z = pi.z;

    imageStore(partorPos, tcp, result);

    frag = result;
}

