#version 430

// layout (location=0) in vec3 vertexPosition;

layout(binding=0) uniform sampler2D texPartPos;
layout(binding=1) uniform sampler2D texPartCol;

out vec2 uv;
out vec4 col;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float g_time;

uniform float effectWidth;
uniform float effectHeight;

void main() {
  vec4 vp = vec4(0.0);

  float id = float(gl_VertexID);

  float idq = floor((id/6.0-fract(id/6.0))+0.5); // quad index

  float idv = floor((id/3.0)); // triangle index 0,1,2,3,...
  int idt = int(idv);
  float id3 = fract(id/3.0)*3.0; // index of the vertex in a triangle 0,1,2
  if ((idt&1)==0) {
    if (id3 < 0.50) {
        vp = vec4(0.0, 0.0, 0.0, 1.0);
    } else if (id3 < 1.5) {
        vp = vec4(1.0, 0.0, 0.0, 1.0);
    } else if (id3 < 2.5) {
        vp = vec4(1.0, 1.0, 0.0, 1.0);
    }
  } else {
    if (id3 < 0.50) {
        vp = vec4(0.0, 0.0, 0.0, 1.0);
    } else if (id3 < 1.5) {
        vp = vec4(1.0, 1.0, 0.0, 1.0);
    } else if (id3 < 2.5) {
        vp = vec4(0.0, 1.0, 0.0, 1.0);
    }
  }
  vp.xy -= vec2(0.50);

  vp.x *= 2.0/effectWidth;
  vp.y *= 2.0/effectHeight;

  //vp *= 0.0;


 // vp.x += idv*0.11;
//  vp.x += sin(idv*0.1);
//  vp.y += cos(idv*0.112);

  vec2 fpt;
  ivec2 pt;
  fpt.y = floor(idq/effectWidth);
  fpt.x = idq-fpt.y*effectWidth;
  pt = ivec2(fpt);

  vec4 pp = texelFetch(texPartPos, pt, 0);
  vec4 pc = texelFetch(texPartCol, pt, 0);
  //vec4 pp = texture2D(tex, fpt/vec2(effectWidth, effectHeight));

  vp.xy += pp.xy*1.0+0.0*(fpt.xy/effectWidth*2.0-vec2(1.0));

  if (pp.z < 0.01) vp.xy*=0.0;

  float fd = 1.0;
  if (pp.z > 2.0) {
    fd = 1.0-min(pp.z-2.0, 1.0);
    fd *= fd;
  } else if (pp.z > 0.0) {
    fd = pp.z;
    fd *= fd;
  }

  vp.xy *= 1.0;

  gl_Position = vp;
  uv = vec2(0.0);

  col = vec4(1.0)*fd;
}
