#version 430



layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


uniform float g_time;
uniform float g_timeStep;

uniform float windowWidth;
uniform float windowHeight;


in vec2 posV[1];
in vec4 colV[1];

out vec4 col;

uniform float effectWidth;
uniform float effectHeight;

vec4 vpa[4] = {
    vec4(0.0, 0.0, 0.0, 1.0),
    vec4(1.0, 0.0, 0.0, 1.0),
    vec4(0.0, 1.0, 0.0, 1.0),
    vec4(1.0, 1.0, 0.0, 1.0)
    };

void main(void) {

        vec4 vp;

        if (colV[0].w < 0.5) {
            return;
        }

        float kb = 1.0-colV[0].z;
        //kb *= kb;
        // float kok = (kb*8.0+2.0);
        float kok = 4.0;

        for (int i=0; i<4; i++) {
            vp = vpa[i];
            vp.xy -= vec2(0.50, 0.50);
            vp.x *= kok/effectWidth;
            vp.y *= kok/effectHeight;
            vp.xy += posV[0];
            gl_Position = vp;
            col.xyz = vec3(colV[0].x)*1.0;
            col.w = 1.0;
            EmitVertex();
        }

        EndPrimitive();
}
