import QtQuick 2.3
import QtQuick.Window 2.2

import SystemTime 1.0

import Qt.labs.settings 1.0

import AdaptDemoSystem 1.0

DemoRoot {
    id: root
    visible: true
    width: windowWidth
    height: windowHeight
    focus: true

    property bool bReleaseVer: true
    property string loaderImageFile: "../images/system/loader.png"
    property real exitDemoTime: 253.0
    property bool bExitDemo: true
    // property int demoStartRow: 0
    property int demoStartRow: 0

    property bool demoIsLoaded: false
    signal demoLoaded();
    signal startLoading();

    // not used in release version, but declared to avoid internal errors
    signal rocketTrackFocused(string trackName, string trackValue);
    signal rocketFocusedTrackValueChanged(string trackName, string trackValue);
    signal focusedToEffectBaseName(string effectBaseName);

    property bool bEnableCoordsAxis: true
    property bool bEnableCoordsPlaneXY: true
    property bool bEnableCoordsPlaneXZ: true
    property bool bEnableCoordsPlaneYZ: true

    property bool bShowingSubTool: false

    property var fxInstancesPerType

    signal keyLeft()
    signal keyRight()
    signal keyUp()
    signal keyDown()

    signal keyR()
    signal keyC()

    signal keyPressed(int keyCode, bool autoRepeat)
    signal keyReleased(int keyCode)

    signal mouseMove(int mouseX, int mouseY)
    signal mousePress(int mouseX, int mouseY)
    signal mouseRelease(int mouseX, int mouseY)

    signal showEditor()

    signal customTextGroupShowToggled(string groupId)
    function toggleCustomTextGroupShow(groupId) {
        customTextGroupShowToggled(groupId)
        console.log("toggleCustomTextGroupShow", groupId);
    }

    signal customTextSet(string groupId, string textId, string customText)
    function setCustomText(groupId, textId, customText) {
        customTextSet(groupId, textId, customText);
    }

    function getTN(sn) {
        var s = sn;
        var sa = s.split(".");
        if (sa.length > 1) {
            var tn = "";
            for (var i=1; i<sa.length; i++) {
                tn += sa[i];
                if (i !== (sa.length-1)) {
                    tn += ".";
                }
            }
            return tn;
        }
        return "";
    }

    // for storing the fxTemplates/

    property var allEffectTracks
    property var allEffects

    function filterWithEffectName(effectName, syncName) {
        var kp = syncName.toLowerCase();
        var pp = effectName.toLowerCase();

        if (kp.indexOf(pp)===-1) {
            return false;
        }
        return true;
    }

    function addEffectTrack(effectName, tr, defaultValue) {
        if (allEffectTracks===undefined) allEffectTracks = {};

        var track = getTN(tr);

        if (allEffectTracks[effectName+track] !== undefined) {
            return;
        }

        if (!filterWithEffectName(effectName, tr)) {
            return;
        }

        if (allEffects===undefined) allEffects = {};

        allEffectTracks[effectName+track] = {
            en: effectName,
            tr: track,
            dv: defaultValue
        };

        if (allEffects[effectName]===undefined) allEffects[effectName] = {};

        if (defaultValue === undefined) {
            defaultValue = 0.0;
        }

        allEffects[effectName][track] = {
            "default": defaultValue,
            "value": 0.0,
            "keys": [] };

        console.log("Added effect:"+effectName+" track:"+track+ " syncDefault:"+defaultValue)

//        if (demoIsLoaded) {
//            saveEffectTemplatesTimer.start()
//        }
    }

    Filer {
        id: filer

        onFileChanged: {
            console.log("FILER path changed to:"+path)
            if (path.indexOf("fx/demo/") !== -1 ||
                path.indexOf("config") !== -1) {
                initFXParams();
            }
        }
    }


    // for managing the fx parameters

    property var fxParams
    property var paramResolvers: ({})
    property var paramValues: ({})

    property var demoLime
    property var demoBlocks
    property var previousLoadedMusic

    property var demoBlocksTimes

    function fxFromTL(ef, p) {
        if (p.indexOf("demo.") === 0) {
            p = p.slice(5);
        }

        //   console.log("checking fxFromTL for:"+p);
        if (fxParams[p] !== undefined) {
            //console.log("checked YES fxFromTL for:"+p);
            return true;
        }
        //console.log("checked NO fxFromTL for:"+p);
        return false;
    }

    function fxParam(p) {

        if (p.indexOf("demo.") === 0) {
            p = p.slice(5);
        }

        var keys = fxParams[p];
        return keys;
    }

    Connections {
        target: demoLoader.item
        onFrameRendered: {
            // upd += 0.01;
            var paramNames = Object.keys(fxParams);

            for (var i=0; i<paramNames.length; i++) {
                var pn = paramNames[i];
                var v = getTLParamValue(pn, rocket.time);
                var vo = paramValues[pn];
                paramValues[pn] = v;
                if (vo !== v) {
                    //   console.log("dynamic update of:"+pn)
                    paramResolvers[pn].upd += 0.01;
                }
            }

        }
    }

    function getTLParamValue(p, rt) {
        if (p.indexOf("demo.") === 0) {
            p = p.slice(5);
        }
        var keys = fxParams[p];
        if (keys === undefined) {
            return 0.0;
        }
        for (var i=0; i<keys.length; i++) {
            if (rt < keys[i].time) {
                // current key found
                var ki = i>0 ? i-1 : 0;

                var k = keys[ki];

                if (i===0) {
                    return k.value;
                }

                if (k.int > 0) {
                    var kn = k; // just in case, take next as the current one
                    if (ki<(keys.length-1)) {
                        kn = keys[ki+1];
                    }
                    var dt = kn.time-k.time;
                    var t = (rt-k.time)/dt;
                    var v = k.value;

                    if (k.int === 1) { // linear
                      v = k.value+(kn.value-k.value)*t;
                    } else if (k.int === 2) { // smoothstep
                      v = k.value+(kn.value-k.value)*t*t*(3.0-2.0*t);
                    } else if (k.int === 3) { // ramp
                      v = k.value+(kn.value-k.value)*t*t;
                    } else if (k.int === 4) { // spline
                        var t2 = t*t;
                        var t3 = t*t*t;

                        var knn = kn;
                        if (ki<(keys.length-2)) {
                            knn = keys[ki+2];
                        }
                        var kp = k;
                        if (ki>0) {
                            kp = keys[ki-1];
                        }

                        var tt0;
                        var tt1;

                        var pt0 = k.time;
                        var p0 = k.value;
                        var pt1 = kn.time;
                        var p1 = kn.value;

                        tt0 = kn.time-kp.time;
                        pt0 = kn.value-kp.value;

                        tt1 = knn.time-k.time;
                        pt1 = knn.value-k.value;

                        var ttFract = 1.0/(tt0+tt1);

                        pt0 = pt0*tt1*ttFract;
                        pt1 = pt1*tt0*ttFract;

                        v = ((2.0*t3-3.0*t2+1.0)*p0+(t3-2.0*t2+t)*pt0+(-2.0*t3+3.0*t2)*p1+(t3-t2)*pt1);
                    }

                    // console.log("p:"+p+"  time:"+t+" dt:"+dt+" rt:"+rt+" v:"+v)

                    return v;
                } else {
                    // console.log("p:"+p+"  time:"+t+" v:"+v)
                    return k.value; // step
                }
            }
        }
        return keys[keys.length-1].value;
    }


    Component {
        // resolve value of Time Limer parameter, update signalled on change of value
        id: paramResolver
        Item {
            property real upd: 0.0
            function resolveParam(p, rt) {
                return paramValues[p];
            }
        }
    }

    function fxV(p) {
        var rt = rocket.time;
        if (p.indexOf("demo.") === 0) {
            p = p.slice(5);
        }
        return paramResolvers[p].resolveParam(p, rt)+paramResolvers[p].upd*0.0;
    }

    signal reloadEffects();

    property string timeLimeFile: "fx/demo/demo.atl.json"
    property string demoConfigFile: "config.json"

    property var demoConfig



    function initFXParams() {

        var demoConfigText = filer.getFileText(demoConfigFile);
        if (demoConfigText !== "") {
//            if (demoConfig === undefined) {
//                filer.addWatchPath(demoConfigFile);
//            }
            demoConfig = JSON.parse(demoConfigText);
            if (demoConfig && demoConfig.timeLimeFile) {
                timeLimeFile = demoConfig.timeLimeFile;
            }
        }

        if (fxParams === undefined) {
            filer.addWatchPath(demoConfigFile);
//            filer.addWatchPath(timeLimeFile);
        }
        var fxParamsNew = {};

        var demoJSON = filer.getFileText(timeLimeFile);


        var pDemoBlocks = [];
        var bi=0;
        if (demoBlocks !== undefined) {
            for (bi=0; bi<demoBlocks.length; bi++) {
                pDemoBlocks.push(demoBlocks[bi]);
            }
        }

        demoLime = JSON.parse(demoJSON);

        var musicFile = "music.mp3";

        // version conversions
        if (demoLime.version === undefined) { // version 0.0
            demoBlocks = demoLime;
        } else {
            demoBlocks = demoLime.effects;
            musicFile = demoLime.music;
        }

        if (previousLoadedMusic !== musicFile) {
            previousLoadedMusic = musicFile;
            rocket.loadSong(musicFile);
        }

        demoBlocks = demoBlocks.sort(function(a, b) { return a.layer-b.layer });

        console.log("DEMO FX BLOCKS ARE:")
        for (bi=0; bi<demoBlocks.length; bi++) {
            console.log(demoBlocks[bi].id+" layer:"+demoBlocks[bi].layer)
            var fxi = demoBlocks[bi];
            var paramsNames = Object.keys(fxi.params);
            for (var i=0; i<paramsNames.length; i++) {
                var fxp = {
                    name: fxi.id+"."+paramsNames[i],
                    keys: fxi.params[paramsNames[i]].keys
                };

                if (fxp.keys.length === 0) {
                    fxp.keys[0] = {time: 0.0, value:fxi.params[paramsNames[i]].value, int: 0 };
                }

                if (paramResolvers[fxp.name] === undefined) {
                    paramResolvers[fxp.name] = paramResolver.createObject(root);
                }

                fxParamsNew[fxp.name] = fxp.keys;
            }
        }

        var demoBlocksChanged = false;

        demoBlocksTimes = {};

        if (demoBlocks.length !== pDemoBlocks.length) {
            demoBlocksChanged = true
        } else {
            for (bi=0; bi<demoBlocks.length; bi++) {
                if (demoBlocks[bi].layer !== pDemoBlocks[bi].layer) {
                    demoBlocksChanged = true;
                    break;
                }
                if (demoBlocks[bi].id !== pDemoBlocks[bi].id) {
                    demoBlocksChanged = true;
                    break;
                }
//                if (demoBlocks[bi].startTime !== pDemoBlocks[bi].startTime) {
//                    demoBlocksChanged = true;
//                    break;
//                }
//                if (demoBlocks[bi].startTime !== pDemoBlocks[bi].startTime) {
//                    demoBlocksChanged = true;
//                    break;
//                }
            }
        }

        for (bi=0; bi<demoBlocks.length; bi++) {
            demoBlocksTimes[demoBlocks[bi].id] = { st: demoBlocks[bi].startTime, et: demoBlocks[bi].endTime };
        }


        fxParams = fxParamsNew;

        console.log("FXPARAMS ARE:"+JSON.stringify(fxParams));




        // if (demoLoader.source === "") {
        console.log("LATAA DEMO")

        if (demoLoader.source !== "" && demoLoader.item && demoLoader.status === Loader.Ready) {
            console.log("RELOAD DEMO")
            if (demoBlocksChanged) {
                reloadEffects();
            }
        } else {
            demoSkenesLoader.start();
        }

        rocket.markUpdateFrequent();

    }


    Rocket {
        id: rocket
        onMeshesPreloaded: {
            demoDelayedReady.start();
        }
    }

    property real time: 0.0

    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }

    Timer {
        id: timeLinerLoader
        interval: 20
        repeat: false
        running: true
        onTriggered: {
            initFXParams();
        }
    }

    Timer {
        id: demoSkenesLoader
        interval: 500
        repeat: false
        onTriggered: {
            //demoLoader.sourceComponent = demo
            console.log("demo skenes loading now")
            demoLoader.source = "Skenes.qml"
            //  reloadDemo();
        }
    }

    Timer {
        id: delayedSetDemoLoaderSource
        interval: 200
        running: false
        repeat: false
        onTriggered: {
            demoLoader.source = "Skenes.qml";
        }
    }

    Connections {
        target: demoLoader.item
        onFileMissing: {
            console.log("QML received file not found:"+fName+" skene:"+sName);
        }
    }

    Timer {
        id: demoDelayedReady
        interval: 2000
        repeat: false
        onTriggered: {
            loaderImageMain.visible = false;
            demoIsLoaded = true;
            rocket.markDemoLoaded();
            demoLoaded();

          //  loaderImage.visible = false;
        }
    }

    MeshLoadList {
        id: meshLoad
    }

    Loader {
        id: demoLoader
        anchors.fill: parent
        asynchronous: true
        onStatusChanged: {
            if (demoLoader.status === Loader.Ready) {
                console.log("xxxxxxxxxxxxxxx DEMO LOADER is ready xxxxxxxxxxxxxxxx")

                var meshIndex = 0;
                for (meshIndex=0; meshIndex < meshLoad.list.length; meshIndex++) {
                    console.log("preloading mesh:"+meshIndex, meshLoad.list[meshIndex]["file"]);
                    var file2 = meshLoad.list[meshIndex]["file2"];
                    rocket.preLoadMesh("mesh/"+meshLoad.list[meshIndex]["file"],
                                       file2 !== undefined ? "mesh/"+file2 : "",
                                                             meshLoad.list[meshIndex]["smoothNormals"]===true,
                                                             meshLoad.list[meshIndex]["normalSmoothAngle"],
                                                             meshLoad.list[meshIndex]["flipNormals"]===true,
                                                             meshLoad.list[meshIndex]["autoCenter"]===true,
                                                             meshLoad.list[meshIndex]["autoScale"]===true,
                                                             meshLoad.list[meshIndex]["halfFloats"]===true,
                                                             meshLoad.list[meshIndex]["meshTexture"]===true);
                }


                if (demoStartRow >= 0) {
                    rocket.setDemoStartRow(demoStartRow);
                }
                demoDelayedReady.start();
            }
        }
    }

    Timer {
        interval: 200
        repeat: true
        running: true
        onTriggered: {
            if (rocket.getTime() > exitDemoTime && (rocket.getTime() > 0.0) && (rocket.getTime() < 10000.0) && bExitDemo) {
                rocket.exitDemo();
            }
        }
    }
    Item {
        id: loaderImageMain
        anchors.fill: parent
        Image {
            anchors.fill: parent
            source: loaderImageFile
        }
    }
    Keys.onEscapePressed: {
        rocket.exitDemo();
    }

    Keys.onReleased: {
        keyReleased(event.key);
    }

    Keys.onPressed: {
    }

}
