"use strict";

class Scene2Controller extends BaseSceneController {

    _tim;
    _bubble;
    _computer;
    _startScale;

    initialize() {   
        var tim = this.spriteManager.get("tim");
        this._startScale = tim.scale.x;
        this.scene.add(tim);
        this._tim = tim;

        var computer = this.spriteManager.get("computer");
        computer.scale.setScalar(4);
        computer.position.set(2.8, 9999, 0);
        this.scene.add(computer);
        this._computer = computer;

        var bubble = this.spriteManager.get("grrr1");
        this.scene.add(bubble);
        bubble.scale.setScalar(1.1);
        bubble.position.set(0, 9999, 0);
        this._bubble = bubble;


        this.showText("his name was Angry Tim");
    }

    update(time) {
        var targetScale = 1.1;
        var scale = this._startScale + time * (targetScale - this._startScale) / 300;
        if (scale < targetScale)
          scale = targetScale;
        this._tim.scale.setScalar(scale);

        if (time >= 300) {
            this._bubble.position.set(-1.4, 0.8, 0);
            this._computer.position.set(2.8, -0.1, 0);
        }
    }

    clear() {

    }
}