"use strict";

class Scene4Controller extends BaseSceneController {

    _lavaSize = 0;
    _lavaUniforms = {};
    _lavaHeight;
    _tim;

    initialize() {
        this.showText("to see if he could swim");

        var lavaMaterial = this.materialManager.get("lava");
        this._lavaUniforms = lavaMaterial.uniforms;
        this._lavaUniforms["time"] = { value: 1.0 };
        this._lavaUniforms["texture1"] = { value: this.textureManager.get("noise") };
        this._lavaUniforms["texture2"] = { value: this.textureManager.get("lava") };

        var lavaWidth = this.getVisibleWidth(-0.0001);
        this._lavaHeight = this.getVisibleHeight(-0.0001);
        this._lavaSize = Math.max(lavaWidth, this._lavaHeight);
        var lava = new THREE.Mesh(new THREE.PlaneGeometry(this._lavaSize, this._lavaSize), lavaMaterial);
        lava.position.set(0, 0, -0.0001);
        this._startPosition = lava.position;
        this._lava = lava;
        this.scene.add(lava);

        var tim = this.spriteManager.get("tim");
        tim.children[0].material.rotation = 3.5;
        tim.position.set(1, this.getVisibleHeight() / 2 + 2, -0.0002);
        this.scene.add(tim);
        this._tim = tim;

        var textBalloon = this.spriteManager.get("grrr2");
        textBalloon.position.set(2, 0.1, 0);
        tim.add(textBalloon);
    }

    update(localTime, globalTime) {
        this._lavaUniforms["time"].value = globalTime / 1000;

        var targetPosition = new THREE.Vector3(0, - 0.5 * this._lavaSize - 0.3 * this._lavaHeight, -0.0001);
        var position = this._startPosition.clone().lerp(targetPosition, Math.min(localTime / 300, 1));
        this._lava.position.copy(position);

        this._tim.position.add(new THREE.Vector3(0, -0.1, 0));

    }
}