{Ŀ}
{  IVS_VGA .PAS - VGA Driver Unit                                         }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{$INCLUDE IVS_SET.INC}
{$ASMMODE INTEL}
{$MODE FPC}

{$HINTS OFF} {  Enable this, if you modify the sources!  }
{$NOTES OFF} {  Enable this, if you modify the sources!  }

Unit IVS_VGA;

Interface

Uses IVS_Var, {  The system variables and types  }
     CRT,     {  CRT unit for switching back to the correct textmode  }
     GO32;    {  The GO32 unit, because it's a DOS only driver  }

Const IVS_VGAVersionStr = '1.0.2';
      IVS_VGAVersion    = $102;

      IVS_VGAName     = 'VGA Driver';
      IVS_VGALongName = 'VGA Compatible Device Driver';

Var IVS_VGADevice : IVS_TVideoDevice; {  VGA Device Structure  }
    IVS_VGADriver : IVS_TVideoDriver; {  VGA Device Driver  }

Procedure IVS_VGADevInit; {  Inits the VGA driver structures  }

Implementation

{  >>> F O R W A R D  D E C L A R A T I O N S <<<  }

Procedure VGA_CopyGray; Forward;
Procedure VGA_CopyOptimal; Forward;
Procedure VGA_CopyFake; Forward;


{  >>> V I D E O  M O D E  S T R U C T U R E S <<<  }

Const VGA_DevModeList : Array[0..2] Of IVS_TVideoMode = (
      {  320x200/8bit grayscale  }
          (VMWidth  :320; VMHeight  :200;
           VMBFWidth:320; VMBFHeight:200;
           VMColours:256; VMBPP:8;
           VMName:'grayscale';
           VMMode:$13;
           VMDoubleBuf:IVS_VMNotSupport;
           VMVSync    :IVS_VMNotSupport;
           VMAvailable:True;
           VMCopy_Banked:(CP_Normal  :@IVS_DummyProc;
                          CP_Scaled  :@IVS_DummyProc;
                          CP_Laced   :@IVS_DummyProc;
                          CP_Bilinear:@IVS_DummyProc);
           VMCopy_Linear:(CP_Normal  :@VGA_CopyGray;
                          CP_Scaled  :@IVS_DummyProc;
                          CP_Laced   :@IVS_DummyProc;
                          CP_Bilinear:@IVS_DummyProc)),
      {  320x200/8bit optimalpalette  }
          (VMWidth  :320; VMHeight  :200;
           VMBFWidth:320; VMBFHeight:200;
           VMColours:256; VMBPP:8;
           VMName:'optimal palette';
           VMMode:$13;
           VMDoubleBuf:IVS_VMNotSupport;
           VMVSync    :IVS_VMNotSupport;
           VMAvailable:True;
           VMCopy_Banked:(CP_Normal  :@IVS_DummyProc;
                          CP_Scaled  :@IVS_DummyProc;
                          CP_Laced   :@IVS_DummyProc;
                          CP_Bilinear:@IVS_DummyProc);
           VMCopy_Linear:(CP_Normal  :@VGA_CopyOptimal;
                          CP_Scaled  :@IVS_DummyProc;
                          CP_Laced   :@IVS_DummyProc;
                          CP_Bilinear:@IVS_DummyProc)),
      {  320x400/12bit fake hicolor  }
          (VMWidth  :320;  VMHeight  :400;
           VMBFWidth:320;  VMBFHeight:200;
           VMColours:4096; VMBPP:12;
           VMName:'faked hicolor';
           VMMode:$13;
           VMDoubleBuf:IVS_VMNotSupport;
           VMVSync    :IVS_VMSupport;
           VMAvailable:True;
           VMCopy_Banked:(CP_Normal  :@VGA_CopyFake;
                          CP_Scaled  :@IVS_DummyProc;
                          CP_Laced   :@IVS_DummyProc;
                          CP_Bilinear:@IVS_DummyProc);
           VMCopy_Linear:(CP_Normal  :@IVS_DummyProc;
                          CP_Scaled  :@IVS_DummyProc;
                          CP_Laced   :@IVS_DummyProc;
                          CP_Bilinear:@IVS_DummyProc)));

Var VGA_SegA000     : Word; {  Descriptor to $A000 segment  }
    VGA_CurrentMode : Word; {  Current mode number. $FFFF = no mode.  }

{  >>> I N T E R N A L  F U N C T I O N S <<<  }

{  Returns true, if VGA hardware is present.  }
{  I tested it on my VGA and on an MDA adapter, it seems to work...  }
Function VGA_HWDetect : Boolean;
Var RealRegs : TRealRegs;
Begin
 With RealRegs Do Begin
   AH:=$12;
   AL:=$00;
   BL:=$36;
   RealIntr($10,RealRegs);
   VGA_HWDetect:=(AL<>12);
  End;
End;

{  Allocates a descriptor to $A000. This allows access to the VGA screen.  }
Procedure VGA_AllocVGASegment;
Begin
 {  If descriptor ID<>0 then descriptor already allocated, so it's not  }
 {  needed to allocate it.  }
 If VGA_SegA000<>0 Then Exit;

 {  Allocate a descriptor in the Local Descriptor Table.  }
 VGA_SegA000:=Allocate_LDT_Descriptors(1);
 {  Now, we map the allocated descriptor to the VGA memory, by setting  }
 {  segment begin address to $A0000 (linear address).  }
 Set_Segment_Base_Address(VGA_SegA000,$A000 Shl 4);
 {  Finally, we set segment size to 64K. (VGA has banked access only).  }
 Set_Segment_Limit(VGA_SegA000,$FFFF);
End;

{  Frees up the descriptor allocated with the VGA_AllocVGASegment proc.  }
Procedure VGA_FreeVGASegment;
Begin
 {  If descriptor ID=0 then descriptor not allocated, so nothing to do.  }
 If VGA_SegA000=0 Then Exit;

 {  Now, we simply free up the descriptor.  }
 Free_LDT_Descriptor(VGA_SegA000);
 VGA_SegA000:=0;
End;

{  Switches on VGA mode 13h. (320x200/8bits)  }
Procedure VGA_SwitchMode13h;
Var RealRegs : TRealRegs;
Begin
 RealRegs.AX:=$13;
 RealIntr($10,RealRegs);
End;

{  Switches back to textmode 03h.  }
Procedure VGA_SwitchMode03h;
Var RealRegs : TRealRegs;
Begin
 RealRegs.AX:=$03;
 RealIntr($10,RealRegs);
End;

{  Sets the values of a VGA palette register  }
Procedure VGA_SetRGBPalette(Color : Byte; R,G,B : Byte); Assembler;
Asm
 MOV DX,$03C8; MOV AL,Color; OUT DX,AL; INC DX
 MOV AL,R; OUT DX,AL
 MOV AL,G; OUT DX,AL
 MOV AL,B; OUT DX,AL
End;

{  >>> B A C K B U F F E R  T O  S C R E E N  C O P Y  F U N C T I O N S <<<  }

{  >>> GRAYSCALE <<<  }

Procedure VGA_CopyGray; Assembler;
{  Code by Charlie/iNQ  }
Asm
 PUSH ES
 MOV  ESI,IVS_VirtualScreen
 XOR  EDI,EDI
 MOV  ES,VGA_SegA000
 MOV  ECX,16000
 @StartCopyLoop:
  {  First Pixel  }
  MOV   EAX,[ESI]
  SHR   AH,1  {Green}
  SHR   AL,3  {Blue}
  ADD   AH,AL
  ROR   EAX,8
  SHR   AH,2  {Red}
  ADD   AL,AH
  MOV   DL,AL
  {  Second Pixel  }
  MOV   EAX,[ESI+4]
  SHR   AH,1  {Green}
  SHR   AL,3  {Blue}
  ADD   AH,AL
  ROR   EAX,8
  SHR   AH,2  {Red}
  ADD   AL,AH
  MOV   DH,AL
  ROR   EDX,16
  {  Third Pixel  }
  MOV   EAX,[ESI+8]
  SHR   AH,1  {Green}
  SHR   AL,3  {Blue}
  ADD   AH,AL
  ROR   EAX,8
  SHR   AH,2  {Red}
  ADD   AL,AH
  MOV   DL,AL
  {  Fourth Pixel  }
  MOV   EAX,[ESI+12]
  SHR   AH,1  {Green}
  SHR   AL,3  {Blue}
  ADD   AH,AL
  ROR   EAX,8
  SHR   AH,2  {Red}
  ADD   AL,AH
  MOV   DH,AL
  {  Moving VGA Pixel into video RAM  }
  MOV   EAX,EDX
  ROR   EAX,16
  STOSD
  ADD   ESI,16
 LOOP @StartCopyLoop
 POP  ES
End;

{  >>> OPTIMAL PALETTE <<<  }

Procedure VGA_CopyOptimal; Assembler;
{  Code by Charlie/iNQ  }
Asm
 PUSH ES
 MOV  ESI,IVS_VirtualScreen
 XOR  EDI,EDI
 MOV  ES,VGA_SegA000
 MOV  ECX,16000
 @StartCopyLoop:
  {  First Pixel  }
  MOV   EAX,[ESI]
  ROR   EAX,8
  SHR   AH,5
  SHR   AX,5
  ROL   EAX,2
  MOV   BX,AX
  {  Second Pixel  }
  MOV   EAX,[ESI+4]
  ROR   EAX,8
  SHR   AH,5
  SHR   AX,5
  ROL   EAX,2
  SHL   AX,8
  OR    BX,AX
  ROR   EBX,16
  {  Third Pixel  }
  MOV   EAX,[ESI+8]
  ROR   EAX,8
  SHR   AH,5
  SHR   AX,5
  ROL   EAX,2
  MOV   BX,AX
  {  Fourth Pixel  }
  MOV   EAX,[ESI+12]
  ROR   EAX,8
  SHR   AH,5
  SHR   AX,5
  ROL   EAX,2
  SHL   AX,8
  {  Moving VGA Pixel into video RAM  }
  OR    BX,AX
  MOV   EAX,EBX
  ROR   EAX,16
  STOSD
  ADD   ESI,16
 LOOP @StartCopyLoop
 POP  ES
End;

{  >>> FAKED HICOLOR <<<  }

Procedure VGA_CopyFake; Assembler;
{  Code by mrc!/iNQ  }
Var VidMemOffset : Byte;
    ScreenOffset : DWord;
Asm
 PUSH  GS
 MOV   GS,VGA_SegA000

 MOV   DX,$3D4 {  Address Read  }
 MOV   AL,$C
 OUT   DX,AL
 INC   DX
 XOR   EAX,EAX
 IN    AL,DX
 XOR   AL,$7D  {  Flip Address  }

 MOV   VidMemOffset,AL
 SHL   AX,8
 MOV   ScreenOffset,EAX

 {  First Pixel  }
 MOV   ESI,IVS_VirtualScreen
 MOV   EDI,ScreenOffset

 MOV   DX,$3C4
 MOV   AX,$0102
 OUT   DX,AX

 MOV   ECX,200

 @Loop11:
  ROR   ECX,16
  MOV   CX,80

  @Loop12:
   MOV   EAX,[ESI]
   ADD   ESI,16
   MOV   BL,AH
   MOV   AH,AL
   ROR   EAX,8
   SHR   AL,4
   SHR   AH,4
   ADD   AH,240
   AND   BL,240
   ADD   AL,BL
   CMP   AL,240
   JB @OK1
    SUB   AL,16
   @OK1:
   MOV   GS:[EDI],AL
   MOV   GS:[EDI+80],AH
   INC   EDI

   DEC   CX
  JNZ   @Loop12

  ADD   EDI,80

  ROR   ECX,16
  DEC   ECX
 JNZ   @Loop11

 {  Second Pixel  }
 MOV   ESI,IVS_VirtualScreen
 MOV   EDI,ScreenOffset
 ADD   ESI,4

 MOV   AX,$0202
 OUT   DX,AX

 MOV   ECX,200

 @Loop21:
  ROR   ECX,16
  MOV   CX,80

  @Loop22:
   MOV   EAX,[ESI]
   ADD   ESI,16
   MOV   BL,AH
   SHL   AX,8
   ROR   EAX,8
   SHR   AL,4
   SHR   AH,4
   ADD   AH,240
   AND   BL,240
   ADD   AL,BL
   CMP   AL,240
   JB @OK2
    SUB   AL,16
   @OK2:
   MOV   GS:[EDI],AH
   MOV   GS:[EDI+80],AL
   INC   EDI

   DEC   CX
  JNZ   @Loop22

  ADD   EDI,80

  ROR   ECX,16
  DEC   ECX
 JNZ   @Loop21

 {  Third Pixel  }
 MOV   ESI,IVS_VirtualScreen
 MOV   EDI,ScreenOffset
 ADD   ESI,8

 MOV   AX,$0402
 OUT   DX,AX

 MOV   ECX,200

 @Loop31:
  ROR   ECX,16
  MOV   CX,80

  @Loop32:
   MOV   EAX,[ESI]
   ADD   ESI,16
   MOV   BL,AH
   SHL   AX,8
   ROR   EAX,8
   SHR   AL,4
   SHR   AH,4
   ADD   AH,240
   AND   BL,240
   ADD   AL,BL
   CMP   AL,240
   JB @OK3
    SUB   AL,16
   @OK3:
   MOV   GS:[EDI],AL
   MOV   GS:[EDI+80],AH
   INC   EDI

   DEC   CX
  JNZ   @Loop32

  ADD   EDI,80

  ROR   ECX,16
  DEC   ECX
 JNZ   @Loop31

 {  Fourth Pixel  }
 MOV   ESI,IVS_VirtualScreen
 MOV   EDI,ScreenOffset
 ADD   ESI,12

 MOV   AX,$0802
 OUT   DX,AX

 MOV   ECX,200

 @Loop41:
  ROR   ECX,16
  MOV   CX,80

  @Loop42:
   MOV   EAX,[ESI]
   ADD   ESI,16
   MOV   BL,AH
   SHL   AX,8
   ROR   EAX,8
   SHR   AL,4
   SHR   AH,4
   ADD   AH,240
   AND   BL,240
   ADD   AL,BL
   CMP   AL,240
   JB @OK4
    SUB   AL,16
   @OK4:
   MOV   GS:[EDI],AH
   MOV   GS:[EDI+80],AL
   INC   EDI

   DEC   CX
  JNZ   @Loop42

  ADD   EDI,80

  ROR   ECX,16
  DEC   ECX
 JNZ   @Loop41

 {  Vertical Retrace  }
 MOV   DX,$03DA
 @1:
  IN    AL,DX
  TEST  AL,8
 JZ @1
 @2:
  IN    AL,DX
  TEST  AL,8
 JNZ @2

 {  Address Change  }
 MOV   DX,$3D4
 MOV   AL,$C
 MOV   AH,VidMemOffset
 OUT   DX,AX

 POP   GS
End;

{  >>> D E V I C E  D R I V E R  F U N C T I O N S <<<  }

{  This procedure should detect the available mode list, and setup  }
{  the modelist in the device driver record. On VGA, we simply setup the  }
{  modelist, because mode $13 (320x200/8bits) is always available on VGA.  }
Function VGA_Detect : Boolean;
Begin
 VGA_Detect:=False;
 With IVS_VGADevice Do Begin
   If Not DevAvail Then Exit;
   If DevModeNum<>0 Then Begin VGA_Detect:=True; Exit; End;

   {  Setting Modelist  }
   DevModeList:=@VGA_DevModeList;
   DevModeNum:=3;
   DevBestMode:=2;

  End;
 VGA_Detect:=True;
End;

{  Inits the specified videomode  }
Function VGA_Init(ModeNumber : DWord; ModeSetup : IVS_TModeSetup) : Boolean;
Var Counter  : DWord;
    Counter2 : DWord;
Begin
 VGA_Init:=False;
 With IVS_VGADevice Do Begin
   {  Checking if modenumber OK.  }
   If ModeNumber>DevModeNum-1 Then Exit;
   If VGA_CurrentMode<>$FFFF Then Exit;

   {  Video memory area init  }
   VGA_AllocVGASegment;

   {  Switching on videomode  }
   VGA_SwitchMode13h;

   {  Tweak the card if modenumber specifies fakemode  }
   If Modenumber=2 Then
     Asm {  FakeMode Initialization  }
      MOV DX,3D4H;   MOV AX,4009H; OUT DX,AX
      MOV AX,14H;    OUT DX,AX;
      MOV AX,0E317H; OUT DX,AX;
      MOV DX,3C4H;   MOV AX,604H;  OUT DX,AX
      MOV DX,3C4H;   MOV AX,0F02H; OUT DX,AX
     End;

   {  Setting palette & assign copy function  }
   Case ModeNumber Of
     0 : Begin {  Grayscale palette  }
           For Counter:=0 To 255 Do
             VGA_SetRGBPalette(Counter,Counter Shr 2,Counter Shr 2,Counter Shr 2);
           IVS_VGADriver.DrvCopy:=VGA_DevModeList[ModeNumber].VMCopy_Linear.CP_Normal;
          End;
     1 : Begin {  Optimalpalette  }
           For Counter:=0 To 255 Do
             VGA_SetRGBPalette(Counter,(Counter Shr 5)*63 Div 7,
                              (Counter Shr 2 Shl 3),(Counter Shl 4));
           IVS_VGADriver.DrvCopy:=VGA_DevModeList[ModeNumber].VMCopy_Linear.CP_Normal;
          End;
     2 : Begin {  Fakemode  }
           For Counter:=0 To 14 Do
             For Counter2:=0 To 15 Do
               VGA_SetRGBPalette(16*Counter+Counter2,0,Round(Counter*4.5),Round(Counter2*4.2));
           For Counter:=0 To 15 Do VGA_SetRGBPalette(240+Counter,Round(Counter*4.2),0,0);
           IVS_VGADriver.DrvCopy:=VGA_DevModeList[ModeNumber].VMCopy_Banked.CP_Normal;
          End;
    End;

   {  Clearing the video memory area  }
   For Counter:=0 To 63999 Do Begin Mem[$A000:Counter]:=0; End;

  End;
 VGA_CurrentMode:=ModeNumber;
 VGA_Init:=True;
End;

{  Shuts down the current active videomode  }
Function VGA_Close : Boolean;
Begin
 VGA_Close:=False;
 If VGA_CurrentMode=$FFFF Then Exit;

 {  Setting back to textmode  }
 VGA_SwitchMode03h;
 TextMode(LastMode);
 {  Releasing the videomem descriptor  }
 VGA_FreeVGASegment;
 {  Deassign copy function  }
 IVS_VGADriver.DrvCopy:=@IVS_DummyProc;

 VGA_CurrentMode:=$FFFF;
 VGA_Close:=True;
End;

{  >>> I N I T  C O D E <<<  }

{  Inits the VGA driver structures  }
Procedure IVS_VGADevInit;
Begin
 With IVS_VGADriver Do Begin
   DrvDetect:=@VGA_Detect;
   DrvInit  :=@VGA_Init;
   DrvClose :=@VGA_Close;
   DrvCopy  :=@IVS_DummyProc;
  End;
 IVS_VGADevice.DevDriver:=@IVS_VGADriver;

 {$IFDEF _IVS_VGA_DEBUGMODE_}
  WriteLn('DEV_INIT: Device - ',IVS_VGALongName,' version ',IVS_VGAVersionStr);
 {$ENDIF}

 {  Detecting device...  }
 If VGA_HWDetect Then Begin
   With IVS_VGADevice Do Begin
     DevAvail   :=True;
     DevName    :=IVS_VGAName;
     DevDRAM    :=256*1024;
     DevModeNum :=0;
     DevBestMode:=0;
     DevModeList:=Nil;
    End;
  End Else Begin
   IVS_VGADevice.DevAvail:=False;
   {$IFDEF _IVS_VGA_DEBUGMODE_}
    WriteLn('DEV_INIT: Device - VGA DETECTION FAILED!');
   {$ENDIF}
  End;
End;

Begin
 VGA_CurrentMode:=$FFFF;
End.

{  IVS_VGA.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }

{  History:  }
{  1.0.2 - Copyright header changes. [2001.07.02 Charlie]                }
{  1.0.1 - Set VGA segment to zero after it was freed. Without this, it  }
{          cannot be allocated again. [2001.01.17. Charlie]              }
{  1.0.0 - Initial version [2000.08.29. Charlie]                         }
