; FASM

TEXT_WIDTH = 15
TEXT_LINES = 6

FAST_APPEAR = 0                 ; for debug

        org 100h

        ; ax = 0, bx = 0, cx = 0FFh, si = 100h, bp = 9??h, di = sp, word [sp] = 0

        db 4,5,2,9,0E4h,5,2,0,4,5,2,9,4,0C5h,2,7        ; notes: A A# G d A+g A# G ~ A A# G d A A#+f G c
        ; al = undefined, other are unchanged

        ; Video mode, font, text, palette
        mov al,13h
        int 10h                 ; 320x200, 256 color

        mov ax,1122h
        int 10h                 ; set font size 8x14

        xchg ax,bp
        mov dx,text
        int 21h                 ; output text on top left line

        push 0A000h
        pop ds

        mov dx,3C9h
        xor al,al
@@:     out dx,al               ; red = gradient
        out dx,al               ; green = gradient
        outsb                   ; blue = 0
        cmp cl,0C1h
        sbb al,0                ; black for first 64 colors, gradient for next 192 colors
        loop @B

        ; Scale text
next:
        salc
        mov di,bx
        shr di,1
        jc @F
        mov al,[di - (((7-TEXT_LINES)*7+1)*320 + (20-TEXT_WIDTH)*4)]
@@:     mov [bx],al
        dec bx
        jnz next

        ; Text appearance
appear:
        shl byte [bx],4
        in al,60h
        dec ax
        jz exit
if ~ defined FAST_APPEAR | ~ FAST_APPEAR
        test bl,dh
        jnz @F
        mov ah,86h
        int 15h
end if
;@@:     mov al,bh
;        out 61h,al              ; more lite sounds of horror :)
@@:     imul bx,-103            ; interesting sounds on: 125;113;73;53;25;-27;-39;-55;-75;-103;-107;-123
        inc bx
        mov al,bh
        out 61h,al              ; sounds of horror (use this block or above)
        jnz appear

        ; Flashlight
flashlight:
pixel:
        mov ax,0CCCDh
        mul di                  ; dl = X (0..255), dh = Y
        xchg ax,dx
        sub al,ch
@@:     neg al
        jl @B                   ; dl = abs(dl)
        cmp al,48
        jbe @F
        mov al,48
@@:     and byte [di],0C0h
        or [di],al
        inc di
        jnz pixel

        ; Music
        mov dx,330h
        add ch,dh
        test cl,dh
        jnz skip

        and si,10Fh
        mov bl,[es:si]
        inc si
@@:     test bl,bl
        jz skip
        mov ax,3F90h            ; note on command (90h to 330h) and enter UART mode (3Fh to 331h)
        out dx,ax
        mov al,bl
        and al,0Fh
        add al,65               ; note
        out dx,al
        mov al,7Fh              ; volume (max)
        out dx,al
        shr bl,4                ; high nibble
        jmp @B
skip:
        inc cx

        hlt                     ; delay

        ; Check Esc key
        in al,60h
        dec al
        jnz flashlight

exit:
        ret

text    db 'Revision Online',10
        db '      ',196,205,196,10
        db '  HEAR & OBEY',10
        db 'HTTPS://RMDA.SU',10
        db 'come, taste the',10
        db 'REAL demoscene!'
        db '$'
