/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine;

import abyss.lunarengine.Commander;
import abyss.lunarengine.DefaultKeyListener;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.VBI;
import abyss.lunarengine.tools.Settings;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;

public class Debug
extends JFrame
implements ActionListener {
    private static final String PROPERTY_SCREENBOUNDS = "LunarEngineDebugScreenbounds";
    private Settings settings;
    private static final Rectangle DEFAULT_SCREEN_BOUNDS = new Rectangle(0, 0, 194, 435);
    private static final int MAXTHREADS = 5;
    public static volatile long runtime_realtime = 0L;
    public static volatile long[] runtime_render = new long[5];
    private static long timestamp;
    private static long timestampDelta;
    private static long timestampLastRefresh;
    private int screenSizeX = 450;
    private int screenSizeY = 170;
    private static Panel panelData;
    private static long[] timestamp_Work;
    private static long timestamp_VBI;
    private long refreshTimestamp;
    private static Vector<String> vecLog;

    public Debug(String title) {
        super("DEBUG: " + title);
        System.out.println("Create debug window...");
        this.settings = new Settings(new File("c:/temp/LunarEngineDebug.properties"), "LunarEngine Debug Tool");
        this.setBounds(this.settings.getRectangle(PROPERTY_SCREENBOUNDS, DEFAULT_SCREEN_BOUNDS));
        this.setResizable(true);
        this.setBackground(Color.BLACK);
        super.setBackground(Color.BLACK);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Debug.this.setVisible(false);
                Debug.this.dispose();
            }
        });
        this.addKeyListener(new DefaultKeyListener());
        this.setLayout(null);
        panelData = new PanelData();
        panelData.setBackground(new Color(0));
        int x1 = 4;
        int x2 = 70;
        int y = 4;
        int lineHeight = 20;
        Button buttonExit = new Button("Shutdown");
        buttonExit.setActionCommand("EXIT");
        buttonExit.addActionListener(this);
        buttonExit.setBounds(x1, y, 100, 20);
        this.add(buttonExit);
        Button buttonClose = new Button("Close Debug");
        buttonClose.setActionCommand("CLOSE");
        buttonClose.addActionListener(this);
        buttonClose.setBounds(x1, y += lineHeight, 100, 20);
        this.add(buttonClose);
        Button buttonTitle = new Button("Restart");
        buttonTitle.setActionCommand("RESTART");
        buttonTitle.addActionListener(this);
        buttonTitle.setBounds(x1, y += lineHeight, 100, 20);
        this.add(buttonTitle);
        Button buttonFreeze = new Button("Freeze");
        buttonFreeze.setActionCommand("FREEZE");
        buttonFreeze.addActionListener(this);
        buttonFreeze.setBounds(x1, y += lineHeight, 100, 20);
        this.add(buttonFreeze);
        Button buttonStep = new Button("Step");
        buttonStep.setActionCommand("STEP");
        buttonStep.addActionListener(this);
        buttonStep.setBounds(x1, y += lineHeight, 100, 20);
        this.add(buttonStep);
        Label labelFPS = new Label("VBI FPS: ");
        labelFPS.setBounds(x1, y += lineHeight, 50, 20);
        this.add(labelFPS);
        TextField textfieldFPS = new TextField("60", 1);
        textfieldFPS.setName("FPS");
        textfieldFPS.addActionListener(this);
        textfieldFPS.setBounds(x2, y, 30, 18);
        this.add(textfieldFPS);
        panelData.setBounds(0, y += lineHeight, 180, 280);
        this.add(panelData);
        this.refreshTimestamp = System.currentTimeMillis();
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof TextField) {
            String feldName = ((TextField)event.getSource()).getName();
            System.out.println("Debug: TextField: " + feldName + ": " + event.getActionCommand());
            if (feldName.equals("FPS")) {
                try {
                    VBI.setFramerate(Integer.parseInt(event.getActionCommand()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            String buttonName = event.getActionCommand();
            System.out.println("Debug: ActionEvent: " + buttonName);
            if (buttonName.equals("EXIT")) {
                LunarEngine.shutdown();
            } else if (buttonName.equals("CLOSE")) {
                this.dispose();
            } else if (buttonName.equals("RESTART")) {
                Commander.start(0);
            } else if (buttonName.equals("FREEZE")) {
                VBI.togglePause();
            } else if (buttonName.equals("STEP")) {
                VBI.setSetp(true);
            }
        }
    }

    public void refresh() {
        long now = System.currentTimeMillis();
        if (this.refreshTimestamp + 333L < now) {
            this.refreshTimestamp = now;
        }
        panelData.repaint();
    }

    public static void refresh2() {
        timestampDelta = System.currentTimeMillis() - timestamp;
        timestamp = System.currentTimeMillis();
        if (System.currentTimeMillis() - timestampLastRefresh > 500L) {
            timestampLastRefresh = System.currentTimeMillis();
            if (panelData != null) {
                panelData.repaint();
            }
        }
    }

    public static void beforeRenderThreadWork(int threadnumber) {
        Debug.timestamp_Work[threadnumber] = System.currentTimeMillis();
    }

    public static void afterRenderThreadWork(int threadnumber) {
        Debug.runtime_render[threadnumber] = System.currentTimeMillis() - timestamp_Work[threadnumber];
    }

    public static void beforeVBIWork() {
        timestamp_VBI = System.currentTimeMillis();
    }

    public static void afterVBIWork() {
        runtime_realtime = System.currentTimeMillis() - timestamp_VBI;
    }

    private void saveScreenBounds() {
        this.settings.setRectangle(PROPERTY_SCREENBOUNDS, this.getBounds());
        try {
            this.settings.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.saveScreenBounds();
        super.dispose();
    }

    public static void log(String message) {
        vecLog.add(message);
        System.out.println(message);
    }

    public static synchronized void createLogfile() {
        File fileTempfolder = new File(System.getProperty("java.io.tmpdir"));
        File fileLog = new File(fileTempfolder, "LunarEngineDebug.log");
        System.out.println("Logfile: " + fileLog.getAbsolutePath());
        if (fileLog.exists()) {
            fileLog.delete();
        }
        try {
            FileWriter fileWriter = new FileWriter(fileLog, true);
            for (int i = 0; i < vecLog.size(); ++i) {
                fileWriter.write(vecLog.get(i));
                fileWriter.write("\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static {
        timestamp_Work = new long[5];
        vecLog = new Vector();
    }

    private class PanelData
    extends Panel {
        private static final long serialVersionUID = 1L;
        private Image dbImage;
        private Graphics dbGraphics;
        private int dataPosY;

        private PanelData() {
        }

        private void print(Graphics g, String txt) {
            g.drawString(txt, 4, this.dataPosY);
            this.dataPosY += 14;
        }

        public void update(Graphics g) {
            if (this.dbImage == null) {
                this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
                this.dbGraphics = this.dbImage.getGraphics();
            }
            this.dbGraphics.setColor(this.getBackground());
            this.dbGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            this.dbGraphics.setColor(this.getForeground());
            this.paint(this.dbGraphics);
            g.drawImage(this.dbImage, 0, 0, this);
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, Debug.this.screenSizeX, Debug.this.screenSizeY);
            g.setColor(new Color(0xBBBBBB));
            this.dataPosY = 16;
            this.print(g, "Frame: " + Commander.totalFrameCounter);
            this.print(g, "Time: " + timestampDelta);
            if (timestampDelta > 0L) {
                this.print(g, "FPS: " + 1000L / timestampDelta);
            } else {
                this.print(g, "FPS: unknown");
            }
            this.print(g, "VBI: " + runtime_realtime);
            this.print(g, "Worker S: " + runtime_render[0]);
            this.print(g, "Worker 1: " + runtime_render[1]);
            this.print(g, "Worker 2: " + runtime_render[2]);
            this.print(g, "Worker 3: " + runtime_render[3]);
            this.print(g, "Comm: " + Commander.framecounter);
            String s = "";
            if (Commander.lastCommnand != null) {
                s = Commander.lastCommnand.getClass().getName();
                int p = s.lastIndexOf(46);
                s = s.substring(p + 1);
            }
            this.print(g, "Comm: " + s);
            this.print(g, "1 VBI: " + (LunarEngine.partVbi1 != null ? LunarEngine.partVbi1.getClass().getSimpleName() : ""));
            this.print(g, "1 Work: " + (LunarEngine.partWorker1 != null ? LunarEngine.partWorker1.getClass().getSimpleName() : ""));
            this.print(g, "2 VBI: " + (LunarEngine.partVbi2 != null ? LunarEngine.partVbi2.getClass().getSimpleName() : ""));
            this.print(g, "2 Work: " + (LunarEngine.partWorker2 != null ? LunarEngine.partWorker2.getClass().getSimpleName() : ""));
            this.print(g, "3 VBI: " + (LunarEngine.partVbi3 != null ? LunarEngine.partVbi3.getClass().getSimpleName() : ""));
            this.print(g, "3 Work: " + (LunarEngine.partWorker3 != null ? LunarEngine.partWorker3.getClass().getSimpleName() : ""));
            this.print(g, "freeMemory [mb]: " + Runtime.getRuntime().freeMemory() / 1024L / 1024L);
            this.print(g, "totalMemory [mb]: " + Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        }
    }
}

