/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine;

import abyss.lunarengine.APart;
import abyss.lunarengine.DefaultJFrame;
import abyss.lunarengine.LunarEngineCallback;
import abyss.lunarengine.LunarEngineTools;
import abyss.lunarengine.Screen;
import abyss.lunarengine.VBI;
import abyss.lunarengine.WorkerThread;
import abyss.lunarengine.screenoptionsselector.DataController;
import abyss.lunarengine.screenoptionsselector.DataService;
import abyss.lunarengine.screenoptionsselector.Model;
import abyss.lunarengine.screenoptionsselector.Resolution;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Vector;
import javax.swing.JFrame;

public class LunarEngine {
    private static final String ENGINENAME = "LunarEngine 2.2 by Abyss";
    public static final String SYSTEMPROPERTY_FULLSCREEN_EXCLUSIVE_MODE = "lunarengine.FullscreenExclusiveMode";
    public static final String SYSTEMPROPERTY_ENABLE_SCALING_ON_BIGGER_SCREEN = "lunarengine.EnableScalingOnBiggerScreen";
    public static final String SYSTEMPROPERTY__FPS = "lunarengine.fps";
    public static String clientName = "";
    public static boolean fullscreenExclusiveMode = false;
    public static boolean hideMousePointer = true;
    static final boolean DEBUG = false;
    public static final boolean DEBUG_LOG = false;
    public static final boolean ENABLE_PAUSE = false;
    private static final boolean ENABLE_TOGGLE_FULLSCREEN = false;
    static final boolean ENABLE_CREATEBUFFERSTRATEGY = true;
    static boolean enableScalingOnBiggerScreens = true;
    static int fps = 60;
    static APart partVbi1;
    static APart partVbi2;
    static APart partVbi3;
    static APart partWorker1;
    static APart partWorker2;
    static APart partWorker3;
    public static volatile BufferedImage bufferedImageToReset;
    public static volatile int[] screendataToReset;
    public static volatile BufferedImage bufferedImageToWork;
    public static volatile int[] screendataToWork;
    public static volatile BufferedImage bufferedImageToWork2;
    public static volatile int[] screendataToWork2;
    public static volatile BufferedImage bufferedImageToWork3;
    public static volatile int[] screendataToWork3;
    public static volatile BufferedImage bufferedImageToRender;
    public static volatile int[] screendataToRender;
    public static int[] screendataSwap;
    public static BufferedImage bufferedImageSwap;
    private static volatile boolean shutdownRequested;
    static Thread threadEngine;
    static WorkerThread workerThread1;
    static WorkerThread workerThread2;
    static WorkerThread workerThread3;
    private static JFrame jFrameDebug;
    public static volatile boolean left1;
    public static volatile boolean right1;
    public static volatile boolean up1;
    public static volatile boolean down1;
    public static volatile boolean button1;
    public static volatile boolean left2;
    public static volatile boolean right2;
    public static volatile boolean up2;
    public static volatile boolean down2;
    public static volatile boolean button2;
    public static volatile int keycode;
    private static Vector<LunarEngineCallback> callback;
    private static volatile boolean mainloopEnabled;
    private static GraphicsDevice defaultScreenDevice;
    private static DisplayMode oldDisplayMode;

    public static final void initializeEngine(LunarEngineCallback lunarEngineCallback) {
        callback.add(lunarEngineCallback);
        LunarEngine.initializeEngine();
    }

    public static final void initializeEngine() {
        fullscreenExclusiveMode = System.getProperty(SYSTEMPROPERTY_FULLSCREEN_EXCLUSIVE_MODE, fullscreenExclusiveMode ? "true" : "false").equalsIgnoreCase("true");
        enableScalingOnBiggerScreens = System.getProperty(SYSTEMPROPERTY_ENABLE_SCALING_ON_BIGGER_SCREEN, enableScalingOnBiggerScreens ? "true" : "false").equalsIgnoreCase("true");
        fps = Integer.parseInt(System.getProperty(SYSTEMPROPERTY__FPS, String.valueOf(fps)));
        Rectangle screenBounds = LunarEngine.getScreenBounds();
        Screen.setDeviceScreenSize(screenBounds.width, screenBounds.height);
        LunarEngine.adjustScreenRenderSize();
        APart.jFrame = new DefaultJFrame(clientName);
        LunarEngine.createScreenBuffers();
        if (hideMousePointer) {
            LunarEngine.hideMousePointer();
        }
    }

    public static void startEngine() throws Throwable {
        try {
            if (fullscreenExclusiveMode) {
                LunarEngine.activateFullscreen();
            }
            APart.jFrame.setVisible(true);
            APart.jFrame.toFront();
            APart.jFrame.setAlwaysOnTop(true);
            LunarEngine.mainloop();
        }
        finally {
            if (fullscreenExclusiveMode) {
                LunarEngine.deactivateFullscreen();
            }
        }
    }

    private static final void createScreenBuffers() {
        bufferedImageToReset = new BufferedImage(Screen.screenSizeX, Screen.screenSizeY, 1);
        screendataToReset = ((DataBufferInt)bufferedImageToReset.getRaster().getDataBuffer()).getData();
        bufferedImageToWork = new BufferedImage(Screen.screenSizeX, Screen.screenSizeY, 1);
        screendataToWork = ((DataBufferInt)bufferedImageToWork.getRaster().getDataBuffer()).getData();
        bufferedImageToWork2 = new BufferedImage(Screen.screenSizeX, Screen.screenSizeY, 1);
        screendataToWork2 = ((DataBufferInt)bufferedImageToWork2.getRaster().getDataBuffer()).getData();
        bufferedImageToWork3 = new BufferedImage(Screen.screenSizeX, Screen.screenSizeY, 1);
        screendataToWork3 = ((DataBufferInt)bufferedImageToWork3.getRaster().getDataBuffer()).getData();
        bufferedImageToRender = new BufferedImage(Screen.screenSizeX, Screen.screenSizeY, 1);
        screendataToRender = ((DataBufferInt)bufferedImageToRender.getRaster().getDataBuffer()).getData();
    }

    public static final void setActivePart(APart part) {
        if (part != null) {
            partVbi1 = part;
            partVbi2 = null;
            partVbi3 = null;
            partWorker1 = part;
            partWorker2 = part;
            partWorker3 = part;
        } else {
            partVbi1 = null;
            partVbi2 = null;
            partVbi3 = null;
            partWorker1 = null;
            partWorker2 = null;
            partWorker3 = null;
        }
    }

    public static final void setPartVbi1(APart part) {
        partVbi1 = part;
    }

    public static final void setPartVbi2(APart part) {
        partVbi2 = part;
    }

    public static final void setPartVbi3(APart part) {
        partVbi3 = part;
    }

    public static final void setPartWorker1(APart part) {
        partWorker1 = part;
    }

    public static final void setPartWorker2(APart part) {
        partWorker2 = part;
    }

    public static final void setPartWorker3(APart part) {
        partWorker3 = part;
    }

    private static final void hideMousePointer() {
        APart.jFrame.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 3), new Point(0, 0), "InvisibleCursor"));
    }

    private static final void activateFullscreen() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        defaultScreenDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (!defaultScreenDevice.isFullScreenSupported()) {
            fullscreenExclusiveMode = false;
        }
        defaultScreenDevice.setFullScreenWindow(APart.jFrame);
        if (APart.jFrame.getBufferStrategy() == null) {
            APart.jFrame.createBufferStrategy(2);
        }
        if (defaultScreenDevice.isDisplayChangeSupported()) {
            oldDisplayMode = defaultScreenDevice.getDisplayMode();
            try {
                int bitDepth = oldDisplayMode.getBitDepth();
                int refreshRate = oldDisplayMode.getRefreshRate();
                DisplayMode displayMode = new DisplayMode(Screen.screenRenderSizeX, Screen.screenRenderSizeY, bitDepth, refreshRate);
                defaultScreenDevice.setDisplayMode(displayMode);
                fullscreenExclusiveMode = true;
            }
            catch (IllegalArgumentException e) {
                System.out.println("error switching to fullscreen exclusive mode, could not change display mode");
                e.printStackTrace();
                fullscreenExclusiveMode = false;
            }
        } else {
            fullscreenExclusiveMode = false;
        }
    }

    private static void deactivateFullscreen() {
        if (oldDisplayMode != null) {
            defaultScreenDevice.setDisplayMode(oldDisplayMode);
            oldDisplayMode = null;
        }
        defaultScreenDevice.setFullScreenWindow(null);
        fullscreenExclusiveMode = false;
        APart.jFrame.setVisible(true);
        APart.jFrame.toFront();
    }

    public static final void toggleFullscreen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mainloop() throws Throwable {
        threadEngine = Thread.currentThread();
        threadEngine.setPriority(8);
        workerThread1 = new WorkerThread(1);
        workerThread1.setPriority(8);
        workerThread1.start();
        workerThread2 = new WorkerThread(2);
        workerThread2.setPriority(8);
        workerThread2.start();
        workerThread3 = new WorkerThread(3);
        workerThread3.setPriority(8);
        workerThread3.start();
        VBI.start();
        BufferStrategy bufferStrategy = APart.jFrame.getBufferStrategy();
        while (mainloopEnabled) {
            Thread thread;
            if (LunarEngine.workerThread1.isReady && LunarEngine.workerThread2.isReady && LunarEngine.workerThread3.isReady) {
                LunarEngine.rotateBuffers();
                thread = workerThread1;
                synchronized (thread) {
                    if (workerThread1.isAlive()) {
                        workerThread1.notify();
                    }
                }
                thread = workerThread2;
                synchronized (thread) {
                    if (workerThread2.isAlive()) {
                        workerThread2.notify();
                    }
                }
                thread = workerThread3;
                synchronized (thread) {
                    if (workerThread3.isAlive()) {
                        workerThread3.notify();
                    }
                }
                if (bufferedImageToRender != null) {
                    Graphics graphics;
                    if (fullscreenExclusiveMode) {
                        graphics = bufferStrategy.getDrawGraphics();
                        APart.paintDefault(graphics);
                        graphics.dispose();
                        bufferStrategy.show();
                    } else {
                        graphics = APart.jFrame.getGraphics();
                        APart.paintDefault(graphics);
                        graphics.dispose();
                    }
                }
            }
            thread = threadEngine;
            synchronized (thread) {
                try {
                    threadEngine.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        LunarEngine.doShutdown();
    }

    protected static final void vbi() throws Throwable {
        if (partVbi1 != null) {
            partVbi1.vbi();
        }
        if (partVbi2 != null) {
            partVbi2.vbi();
        }
        if (partVbi3 != null) {
            partVbi3.vbi();
        }
    }

    protected static final void vbiWork(int threadNumber) throws Throwable {
        switch (threadNumber) {
            case 1: {
                if (partWorker1 == null) break;
                partWorker1.worker1();
                break;
            }
            case 2: {
                if (partWorker2 == null) break;
                partWorker2.worker2();
                break;
            }
            case 3: {
                if (partWorker3 == null) break;
                partWorker3.worker3();
            }
        }
    }

    private static final void rotateBuffers() {
        if (partWorker1 != null) {
            partWorker1.rotateBuffers();
        } else if (partWorker2 != null) {
            partWorker2.rotateBuffers();
        } else if (partWorker3 != null) {
            partWorker3.rotateBuffers();
        }
        if (partWorker1 != null) {
            partWorker1.rotatePartBuffers();
        }
        if (partWorker2 != null && partWorker2 != partWorker1) {
            partWorker2.rotatePartBuffers();
        }
        if (partWorker3 != null && partWorker3 != partWorker1 && partWorker3 != partWorker2) {
            partWorker3.rotatePartBuffers();
        }
    }

    public static final void throwableHandler(Throwable throwable) {
        throwable.printStackTrace();
        System.exit(1);
    }

    public static final void shutdown() {
        if (!shutdownRequested) {
            shutdownRequested = true;
            if (fullscreenExclusiveMode) {
                LunarEngine.deactivateFullscreen();
            }
            mainloopEnabled = false;
            if (threadEngine != null && threadEngine.isAlive()) {
                threadEngine.interrupt();
            }
        }
    }

    private static final void doShutdown() {
        VBI.shutdown();
        workerThread1.interrupt();
        workerThread2.interrupt();
        workerThread3.interrupt();
        APart.jFrame.setVisible(false);
        for (int i = 0; i < callback.size(); ++i) {
            callback.get(i).lunarEngineShutdown();
        }
        LunarEngineTools.sleep(30L);
        APart.jFrame.dispose();
        if (jFrameDebug != null) {
            jFrameDebug.setVisible(false);
            jFrameDebug.dispose();
        }
    }

    private static final void adjustScreenRenderSize() {
        if (Screen.screenDeviceSizeX == Screen.screenRenderSizeX && Screen.screenDeviceSizeY == Screen.screenRenderSizeY) {
            return;
        }
        if (Screen.screenDeviceSizeX > Screen.screenRenderSizeX || Screen.screenDeviceSizeY > Screen.screenRenderSizeY) {
            Model model = DataService.getInstance().getModel();
            model.setWindowTitle(clientName != null ? clientName : ENGINENAME);
            model.addResolution(new Resolution(Screen.screenSizeX, Screen.screenSizeY, true));
            model.addResolution(new Resolution(Screen.screenDeviceSizeX, Screen.screenDeviceSizeY));
            try {
                new DataController().openGUI();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            fullscreenExclusiveMode = model.isFullscreenExclusiveModeEnabled();
            if (fullscreenExclusiveMode) {
                Resolution resolution = model.getSelectedResolution();
                Screen.screenRenderSizeX = resolution.getWidth();
                Screen.screenRenderSizeY = resolution.getHeight();
                if (model.isZoomEnabled()) {
                    APart.scaleRenderedImageToScreen = true;
                } else {
                    APart.scaleRenderedImageToScreen = false;
                    Screen.renderOffsetX = Screen.screenDeviceSizeX - Screen.screenSizeX >> 1;
                    Screen.renderOffsetY = Screen.screenDeviceSizeY - Screen.screenSizeY >> 1;
                }
            } else {
                Screen.screenRenderSizeX = Screen.screenDeviceSizeX;
                Screen.screenRenderSizeY = Screen.screenDeviceSizeY;
                if (model.isZoomEnabled()) {
                    APart.scaleRenderedImageToScreen = true;
                } else {
                    APart.scaleRenderedImageToScreen = false;
                    Screen.renderOffsetX = Screen.screenDeviceSizeX - Screen.screenSizeX >> 1;
                    Screen.renderOffsetY = Screen.screenDeviceSizeY - Screen.screenSizeY >> 1;
                }
            }
            if (!model.isLaunchEnabled()) {
                System.exit(0);
            }
        } else {
            APart.scaleRenderedImageToScreen = true;
            Screen.screenRenderSizeX = Screen.screenDeviceSizeX;
            Screen.screenRenderSizeY = Screen.screenDeviceSizeY;
        }
    }

    public static final Rectangle getScreenBounds() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration.getBounds();
    }

    static {
        callback = new Vector();
        mainloopEnabled = true;
        System.out.println(ENGINENAME);
    }
}

