/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.gfx;

public class LordFader {
    public int[] colors;
    private int size;
    private int currentIndex;

    public LordFader(int color1, int color2, int size) {
        this.size = size;
        this.colors = new int[size];
        double red1 = color1 >> 16 & 0xFF;
        double green1 = color1 >> 8 & 0xFF;
        double blue1 = color1 & 0xFF;
        double red2 = color2 >> 16 & 0xFF;
        double green2 = color2 >> 8 & 0xFF;
        double blue2 = color2 & 0xFF;
        double redDelta = (red2 - red1) / (double)(size - 1);
        double greenDelta = (green2 - green1) / (double)(size - 1);
        double blueDelta = (blue2 - blue1) / (double)(size - 1);
        for (int i = 0; i < size; ++i) {
            this.colors[i] = ((int)(red1 + 0.5) << 16) + ((int)(green1 + 0.5) << 8) + (int)(blue1 + 0.5);
            red1 += redDelta;
            green1 += greenDelta;
            blue1 += blueDelta;
        }
    }

    public void fade(int delta) {
        this.currentIndex += delta;
        if (this.currentIndex >= this.size) {
            this.currentIndex = this.size - 1;
        } else if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
    }

    public int getCurrentColor() {
        return this.colors[this.currentIndex];
    }

    public void setIndex(int index) {
        this.currentIndex = index;
    }

    public static int colorHalfBright(int color) {
        return (color & 0xFEFEFE) >> 1;
    }
}

