/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.screenoptionsselector;

import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.screenoptionsselector.Model;
import abyss.lunarengine.tools.ObservableJDialog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class EditorView
extends ObservableJDialog
implements ActionListener {
    private Model model;
    private ButtonGroup buttongroupResolutions;
    private JRadioButton[] radiobuttonResolutions;
    private JCheckBox checkboxFullscreenExclusiveMode;
    private JCheckBox checkboxZoom;
    private JButton buttonOk;
    private JButton buttonCancel;
    private static final double SECTIOAUREA = 1.6180339887;

    public EditorView(JFrame dummyframe, String title, Model model) {
        super(dummyframe, true);
        this.model = model;
        this.setTitle(title);
        this.setResizable(true);
        this.setBackground(new Color(0xDCDCDC));
        this.setLayout(null);
        this.setUndecorated(true);
        int dialogWidth = 370;
        int dialogHeight = (int)((double)dialogWidth / 1.6180339887);
        Rectangle screenBounds = LunarEngine.getScreenBounds();
        Rectangle dialogBounds = new Rectangle(screenBounds.width - dialogWidth >> 1, screenBounds.height - dialogHeight >> 1, dialogWidth, dialogHeight);
        this.setBounds(dialogBounds);
        int x = 86;
        int y = 34;
        JLabel label = new JLabel(title);
        int stringWidth = this.getFontMetrics(label.getFont()).stringWidth(title);
        label.setBounds(dialogBounds.width - stringWidth - 8, dialogBounds.height - (label.getFont().getSize() << 1), 200, 20);
        this.add(label);
        int delta = 20;
        this.checkboxFullscreenExclusiveMode = new JCheckBox("fullscreen exclusive mode");
        this.checkboxFullscreenExclusiveMode.setBounds(x, y, 200, 20);
        this.checkboxFullscreenExclusiveMode.setSelected(true);
        model.setFullscreenExclusiveMode(true);
        this.checkboxFullscreenExclusiveMode.addActionListener(this);
        this.add(this.checkboxFullscreenExclusiveMode);
        this.checkboxZoom = new JCheckBox("zoom");
        this.checkboxZoom.setBounds(x, y += delta, 200, 20);
        this.checkboxZoom.setSelected(true);
        model.setZoom(true);
        this.checkboxZoom.setEnabled(true);
        this.checkboxZoom.addActionListener(this);
        this.add(this.checkboxZoom);
        y += delta + 10;
        this.buttongroupResolutions = new ButtonGroup();
        this.radiobuttonResolutions = new JRadioButton[2];
        String[] resolutionSelection = model.getResolutionLables();
        for (int i = 0; i < resolutionSelection.length; ++i) {
            this.radiobuttonResolutions[i] = new JRadioButton(resolutionSelection[i]);
            this.radiobuttonResolutions[i].setBounds(x, y, 200, 20);
            this.radiobuttonResolutions[i].setSelected(i == 0);
            this.radiobuttonResolutions[i].addActionListener(this);
            this.add(this.radiobuttonResolutions[i]);
            this.buttongroupResolutions.add(this.radiobuttonResolutions[i]);
            y += delta;
        }
        y += 30;
        int sizeButtonOkX = 52;
        int sizeGap = 4;
        int sizeButtonCancelX = 272;
        x = dialogBounds.width - (sizeButtonOkX + sizeGap + sizeButtonCancelX) >> 1;
        this.buttonOk = new JButton("Ok");
        this.buttonOk.setBounds(x, y, sizeButtonOkX, 20);
        this.buttonOk.addActionListener(this);
        this.add(this.buttonOk);
        this.buttonCancel = new JButton("Cancel, but i\u00b4ll come back later. Promise!");
        this.buttonCancel.setBounds(x + sizeButtonOkX + sizeGap, y, sizeButtonCancelX, 20);
        this.buttonCancel.addActionListener(this);
        this.add(this.buttonCancel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                EditorView.this.setChanged();
                EditorView.this.notifyObservers("ESC");
            }
        });
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    EditorView.this.setChanged();
                    EditorView.this.notifyObservers("ESC");
                }
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(new Color(0x9999BB));
        g.drawLine(0, 0, this.getBounds().width, 0);
        g.drawLine(0, 1, this.getBounds().width, 1);
        g.drawLine(0, 0, 0, this.getBounds().height);
        g.drawLine(1, 0, 1, this.getBounds().height);
        g.drawLine(this.getBounds().width - 1, 0, this.getBounds().width - 1, this.getBounds().height);
        g.drawLine(this.getBounds().width - 2, 0, this.getBounds().width - 2, this.getBounds().height);
        g.drawLine(0, this.getBounds().height - 1, this.getBounds().width, this.getBounds().height - 1);
        g.drawLine(0, this.getBounds().height - 2, this.getBounds().width, this.getBounds().height - 2);
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        Object source = e.getSource();
        if (source instanceof JRadioButton) {
            for (i = 0; i < this.radiobuttonResolutions.length; ++i) {
                if (source != this.radiobuttonResolutions[i]) continue;
                this.model.setSelectedResolutionIndex(i);
                return;
            }
        }
        if (source == this.checkboxFullscreenExclusiveMode) {
            if (this.checkboxFullscreenExclusiveMode.isSelected()) {
                this.model.setFullscreenExclusiveMode(true);
                this.model.setZoom(true);
                this.checkboxZoom.setSelected(true);
                for (i = 0; i < this.radiobuttonResolutions.length; ++i) {
                    this.radiobuttonResolutions[i].setEnabled(true);
                }
            } else {
                this.model.setFullscreenExclusiveMode(false);
                for (i = 0; i < this.radiobuttonResolutions.length; ++i) {
                    this.radiobuttonResolutions[i].setEnabled(false);
                }
            }
        } else if (source == this.checkboxZoom) {
            this.model.setZoom(this.checkboxZoom.isSelected());
        } else if (source == this.buttonOk) {
            this.model.setLaunch(true);
            this.setChanged();
            this.notifyObservers("ESC");
        } else if (source == this.buttonCancel) {
            this.model.setLaunch(false);
            this.setChanged();
            this.notifyObservers("ESC");
        }
    }
}

