/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.sinatra;

import abyss.lunarengine.sinatra.SinusWave;

public class Sinatra {
    private int[] wave;
    private int waveLen;
    private int surfIndex;
    private int surfDeltaIndex;
    private int newIndex;
    public static final int PLAYMODE_ONCE = 1;
    public static final int PLAYMODE_REPEAT = 2;
    public static final int PLAYMODE_PINGPONG = 3;
    public int playmode = 2;
    private boolean ping = true;

    private Sinatra() {
    }

    public static Sinatra getInstance(double[] parameter) {
        Sinatra result = new Sinatra();
        result.waveLen = (int)parameter[0];
        result.wave = result.calc(parameter);
        return result;
    }

    private int[] calc(double[] parameter) {
        int parameterIndex = 0;
        int wavesize = (int)parameter[parameterIndex++];
        int wavecount = (int)parameter[parameterIndex++];
        SinusWave[] sinusWaves = new SinusWave[wavecount];
        for (int i = 0; i < wavecount; ++i) {
            sinusWaves[i] = new SinusWave();
            sinusWaves[i].setRadius(parameter[parameterIndex++]);
            sinusWaves[i].setAngleStep(parameter[parameterIndex++]);
            sinusWaves[i].setAngleStart(parameter[parameterIndex++]);
            sinusWaves[i].setAngleEnd(parameter[parameterIndex++]);
        }
        int[] wave = new int[wavesize];
        for (int i = 0; i < wavesize; ++i) {
            double wert = 0.0;
            for (int w = 0; w < wavecount; ++w) {
                wert += sinusWaves[w].getNextValue();
            }
            wave[i] = (int)(wert + 0.5);
        }
        return wave;
    }

    public void move(int delta) {
        this.newIndex += delta;
        if (this.newIndex >= this.waveLen) {
            this.newIndex -= this.waveLen;
        }
        if (this.newIndex < 0) {
            this.newIndex += this.waveLen;
        }
    }

    public void beginRender() {
        this.surfIndex = this.newIndex;
    }

    public int getCurrentValue(int index) {
        return this.wave[index];
    }

    public int getNextValue(int delta) {
        switch (this.playmode) {
            case 1: {
                this.surfIndex += delta;
                if (this.surfIndex >= this.waveLen) {
                    this.surfIndex = this.waveLen - 1;
                }
                if (this.surfIndex >= 0) break;
                this.surfIndex = 0;
                break;
            }
            case 2: {
                this.surfIndex += delta;
                if (this.surfIndex >= this.waveLen) {
                    this.surfIndex -= this.waveLen;
                }
                if (this.surfIndex >= 0) break;
                this.surfIndex += this.waveLen;
                break;
            }
            case 3: {
                this.surfIndex = this.ping ? (this.surfIndex += delta) : (this.surfIndex -= delta);
                if (this.surfIndex >= this.waveLen) {
                    this.surfIndex = this.waveLen - 1;
                    boolean bl = this.ping = !this.ping;
                }
                if (this.surfIndex >= 0) break;
                this.surfIndex = 0;
                this.ping = !this.ping;
            }
        }
        this.surfDeltaIndex = this.surfIndex;
        return this.wave[this.surfIndex];
    }

    public int getNextDeltaValue(int delta) {
        this.surfDeltaIndex += delta;
        if (this.surfDeltaIndex < 0) {
            this.surfDeltaIndex += this.waveLen;
        } else if (this.surfDeltaIndex >= this.waveLen) {
            this.surfDeltaIndex -= this.waveLen;
        }
        return this.wave[this.surfDeltaIndex];
    }

    public int getWaveLen() {
        return this.waveLen;
    }

    public void setIndex(int index) {
        this.surfIndex = index;
    }

    public int getIndex() {
        return this.surfIndex;
    }

    public void setDeltaIndex(int deltaIndex) {
        this.surfDeltaIndex = deltaIndex;
    }

    public void resetDeltaIndex() {
        this.surfDeltaIndex = this.surfIndex;
    }

    public int getDeltaIndex() {
        return this.surfDeltaIndex;
    }

    public Sinatra clone() {
        Sinatra sinatra = new Sinatra();
        sinatra.wave = (int[])this.wave.clone();
        sinatra.waveLen = this.waveLen;
        sinatra.playmode = this.playmode;
        return sinatra;
    }
}

