/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part04bobspiral;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Bob;
import abyss.lunarengine.gfx.BobFactory;
import abyss.lunarengine.sinatra.Sinatra;

public class PartBobSpiral
extends APart {
    private Sinatra sinatraX;
    private Sinatra sinatraY;
    private int[][] tunnelMove;
    private int[][] tunnelRender;
    private int[][] tunnelWork;
    private static final int SPIRAL_LENGTH = 260;
    private int tunnelIndex;
    private Bob bob;
    private int[] sinTab = new int[360];
    private int[] cosTab = new int[360];
    public boolean fadeIn = true;
    private static final int SHIFT = 12;
    private int fadePos;
    private volatile int deltaAngle;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartBobSpiral partBobSpiral = new PartBobSpiral();
            ((APart)partBobSpiral).precalc();
            LunarEngine.setActivePart(partBobSpiral);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public PartBobSpiral() {
        this.tunnelMove = new int[260][3];
        this.tunnelRender = new int[260][3];
        this.tunnelWork = new int[260][3];
    }

    public void precalc() {
        int i;
        for (i = 0; i < 360; ++i) {
            this.sinTab[i] = (int)(Math.sin((double)i * Math.PI / 180.0) * 4096.0 + 0.5);
            this.cosTab[i] = (int)(Math.cos((double)i * Math.PI / 180.0) * 4096.0 + 0.5);
        }
        this.bob = BobFactory.createBob(PartBobSpiral.class, "/data/spiralbob/");
        this.bob.enabled = true;
        this.sinatraX = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0, 0.0, 0.0, 0.0});
        this.sinatraY = Sinatra.getInstance(new double[]{2048.0, 2.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0, 0.0, 0.0, 0.0});
        for (i = 0; i < 260; ++i) {
            this.vbi();
        }
    }

    public void initialize() {
        this.fadePos = 260;
    }

    public void vbi() {
        int i;
        if (this.fadeIn) {
            if (this.fadePos > 0) {
                --this.fadePos;
            }
        } else if (this.fadePos < 260) {
            ++this.fadePos;
        }
        for (int i2 = 0; i2 < 260; ++i2) {
            int[] nArray = this.tunnelMove[i2];
            nArray[2] = nArray[2] + 1;
        }
        this.tunnelIndex = this.tunnelIndex == 259 ? 0 : ++this.tunnelIndex;
        this.tunnelMove[this.tunnelIndex][0] = this.sinatraX.getNextValue(4);
        this.tunnelMove[this.tunnelIndex][1] = this.sinatraY.getNextValue(4);
        this.tunnelMove[this.tunnelIndex][2] = 40;
        int index = 0;
        for (i = this.tunnelIndex + 1; i < 260; ++i) {
            this.tunnelWork[index++] = this.tunnelMove[i];
        }
        for (i = 0; i <= this.tunnelIndex; ++i) {
            this.tunnelWork[index++] = this.tunnelMove[i];
        }
        this.tunnelRender = this.tunnelWork;
        this.deltaAngle += 7;
        this.bob.vbi();
    }

    public void worker2() {
        Bob.screendataToWork = LunarEngine.screendataToWork2;
        int deltaLoop = this.deltaAngle;
        for (int t = 0; t < 260; ++t) {
            if (t >= this.fadePos) {
                int radius = this.tunnelRender[t][2];
                for (int i = 0; i < 180; i += 10) {
                    this.bob.render(this.calcXint(radius, i + ++deltaLoop) + Screen.screenCenterX + this.tunnelRender[t][0], this.calcYint(radius, i + deltaLoop) + Screen.screenCenterY + this.tunnelRender[t][1]);
                }
                continue;
            }
            deltaLoop += 18;
        }
    }

    private int calcXint(int r, int a) {
        return this.cosTab[a % 360] * r >> 12;
    }

    private int calcYint(int r, int a) {
        return this.sinTab[a % 360] * r >> 12;
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, 2838);
    }

    public void rotateBuffers() {
        this.rotateBuffers4();
    }
}

