/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part06lightningobject;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.Tools2D;
import abyss.parallelmultiverse.part06lightningobject.Line;
import abyss.parallelmultiverse.part06lightningobject.LinePoint3D;
import abyss.parallelmultiverse.part06lightningobject.Lineobject3D;

public class PartLightningObject
extends APart {
    public double lightningLinePartsDelta;
    public double rndDelta;
    public boolean fadeOut;
    private double xOffset;
    public double xDestination;
    private Tools2D tools2D;
    Lineobject3D lineobject3D;
    private double lightningLineParts;
    private double rnd;
    private int angleStep;
    private int pointsPerCircle;
    private int circles;
    private int[] colors;
    private int[][] fadedeColors;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartLightningObject partLightningObjects = new PartLightningObject();
            ((APart)partLightningObjects).precalc();
            ((APart)partLightningObjects).initialize();
            LunarEngine.setActivePart(partLightningObjects);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public PartLightningObject() {
        this.xDestination = this.xOffset;
        this.lineobject3D = new Lineobject3D();
        this.colors = new int[]{12021773, 13598479, 12021773, 8692312, 9416543, 8692312, 6645108, 0x6F6F7F, 6645108, 7093259, 9391887, 7093259, 13154944, 14667663, 13154944};
        this.fadedeColors = new int[this.colors.length][256];
    }

    public void precalc() {
        int i;
        int j;
        this.angleStep = 5;
        this.pointsPerCircle = 360 / this.angleStep;
        this.circles = 15;
        this.tools2D = new Tools2D();
        this.addCircle(50.0, -240);
        this.addCircle(80.0, -190);
        this.addCircle(150.0, -170);
        this.addCircle(180.0, -150);
        this.addCircle(180.0, -125);
        this.addCircle(150.0, -100);
        this.addCircle(300.0, -10);
        this.addCircle(300.0, 0);
        this.addCircle(150.0, -50);
        this.addCircle(150.0, 20);
        this.addCircle(100.0, 60);
        this.addCircle(100.0, 90);
        this.addCircle(70.0, 90);
        this.addCircle(70.0, 140);
        this.addCircle(120.0, 200);
        for (int i2 = 0; i2 < this.colors.length; ++i2) {
            int j2;
            int color = this.colors[i2];
            LordFader fader = new LordFader(0, color, 158);
            for (j2 = 0; j2 < 128; ++j2) {
                this.fadedeColors[i2][j2] = fader.colors[j2 + 30];
            }
            fader = new LordFader(color, 0xFFFFFF, 240);
            for (j2 = 0; j2 < 128; ++j2) {
                this.fadedeColors[i2][j2 + 128] = fader.colors[j2];
            }
        }
        int colorIndex = 0;
        int index = 0;
        for (j = 0; j < this.circles; ++j) {
            for (i = index; i < index + this.pointsPerCircle - 1; ++i) {
                this.lineobject3D.addLine(new Line(i, i + 1, this.fadedeColors[colorIndex]));
            }
            this.lineobject3D.addLine(new Line(i, index, this.fadedeColors[colorIndex]));
            index += this.pointsPerCircle;
            ++colorIndex;
            colorIndex %= this.colors.length;
        }
        colorIndex = 0;
        index = 0;
        for (j = 0; j < this.circles - 1; ++j) {
            for (i = index; i < index + this.pointsPerCircle; ++i) {
                this.lineobject3D.addLine(new Line(i, i + this.pointsPerCircle, this.fadedeColors[colorIndex]));
            }
            index += this.pointsPerCircle;
            ++colorIndex;
            colorIndex %= this.colors.length;
        }
        this.lineobject3D.createArrays();
        this.lineobject3D.turnAlpha = 0.4;
        this.lineobject3D.turnBeta = 0.5;
        this.lineobject3D.turnGamma = 0.3;
        this.lineobject3D.focus1 = 800;
        this.lineobject3D.focus2 = 1000;
    }

    private void addCircle(double radius, int z) {
        z *= 3;
        radius *= 1.5;
        for (double a = 0.0; a < 360.0; a += (double)this.angleStep) {
            int x = (int)(radius * Math.cos(a * (Math.PI / 180)));
            int y = (int)(radius * Math.sin(a * (Math.PI / 180)));
            this.lineobject3D.addPoint(new LinePoint3D(x, y, z));
        }
    }

    public void initialize() {
        this.lightningLineParts = 1.0;
        this.xOffset = -400.0;
    }

    public void vbi() {
        this.lineobject3D.rotateVBI();
        if (this.xOffset < this.xDestination) {
            this.xOffset += 2.0;
        }
        this.lightningLineParts += this.lightningLinePartsDelta;
        this.tools2D.lightningLineParts = (int)this.lightningLineParts;
        this.rnd += this.rndDelta;
        if (this.rnd < 0.0) {
            this.rnd = 0.0;
        }
        this.tools2D.rnd = (int)this.rnd;
        if (this.fadeOut && this.lineobject3D.focus1 > 10) {
            this.lineobject3D.focus1 -= 8;
        }
    }

    public void worker2() {
        this.lineobject3D.rotateCALC();
        this.tools2D.screendataWorking = LunarEngine.screendataToWork2;
        this.lineobject3D.render(this.tools2D, (int)this.xOffset);
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, 2838);
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

