/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part10confetti;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Bob2;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.PolarBear;
import abyss.lunarengine.tools.Random;
import abyss.parallelmultiverse.part10confetti.Confetti;

public class PartConfetti
extends APart {
    public int mode;
    public boolean disableConfettiCanons;
    public static final int MODE_RAIN = 1;
    public static final int MODE_CANNON = 2;
    public static final int NUMBER_OF_BOBS = 30;
    public static final int NUMBER_OF_BOBFRAMES = 60;
    private Confetti[] confettis;
    private final int CONFETTI_COUNT = 2000;
    public static final int confettiSize = 16;
    public static final int bobSize = 33;
    private LordFader fader;
    private LordFader faderConfetti;
    private Bob2[] bob = new Bob2[30];
    private int[][] colors;
    private int nextConfettiIndex;
    private int firstShotLeft = 200;
    private int firstShotRight = 200;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartConfetti partConfetti = new PartConfetti();
            partConfetti.precalc();
            partConfetti.initialize();
            partConfetti.mode = 1;
            LunarEngine.setActivePart(partConfetti);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public PartConfetti() {
        this.confettis = new Confetti[2000];
    }

    public void precalc() {
        int i;
        this.fader = new LordFader(255, 0, 31);
        int[] cols = new int[]{0x330000, 13056, 51, 0x333300, 0x330033, 13107, 0x333333};
        int[] cols2 = new int[]{0xFF9999, 0x99FF99, 0x9999FF, 0xFFFF99, 0xFF99FF, 0x99FFFF, 0xFFFFFF};
        this.colors = new int[cols.length][];
        int step1 = 230;
        int step2 = 256 - step1;
        for (i = 0; i < cols.length; ++i) {
            int j;
            this.colors[i] = new int[256];
            this.faderConfetti = new LordFader(0, cols[i], step1);
            for (j = 0; j < step1; ++j) {
                this.colors[i][j] = this.faderConfetti.colors[j];
            }
            this.faderConfetti = new LordFader(cols[i], cols2[i], step2);
            for (j = 0; j < step2; ++j) {
                this.colors[i][step1 + j] = this.faderConfetti.colors[j];
            }
        }
        this.bob[0] = new Bob2(60, 33, 33);
        for (i = 0; i < 60; ++i) {
            int r2a = i + i + i;
            int radius2 = PolarBear.calcXint(16.0, r2a);
            int colorindex = i >= 30 ? 60 - i : i;
            for (int a = 90; a < 270; ++a) {
                int x1 = PolarBear.calcXint(radius2, a);
                int y1 = PolarBear.calcYint(16.0, a);
                double r1 = PolarBear.calcRadius(x1, y1);
                double a1 = PolarBear.calcAlpha(x1, y1);
                x1 = PolarBear.calcXint(r1, a1);
                y1 = PolarBear.calcYint(r1, a1);
                for (int x = -x1; x <= x1; ++x) {
                    int xx = x + 16;
                    int yy = (y1 + 16) * 33;
                    this.bob[0].bobdata[i][xx + yy] = this.fader.colors[colorindex];
                }
            }
        }
        double angle = 0.0;
        for (int b = 1; b < 30; ++b) {
            this.bob[b] = new Bob2(60, 33, 33);
            angle += 6.0;
            for (int f = 0; f < 60; ++f) {
                for (double y = -16.0; y <= 16.0; y += 0.7) {
                    for (double x = -16.0; x <= 16.0; x += 0.7) {
                        double r = PolarBear.calcRadius(x, y);
                        double a = PolarBear.calcAlpha(x, y) + angle;
                        if (x < 0.0) {
                            a += 180.0;
                        }
                        int x1 = 16 + PolarBear.calcXint(r, a);
                        int y1 = 16 + PolarBear.calcYint(r, a);
                        int x2 = (int)(x + 0.5) + 16;
                        int y2 = (int)(y + 0.5) + 16;
                        if (x1 < 0 || x1 >= 33 || y1 < 0 || y1 >= 33) continue;
                        this.bob[b].bobdata[f][x1 + y1 * 33] = this.bob[0].bobdata[f][x2 + y2 * 33];
                    }
                }
            }
        }
        for (int i2 = 0; i2 < this.bob.length; ++i2) {
            this.bob[i2].enabled = true;
        }
        int[] deltaY = new int[]{48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128};
        int[] deltaBob = new int[]{5, 7, 13, 17, 19};
        int[] deltaFrame = new int[]{17, 8, 19, 5, 7, 13};
        int[] startBob = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28};
        int[] startFrame = new int[]{3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57};
        for (int i3 = 0; i3 < 2000; ++i3) {
            this.confettis[i3] = new Confetti((int)(Random.random() * 1900.0), (int)(Random.random() * 1000.0) - 1100, 0, deltaY[i3 % deltaY.length], deltaBob[i3 % deltaBob.length], deltaFrame[i3 % deltaFrame.length], startBob[i3 % startBob.length], startFrame[i3 % startFrame.length], this.colors[i3 % this.colors.length]);
        }
        Confetti.bob = this.bob;
    }

    public void initialize() {
        Confetti.fadeout = false;
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                for (int i = 0; i < 2000; ++i) {
                    this.confettis[i].enabled = false;
                }
                break;
            }
        }
    }

    public void beginFadeOut() {
        Confetti.fadeout = true;
        for (int i = 0; i < 2000; ++i) {
            if (this.confettis[i].offsetY < 0) {
                this.confettis[i].enabled = false;
                continue;
            }
            this.confettis[i].deltaY += 192;
        }
    }

    public void vbi() {
        switch (this.mode) {
            case 1: {
                for (int i = 0; i < 2000; ++i) {
                    this.confettis[i].vbiRain();
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < 2000; ++i) {
                    this.confettis[i].vbiCannons();
                }
                if (this.disableConfettiCanons) {
                    return;
                }
                i = 0;
                while (this.nextConfettiIndex < 2000) {
                    if (!this.confettis[this.nextConfettiIndex].enabled) {
                        this.confettis[this.nextConfettiIndex].enabled = true;
                        this.confettis[this.nextConfettiIndex].offsetX = 0;
                        this.confettis[this.nextConfettiIndex].offsetY = Screen.screenSizeY << 5;
                        this.confettis[this.nextConfettiIndex].deltaX = (int)(Random.random() * 352.0) + 64;
                        this.confettis[this.nextConfettiIndex].deltaY = -((int)(Random.random() * 256.0)) - 128;
                        if (this.firstShotLeft == 0) {
                            if (i > 1) {
                                break;
                            }
                        } else {
                            --this.firstShotLeft;
                        }
                    }
                    ++this.nextConfettiIndex;
                    ++i;
                }
                if (this.nextConfettiIndex == 2000) {
                    this.nextConfettiIndex = 0;
                }
                i = 0;
                while (this.nextConfettiIndex < 2000) {
                    if (!this.confettis[this.nextConfettiIndex].enabled) {
                        this.confettis[this.nextConfettiIndex].enabled = true;
                        this.confettis[this.nextConfettiIndex].offsetX = Screen.screenSizeX << 5;
                        this.confettis[this.nextConfettiIndex].offsetY = Screen.screenSizeY << 5;
                        this.confettis[this.nextConfettiIndex].deltaX = -((int)(Random.random() * 352.0)) - 64;
                        this.confettis[this.nextConfettiIndex].deltaY = -((int)(Random.random() * 256.0)) - 128;
                        if (this.firstShotRight == 0) {
                            if (i > 1) {
                                break;
                            }
                        } else {
                            --this.firstShotRight;
                        }
                    }
                    ++this.nextConfettiIndex;
                    ++i;
                }
                if (this.nextConfettiIndex != 2000) break;
                this.nextConfettiIndex = 0;
            }
        }
    }

    public void worker2() {
        Bob2.screendataToWork = LunarEngine.screendataToWork;
        Confetti.screendataToWork = LunarEngine.screendataToWork;
        for (int i = 0; i < 2000; ++i) {
            this.confettis[i].render();
        }
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, 0);
    }
}

