/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part16dottyobject;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.PolarBear;
import abyss.lunarengine.gfx.Tools2D;
import abyss.lunarengine.sinatra.Sinatra;
import abyss.parallelmultiverse.part16dottyobject.Line;
import abyss.parallelmultiverse.part16dottyobject.LinePoint3D;
import abyss.parallelmultiverse.part16dottyobject.Lineobject3D;
import abyss.parallelmultiverse.part16dottyobject.Lineobject3DDottyLine;

public class PartDottyObject
extends APart {
    public int renderBuffer;
    public boolean fadeOut;
    private volatile int xOffset;
    public int xDestination;
    private Tools2D tools2D;
    private Lineobject3DDottyLine lineobject3D;
    private Lineobject3D lineobject3DRing;
    private int angleStep;
    private int pointsPerCircle;
    private int circles;
    private int circlesRing;
    private int ringPosZ;
    private Sinatra sinatra;
    private int lastValue;

    public PartDottyObject() {
        this.xDestination = this.xOffset;
        this.lineobject3D = new Lineobject3DDottyLine();
        this.lineobject3DRing = new Lineobject3D();
        this.angleStep = 15;
        this.pointsPerCircle = 360 / this.angleStep;
        this.circles = 21;
        this.circlesRing = 3;
    }

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartDottyObject partLightningObjects = new PartDottyObject();
            partLightningObjects.precalc();
            partLightningObjects.initialize();
            partLightningObjects.xDestination = Screen.screenCenterX;
            partLightningObjects.xOffset = Screen.screenCenterX;
            LunarEngine.setActivePart(partLightningObjects);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public void precalc() {
        int i;
        int j;
        int j2;
        int j3;
        LordFader fader;
        this.sinatra = Sinatra.getInstance(new double[]{360.0, 1.0, 800.0, 1.0, 90.0, 450.0});
        this.tools2D = new Tools2D();
        this.addCircle(50.0, -200, this.lineobject3D);
        this.addCircle(50.0, -170, this.lineobject3D);
        this.addCircle(30.0, -170, this.lineobject3D);
        this.addCircle(30.0, -120, this.lineobject3D);
        this.addCircle(50.0, -120, this.lineobject3D);
        this.addCircle(50.0, -90, this.lineobject3D);
        this.addCircle(100.0, -90, this.lineobject3D);
        this.addCircle(100.0, -60, this.lineobject3D);
        this.addCircle(30.0, -60, this.lineobject3D);
        this.addCircle(30.0, -10, this.lineobject3D);
        this.addCircle(200.0, -10, this.lineobject3D);
        this.addCircle(200.0, 20, this.lineobject3D);
        this.addCircle(70.0, 20, this.lineobject3D);
        this.addCircle(70.0, 50, this.lineobject3D);
        this.addCircle(200.0, 100, this.lineobject3D);
        this.addCircle(200.0, 120, this.lineobject3D);
        this.addCircle(30.0, 140, this.lineobject3D);
        this.addCircle(30.0, 170, this.lineobject3D);
        this.addCircle(150.0, 190, this.lineobject3D);
        this.addCircle(30.0, 200, this.lineobject3D);
        this.addCircle(30.0, 230, this.lineobject3D);
        this.ringPosZ = -690;
        this.addCircle(280.0, -250, this.lineobject3DRing);
        this.addCircle(300.0, -230, this.lineobject3DRing);
        this.addCircle(280.0, -210, this.lineobject3DRing);
        int[] colors = new int[]{12021773, 13598479, 12021773, 8692312, 9416543, 8692312, 6645108, 0x6F6F7F, 6645108, 7093259, 9391887, 7093259, 13154944, 14667663, 13154944};
        int numberOfColors = colors.length;
        int[][] fadedeColors = new int[numberOfColors][256];
        for (int i2 = 0; i2 < numberOfColors; ++i2) {
            int color = colors[i2];
            fader = new LordFader(0, color, 158);
            for (j3 = 0; j3 < 128; ++j3) {
                fadedeColors[i2][j3] = fader.colors[j3 + 30];
            }
            fader = new LordFader(color, 0xFFFFFF, 240);
            for (j3 = 0; j3 < 128; ++j3) {
                fadedeColors[i2][j3 + 128] = fader.colors[j3];
            }
        }
        int colorRing = 10202307;
        int[] fadedColorsRing = new int[256];
        fader = new LordFader(0, colorRing, 158);
        for (j3 = 0; j3 < 128; ++j3) {
            fadedColorsRing[j3] = fader.colors[j3 + 30];
        }
        fader = new LordFader(colorRing, 0xFFFFFF, 240);
        for (j3 = 0; j3 < 128; ++j3) {
            fadedColorsRing[j3 + 128] = fader.colors[j3];
        }
        int[] fadedColorsRing2 = new int[256];
        colorRing = 0x99FFFF;
        fader = new LordFader(0, colorRing, 158);
        for (j2 = 0; j2 < 128; ++j2) {
            fadedColorsRing2[j2] = fader.colors[j2 + 30];
        }
        fader = new LordFader(colorRing, 0xFFFFFF, 240);
        for (j2 = 0; j2 < 128; ++j2) {
            fadedColorsRing2[j2 + 128] = fader.colors[j2];
        }
        int colorIndex = 0;
        int index = 0;
        for (j = 0; j < this.circles; ++j) {
            for (i = index; i < index + this.pointsPerCircle - 1; ++i) {
                this.lineobject3D.addLine(new Line(i, i + 1, fadedeColors[colorIndex]));
            }
            this.lineobject3D.addLine(new Line(i, index, fadedeColors[colorIndex]));
            index += this.pointsPerCircle;
            ++colorIndex;
            colorIndex %= numberOfColors;
        }
        index = 0;
        for (j = 0; j < this.circlesRing; ++j) {
            for (i = index; i < index + this.pointsPerCircle - 1; ++i) {
                this.lineobject3DRing.addLine(new Line(i, i + 1, fadedColorsRing));
            }
            this.lineobject3DRing.addLine(new Line(i, index, fadedColorsRing));
            index += this.pointsPerCircle;
        }
        colorIndex = 0;
        index = 0;
        for (j = 0; j < this.circles - 1; ++j) {
            for (i = index; i < index + this.pointsPerCircle; ++i) {
                this.lineobject3D.addLine(new Line(i, i + this.pointsPerCircle, fadedeColors[colorIndex]));
            }
            index += this.pointsPerCircle;
            ++colorIndex;
            colorIndex %= numberOfColors;
        }
        index = 0;
        for (j = 0; j < this.circlesRing - 1; ++j) {
            for (i = index; i < index + this.pointsPerCircle; ++i) {
                this.lineobject3DRing.addLine(new Line(i, i + this.pointsPerCircle, fadedColorsRing));
            }
            if (j == 1) {
                int radius = 450;
                int alpha = 0;
                for (i = index; i < index + this.pointsPerCircle; ++i) {
                    LinePoint3D point = this.lineobject3DRing.getPoint(i);
                    int x = PolarBear.calcXint(radius - 100, alpha);
                    int y = PolarBear.calcYint(radius - 100, alpha);
                    int indexPoint = this.lineobject3DRing.addPoint(new LinePoint3D(x, y, point.sz));
                    this.lineobject3DRing.addLine(new Line(i, indexPoint, fadedColorsRing2));
                    alpha += 360 / this.pointsPerCircle;
                }
            }
            index += this.pointsPerCircle;
        }
        this.lineobject3D.createArrays();
        this.lineobject3D.turnAlpha = 0.4;
        this.lineobject3D.turnBeta = 0.3;
        this.lineobject3D.turnGamma = 0.3;
        this.lineobject3D.beta = 90.0;
        this.lineobject3D.focus1 = 800;
        this.lineobject3D.focus2 = 1000;
        this.lineobject3DRing.createArrays();
        this.lineobject3DRing.turnAlpha = this.lineobject3D.turnAlpha;
        this.lineobject3DRing.turnBeta = this.lineobject3D.turnBeta;
        this.lineobject3DRing.turnGamma = this.lineobject3D.turnGamma;
        this.lineobject3DRing.beta = this.lineobject3D.beta;
        this.lineobject3DRing.focus1 = this.lineobject3D.focus1;
        this.lineobject3DRing.focus2 = this.lineobject3D.focus2;
    }

    private void addCircle(double radius, int z, Lineobject3D lineobject3D) {
        z *= 3;
        radius *= 1.5;
        for (double a = 0.0; a < 360.0; a += (double)this.angleStep) {
            int x = (int)(radius * Math.cos(a * (Math.PI / 180)));
            int y = (int)(radius * Math.sin(a * (Math.PI / 180)));
            lineobject3D.addPoint(new LinePoint3D(x, y, z));
        }
    }

    public void initialize() {
        this.xOffset = Screen.screenSizeX + 750;
        this.tools2D.lightningLineParts = 10;
        this.renderBuffer = 3;
        this.sinatra.setIndex(180);
        this.lastValue = this.sinatra.getNextValue(0);
    }

    public void vbi() {
        this.lineobject3D.rotateVBI();
        this.lineobject3DRing.rotateVBI();
        this.ringPosZ = this.sinatra.getNextValue(1);
        for (int i = 0; i < this.lineobject3DRing.points.length; ++i) {
            this.lineobject3DRing.points[i].sz += this.ringPosZ - this.lastValue << 12;
        }
        this.lastValue = this.ringPosZ;
        if (this.xOffset > this.xDestination) {
            this.xOffset -= 5;
        }
        if (this.fadeOut && this.lineobject3D.focus1 > 10) {
            this.lineobject3D.focus1 -= 8;
            this.lineobject3DRing.focus1 -= 8;
        }
    }

    public void worker3() {
        switch (this.renderBuffer) {
            case 0: {
                return;
            }
            case 2: {
                this.tools2D.screendataWorking = LunarEngine.screendataToWork2;
                break;
            }
            case 3: {
                this.tools2D.screendataWorking = LunarEngine.screendataToWork3;
            }
        }
        this.lineobject3D.rotateCALC();
        this.lineobject3D.render(this.tools2D, this.xOffset, this.ringPosZ);
        this.lineobject3DRing.rotateCALC();
        this.tools2D.lightningLineParts = 15;
        this.tools2D.rnd = 20;
        this.lineobject3DRing.render(this.tools2D, this.xOffset);
    }

    public void worker2() {
        Screen.screenClear(LunarEngine.screendataToReset, 0);
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

