/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part20lasercutter;

import abyss.lunarengine.Commander;
import abyss.lunarengine.ICommanderAction;
import abyss.lunarengine.LunarEngine;
import abyss.parallelmultiverse.part10confetti.PartConfetti;
import abyss.parallelmultiverse.part20lasercutter.PartLaserCutter;

public class MainLaserCutter {
    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartLaserCutter partLaserCutter = new PartLaserCutter();
            partLaserCutter.precalc();
            PartConfetti partConfetti = new PartConfetti();
            partConfetti.precalc();
            MainLaserCutter.addCommands(partLaserCutter, partConfetti);
            Commander.start(0);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public static int addCommands(final PartLaserCutter partLaserCutter, final PartConfetti partConfetti) {
        int index = Commander.addCommanderAction(600, new ICommanderAction(){

            public void doAction(Object object) {
                partLaserCutter.initialize();
                LunarEngine.setActivePart(partLaserCutter);
                if (partConfetti != null) {
                    partConfetti.mode = 2;
                    partConfetti.initialize();
                }
            }
        });
        Commander.addCommanderAction(20, new ICommanderAction(){

            public void doAction(Object object) {
                partLaserCutter.moveToFront();
            }
        });
        Commander.addCommanderAction(30, new ICommanderAction(){

            public void doAction(Object object) {
                partLaserCutter.explosionLaser();
            }
        });
        Commander.addCommanderAction(435, new ICommanderAction(){

            public void doAction(Object object) {
                if (partConfetti != null) {
                    LunarEngine.setPartVbi2(partConfetti);
                    LunarEngine.setPartWorker2(partConfetti);
                }
            }
        });
        Commander.addCommanderAction(470, new ICommanderAction(){

            public void doAction(Object object) {
                partLaserCutter.explosionLogo();
                if (partConfetti != null) {
                    partConfetti.disableConfettiCanons = true;
                }
            }
        });
        Commander.addCommanderAction(1, new ICommanderAction(){

            public void doAction(Object object) {
                LunarEngine.shutdown();
            }
        });
        return index;
    }
}

