/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part20lasercutter;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Bob;
import abyss.lunarengine.gfx.BobFactory;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.Point3D;
import abyss.lunarengine.gfx.Tools2D;
import abyss.parallelmultiverse.common.BobTheBuilder;
import abyss.parallelmultiverse.common.Bobs3D;
import abyss.parallelmultiverse.common.BobsSpread;
import abyss.parallelmultiverse.common.PointSpread;
import abyss.parallelmultiverse.part20lasercutter.BobLogo;
import abyss.parallelmultiverse.part20lasercutter.LaserPos;

public class PartLaserCutter
extends APart {
    public static final int BACKGROUNDCOLOR = 197636;
    private Bob[] bobs;
    private Bobs3D bobs3dLogo;
    private Bobs3D bobs3dLaser;
    private Bobs3D laserPoint1;
    private Tools2D tools2d;
    private BobsSpread bobSpread;
    private int laserX;
    private int laserY;
    private static final int BOBSIZE = 8;
    private BobLogo bobLogo;
    private boolean laserPower;
    private LordFader faderBackground;
    private boolean toFront;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartLaserCutter partLaserCutter = new PartLaserCutter();
            ((APart)partLaserCutter).precalc();
            ((APart)partLaserCutter).initialize();
            LunarEngine.setActivePart(partLaserCutter);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public void precalc() {
        this.faderBackground = new LordFader(393984, 197636, 120);
        this.tools2d = new Tools2D();
        this.bobs = new Bob[7];
        this.bobs[0] = BobFactory.createBob(PartLaserCutter.class, "/data/ball08/");
        block8: for (int i = 1; i < this.bobs.length; ++i) {
            this.bobs[i] = this.bobs[0].clone();
            this.bobs[i].enabled = true;
            this.bobs[i].animdelay = 0;
            switch (i) {
                case 1: {
                    BobTheBuilder.reColorFade(this.bobs[i], 10202307);
                    continue block8;
                }
                case 2: {
                    BobTheBuilder.reColorFade(this.bobs[i], 7637932);
                    continue block8;
                }
                case 3: {
                    BobTheBuilder.reColorFade(this.bobs[i], 4350606);
                    continue block8;
                }
                case 4: {
                    BobTheBuilder.reColorFade(this.bobs[i], 2112351);
                    continue block8;
                }
                case 5: {
                    BobTheBuilder.reColorFade(this.bobs[i], 0xAAAAAA);
                    continue block8;
                }
                case 6: {
                    BobTheBuilder.reColorFade(this.bobs[i], 0x666666);
                }
            }
        }
        boolean gammaS = false;
        boolean betaS = false;
        int focus1 = 900;
        int focus2 = 900;
        double turnAlpha = 0.0;
        double turnBeta = 1.5;
        double turnGamma = 0.0;
        this.bobs3dLogo = BobTheBuilder.createCuboid(8, 104, 4, 43);
        this.bobs3dLogo.beta = (double)betaS;
        this.bobs3dLogo.gamma = (double)gammaS;
        this.bobs3dLogo.turnAlpha = turnAlpha;
        this.bobs3dLogo.turnBeta = turnBeta;
        this.bobs3dLogo.turnGamma = turnGamma;
        this.bobs3dLogo.focus1 = focus1;
        this.bobs3dLogo.focus2 = focus2;
        this.bobs3dLaser = BobTheBuilder.createLaser(8);
        this.bobs3dLaser.beta = (double)betaS;
        this.bobs3dLaser.gamma = (double)gammaS;
        this.bobs3dLaser.turnAlpha = turnAlpha;
        this.bobs3dLaser.turnBeta = turnBeta;
        this.bobs3dLaser.turnGamma = turnGamma;
        this.bobs3dLaser.focus1 = focus1;
        this.bobs3dLaser.focus2 = focus2;
        this.laserPoint1 = new Bobs3D();
        this.laserPoint1.addBob(new Point3D(0, 405, 0, 1));
        this.laserPoint1.addBob(new Point3D(0, 350, 0, 1));
        this.laserPoint1.createArrays();
        this.laserPoint1.beta = (double)betaS;
        this.laserPoint1.gamma = (double)gammaS;
        this.laserPoint1.turnAlpha = turnAlpha;
        this.laserPoint1.turnBeta = turnBeta;
        this.laserPoint1.turnGamma = turnGamma;
        this.laserPoint1.focus1 = focus1;
        this.laserPoint1.focus2 = focus2;
        this.laserPoint1.rotateCALC();
        this.bobSpread = new BobsSpread();
        this.bobLogo = new BobLogo();
    }

    public void initialize() {
        this.tools2d.lightningLineParts = 8;
        this.tools2d.rnd = 16;
        PointSpread.bobsize = 8;
    }

    public void vbi() {
        this.bobs3dLaser.rotateVBI();
        this.bobs3dLogo.rotateVBI();
        this.laserPoint1.rotateVBI();
        LaserPos laserPos = this.bobLogo.getNextLaserPos();
        if (laserPos != null) {
            this.laserPower = laserPos.power;
            this.laserX = laserPos.x << 3;
            this.laserY = laserPos.y << 3;
        } else {
            this.laserPower = false;
        }
        if (this.toFront) {
            if (this.bobs3dLogo.alpha > 1.0) {
                this.bobs3dLogo.alpha -= 1.0;
                this.bobs3dLaser.alpha -= 1.0;
                this.laserPoint1.alpha -= 1.0;
            } else if (this.bobs3dLogo.alpha < 1.0) {
                this.bobs3dLogo.alpha += 1.0;
                this.bobs3dLaser.alpha += 1.0;
                this.laserPoint1.alpha += 1.0;
            }
            if (this.bobs3dLogo.beta > 2.0) {
                this.bobs3dLogo.beta -= 1.0;
                this.bobs3dLaser.beta -= 1.0;
                this.laserPoint1.beta -= 1.0;
            } else if (this.bobs3dLogo.beta < 1.0) {
                this.bobs3dLogo.beta += 1.0;
                this.bobs3dLaser.beta += 1.0;
                this.laserPoint1.beta += 1.0;
            }
            if (this.bobs3dLogo.gamma > -75.0) {
                this.bobs3dLogo.gamma -= 1.0;
                this.bobs3dLaser.gamma -= 1.0;
                this.laserPoint1.gamma -= 1.0;
            } else if (this.bobs3dLogo.gamma < -76.0) {
                this.bobs3dLogo.gamma += 1.0;
                this.bobs3dLaser.gamma += 1.0;
                this.laserPoint1.gamma += 1.0;
            }
        }
        this.laserPoint1.deltaX = this.bobs3dLaser.deltaX = this.laserX;
        this.laserPoint1.deltaZ = this.bobs3dLaser.deltaZ = this.laserY;
        this.bobSpread.vbi();
        if (laserPos != null && laserPos.power) {
            int laserZ = (this.laserPoint1.points[1].sz >> 12) + this.laserPoint1.deltaZ;
            for (int i = 0; i < this.bobs3dLogo.arrayIndex; ++i) {
                if (!this.bobs3dLogo.points[i].enabled) continue;
                if (Math.abs((this.bobs3dLogo.points[i].sx >> 12) - this.laserX) < 10 && this.bobs3dLogo.points[i].sy < 1974272 && Math.abs((this.bobs3dLogo.points[i].sz >> 12) - laserZ) < 10) {
                    this.bobs3dLogo.points[i].enabled = false;
                    this.bobSpread.addBob(this.bobs3dLogo.points[i]);
                    continue;
                }
                if (!this.toFront) continue;
                this.bobs3dLogo.points[i].sy -= 20480;
            }
        }
        this.faderBackground.fade(1);
    }

    public void moveToFront() {
        this.toFront = true;
        this.bobs3dLogo.turnAlpha = 0.0;
        this.bobs3dLogo.turnBeta = 0.0;
        this.bobs3dLogo.turnGamma = 0.0;
        this.bobs3dLaser.turnAlpha = 0.0;
        this.bobs3dLaser.turnBeta = 0.0;
        this.bobs3dLaser.turnGamma = 0.0;
        this.laserPoint1.turnAlpha = 0.0;
        this.laserPoint1.turnBeta = 0.0;
        this.laserPoint1.turnGamma = 0.0;
    }

    public void explosionLogo() {
        for (int i = 0; i < this.bobs3dLogo.arrayIndex; ++i) {
            if (!this.bobs3dLogo.points[i].enabled) continue;
            this.bobs3dLogo.points[i].enabled = false;
            this.bobSpread.addBob(this.bobs3dLogo.points[i]);
        }
    }

    public void explosionLaser() {
        for (int i = 0; i < this.bobs3dLaser.arrayIndex; ++i) {
            if (!this.bobs3dLaser.points[i].enabled) continue;
            this.bobs3dLaser.points[i].enabled = false;
            this.bobSpread.addBob(this.bobs3dLaser.points[i]);
        }
    }

    public void worker1() {
        int z;
        Bob bob;
        int i;
        this.tools2d.screendataWorking = LunarEngine.screendataToWork2;
        Bob.screendataToWork = LunarEngine.screendataToWork2;
        this.bobs3dLaser.rotateCALC();
        this.bobs3dLogo.rotateCALC();
        this.laserPoint1.rotateCALCnosort();
        for (i = 0; i < this.bobs3dLogo.arrayIndex; ++i) {
            if (!this.bobs3dLogo.points[i].enabled) continue;
            bob = this.bobs[this.bobs3dLogo.points[i].data];
            z = 475 - this.bobs3dLogo.points[i].dz >> 2;
            bob.frame = z > 255 ? 255 : (z < 0 ? 0 : z);
            bob.render(this.bobs3dLogo.points[i].dx + Screen.screenCenterX, this.bobs3dLogo.points[i].dy + Screen.screenCenterY);
        }
        for (i = 0; i < this.bobs3dLaser.arrayIndex; ++i) {
            bob = this.bobs[this.bobs3dLaser.points[i].data];
            z = 475 - this.bobs3dLaser.points[i].dz >> 2;
            bob.frame = z > 255 ? 255 : (z < 0 ? 0 : z);
            bob.render(this.bobs3dLaser.points[i].dx + Screen.screenCenterX, this.bobs3dLaser.points[i].dy + Screen.screenCenterY);
        }
        this.bobSpread.render(this.bobs);
        if (this.laserPower) {
            int laserXX1 = this.laserPoint1.points[1].dx + Screen.screenCenterX + 4;
            int laserYY1 = this.laserPoint1.points[1].dy + Screen.screenCenterY + 4;
            int laserXX2 = this.laserPoint1.points[0].dx + Screen.screenCenterX + 4;
            int laserYY2 = this.laserPoint1.points[0].dy + Screen.screenCenterY + 4;
            this.tools2d.pixel = 0xFF0000;
            this.tools2d.lightningLine(laserXX1, laserYY1, laserXX2, laserYY2);
            this.tools2d.lightningLine(laserXX1, laserYY1, laserXX2, laserYY2);
            this.tools2d.lightningLine(laserXX1, laserYY1, laserXX2, laserYY2);
        }
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, this.faderBackground.getCurrentColor());
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

