/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer.sax;

import com.sun.xml.internal.stream.buffer.AbstractCreator;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXBufferCreator
extends AbstractCreator
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler {
    protected String[] _namespaceAttributes = new String[32];
    protected int _namespaceAttributesPtr;
    private int depth = 0;

    public SAXBufferCreator() {
    }

    public SAXBufferCreator(MutableXMLStreamBuffer mutableXMLStreamBuffer) {
        this();
        this.setBuffer(mutableXMLStreamBuffer);
    }

    public MutableXMLStreamBuffer create(XMLReader xMLReader, InputStream inputStream) throws IOException, SAXException {
        return this.create(xMLReader, inputStream, null);
    }

    public MutableXMLStreamBuffer create(XMLReader xMLReader, InputStream inputStream, String string) throws IOException, SAXException {
        if (this._buffer == null) {
            this.createBuffer();
        }
        this._buffer.setSystemId(string);
        xMLReader.setContentHandler(this);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        try {
            this.setHasInternedStrings(xMLReader.getFeature("http://xml.org/sax/features/string-interning"));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (string != null) {
            InputSource inputSource = new InputSource(string);
            inputSource.setByteStream(inputStream);
            xMLReader.parse(inputSource);
        } else {
            xMLReader.parse(new InputSource(inputStream));
        }
        return this.getXMLStreamBuffer();
    }

    public void reset() {
        this._buffer = null;
        this._namespaceAttributesPtr = 0;
        this.depth = 0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.storeStructure(16);
    }

    @Override
    public void endDocument() throws SAXException {
        this.storeStructure(144);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.cacheNamespaceAttribute(string, string2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.storeQualifiedName(32, string, string2, string3);
        if (this._namespaceAttributesPtr > 0) {
            this.storeNamespaceAttributes();
        }
        if (attributes.getLength() > 0) {
            this.storeAttributes(attributes);
        }
        ++this.depth;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.storeStructure(144);
        if (--this.depth == 0) {
            this.increaseTreeCount();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.storeContentCharacters(80, cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.storeStructure(112);
        this.storeStructureString(string);
        this.storeStructureString(string2);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.storeContentCharacters(96, cArray, n, n2);
    }

    private void cacheNamespaceAttribute(String string, String string2) {
        this._namespaceAttributes[this._namespaceAttributesPtr++] = string;
        this._namespaceAttributes[this._namespaceAttributesPtr++] = string2;
        if (this._namespaceAttributesPtr == this._namespaceAttributes.length) {
            String[] stringArray = new String[this._namespaceAttributesPtr * 2];
            System.arraycopy(this._namespaceAttributes, 0, stringArray, 0, this._namespaceAttributesPtr);
            this._namespaceAttributes = stringArray;
        }
    }

    private void storeNamespaceAttributes() {
        for (int i = 0; i < this._namespaceAttributesPtr; i += 2) {
            int n = 64;
            if (this._namespaceAttributes[i].length() > 0) {
                n |= 1;
                this.storeStructureString(this._namespaceAttributes[i]);
            }
            if (this._namespaceAttributes[i + 1].length() > 0) {
                n |= 2;
                this.storeStructureString(this._namespaceAttributes[i + 1]);
            }
            this.storeStructure(n);
        }
        this._namespaceAttributesPtr = 0;
    }

    private void storeAttributes(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).startsWith("xmlns")) continue;
            this.storeQualifiedName(48, attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
            this.storeStructureString(attributes.getType(i));
            this.storeContentString(attributes.getValue(i));
        }
    }

    private void storeQualifiedName(int n, String string, String string2, String string3) {
        if (string.length() > 0) {
            n |= 2;
            this.storeStructureString(string);
        }
        this.storeStructureString(string2);
        if (string3.indexOf(58) >= 0) {
            n |= 4;
            this.storeStructureString(string3);
        }
        this.storeStructure(n);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return null;
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }
}

