#pragma once
#include <vector>
#include <math.h>

#define GLEW_STATIC
#include "GL/glew.h"
#ifdef _WIN32
#include "GL/wglew.h" // For wglSwapInterval
#endif

#define GLM_FORCE_RADIANS
#include "glm/glm.hpp"
#include "glm/gtc/epsilon.hpp"
#include "glm/gtc/type_ptr.hpp"
#include "glm/gtc/matrix_transform.hpp"
#include "glm/gtx/transform.hpp"
#include "glm/gtx/quaternion.hpp"
#include "glm/gtx/compatibility.hpp"
#include "glm/ext.hpp"
#include "glm/gtx/vector_angle.hpp"

#define FONT_SIZE 12

#define WIDTH_DATA_OFFSET  20 // Offset to width data with BFF file
#define MAP_DATA_OFFSET   276 // Offset to texture image data with BFF file


namespace BHorzScroll
{
	using namespace std;

	class HorzScroll
	{


	public:
		static int load(const char *filename);
		static void buildFont(HDC hDC = NULL, bool textured = true);								// Build Our Bitmap Font
		static void draw(int w, int h);
		static void drawHTexScroll(float posx, float posy, float wide);
		static bool setFont(CHAR fontName[32], int fontSize, BOOL italic, BOOL bold);
		static bool buildTexture(COLORREF color, int &width, int &height);
		static bool initBFFtext2D(const std::string & fname);

		static GLuint LoadTextureMN(const int x, const int y, LPVOID pData);
	};


}